/*---------------------------------------------------------------------------

               Copyright (c) 1994 SandStone Software Inc.
                          All rights reserved

----------------------------------------------------------------------------*/

   SSInline SSLexExpressionList::~SSLexExpressionList( void)
      {
      freeSS( opTable);
      }

   SSInline SSLexMark::SSLexMark( void)
      {
      oulMark = oulLine = oulOffset = 0;
      }

   SSInline char* SSLexConsumer::lexemeBuffer( void) const
      {
      return opchBuff + ( SSIndex) oulStart;
      }

   SSInline SSUnsigned32 SSLexConsumer::line( void) const
      {
      return oulLine;
      }

   SSInline SSUnsigned32 SSLexConsumer::offset( void) const
      {
      return oulOffset;
      }

   SSInline SSUnsigned32 SSLexConsumer::lexemeLength( void) const
      {
      return oulIndex - oulStart;
      }

   SSInline SSUnsigned32 SSLexConsumer::lexemeLength( SSLexMark& qMark) const
      {
      return qMark.oulMark - oulStart;
      }

   SSInline SSDbcsInfo& SSLexConsumer::dbcs( void) const
      {
      return oDbcs;
      }

   SSInline SSLexConsumer::SSLexConsumerType SSLexConsumer::type( void) const
      {
      return oType;
      }

   SSInline SSBooleanValue SSLexConsumer::endOfData( void) const
      {
      return oEndOfData;
      }

   SSInline SSUnsigned32 SSLexConsumer::consumed( void) const
      {
      return oulConsumed;
      }

   SSInline void SSLexConsumer::singleByte( void)
      {
      oulCurrent = opchBuff[ ( SSIndex) oulIndex++];
      }

   SSInline void SSLexConsumer::doubleByte( void)
      {
      oulCurrent = dbcs().asUnsigned32( opchBuff + ( SSIndex) oulIndex);
      oulIndex += 2;
      }

   SSInline void SSLexConsumer::unicodeByte( void)
      {
      oulCurrent = *(( SSUnicode*) opchBuff[ ( SSIndex) oulIndex]);
      oulIndex += 2;
      }

   SSInline SSUnsigned32 SSLexConsumer::current( void) const
      {
      return oulCurrent;
      }

   SSInline SSLexMark SSLexConsumer::mark( void)
      {
      SSLexMark zMark;
      zMark.oulMark = oulIndex;
      zMark.oulLine = oulScanLine;
      zMark.oulOffset = oulScanOffset;
      return zMark;
      }

   SSInline void SSLexConsumer::flushStartOfLine( SSLexMark& qMark)
      {
      oulStart += oType == unicode ? 2 : 1;
      oulLine++;
      qMark.oulLine--;
      oulOffset = 1;
      }

   SSInline void SSLexConsumer::flushLexeme( SSLexMark& qMark)
      {
      oulStart = oulIndex = qMark.oulMark;
      oulLine += qMark.oulLine;
      oulOffset = qMark.oulOffset;
      oulScanLine = 0;
      oulScanOffset = qMark.oulOffset;
      }

   SSInline void SSLexConsumer::flushLexeme( void)
      {
      oulStart = oulIndex;
      oulLine += oulScanLine;
      oulOffset = oulScanOffset;
      oulScanLine = 0;
      }

   SSInline void SSLexFileConsumer::close( void)
      {
      if ( opFile)
         {
         fclose( opFile);
         opFile = 0;
         }
      }

   SSInline FILE* SSLexFileConsumer::file( void) const
      {
      return opFile;
      }

   SSInline void SSLexLexeme::operator delete( void* qpBuff)
      {
      freeSS( qpBuff);
      }

   SSInline void* SSLexLexeme::operator new( size_t qSize, SSUnsigned32 qBuff)
      {
      return mallocSS( qSize + qBuff + SSLexMinimumCharacterSize);
      }

   SSInline void* SSLexLexeme::operator new( size_t qSize)
      {
      return mallocSS( qSize);
      }

   SSInline void SSLexLexeme::setLength( SSUnsigned32 qulLength)
      {
      oulLength = qulLength;
      }

   SSInline void SSLexLexeme::setType( SSLexLexeme::SSLexLexemeType qType)
      {
      oType = qType;
      }

   SSInline void SSLexLexeme::setBuffer( char* qpchBuff)
      {
      opchBuff = qpchBuff;
      }

   SSInline SSLexLexeme::SSLexLexeme( void) : oulLength( 0),
      oulLine( 0), oulOffset( 0), oulToken( 0), opchBuff( 0),
      oType( SSLexLexeme::character), oOwn( SSFalse)
      {
      }

   SSInline SSLexLexeme::SSLexLexeme( SSUnsigned32 qulToken) : oulLength( 0), 
      oulLine( 0), oulOffset( 0), oulToken( qulToken), opchBuff( 0),
      oType( SSLexLexeme::character), oOwn( SSFalse)
      {
      }

   SSInline SSLexLexeme::SSLexLexeme( SSUnsigned32 qulLine, SSUnsigned32
      qulOffset) : oulLength( 0), oulToken( 0), oulLine( qulLine), 
      oulOffset( qulOffset), opchBuff( 0), oType( SSLexLexeme::character),
      oOwn( SSFalse)
      {
      }

   SSInline SSUnsigned32 SSLexLexeme::line( void) const
      {
      return oulLine;
      }

   SSInline SSUnsigned32 SSLexLexeme::token( void) const
      {
      return oulToken;
      }

   SSInline SSUnsigned32 SSLexLexeme::offset( void) const
      {
      return oulOffset;
      }

   SSInline SSUnsigned32 SSLexLexeme::length( void) const
      {
      return oulLength;
      }

   SSInline void SSLexLexeme::setLine( SSUnsigned32 qulLine)
      {
      oulLine = qulLine;
      }

   SSInline void SSLexLexeme::setOffset( SSUnsigned32 qulOffset)
      {
      oulOffset = qulOffset;
      }

   SSInline const char* SSLexLexeme::asConstChar( void) const
      {
      return opchBuff;
      }

   SSInline char* SSLexLexeme::asChar( void) const
      {
      return opchBuff;
      }

   SSInline SSLexLexeme::operator const char*( void)
      {
      return opchBuff;
      }

   SSInline const SSUnicode* SSLexLexeme::asConstUnicode( void) const
      {
      return ( SSUnicode*) opchBuff;
      }

   SSInline SSLexLexeme::operator const SSUnicode*( void)
      {
      return ( SSUnicode*) opchBuff;
      }

   SSInline SSLexLexeme::SSLexLexemeType SSLexLexeme::type( void) const
      {
      return oType;
      }

   SSInline SSBooleanValue SSLexLexeme::isEqualLexeme( SSLexLexeme& qLexeme) const
      {
      if ( length() != qLexeme.length()) return SSFalse;
      return !memcmp( opchBuff, qLexeme.opchBuff, ( SSIndex) length());
      }

   SSInline void* SSLexTable::table( void)
      {
      return opTable;
      }

   SSInline SSLexTable::~SSLexTable( void)
      {
      for ( int i = 0; i < oulExpressionList; i++)
         delete oapExpressionList[ i];
      delete [] oapExpressionList;
      freeSS( opTable);
      }

   SSInline SSLexExpressionList::SSLexExpressionList( void* qpTable) : opTable( qpTable)
      {
      }

   SSInline void SSLex::setTable( SSLexTable& qTable)
      {
      opTable = &qTable;
      pushExpressionList( *qTable.expressionList());
      }
 
   SSInline void SSLex::setConsumer( SSLexConsumer& qConsumer)
      {
      opConsumer = &qConsumer;
      }
 
   SSInline SSLexTable* SSLex::table( void) const
      {
      return opTable;
      }

   SSInline SSLexConsumer* SSLex::consumer( void) const
      {
      return opConsumer;
      }

   SSInline SSLexIterator& SSLex::iterator( void) const
      {
      return *opIterator;
      }

   SSInline char* SSLexConsumer::buffer( void)
      {
      return opchBuff;
      }

   SSInline SSUnsigned32 SSLexConsumer::bufferInc( void)
      {
      return oulInc;
      }

   SSInline SSUnsigned32 SSLexConsumer::bufferLength( void)
      {
      return oulBuff;
      }

   SSInline void SSLexConsumer::setBuffer( char* qpchBuff)
      {
      opchBuff = qpchBuff;
      }

   SSInline void SSLexConsumer::setBufferInc( SSUnsigned32 qulInc)
      {
      oulInc = qulInc;
      }

   SSInline void SSLexConsumer::setBufferLength( SSUnsigned32 qulBuff)
      {
      oulBuff = qulBuff;
      }

   SSInline void SSLexConsumer::setEndOfData( void)
      {
      oEndOfData = SSTrue;
      }

   SSInline SSUnsigned32 SSLex::lexemesValid( void)
      {
      return oulLexemesValid;
      }

   SSInline void SSLexLexeme::setToken( SSUnsigned32 qulToken)
      {
      oulToken = qulToken;
      }

   SSInline void SSLexConsumer::adjustMark( SSLexMark& qMark, 
      SSBooleanValue qClear)
      {
      qMark.oulMark -= oulMark;
      if ( qClear) oulMark = 0;
      }

   SSInline void SSLexConsumer::setDataLength( SSUnsigned32 qulLength)
      {
      oulLength = qulLength;
      }
