/* gline.c (emx+gcc) -- Copyright (c) 1987-1995 by Eberhard Mattes */

#include <stdlib.h>
#include <graph.h>
#include "graph2.h"


static int round (int n)
{
  if (n & 1)
    return n/2+1;
  else
    return n/2;
}


int _gline_clip (int x1, int y1, int *x2p, int *y2p)
{
  if (*y2p < _g_clipy0 && y1 >= _g_clipy0)
    {
      *x2p = x1 + round (2 * (_g_clipy0 - y1) * (*x2p - x1) / (*y2p - y1));
      *y2p = _g_clipy0;
    }
  else if (*y2p > _g_clipy1 && y1 <= _g_clipy1)
    {
      *x2p = x1 + round (2 * (_g_clipy1 - y1) * (*x2p - x1) / (*y2p - y1));
      *y2p = _g_clipy1;
    }
  if (*x2p < _g_clipx0 && x1 >= _g_clipx0)
    {
      *y2p = y1 + round (2 * (_g_clipx0 - x1) * (*y2p - y1) / (*x2p - x1));
      *x2p = _g_clipx0;
    }
  else if (*x2p > _g_clipx1 && x1 <= _g_clipx1)
    {
      *y2p = y1 + round (2* (_g_clipx1 - x1) * (*y2p - y1) / (*x2p - x1));
      *x2p = _g_clipx1;
    }
  return (*x2p >= _g_clipx0 && *x2p <= _g_clipx1
          && *y2p >= _g_clipy0 && *y2p <= _g_clipy1);
}


static void _no_line (int x0, int y0, int x1, int y1, int color)
{
}


static void (*_j_line) (int x0, int y0, int x1, int y1, int color) = _no_line;


void g_line (int x0, int y0, int x1, int y1, int color)
{
  _j_line (x0, y0, x1, y1, color);
}


GPRIM_DEF (line);
GPRIM_ALL (line);
