/* trealloc.c (emx+gcc) -- Copyright (c) 1993-1996 by Eberhard Mattes */

#include <stdlib.h>
#include "malloc1.h"

/* Resize a block of memory.  If this cannot done in-place, move the
   block. */

void *_trealloc (void *mem, size_t new_size)
{
  void *p;

  /* First handle the trivial cases: if MEM is NULL, _trealloc()
     behaves like _tmalloc(). */

  if (mem == NULL)
    return _tmalloc (new_size);

  /* If the new size is 0, free the block. */

  if (new_size == 0)
    {
      _tfree (mem);
      return NULL;
    }

  HEAP_LOCK;
  p = _realloc2 (mem, new_size, TRUE);
  HEAP_UNLOCK;
  return p;
}
