/* splitpath.c (emx+gcc) -- Copyright (c) 1992-1996 by Eberhard Mattes */

#include <stdlib.h>
#include <string.h>
#include <sys/nls.h>

#define min(a,b) (((a) < (b)) ? (a) : (b))

void _splitpath (const char *src, char *drive, char *dir, char *fname,
                 char *ext)
{
  int i, j;

  i = 0;
  while (src[i] != 0)
    if (_nls_is_dbcs_lead ((unsigned char)src[i]))
      {
        if (src[i+1] == 0)      /* Invalid DBCS character */
          break;
        i += 2;
      }
    else if (src[i] == ':')
      break;
    else
      ++i;

  if (i > 0 && i + 2 <= _MAX_DRIVE && src[i] == ':')
    {
      if (drive != NULL)
        _strncpy (drive, src, min (i+2, _MAX_DRIVE));
      src += i + 1;
    }
  else if (drive != NULL)
    *drive = 0;
  
  i = 0; j = 0;
  while (src[j] != 0)
    if (_nls_is_dbcs_lead ((unsigned char)src[j]))
      {
        if (src[j+1] == 0)      /* Invalid DBCS character */
          break;
        j += 2;
      }
    else if (src[j] == '/' || src[j] == '\\')
      i = ++j;
    else
      ++j;

  if (dir != NULL)
    _strncpy (dir, src, min (_MAX_DIR, i + 1));
  src += i;
  
  i = 0; j = 0;
  while (src[j] != 0)
    if (_nls_is_dbcs_lead ((unsigned char)src[j]))
      {
        if (src[j+1] == 0)      /* Invalid DBCS character */
          break;
        j += 2;
      }
    else if (src[j] == '.')
      i = j++;
    else
      ++j;

  if (i == 0)
    i = j;
  if (fname != NULL)
    _strncpy (fname, src, min (_MAX_FNAME, i + 1));
  src += i;
  
  if (ext != NULL)
    _strncpy (ext, src, _MAX_EXT);
}
