/* nlstolwr.c (emx+gcc) -- Copyright (c) 1996 by Eberhard Mattes */

#include <sys/nls.h>
#include <emx/nls.h>
#include <emx/startup.h>

unsigned char _nls_tolower_tab[256] = {0};

void _nls_tolower_init (void)
{
  int i;

  _nls_toupper_init ();
  for (i = 0; i < 256; ++i)
    _nls_tolower_tab[i] = (unsigned char)i;
  for (i = 0; i < 256; ++i)
    if (_nls_toupper_tab[i] != i)
      _nls_tolower_tab[_nls_toupper_tab[i]] = (unsigned char)i;
  for (i = 'A'; i <= 'Z'; ++i)
    _nls_tolower_tab[i] = (unsigned char)(i - 'A' + 'a');
}

_CRT_INIT1 (_nls_tolower_init)
