/* winmgr2.c (emx+gcc) -- Copyright (c) 1987-1994 by Eberhard Mattes */

#include <stdlib.h>
#include <string.h>
#include <sys/video.h>
#include <sys/winmgr.h>
#include "winmgr2.h"

void _wm_copy2 (char *mask, char *dst, char *src, int width)
{
  while (width-- > 0)
    {
      if (*mask++)
        {
          *dst++ = *src++;
          *dst++ = *src++;
        }
      else
        {
          dst += 2; src += 2;
        }
    }
}



void _wm_clrline2 (char *dst, int width, char a)
{
  while (width-- > 0)
    {
      *dst++ = ' ';
      *dst++ = a;
    }
}



void _wm_line2 (char *mask, char *data, int y, int x0, int x1)
{
  if (y >= 0 && y < _wm_height)
    {
      if (x0 < 0)
        {
          mask -= x0;
          data -= 2*x0;
          x0 = 0;
        }
      if (x1 >= _wm_width)
        x1 = _wm_width-1;
      v_putmask (data, mask, x0, y, 1 + x1 - x0);
    }
}



void _wm_move2 (char *data, int y, int x0, int x1, int dir)
{
  if (y >= 0 && y < _wm_height)
    {
      if (x0 < 0)
        {
          data -= 2 * x0;
          x0 = 0;
        }
      if (x1 >= _wm_width)
        x1 = _wm_width-1;
      if (dir)
        v_putline (data, x0, y, 1 + x1 - x0);
      else
        v_getline (data, x0, y, 1 + x1 - x0);
    }
}


void _wm_putc2 (char c, int x, int y, int a)
{
  if (x >= 0 && x < _wm_width && y >= 0 && y < _wm_height)
    {
      v_gotoxy (x, y);
      v_attrib (a);
      v_putn (c, 1);
    }
}


void _wm_puts2 (char *dst, const char *src, int cnt, int a)
{
  while (cnt > 0)
    {
      *dst++ = *src++;
      *dst++ = (char)a;
      --cnt;
    }
}


void _wm_putsa2 (char *dst, const char *src, int cnt)
{
  memcpy (dst, src, (size_t)(2 * cnt));
}


void _wm_puta2 (char *dst, int a, int cnt)
{
  ++dst;
  while (cnt > 0)
    {
      *dst = (char)a;
      dst += 2;
      --cnt;
    }
}
