/*
   $Id: configure.cmd,v 1.3 1996/09/21 23:25:18 H.Ueno Exp $
*/

/*------------------------------------------------------------------------
    GNU patch program name.  Change this if you want.
    DO NOT FORGET TO ADD .exe AT THE END OF THE NAME
 -----------------------------------------------------------------------*/

GNUPatch = 'gpatch.exe'

/*------------------------------------------------------------------------
    Configure MH for OS/2
 -----------------------------------------------------------------------*/
call setlocal
OPTIONS 'ETMODE'
OPTIONS 'EXMODE'

'@echo off'
PatchFailed = 'N'
ConfigFailed = 'N'
MHPatchLevel = ''
Patch=".\Patchlevel"
ConfigFile = ''
ConfigFile2 = ''

signal on halt name ENDPROC
call RxFuncAdd 'SysFileTree', 'RexxUtil', 'SysFileTree'
call RxFuncAdd 'SysFileDelete', 'RexxUtil', 'SysFileDelete'
call RxFuncAdd 'SysSearchPath', 'RexxUtil', 'SysSearchPath'

call FindGnuPatch
call CheckPatchLevel
call SelectConfigFile arg(1)
call ApplyPatch
call DoConfig
call EndConfig

ENDPROC:
call endlocal
exit

/*------------------------------------------------------------------------
    Internal Procedures
 -----------------------------------------------------------------------*/
delete_files: procedure
    call SysFileTree arg(1), 'file', 'FS'
    DO i = 1 TO file.0
        'chmod 666' WORD( file.i, 5 )
        call SysFileDelete( WORD( file.i, 5 ) )
    end
    return

delete_files_on_current: procedure
    call SysFileTree arg(1), 'file', 'F'
    DO i = 1 TO file.0
        'chmod 666' WORD( file.i, 5 )
        call SysFileDelete( WORD( file.i, 5 ) )
    end
    return

FindGnuPatch: procedure expose GNUPatch
    if SysSearchPath( 'PATH', GNUPatch ) = '' then do
        Say
        Say 'Could not find' GNUPatch
        Say
        Say 'Do one of the following then try again:'
        Say
        Say '  1. Edit configure.cmd REXX script to specify a name of your GNU'
        Say '     patch program by modifying a "GNUPatch =" line at the top.  '
        Say
        Say '  2. Rename your GNU patch program to gpatch.exe.                '
        Say
        Signal ENDPROC
    end
    return

CheckPatchLevel: procedure expose Patch MHPatchLevel
    if LINES(Patch) then do
        ln = LINEIN(Patch, 1, 1)
        parse var ln mh '.' major '.' minor ' ' pat '.' plevel
        if plevel = '3' | plevel = '4' then do
          MHPatchLevel = plevel
        end
        ln = STREAM(Patch, 'c', 'close')
    end
    if MHPatchLevel = '' then do
        say
        say 'I can not continue processing due to the incompatible MH version.'
        say 'You need to have MH 6.8.3 or MH 6.8.4 sources for the OS/2 patches.'
        say
        Signal ENDPROC
    end
    return

SelectConfigFile: procedure expose ConfigFile ConfigFile2
TAB = d2c(9)
mtsmatch = 'N'
mtslist = ''
mts.0 = 3
mts.1.1 = 'tcpip'    ; mts.1.2 = 'SMTP to send, POP to receive.'
mts.2.1 = 'sendmail' ; mts.2.2 = 'OS/2 sendmail to send, POP to receive.'
mts.3.1 = 'uucp'     ; mts.3.2 = 'Use UUCP with UUPC/Extended package.'

    DO i = 1 TO mts.0
        if mts.i.1 = arg(1) then mtsmatch = 'Y'
        if mtslist <> '' then mtslist = mtslist'|'
        mtslist = mtslist''mts.i.1
    end /* do */
    if mtsmatch = 'Y' then do
        ConfigFile =  'conf\os2\os2.'arg(1)
        ConfigFile2 = 'os2\os2.'arg(1)

        call SysFileTree ConfigFile, 'file', 'F'
        if file.0 = 0 then do
            Say
            Say 'Could not find' ConfigFile 'file.'
            Say 'Did you rename, move, or delete it?'
            Say
            Signal ENDPROC
        end
    end
    else do
        Say
        Say 'Syntax:  configure ['mtslist']'
        Say
        DO i = 1 TO mts.0
            Say '     'mts.i.1''TAB': 'mts.i.2
        end /* do */
        Say
        Signal ENDPROC
    end
    return


ApplyPatch: procedure expose GNUPatch PatchFailed MHPatchLevel
    call SysFileTree "mhos2.pat", 'file', 'F'
    if file.0 <> 0 then do
        say '[Deleting *.orig and *.rej files]'
        call delete_files "*.orig"
        call delete_files "*.rej"
    
        if MHPatchLevel = '3' then do
          say '[Updating MH 6.8.3 to MH 6.8.4]'
          GNUPatch '-p < mh-6.8.4.pat'
          say '[Deleting *.orig files]'
          call delete_files "*.orig"
        end
    
        say '[Applying OS/2 patches]'
        GNUPatch '-p1 < mhos2.pat'
    
        say '[Backing up patch files]'
        'mv -f mhos2.pat mhos2.pa_'
        'mv -f mh-6.8.4.pat mh-6.8.4.pa_'
    
        say '[Deleting *.orig files]'
        call delete_files "*.orig"
    
        call SysFileTree "*.rej", 'file', 'FS'
        if file.0 <> 0 then PatchFailed = 'Y'
    end
    return

DoConfig: procedure expose ConfigFile2 ConfigFailed
    say '[Deleting a Makefile]'
    call delete_files_on_current "Makefile"
    
    say '[Making mhconfig.exe]'
    'cd conf'
    'rm -f mhconfig.o'
    'make SHELL=cmd CC=gcc LDFLAGS=-Zexe'
    
    say '[Creating Makefiles and other files]'
    'mhconfig' ConfigFile2
    'cd ..'
    
    call SysFileTree "Makefile", 'file', 'F'
    if file.0 <> 0 then do
      say '[Cleaning up garbages]'
      'make clean'
    end
    else do
      ConfigFailed = 'Y'
    end
    return

EndConfig: procedure expose PatchFailed ConfigFailed ConfigFile
    'cls'
    if PatchFailed = 'Y' then do
        say
        say 'Applying patches failed for some files.'
        say 'Please make changes manually accoring to *.rej file.'
    end
    
    if ConfigFailed = 'Y' then do
        say
        say 'Configuring MH failed.'
        say 'You do not have the required tools or'
        say 'a' ConfigFile 'file has errors.'
    end
    
    if PatchFailed = 'N' & ConfigFailed = 'N' then do
        say
        say 'Successfully completed.'
    end
    
    say
    say 'Run "make" to start making MH for OS/2.'
    return
