/* pmlib.c (emx+gcc) -- Copyright (c) 1996 by Eberhard Mattes */

#define INCL_WIN
#include <os2.h>

/* Remove all unwanted items from the system menu of a dialog box, as
   required by SAA CUA '89. */

void dlg_sys_menu (HWND hwnd)
{
  HWND hwndSysMenu;
  MENUITEM mi;
  MRESULT mr;
  int i, n, id;

  /* Get the window handle of the system menu. */

  hwndSysMenu = WinWindowFromID (hwnd, FID_SYSMENU);
  if (hwndSysMenu == NULLHANDLE)
    return;

  /* Well, actually the system menu proper is a submenu of the menu we
     just got. */

  mr = WinSendMsg (hwndSysMenu, MM_QUERYITEM,
                   MPFROM2SHORT (SC_SYSMENU, FALSE), (MPARAM)&mi);
  if (!SHORT1FROMMR (mr))
    return;
  hwndSysMenu = mi.hwndSubMenu;
  if (hwndSysMenu == NULLHANDLE)
    return;

  /* Delete all the unwanted menu items. */

  WinSendMsg (hwndSysMenu, MM_DELETEITEM,
              MPFROM2SHORT (SC_MINIMIZE, FALSE), 0L);
  WinSendMsg (hwndSysMenu, MM_DELETEITEM,
              MPFROM2SHORT (SC_MAXIMIZE, FALSE), 0L);
  WinSendMsg (hwndSysMenu, MM_DELETEITEM,
              MPFROM2SHORT (SC_SIZE, FALSE), 0L);
  WinSendMsg (hwndSysMenu, MM_DELETEITEM,
              MPFROM2SHORT (SC_RESTORE, FALSE), 0L);
  WinSendMsg (hwndSysMenu, MM_DELETEITEM,
              MPFROM2SHORT (SC_TASKMANAGER, FALSE), 0L);
  WinSendMsg (hwndSysMenu, MM_DELETEITEM,
              MPFROM2SHORT (SC_HIDE, FALSE), 0L);

  /* Deleting menu items may leave two or more successive separator
     lines.  Now we remove all the separator lines.  */

redo:

  /* Get the number of menu items. */

  mr = WinSendMsg (hwndSysMenu, MM_QUERYITEMCOUNT, 0L, 0L);
  n = SHORT1FROMMR (mr);

  /* Find the first one which is a separator line. */

  for (i = 0; i < n; ++i)
    {
      mr = WinSendMsg (hwndSysMenu, MM_ITEMIDFROMPOSITION,
                       MPFROMSHORT (i), 0L);
      id = SHORT1FROMMR (mr);
      if (id != MID_ERROR)
        {
          mr = WinSendMsg (hwndSysMenu, MM_QUERYITEM,
                           MPFROM2SHORT (id, FALSE), (MPARAM)&mi);
          if (SHORT1FROMMR (mr) && (mi.afStyle & MIS_SEPARATOR))
            {
              /* We found a separator line.  Delete that menu item. */

              WinSendMsg (hwndSysMenu, MM_DELETEITEM,
                          MPFROM2SHORT (id, FALSE), 0L);

              /* Restart the loop as the menu items have been
                 renumbered. */

              goto redo;
            }
        }
    }

  /* Now there's no separator line left. */
}
