/* syserr.c (emx+gcc) -- Copyright (c) 1990-1998 by Eberhard Mattes */

const char * const _sys_errlist[] =
{
  /*  0 EZERO          */ "Error 0",
  /*  1 EPERM          */ "Operation not permitted",
  /*  2 ENOENT         */ "No such file or directory",
  /*  3 ESRCH          */ "No such process",
  /*  4 EINTR          */ "Interrupted system call",
  /*  5 EIO            */ "I/O error",
  /*  6 ENXIO          */ "No such device or address",
  /*  7 E2BIG          */ "Arguments or environment too big",
  /*  8 ENOEXEC        */ "Invalid executable file format",
  /*  9 EBADF          */ "Bad file number",
  /* 10 ECHILD         */ "No children",
  /* 11 EAGAIN         */ "Resource temporarily unavailable",
  /* 12 ENOMEM         */ "Not enough memory",
  /* 13 EACCES         */ "Permission denied",
  /* 14 EFAULT         */ "Bad address",
  /* 15 ENOLCK         */ "No locks available",
  /* 16 EBUSY          */ "Resource busy",
  /* 17 EEXIST         */ "File exists",
  /* 18 EXDEV          */ "Cross-device link",
  /* 19 ENODEV         */ "No such device",
  /* 20 ENOTDIR        */ "Not a directory",
  /* 21 EISDIR         */ "Is a directory",
  /* 22 EINVAL         */ "Invalid argument",
  /* 23 ENFILE         */ "Too many open files in system",
  /* 24 EMFILE         */ "Too many open files",
  /* 25 ENOTTY         */ "Inappropriate ioctl",
  /* 26 EDEADLK        */ "Resource deadlock avoided",
  /* 27 EFBIG          */ "File too large",
  /* 28 ENOSPC         */ "Disk full",
  /* 29 ESPIPE         */ "Invalid seek",
  /* 30 EROFS          */ "Read-only file system",
  /* 31 EMLINK         */ "Too many links",
  /* 32 EPIPE          */ "Broken pipe",
  /* 33 EDOM           */ "Domain error",
  /* 34 ERANGE         */ "Result too large",
  /* 35 ENOTEMPTY      */ "Directory not empty",
  /* 36 EINPROGRESS    */ "Operation now in progress",
  /* 37 ENOSYS         */ "Function not implemented",
  /* 38 ENAMETOOLONG   */ "File name too long",
  /* 39 EDESTADDRREQ   */ "Destination address required",
  /* 40 EMSGSIZE       */ "Message too long",
  /* 41 EPROTOTYPE     */ "Protocol wrong type for socket",
  /* 42 ENOPROTOOPT    */ "Option not supported by protocol",
  /* 43 EPROTONOSUPPORT */ "Protocol not supported",
  /* 44 ESOCKTNOSUPPORT */ "Socket type not supported",
  /* 45 EOPNOTSUPP     */ "Operation not supported on socket",
  /* 46 EPFNOSUPPORT   */ "Protocol family not supported",
  /* 47 EAFNOSUPPORT   */ "Address family not supported by protocol family",
  /* 48 EADDRINUSE     */ "Address already in use",
  /* 49 EADDRNOTAVAIL  */ "Can't assign requested address",
  /* 50 ENETDOWN       */ "Network is down",
  /* 51 ENETUNREACH    */ "Network is unreachable",
  /* 52 ENETRESET      */ "Network dropped connection on reset",
  /* 53 ECONNABORTED   */ "Software caused connection abort",
  /* 54 ECONNRESET     */ "Connection reset by peer",
  /* 55 ENOBUFS        */ "No buffer space available",
  /* 56 EISCONN        */ "Socket is already connected",
  /* 57 ENOTCONN       */ "Socket is not connected",
  /* 58 ESHUTDOWN      */ "Can't send after socket shutdown",
  /* 59 ETOOMANYREFS   */ "Too many references: can't splice",
  /* 60 ETIMEDOUT      */ "Connection timed out",
  /* 61 ECONNREFUSED   */ "Connection refused",
  /* 62 ELOOP          */ "Too many levels of symbolic links",
  /* 63 ENOTSOCK       */ "Socket operation on non-socket",
  /* 64 EHOSTDOWN      */ "Host is down",
  /* 65 EHOSTUNREACH   */ "No route to host",
  /* 66 EALREADY       */ "Operation already in progress"
};

const int _sys_nerr = sizeof (_sys_errlist) / sizeof (_sys_errlist[0]);
