/* wmputsat.c (emx+gcc) -- Copyright (c) 1987-1994 by Eberhard Mattes */

#include <string.h>
#include <sys/winmgr.h>
#include "winmgr2.h"

void wm_puts_at (wm_handle wh, int x, int y, const char *p)
{
  int max, len, cnt, i, px, py, mx, my;
  char *mem;

  len = (int)strlen (p);
  while (len > 0)
    {
      max = wh->width-x;
      if (len < max)
        cnt = len;
      else
        cnt = max;
      if (cnt > 0)
        {
          px = x + wh->ax;
          py = y + wh->ay;
          i = px + py * wh->bwidth;
          mem = &wh->data[2*i];
          _wm_puts2 (mem, p, cnt, wh->wattr);           /* Copy to memory */
          if (wh->display)            /* Copy from memory to video buffer */
            {
              mx = x+wh->x0;
              my = y+wh->y0;
              if (wh->visible)
                _wm_move2 (mem, my, mx, mx+cnt-1, 1);
              else
                _wm_line2 (&wh->mask[i], mem, my, mx, mx+cnt-1);
            }
          else
            wh->update_req = TRUE;
          if (cnt == max)
            {
              if (wh->wrap)
                {
                  x = 0;
                  ++y;
                  if (y >= wh->height)
                    break;
                }
              else
                break;
            }
          else
            x += cnt;
        }
      len -= cnt;
      p += cnt;
    }
}
