/* binpp.cc */

#include <fstream>
#include <stdlib.h>
#include <string.h>

static const char fname[] = "binpp.tmp";

static void test (ios::openmode wmode, ios::openmode rmode,
                  const char *wstr, const char *rstr)
{
  ofstream wf;
  wf.open (fname, wmode);
  if (!wf)
    abort ();
  wf.write (wstr, strlen (wstr));
  wf.flush ();
  if (!wf)
    abort ();
  wf.close ();

  static char buf[512];
  memset (buf, 0, sizeof (buf));
  ifstream rfs;
  rfs.open (fname, rmode);
  if (!rfs)
    abort ();
  if (!rfs.read (buf, strlen (rstr)))
    abort ();
  rfs.close ();
  if (memcmp (buf, rstr, strlen (rstr)) != 0)
    abort ();
}


int main ()
{
  test (ios::out|ios::binary, ios::in|ios::binary,
        "a\nb\rc\r\nd", "a\nb\rc\r\nd");
  test (ios::out|ios::binary, ios::in,
        "a\nb\rc\r\nd", "a\nb\rc\nd");
  test (ios::out, ios::in|ios::binary,
        "a\nb\rc\r\nd", "a\r\nb\rc\r\r\nd");
  test (ios::out, ios::in,
        "a\nb\rc\r\nd", "a\nb\rc\r\nd");
  return 0;
}
