/* coretest.c (emx+gcc) */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <io.h>
#include <fcntl.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/stat.h>

#define INITIALIZED 314159265

static int initialized = 0;
static char *p = NULL;

int main (int argc, char *argv[])
{
  int fh, rc;

  printf ("initialized = %d\n", initialized);
  if (initialized == 0)
    {
      initialized = INITIALIZED;
      p = malloc (100);
      strcpy (p, "Hello!");
      fh = open ("coretest.cor", O_WRONLY|O_CREAT|O_TRUNC, S_IREAD|S_IWRITE);
      if (fh < 0)
        printf ("Cannot create core file\n");
      else
        {
          fflush (stdout);      /* don't dump unflushed buffer */
          rc = _core (fh);
          if (rc < 0)
            perror ("core");
          close (fh);
        }
    }
  else if (initialized == INITIALIZED)
    {
      printf ("%s\n", p);
      if (argc == 2 && strcmp (argv[1], "-d") == 0)
        raise (SIGQUIT);
    }
  return 0;
}
