/* Multi-thread locks for EMX/OS2 */

#ifndef _LIBIO_LOCK_H
#define _LIBIO_LOCK_H	1

#ifdef _IO_MTSAFE_IO

#include <sys/builtin.h>
#include <sys/fmutex.h>

typedef _fmutex _IO_lock_t;
#define _IO_LOCK_T _IO_lock_t *

#define _IO_lock_initializer {}

#define _IO_lock_init(_name) \
     _fmutex_create (&(_name), 0)
#define _IO_lock_fini(_name) \
     _fmutex_close (&(_name))

#define _IO_flockfile(file) \
     _fmutex_request ((file)->_lock, _FMR_IGNINT);
#define _IO_funlockfile(file) \
     _fmutex_release ((file)->_lock);
#define _IO_ftrylockfile(file) \
     _fmutex_request ((file)->_lock, _FMR_NOWAIT);

/*
  KLUDGE WARNING:

  We're assuming here that _IO_cleanup_region_start is always called with
  _fct = (void (*) __P ((void *))) _IO_funlockfile, this allows us to
  ignore this parameter and to inline cleanup function.
  If someday _IO_cleanup_region_start will be used with a different arg,
  the _IO_flockfile/_IO_funlockfile functions should be separately defined.
  For now they are inlined as a direct call to _fmutex_XXX functions.
*/
#define _IO_cleanup_region_start(_fct, _fp) \
     { \
       _IO_lock_t *__cleanup_arg = (_fp)->_lock;
#define _IO_cleanup_region_end(_doit) \
       if (_doit) _fmutex_release (__cleanup_arg); \
     }

#endif

#endif /* _LIBIO_LOCK_H */
