/****************************************************************************
*
*                    SciTech SNAP Graphics Architecture
*
*  ========================================================================
*
*   Copyright (C) 1991-2004 SciTech Software, Inc. All rights reserved.
*
*   This file may be distributed and/or modified under the terms of the
*   GNU General Public License version 2.0 as published by the Free
*   Software Foundation and appearing in the file LICENSE.GPL included
*   in the packaging of this file.
*
*   Licensees holding a valid Commercial License for this product from
*   SciTech Software, Inc. may use this file in accordance with the
*   Commercial License Agreement provided with the Software.
*
*   This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING
*   THE WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
*   PURPOSE.
*
*   See http://www.scitechsoft.com/license/ for information about
*   the licensing options available and how to purchase a Commercial
*   License Agreement.
*
*   Contact license@scitechsoft.com if any conditions of this licensing
*   are not clear to you, or you have questions about licensing options.
*
*  ========================================================================
*
* Language:     ANSI C
* Environment:  Any 32-bit protected mode environment
*
* Description:  Module to implement cursors to test the SciTech SNAP
*               Graphics Architecture.
*
****************************************************************************/

#include "snap/graphics.h"

/*---------------------------- Global Variables ---------------------------*/

GA_monoCursor arrowCursor = {
    {
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x40,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x60,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x70,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x78,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x7F,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x7E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x76,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x66,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x43,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x80,0x00,0x00,0x00,0x00,0x00,
    0x00,0x01,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    },
    {
    0x00,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0xFC,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x80,0x00,0x00,0x00,0x00,0x00,
    0x00,0xFF,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xEF,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0xC7,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x83,0xC0,0x00,0x00,0x00,0x00,0x00,
    0x00,0x03,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    },
    8,0
    };

GA_monoCursor dogCursor = {
    {
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x30,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,0x07,0xE0,
    0x07,0x00,0x00,0x00,0x00,0x00,0x0F,0xC0,0x0F,0xC0,0x00,0x00,0x00,0x00,0x0F,0xC0,0x0F,0xF2,0x00,0x00,0x00,0x00,0x1F,0xC0,0x1F,0xF9,0x00,0x00,0x00,0x01,0x3F,0x80,
    0x1F,0xFC,0x80,0x00,0x00,0x02,0x7F,0x80,0x1F,0xFE,0x40,0x00,0x00,0x04,0xFF,0x80,0x1F,0xFE,0x20,0x00,0x00,0x01,0xFF,0x80,0x1F,0xFF,0x10,0x00,0x00,0x03,0xFF,0x00,
    0x1F,0xFF,0x8C,0x00,0x00,0x03,0xFF,0x00,0x0F,0x7F,0xCE,0x00,0x00,0x27,0xFF,0x00,0x0F,0x3F,0xE7,0x00,0x00,0x0F,0xFF,0x00,0x07,0x9F,0xF7,0x80,0x00,0x43,0xFE,0x00,
    0x07,0x9F,0xE7,0xE0,0x01,0xD3,0xFE,0x00,0x07,0x8F,0xE7,0xE7,0x07,0x87,0xFE,0x00,0x07,0xCF,0xE7,0xE3,0xFC,0x0F,0xFC,0x00,0x03,0xF1,0xE7,0xF0,0x7E,0x4B,0xE4,0x00,
    0x03,0xF0,0xE1,0xF9,0xFF,0xF9,0xE4,0x00,0x03,0xF0,0x31,0xFF,0xFF,0xF3,0xE4,0x00,0x03,0xF1,0x19,0xFF,0xFF,0x8F,0xFE,0x00,0x03,0xF1,0x01,0xFF,0x9F,0xCF,0xFE,0x00,
    0x03,0xF3,0x81,0xFF,0x9F,0xFF,0xFE,0x00,0x01,0xF3,0x83,0xFF,0x9C,0x7F,0xFE,0x00,0x00,0xF2,0xC7,0xE7,0xFE,0x3F,0xFE,0x00,0x00,0xF4,0xD3,0xC7,0xFF,0x7F,0xBC,0x00,
    0x00,0x1E,0x9E,0x7F,0xFF,0x3B,0x1E,0x00,0x00,0x1F,0x9E,0x3F,0xFB,0x3B,0xFE,0x00,0x00,0x0F,0xBF,0x78,0x03,0x9F,0xFE,0x00,0x00,0x0F,0x7B,0xE0,0x01,0x9F,0xD8,0x00,
    0x00,0x00,0x32,0xE3,0xFC,0xEF,0x80,0x00,0x00,0x00,0x66,0x4F,0xFC,0xE0,0x01,0x00,0x00,0x07,0xC7,0x8F,0xBE,0x78,0x81,0x00,0x00,0x27,0x8F,0x9E,0x0A,0x67,0x09,0x00,
    0x00,0x0F,0x9E,0xF8,0x02,0xF7,0x09,0x00,0x00,0xC7,0x9F,0x40,0x01,0xB9,0xF8,0x00,0x00,0x4F,0xBF,0x00,0x01,0xB9,0xFE,0x00,0x00,0x9F,0x9F,0x8C,0x01,0xBF,0xF2,0x00,
    0x00,0x7F,0x9E,0x0E,0x7F,0xBF,0xE0,0x00,0x00,0x78,0x9C,0x07,0xFF,0xFF,0xE0,0x00,0x00,0xFB,0xBE,0xE1,0xFF,0xFF,0xF0,0x00,0x00,0x7F,0xBF,0xF0,0x1F,0xFF,0xF8,0x00,
    0x00,0x73,0x9F,0xF8,0x3E,0x7F,0xF8,0x00,0x00,0x73,0xC3,0xFC,0x3C,0x7F,0xFC,0x00,0x00,0x33,0xC3,0xF8,0x04,0xFF,0x3C,0x00,0x00,0x39,0xCE,0x7C,0x01,0xF7,0xBC,0x00,
    0x00,0x09,0xFE,0x3F,0xE0,0x67,0xFE,0x00,0x00,0x0A,0x6F,0xC1,0xFC,0x7E,0x80,0x00,0x00,0x06,0x7F,0xD0,0x07,0x1C,0x80,0x00,0x00,0x02,0x73,0xFF,0x03,0x03,0x80,0x00,
    0x00,0x02,0x7F,0xFF,0xFF,0x21,0x80,0x00,0x00,0x03,0x3F,0xFC,0xFF,0xFF,0x80,0x00,0x00,0x01,0x3F,0x3E,0xE3,0xFF,0xE0,0x00,0x00,0x00,0x13,0x3F,0xF0,0xFF,0xF8,0x00,
    0x00,0x00,0x03,0xF4,0xFC,0x1F,0xE0,0x00,0x00,0x00,0x00,0x44,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x0E,0xFF,0xC0,0x00,0x00,0x00,0x00,0x00,0x10,0x10,0xFF,0x80,0x00,
    },
    {
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFC,
    0x00,0x00,0x00,0x00,0x00,0x00,0x03,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0x07,0xF8,0x0F,0xC0,0x00,0x00,0x00,0x00,0x1F,0xF8,0x1F,0xF0,0x00,0x00,0x00,0x00,0x3F,0xF8,
    0x1F,0xF8,0x00,0x00,0x00,0x00,0x7F,0xF0,0x3F,0xFE,0x00,0x00,0x00,0x00,0xFF,0xF0,0x3F,0xFF,0x00,0x00,0x00,0x01,0xFF,0xF0,0x3F,0xFF,0x80,0x00,0x00,0x03,0xFF,0xF0,
    0x3F,0xFF,0xC0,0x00,0x00,0x07,0xFF,0xE0,0x3F,0xFF,0xE0,0x00,0x00,0x0F,0xFF,0xE0,0x3F,0xFF,0xF8,0x00,0x00,0x1F,0xFF,0xE0,0x3F,0xFF,0xFC,0x00,0x00,0x3F,0xFF,0xC0,
    0x3F,0xFF,0xFE,0x00,0x00,0x3F,0xFF,0xC0,0x3F,0xFF,0xFF,0x00,0x00,0x7F,0xFF,0xC0,0x3F,0xFF,0xFF,0x80,0x00,0xFF,0xFF,0xC0,0x3F,0xFF,0xFF,0xE0,0x01,0xFF,0xFF,0x80,
    0x1F,0xFF,0xFF,0xF8,0x07,0xFF,0xFF,0x80,0x1F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x80,0x1F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x00,0x0F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x00,
    0x0F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x00,0x0F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x00,0x0F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x00,0x0F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x00,
    0x0F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x80,0x0F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x80,0x07,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x80,0x07,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x80,
    0x03,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x80,0x01,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x80,0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x80,0x00,0x3F,0xFF,0xFF,0xFF,0xFF,0xFF,0x80,
    0x00,0x3F,0xFF,0xFF,0xFF,0xFF,0xFF,0x80,0x00,0x3F,0xFF,0xFF,0xFF,0xFF,0xFF,0x80,0x00,0x7F,0xFF,0xFF,0xFF,0xFF,0xFF,0x80,0x00,0x7F,0xFF,0xFF,0xFF,0xFF,0xFF,0x80,
    0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x80,0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x80,0x01,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x80,0x01,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x80,
    0x01,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x00,0x03,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x00,0x01,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x00,0x01,0xFF,0xFF,0xFF,0xFF,0xFF,0xFE,0x00,
    0x01,0xFF,0xFF,0xFF,0xFF,0xFF,0xFE,0x00,0x01,0xFF,0xFF,0xFF,0xFF,0xFF,0xFE,0x00,0x01,0xFF,0xFF,0xFF,0xFF,0xFF,0xFE,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x00,
    0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x00,0x00,0x7F,0xFF,0xFF,0xFF,0xFF,0xFF,0x80,0x00,0x7F,0xFF,0xFF,0xFF,0xFF,0xFF,0x80,0x00,0x3F,0xFF,0xFF,0xFF,0xFF,0xFF,0x80,
    0x00,0x3F,0xFF,0xFF,0xFF,0xFF,0xFF,0x80,0x00,0x0F,0xFF,0xFF,0xFF,0xFF,0xFF,0x80,0x00,0x0F,0xFF,0xFF,0xFF,0xFF,0xFF,0x80,0x00,0x07,0xFF,0xFF,0xFF,0xFF,0xFF,0x80,
    0x00,0x03,0xFF,0xFF,0xFF,0xFF,0xFF,0x80,0x00,0x03,0xFF,0xFF,0xFF,0xFF,0xFF,0x00,0x00,0x00,0x3F,0xFF,0xFF,0xFF,0xFE,0x00,0x00,0x00,0x03,0xFF,0xFF,0xFF,0xFC,0x00,
    },
    32,32
    };

GA_monoCursor katCursor = {
    {
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x02,0x00,0x00,0xC0,0x00,0x00,0x00,0x00,0x03,0x00,0x01,0xC0,0x00,0x00,0x00,0x00,
    0x02,0x80,0x03,0xC0,0x00,0x00,0x00,0x00,0x02,0xC0,0x03,0xC0,0x00,0x00,0x00,0x00,0x06,0x03,0x81,0x00,0x00,0x00,0x00,0x00,0x07,0x85,0xF0,0x80,0x00,0x00,0x00,0x00,
    0x07,0xE1,0xF4,0x00,0x00,0x00,0x00,0x00,0x07,0x81,0xF0,0x00,0x00,0x00,0x00,0x00,0x05,0x24,0xF2,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0x80,0x00,0x00,0x00,0x00,
    0x02,0xE0,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x87,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0x87,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0xE2,0x80,0x00,0x00,0x00,0x00,
    0x00,0x7A,0x6E,0x00,0x00,0x00,0x00,0x00,0x01,0x7F,0xC6,0x80,0x00,0x00,0x00,0x00,0x03,0xFB,0x90,0xC0,0x00,0x00,0x00,0x00,0x01,0xFC,0x1D,0xC0,0x00,0x00,0x00,0x00,
    0x01,0xFF,0xFB,0x80,0x00,0x00,0x00,0x00,0x00,0xFF,0x03,0x80,0x00,0x00,0x00,0x00,0x00,0x7F,0xC7,0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0x80,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    },
    {
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x07,0x00,0x01,0xE0,0x00,0x00,0x00,0x00,0x0F,0x80,0x03,0xE0,0x00,0x00,0x00,0x00,0x0F,0xC0,0x07,0xE0,0x00,0x00,0x00,0x00,
    0x0F,0xE0,0x0F,0xE0,0x00,0x00,0x00,0x00,0x0F,0xFF,0xDF,0xE0,0x00,0x00,0x00,0x00,0x0F,0xFF,0xFF,0xE0,0x00,0x00,0x00,0x00,0x0F,0xFF,0xFF,0xE0,0x00,0x00,0x00,0x00,
    0x0F,0xFF,0xFF,0xE0,0x00,0x00,0x00,0x00,0x0F,0xFF,0xFF,0xE0,0x00,0x00,0x00,0x00,0x0F,0xFF,0xFF,0xE0,0x00,0x00,0x00,0x00,0x0F,0xFF,0xFF,0xE0,0x00,0x00,0x00,0x00,
    0x07,0xFF,0xFF,0xF0,0x00,0x00,0x00,0x00,0x07,0xFF,0xFF,0xF0,0x00,0x00,0x00,0x00,0x07,0xFF,0xFF,0xF0,0x00,0x00,0x00,0x00,0x0F,0xFF,0xFF,0xE0,0x00,0x00,0x00,0x00,
    0x07,0xFF,0xFF,0xE0,0x00,0x00,0x00,0x00,0x07,0xFF,0xFF,0xE0,0x00,0x00,0x00,0x00,0x07,0xFF,0xFF,0xF0,0x00,0x00,0x00,0x00,0x07,0xFF,0xFF,0xE0,0x00,0x00,0x00,0x00,
    0x07,0xFF,0xFF,0xE0,0x00,0x00,0x00,0x00,0x03,0xFF,0xFF,0xE0,0x00,0x00,0x00,0x00,0x01,0xFF,0xFF,0xC0,0x00,0x00,0x00,0x00,0x01,0xFF,0xFF,0x80,0x00,0x00,0x00,0x00,
    0x00,0xFF,0xEF,0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0x8E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    },
    16,16
    };

GA_monoCursor skullCursor = {
    {
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3C,0x00,0x00,0x00,0x00,
    0x00,0x00,0x01,0xFF,0xE0,0x00,0x00,0x00,0x00,0x00,0x07,0xFF,0xF8,0x00,0x00,0x00,0x00,0x00,0x1F,0xFF,0xFE,0x00,0x00,0x00,0x00,0x00,0x3F,0xFF,0xFF,0x00,0x00,0x00,
    0x00,0x00,0x7F,0xFF,0xFF,0x80,0x00,0x00,0x00,0x00,0x7F,0xFF,0xFF,0xC0,0x00,0x00,0x00,0x00,0xFF,0xFF,0xFF,0xE0,0x00,0x00,0x00,0x01,0xFF,0xFF,0xFF,0xF0,0x00,0x00,
    0x00,0x01,0xFF,0xFF,0xFF,0xF0,0x00,0x00,0x00,0x03,0xFF,0xC0,0x1F,0xF0,0x00,0x00,0x00,0x03,0xCF,0xC6,0x03,0x90,0x00,0x00,0x00,0x03,0x83,0xFE,0x83,0x08,0x00,0x00,
    0x00,0x07,0xE1,0xF8,0x06,0x04,0x00,0x00,0x00,0x07,0xF8,0xF0,0x3E,0x04,0x00,0x00,0x00,0x07,0xF8,0xF0,0x1E,0x06,0x00,0x00,0x00,0x07,0xFC,0x60,0x1E,0x0F,0x00,0x00,
    0x00,0x07,0xFC,0x60,0x1F,0x0F,0x00,0x00,0x00,0x07,0xF8,0x60,0x3F,0xFF,0x80,0x00,0x00,0x07,0xC0,0xF0,0x7F,0xFF,0x80,0x00,0x00,0x07,0xC3,0xF9,0xFF,0xFF,0x80,0x00,
    0x00,0x07,0xC7,0xFF,0xFD,0xFF,0x80,0x00,0x00,0x07,0xE3,0xFF,0xF8,0x0F,0x80,0x00,0x00,0x07,0xE3,0xFF,0xF0,0x0C,0x00,0x00,0x00,0x03,0xF1,0xFF,0xF0,0x0C,0x00,0x00,
    0x00,0x03,0xE0,0xFF,0xF1,0xDC,0x00,0x00,0x00,0x01,0xC0,0x01,0xF1,0xF6,0x00,0x00,0x00,0x00,0xC0,0x00,0xFE,0x42,0x00,0x00,0x00,0x00,0x04,0x00,0x78,0x00,0x00,0x00,
    0x00,0x00,0x06,0x00,0x40,0x00,0x00,0xC0,0x00,0x00,0x03,0x00,0x01,0x18,0x01,0x80,0x00,0x00,0x03,0x80,0x02,0x00,0x00,0x00,0x00,0x00,0x03,0xC0,0x20,0x00,0x00,0x00,
    0x00,0x00,0x21,0xC0,0x40,0x7E,0x04,0x00,0x00,0x01,0x11,0xE0,0x01,0xFF,0x0C,0x00,0x00,0x11,0x09,0xE0,0x00,0xFF,0xF8,0x00,0x00,0x38,0x80,0xE0,0x00,0xFF,0xF0,0x00,
    0x00,0x38,0x00,0xE0,0x00,0x7F,0xC0,0x00,0x00,0x1C,0x00,0xF9,0x80,0x3C,0x00,0x00,0x00,0x00,0x00,0xFF,0x80,0x18,0x00,0x00,0x00,0x00,0x00,0xFF,0xCB,0x80,0xF0,0x00,
    0x00,0x00,0x00,0xFF,0xFF,0x01,0x9C,0x00,0x00,0x00,0x00,0x1F,0xFF,0x13,0x0E,0x00,0x00,0x00,0x00,0x00,0x1E,0x23,0x04,0x00,0x00,0x00,0x00,0x00,0x06,0x23,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x63,0x00,0x40,0x00,0x00,0x00,0x00,0x00,0x61,0x88,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x23,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x02,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    },
    {
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0x80,0x00,0x00,0x00,0x00,0x00,0x01,0xFF,0xF8,0x00,0x00,0x00,
    0x00,0x00,0x0F,0xFF,0xFE,0x00,0x00,0x00,0x00,0x00,0x1F,0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,0x7F,0xFF,0xFF,0x80,0x00,0x00,0x00,0x00,0xFF,0xFF,0xFF,0xE0,0x00,0x00,
    0x00,0x01,0xFF,0xFF,0xFF,0xF0,0x00,0x00,0x00,0x03,0xFF,0xFF,0xFF,0xF8,0x00,0x00,0x00,0x03,0xFF,0xFF,0xFF,0xFC,0x00,0x00,0x00,0x07,0xFF,0xFF,0xFF,0xFC,0x00,0x00,
    0x00,0x0F,0xFF,0xFF,0xFF,0xFE,0x00,0x00,0x00,0x0F,0xFF,0xFF,0xFF,0xFE,0x00,0x00,0x00,0x0F,0xFF,0xFF,0xFF,0xFE,0x00,0x00,0x00,0x1F,0xFF,0xFF,0xFF,0xFF,0x00,0x00,
    0x00,0x1F,0xFF,0xFF,0xFF,0xFF,0x00,0x00,0x00,0x1F,0xFF,0xFF,0xFF,0xFF,0x80,0x00,0x00,0x1F,0xFF,0xFF,0xFF,0xFF,0x80,0x00,0x00,0x3F,0xFF,0xFF,0xFF,0xFF,0xC0,0x00,
    0x00,0x3F,0xFF,0xFF,0xFF,0xFF,0xE0,0x00,0x00,0x3F,0xFF,0xFF,0xFF,0xFF,0xE0,0x00,0x00,0x3F,0xFF,0xFF,0xFF,0xFF,0xF0,0x00,0x00,0x3F,0xFF,0xFF,0xFF,0xFF,0xF0,0x00,
    0x00,0x3F,0xFF,0xFF,0xFF,0xFF,0xF0,0x00,0x00,0x3F,0xFF,0xFF,0xFF,0xFF,0xF0,0x00,0x00,0x3F,0xFF,0xFF,0xFF,0xFF,0xF0,0x00,0x00,0x1F,0xFF,0xFF,0xFF,0xFF,0xE0,0x00,
    0x00,0x1F,0xFF,0xFF,0xFF,0xFF,0x80,0x00,0x00,0x1F,0xFF,0xFF,0xFF,0xFF,0x80,0x00,0x00,0x0F,0xFF,0xFF,0xFF,0xFF,0x80,0x00,0x00,0x0F,0xFF,0xFF,0xFF,0xFF,0xC1,0xE0,
    0x00,0x07,0xFF,0xFF,0xFF,0xFF,0xC3,0xF0,0xE0,0x03,0xFF,0xFF,0xFF,0xFF,0xC7,0xF0,0xF3,0x01,0xFF,0xFF,0xFF,0xFF,0xC7,0xF8,0x3F,0x80,0xFF,0xFF,0xFF,0xFF,0xCF,0xF0,
    0x0F,0x83,0xFF,0xFF,0xFF,0xFF,0xDF,0xE0,0x01,0xDF,0xFF,0xFF,0xFF,0xFF,0xFF,0xC0,0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x80,0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x80,
    0x1C,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFE,0x00,0xE1,0xFF,0xFF,0xFF,0xFF,0xFF,0xFC,0x00,0xE1,0xFF,0xC7,0xFF,0xFF,0xFF,0xFF,0x00,
    0x03,0xFF,0x07,0xFF,0xFF,0xFF,0xFF,0x00,0x03,0x00,0x07,0xFF,0xFF,0xFF,0xFF,0x80,0x07,0x00,0x03,0xFF,0xFF,0xFF,0xFF,0xC0,0x06,0x00,0x03,0xFF,0xFF,0xFF,0xFF,0xE0,
    0x1E,0x00,0x00,0x7F,0xFF,0xFF,0xFF,0xE0,0x3C,0x00,0x00,0x01,0xFF,0xFF,0xFF,0xF0,0x30,0x00,0x00,0x00,0x3F,0xFF,0xFF,0xF0,0x00,0x00,0x00,0x00,0x07,0xFF,0xFF,0xF0,
    0x00,0x00,0x00,0x00,0x03,0xF7,0xFF,0xF8,0x00,0x00,0x00,0x00,0x07,0xE1,0xFF,0xFC,0x00,0x00,0x00,0x00,0x07,0xE0,0xFF,0xFE,0x00,0x00,0x00,0x00,0x0F,0xE0,0xFF,0xFF,
    0x00,0x00,0x00,0x00,0x0F,0xE0,0xFF,0xF7,0x00,0x00,0x00,0x00,0x07,0xE0,0x7F,0xF0,0x00,0x00,0x00,0x00,0x03,0xC0,0x07,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x90,
    0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    },
    32,32
    };

GA_colorCursor frogCursor = {
    {
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x7A,0xA9,0x9C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x56,0x66,0x27,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x76,0x66,0x23,0x90,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0xB2,0x66,0x23,0xA0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0xB2,0x66,0x24,0x6A,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x09,0x32,0x66,0x26,0x76,0xB0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x51,0x33,0x66,0x24,0x44,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x0A,0x00,0x30,0x26,0x22,0x54,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xA7,0x68,0x7A,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x06,0x10,0x00,0x16,0x62,0x47,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xCB,0x97,0x65,0x63,0x33,0x38,0x69,0xA0,0x00,0x75,0x22,0x90,0x00,0x00,
    0x00,0x00,0x00,0x00,0x05,0x33,0x10,0x02,0x26,0x26,0x00,0x00,0x0B,0x76,0x9C,0x00,0xB7,0x65,0x22,0x22,0x25,0x33,0x33,0x33,0x82,0x26,0x22,0x26,0x26,0x28,0x00,0x00,
    0x00,0x00,0x00,0x00,0x95,0x33,0x33,0x00,0x22,0x25,0xC0,0x00,0x06,0x25,0x26,0x72,0x25,0x22,0x26,0x22,0x23,0x33,0x03,0x38,0x36,0x62,0x62,0x62,0x22,0x33,0x00,0x00,
    0x00,0x00,0x00,0x00,0x65,0x35,0x83,0x00,0x12,0x62,0x90,0x00,0x06,0x62,0x66,0x62,0x22,0x26,0x22,0x66,0x23,0x33,0x03,0x38,0x36,0x66,0x62,0x62,0x62,0x23,0x00,0x00,
    0x00,0x00,0x00,0x0A,0x63,0x38,0x33,0x30,0x01,0x22,0x29,0x00,0x02,0x26,0x66,0x64,0x42,0x22,0x26,0x26,0x22,0x33,0x33,0x33,0x66,0x66,0x66,0x26,0x26,0x23,0x00,0x00,
    0x00,0x00,0x00,0x06,0x43,0x33,0x88,0x30,0x10,0x12,0x22,0x70,0xA2,0x26,0x66,0x44,0x41,0x22,0x22,0x22,0x62,0x23,0x33,0x36,0x66,0x26,0x26,0x66,0x22,0x29,0x00,0x00,
    0x00,0x00,0x00,0x94,0x42,0x8A,0x00,0x33,0x30,0x01,0x22,0x26,0x72,0x26,0x26,0x24,0x44,0x26,0x62,0x22,0x22,0x22,0x25,0x62,0x62,0x66,0x66,0x66,0x66,0x2A,0x00,0x00,
    0x00,0x00,0x0B,0x44,0x41,0x01,0x00,0x09,0x01,0x00,0x01,0x22,0x22,0x22,0x66,0x22,0x26,0x76,0x79,0x62,0x12,0x66,0x66,0x66,0x66,0x66,0x66,0x66,0x66,0x29,0x00,0x07,
    0x00,0x00,0x06,0x46,0x44,0x17,0x04,0x47,0x11,0x00,0x06,0x22,0x22,0x66,0x66,0x66,0x55,0x57,0x7A,0x97,0x61,0x67,0x9B,0x9B,0xA9,0x9B,0xCC,0xBB,0x99,0x90,0x00,0x51,
    0x00,0x00,0x76,0x44,0x41,0x40,0xA4,0x45,0x11,0x00,0x01,0x01,0x21,0x66,0x62,0x46,0x96,0x65,0x57,0x79,0x77,0x66,0x55,0x42,0x5A,0x00,0x00,0x00,0x00,0x00,0x02,0x10,
    0x00,0x00,0x46,0x44,0x14,0xB0,0x74,0x75,0x11,0x00,0x00,0x00,0x01,0x67,0x62,0x99,0x99,0x86,0x63,0x46,0x77,0x77,0x77,0x62,0x70,0x00,0x00,0x00,0x00,0x00,0x71,0x11,
    0x00,0x06,0x44,0x44,0x17,0x00,0x47,0x71,0x01,0x00,0x05,0x00,0x02,0x66,0x26,0x69,0xB9,0x96,0x66,0x62,0x11,0x12,0x42,0x41,0x70,0x00,0x00,0x00,0x00,0x00,0x21,0x11,
    0x00,0xB4,0x64,0x41,0x70,0x0A,0x46,0x71,0x01,0x10,0x05,0x51,0x02,0x62,0x63,0x36,0x99,0x99,0x85,0x55,0x52,0x11,0x00,0x11,0x90,0x00,0x00,0x00,0x00,0x09,0x11,0x11,
    0x00,0x54,0x44,0x44,0x00,0x05,0x46,0x72,0x11,0x01,0x12,0x68,0x26,0x62,0x23,0x32,0x26,0x63,0x33,0x32,0x31,0x00,0x00,0x00,0x70,0x00,0x00,0x00,0x00,0x04,0x11,0x11,
    0x0B,0x44,0x64,0x1C,0x00,0x04,0x67,0x85,0x01,0x01,0x48,0x96,0x56,0x62,0x33,0x33,0x22,0x58,0x76,0x52,0x10,0x00,0x00,0x01,0x1B,0x00,0x00,0x00,0x00,0xB1,0x11,0x11,
    0x06,0x42,0x54,0x70,0x00,0xA4,0x67,0x75,0x01,0x12,0x89,0x86,0x62,0x23,0x33,0x33,0x32,0x22,0x20,0x00,0x00,0x00,0x00,0x04,0x47,0x00,0x00,0x00,0x00,0x71,0x11,0x11,
    0x00,0x74,0x74,0x00,0x00,0x74,0x66,0x85,0x01,0x12,0x99,0x66,0x22,0x03,0x33,0x33,0x33,0x22,0x11,0x00,0x00,0x00,0x00,0x14,0x56,0xA0,0x00,0x00,0x00,0x21,0x11,0x11,
    0x00,0x0B,0x9C,0x00,0x00,0x76,0x57,0x76,0x00,0x11,0x86,0x63,0x90,0x03,0x38,0x83,0x33,0x06,0x22,0x10,0x00,0x00,0x00,0x15,0x77,0x70,0x00,0x00,0x00,0x11,0x11,0x11,
    0x00,0x00,0x00,0x00,0x00,0x77,0x76,0x85,0x51,0x01,0x66,0x3A,0x00,0xB3,0x3C,0x0C,0x8C,0x00,0xA2,0x11,0x10,0x00,0x00,0x15,0x47,0x40,0x00,0x00,0x0A,0x11,0x11,0x11,
    0x00,0x00,0x00,0x00,0x00,0xA6,0x66,0x65,0x70,0x10,0x33,0x80,0x00,0xA3,0x3C,0x00,0x00,0x00,0x0C,0x62,0x11,0x00,0x00,0x07,0x47,0x7A,0x00,0x00,0x09,0x11,0x11,0x21,
    0x00,0x00,0x00,0x00,0x00,0x0A,0x66,0x75,0x72,0x00,0x03,0xC0,0x00,0x83,0x3C,0x00,0x00,0x00,0x00,0x09,0x21,0x10,0x00,0x04,0x74,0x77,0x00,0x00,0x07,0x01,0x11,0x11,
    0x00,0x00,0x00,0x00,0x00,0x00,0x0A,0x55,0x67,0x00,0x00,0x4C,0x00,0x33,0x3A,0x00,0x00,0x00,0x00,0x00,0xC6,0x21,0x10,0x00,0x44,0x79,0x00,0x00,0x05,0x11,0x11,0x16,
    0x00,0x00,0x00,0xB7,0x77,0x9B,0x00,0x05,0x5A,0x00,0x01,0x14,0xC0,0x83,0x3C,0x00,0x00,0x00,0x00,0x00,0x00,0x72,0x21,0x20,0x35,0x57,0x00,0x00,0x05,0x11,0x11,0x60,
    0x00,0x00,0x00,0x67,0x77,0x47,0x47,0x00,0xB7,0x10,0x14,0x11,0x4A,0xDC,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x56,0x62,0x35,0x33,0x35,0xB0,0x00,0x04,0x11,0x17,0x00,
    0x00,0x00,0x0B,0x7A,0x77,0x74,0x74,0x4B,0xEA,0x10,0x15,0x40,0x01,0x70,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xB0,0x08,0x33,0x33,0x33,0x35,0xC0,0x01,0x22,0xB0,0x00,
    0x00,0x00,0x00,0x79,0x77,0x74,0x44,0x44,0xCE,0x10,0x15,0x50,0x01,0x45,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x05,0x38,0x88,0x33,0x33,0x80,0x91,0x60,0x00,0x00,
    0x00,0x00,0x00,0x5A,0x74,0x77,0x77,0x41,0xBE,0x11,0x15,0x54,0x04,0x44,0x4B,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x53,0x38,0x08,0x33,0x33,0x3A,0x20,0x4B,0x00,0x00,
    0x00,0x00,0x00,0x97,0x77,0x41,0xA7,0x44,0xAE,0x50,0x01,0x54,0x14,0x44,0x44,0xA0,0x00,0x00,0x00,0x00,0x00,0x00,0x53,0x30,0x08,0x38,0x88,0x83,0x00,0x4B,0x00,0x00,
    0x00,0x00,0x00,0x07,0x77,0x74,0xA0,0x07,0xB7,0x01,0x01,0x02,0x44,0x44,0x44,0x47,0x00,0x00,0x00,0x00,0x00,0x00,0x0B,0x00,0x08,0x3B,0x0A,0x07,0x00,0x06,0xA0,0x00,
    0x00,0x00,0x00,0x00,0x77,0x77,0x4A,0x00,0x00,0x41,0x13,0x00,0x14,0x44,0x44,0x44,0x70,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xA3,0x30,0x00,0x00,0xB7,0xA5,0x07,0x00,
    0x00,0x00,0x00,0x00,0x09,0x77,0x44,0xB0,0x00,0x90,0x00,0x34,0x00,0x14,0x44,0x44,0x47,0x00,0x00,0x00,0x00,0x00,0x00,0x0C,0x33,0xA0,0x00,0x00,0x00,0x00,0xA0,0x00,
    0x00,0x00,0x00,0x00,0x00,0x77,0x74,0x4C,0x00,0xA0,0x10,0x14,0x74,0x40,0x04,0x44,0x44,0x70,0x00,0x00,0x00,0x00,0x00,0x05,0x33,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x07,0x77,0x45,0x0A,0x01,0x10,0x34,0x44,0x44,0x40,0x44,0x77,0x40,0x00,0x00,0x00,0x00,0x00,0x08,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x75,0x74,0x78,0x50,0x10,0x33,0x75,0x44,0x74,0x44,0x47,0x40,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x07,0x44,0x01,0x52,0x13,0x33,0xC0,0x0A,0x74,0x44,0x47,0xB0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x53,0x03,0x35,0x33,0x03,0xA0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x05,0x53,0x58,0x03,0x52,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0B,0x03,0x55,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x09,0x33,0x3A,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x05,0x33,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0A,0x88,0xB0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    },
    {
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0xC0,0x00,0x00,0x00,0x00,0x00,
    0x00,0x0F,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x07,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x07,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0xF0,0x00,0x00,0x00,0x00,0x00,
    0x00,0x3F,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0xF0,0x00,0x00,0x1E,0x00,0x00,0x00,0x7F,0xF0,0x00,0x01,0xFF,0x83,0xC0,0x00,0x7F,0xF0,0x30,0x7F,0xFF,0xFF,0xF0,
    0x00,0x7F,0xF0,0x7F,0xFF,0xFF,0xFF,0xF0,0x00,0xFF,0xF0,0x7F,0xFF,0xFF,0xFF,0xF0,0x00,0xFF,0xF8,0x7F,0xFF,0xFF,0xFF,0xF0,0x01,0xFF,0xFE,0x7F,0xFF,0xFF,0xFF,0xE0,
    0x01,0xE3,0xFF,0xFF,0xFF,0xFF,0xFF,0xE0,0x03,0xF0,0xFF,0xFF,0xFB,0xFF,0xFF,0xE1,0x07,0xF7,0xFF,0xFF,0xF9,0xF0,0x00,0x03,0x0F,0xE7,0xFF,0xFF,0x7E,0xFF,0x80,0x07,
    0x0F,0xCF,0xFF,0xFC,0x3F,0xFF,0x80,0x0F,0x1F,0xCF,0xFF,0xFE,0x1F,0xFF,0x80,0x0F,0x1F,0x8F,0xFF,0xFF,0x0F,0xFF,0x00,0x0F,0x3F,0x1F,0xFF,0xFF,0xFF,0xFF,0x80,0x1F,
    0x3E,0x1F,0xFD,0xFF,0xFF,0xFF,0x80,0x1F,0x7E,0x1F,0xFB,0xFF,0xFF,0xFF,0xC0,0x3F,0x3C,0x3F,0xF3,0xFF,0xFF,0xFF,0xC0,0x3F,0x00,0x3F,0xFF,0x3F,0xDF,0xFF,0xE0,0x3F,
    0x00,0x3F,0xFE,0x18,0x87,0xFF,0xE0,0x3F,0x00,0x1F,0xFE,0x18,0x03,0xFF,0xE0,0x3F,0x00,0x0F,0xFC,0x38,0x00,0xFF,0xF0,0x7F,0x00,0x03,0xFE,0x38,0x00,0x7F,0xE0,0x7F,
    0x01,0xC1,0xBF,0x38,0x00,0x3F,0xF0,0x7E,0x03,0xFC,0x7F,0x80,0x00,0x3F,0xF0,0x7C,0x02,0xFE,0x3F,0xE0,0x00,0x07,0xFC,0x70,0x02,0xFF,0x3F,0xF0,0x00,0x07,0xFE,0x60,
    0x02,0xFF,0x3F,0xF8,0x00,0x0F,0x7E,0xE0,0x01,0xF7,0x3F,0xFC,0x00,0x0E,0x7F,0xE0,0x01,0xF1,0x7F,0xFF,0x00,0x00,0x61,0xF0,0x00,0xF8,0x3F,0xFF,0x80,0x00,0x60,0x5C,
    0x00,0x3C,0x1F,0xFF,0xC0,0x00,0xC0,0x00,0x00,0x3E,0x1F,0xFF,0xE0,0x01,0xC0,0x00,0x00,0x1F,0x3F,0xFF,0xE0,0x01,0xC0,0x00,0x00,0x0F,0xFF,0xFF,0xE0,0x00,0x00,0x00,
    0x00,0x07,0xFF,0x0F,0xC0,0x00,0x00,0x00,0x00,0x03,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x0E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    },
    {
    {0x00,0x00,0x00,0}, {0x11,0x1C,0x16,0}, {0x15,0x39,0x2E,0}, {0x13,0x34,0x5D,0},
    {0x45,0x38,0x2B,0}, {0x41,0x4B,0x5A,0}, {0x48,0x74,0x64,0}, {0x80,0x84,0x77,0},
    {0x6F,0x7B,0xAD,0}, {0x96,0xB8,0xB1,0}, {0xB5,0xBB,0xBA,0}, {0xC6,0xCE,0xD1,0},
    {0xDA,0xDE,0xE2,0}, {0xEC,0xEC,0xED,0}, {0xF3,0xF3,0xF7,0}, {0xFF,0xFF,0xFF,0},
    },
    32,32
    };

GA_colorCursor256 doggieCursor = {
    {
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x2C,0x46,0x51,0x51,0x51,0x40,
    0x23,0x00,0x1C,0x46,0x57,0x5B,0x5B,0x5B,0x57,0x40,0x23,0x0B,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x14,0x40,0x46,0x51,0x57,0x5B,0x61,0x6F,
    0x87,0x5B,0x51,0x5B,0x61,0x69,0x69,0x69,0x69,0x6F,0x87,0x6F,0x17,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0B,0x32,0x40,0x46,0x51,0x57,0x57,0x69,0x7D,
    0xA2,0xA2,0x95,0x61,0x61,0x69,0x69,0x6F,0x7D,0x87,0xA2,0xA2,0x87,0x14,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0E,0x2C,0x37,0x40,0x46,0x46,0x51,0x61,0x7D,
    0xA2,0xA3,0xA3,0xA2,0x57,0x5B,0x61,0x69,0x7D,0x95,0xA2,0xA2,0xA2,0x69,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0E,0x1C,0x26,0x32,0x37,0x3B,0x46,0x57,0x6F,
    0xB3,0xCC,0xB4,0xA6,0x62,0x40,0x51,0x61,0x6F,0x99,0xD2,0xAB,0xA6,0xA2,0x1C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0B,0x17,0x17,0x1C,0x26,0x32,0x37,0x40,0x57,
    0x8D,0xC5,0xB7,0xB4,0x72,0x23,0x32,0x40,0x57,0x8B,0xB4,0xAB,0xBE,0xA3,0x1C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x14,0x17,0x14,0x17,0x19,0x23,0x2C,0x3B,
    0x61,0x95,0xAB,0xBE,0x6F,0x22,0x1C,0x23,0x2C,0x46,0x7D,0xA3,0xB6,0x7D,0x0E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x14,0x1C,0x29,0x32,0x36,0x2C,0x1C,0x1C,
    0x32,0x57,0x7D,0x8B,0x95,0x7D,0x5B,0x1C,0x14,0x1C,0x32,0x5B,0x5B,0x19,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0E,0x22,0x37,0x57,0x7D,0xA2,0xA2,0x40,
    0x29,0x37,0x57,0x95,0xA6,0xA2,0x40,0x00,0x00,0x00,0x0B,0x0E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0B,0x1C,0x36,0x5B,0x87,0xA8,0xA6,0x52,
    0x46,0x6F,0xA2,0xA2,0xAB,0x7D,0x0E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1C,0x32,0x57,0x87,0xAF,0xAC,0x5B,
    0x51,0x95,0xA3,0xAC,0xAC,0x36,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x2C,0x5B,0x95,0xB0,0xBE,0x6B,
    0x57,0xA6,0xAB,0xC5,0xA8,0x14,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x23,0x46,0x87,0xA8,0xCC,0x7F,
    0x57,0xA6,0xAB,0xCC,0x7F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x14,0x36,0x6F,0xA2,0xCF,0x97,
    0x51,0xA3,0xAC,0xC8,0x46,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0B,0x26,0x51,0xA2,0xCC,0xAB,
    0x57,0xA6,0xB4,0xBE,0x23,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x19,0x3B,0x87,0xBD,0xB4,
    0x5B,0xA6,0xBE,0xAF,0x0E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x27,0x12,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0E,0x2C,0x5B,0xAB,0xB4,
    0x51,0x61,0x6E,0x62,0x32,0x1C,0x0E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x2D,0x15,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x14,0x32,0x61,0x51,
    0x51,0x5B,0x69,0x6F,0x6F,0x7D,0x87,0x51,0x26,0x0E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x19,0x46,0x76,0x1A,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1C,0x51,0x46,0x46,
    0x57,0x61,0x6F,0x7D,0x87,0xA2,0xA2,0xA2,0xA2,0x95,0x40,0x14,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x5B,0xA2,0xAC,0x8A,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x14,0x51,0x61,0x40,0x51,
    0x5B,0x69,0x7D,0x87,0xA2,0xA2,0xA2,0xA3,0xA3,0xA3,0xA3,0xA2,0x46,0x0E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x23,0x7D,0xA2,0xA9,0xA6,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x32,0x51,0x40,0x46,0x57,
    0x61,0x6F,0x7D,0xA2,0xA2,0xA3,0xA3,0xA3,0xA3,0xA3,0xA3,0xA3,0xA3,0x7D,0x14,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3B,0xA2,0xA3,0xB0,0xA6,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x19,0x3B,0x3B,0x3B,0x46,0x57,
    0x5B,0x69,0x7D,0xA8,0xB0,0xB3,0xAC,0xAB,0xA6,0xA6,0xA3,0xA3,0xA3,0xA3,0x87,0x14,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0E,0x51,0xA2,0xA6,0xB7,0xA6,0x0B,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x2C,0x3B,0x36,0x3B,0x46,0x51,
    0x57,0x61,0x72,0x9A,0xC4,0xCE,0xC7,0xBA,0xB0,0xAB,0xA6,0xA6,0xA6,0xA3,0xA3,0x69,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x5B,0xA3,0xAC,0xBE,0xA9,0x0E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x36,0x3B,0x2C,0x3B,0x40,0x46,
    0x51,0x57,0x61,0x8B,0xC7,0xE0,0xDE,0xCE,0xBA,0xAC,0xA6,0xA6,0x96,0xA3,0xA3,0xA3,0x26,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x14,0x61,0xA6,0xB7,0xCC,0xAB,0x0E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1C,0x37,0x37,0x2C,0x37,0x3B,0x40,
    0x46,0x51,0x57,0x63,0x9B,0xCE,0xCF,0xC1,0xB4,0xAB,0x7F,0x87,0xA6,0xA3,0xA3,0xA3,0x62,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x14,0x61,0xAC,0xCC,0xDB,0xAC,0x12,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x29,0x37,0x32,0x29,0x32,0x37,0x3B,
    0x40,0x46,0x46,0x46,0x5C,0x8B,0xA8,0xA8,0xA6,0x72,0x5B,0x81,0xBD,0xA8,0xA8,0xB3,0xAB,0x1C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x57,0xB7,0xE0,0xDB,0xAD,0x17,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0E,0x2C,0x37,0x32,0x23,0x2C,0x32,0x36,
    0x3B,0x3B,0x3B,0x3B,0x46,0x5B,0x6F,0x95,0xA2,0x46,0x37,0x40,0x57,0x7D,0xAF,0xD6,0xC1,0x32,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0E,0x46,0xB0,0xE3,0xD9,0xAD,0x1A,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x12,0x2C,0x36,0x32,0x1C,0x23,0x2C,0x32,
    0x36,0x36,0x36,0x36,0x3B,0x46,0x5B,0x69,0x7D,0x61,0x1C,0x1C,0x2C,0x3B,0x4C,0x5E,0x6B,0x1C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x2C,0x89,0xE0,0xD9,0xB1,0x27,0x1C,0x2C,0x37,0x46,0x51,0x57,0x46,0x3B,0x2C,0x1C,0x1C,0x2C,0x36,0x36,0x14,0x1C,0x23,0x29,
    0x2C,0x2C,0x2C,0x2C,0x32,0x3B,0x57,0x6F,0x87,0x95,0x95,0x62,0x46,0x37,0x40,0x5B,0x87,0x95,0x4C,0x19,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1C,0x61,0xCE,0x79,0x41,0x3B,0x46,0x46,0x51,0x57,0x5B,0x61,0x69,0x6F,0x87,0x95,0x2C,0x2C,0x32,0x36,0x1C,0x14,0x1C,0x23,
    0x23,0x26,0x26,0x26,0x2C,0x57,0x7D,0x87,0x8B,0xA6,0xA8,0xA6,0xA3,0x8B,0x5B,0x8D,0xBE,0xAB,0xA3,0xA3,0x40,0x0B,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0B,0x3B,0x48,0x2D,0x36,0x3B,0x40,0x46,0x57,0x5B,0x61,0x69,0x7D,0x7D,0xA2,0xA2,0x23,0x2C,0x32,0x36,0x2C,0x14,0x14,0x19,
    0x1C,0x1C,0x22,0x23,0x46,0x69,0x89,0xB3,0xC1,0xCB,0xCE,0xC2,0xAF,0xA3,0x62,0x57,0x9D,0xCB,0xAB,0xA3,0xA3,0x57,0x0B,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1C,0x23,0x2C,0x32,0x36,0x3B,0x46,0x51,0x57,0x61,0x69,0x7D,0x95,0xA2,0x95,0x23,0x2C,0x2C,0x36,0x40,0x1C,0x14,0x14,
    0x14,0x17,0x1C,0x40,0x5B,0x6B,0x99,0xC0,0xCE,0xDB,0xE0,0xDB,0xBA,0xA6,0x7D,0x40,0x53,0x81,0xAB,0xA3,0xA3,0xA2,0x52,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1C,0x23,0x26,0x2C,0x32,0x37,0x3B,0x46,0x51,0x57,0x61,0x6F,0x87,0xA2,0x7D,0x23,0x2C,0x2C,0x32,0x40,0x40,0x17,0x14,
    0x14,0x14,0x2C,0x51,0x5B,0x75,0xB3,0xC0,0xCB,0xD5,0xDB,0xD9,0xB9,0xAB,0x87,0x37,0x3B,0x46,0x62,0x95,0xA6,0xA3,0xA2,0x37,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0B,0x19,0x1C,0x23,0x26,0x2C,0x32,0x37,0x40,0x46,0x51,0x57,0x61,0x87,0xA2,0x72,0x22,0x26,0x2C,0x32,0x40,0x57,0x46,0x19,
    0x14,0x1C,0x46,0x51,0x5C,0x75,0x90,0xB8,0xC0,0xC7,0xD1,0xCE,0xAF,0xB0,0x95,0x37,0x3B,0x40,0x52,0x69,0x8B,0xAB,0xA2,0xA2,0x1C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0E,0x14,0x14,0x1C,0x23,0x26,0x2C,0x32,0x37,0x3B,0x46,0x46,0x57,0x7D,0xA2,0x76,0x1C,0x23,0x29,0x32,0x40,0x51,0x61,0x5B,
    0x23,0x2C,0x40,0x46,0x57,0x65,0x77,0x90,0xB3,0xBC,0xC1,0xBD,0xA8,0xBA,0x95,0x37,0x36,0x37,0x46,0x57,0x6F,0xAB,0xAB,0xA2,0x69,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0B,0x14,0x14,0x14,0x19,0x1C,0x23,0x2C,0x32,0x36,0x3B,0x46,0x51,0x61,0xA6,0x91,0x19,0x23,0x26,0x2C,0x3B,0x51,0x61,0x6F,
    0x6F,0x36,0x3B,0x46,0x46,0x53,0x5E,0x66,0x77,0x90,0xAF,0xAB,0xAB,0xC4,0x95,0x36,0x32,0x32,0x37,0x46,0x57,0x7D,0xBD,0xA6,0xA2,0x23,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x0E,0x2C,0x62,0x1C,0x14,0x14,0x14,0x14,0x17,0x1C,0x23,0x2C,0x36,0x3B,0x46,0x57,0x87,0xC4,0x1A,0x1C,0x23,0x26,0x36,0x46,0x57,0x69,
    0x46,0x32,0x37,0x3B,0x40,0x46,0x4C,0x53,0x5E,0x66,0x75,0x7D,0xBD,0xB9,0x7D,0x2C,0x26,0x2C,0x2C,0x37,0x40,0x57,0x90,0xBE,0xA2,0x5B,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x14,0x40,0x7D,0xA6,0x4E,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x19,0x26,0x36,0x40,0x57,0x7D,0xA6,0x39,0x17,0x1C,0x22,0x2C,0x36,0x40,0x51,
    0x2C,0x32,0x37,0x3B,0x40,0x40,0x46,0x46,0x4C,0x57,0x5C,0x69,0xCA,0x8C,0x6F,0x1C,0x23,0x23,0x26,0x2C,0x37,0x40,0x57,0xC4,0xA8,0x95,0x14,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x10,0x3B,0x5B,0xA3,0xC2,0xC3,0x4F,0x1A,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x23,0x37,0x57,0x7D,0x95,0xA6,0x2D,0x17,0x19,0x22,0x26,0x32,0x37,
    0x23,0x23,0x32,0x37,0x3B,0x3B,0x40,0x40,0x40,0x46,0x57,0x75,0xB9,0x7D,0x40,0x17,0x1C,0x1C,0x1C,0x23,0x2C,0x36,0x40,0x66,0xB9,0x95,0x36,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x0B,0x2C,0x46,0x69,0xAF,0xE0,0xDE,0xD0,0x9C,0x48,0x23,0x23,0x24,0x2F,0x3A,0x42,0x1E,0x23,0x3B,0x69,0x95,0xA2,0xA3,0x47,0x24,0x19,0x1C,0x29,0x40,
    0x1C,0x23,0x26,0x32,0x37,0x3B,0x3B,0x3B,0x40,0x46,0x51,0x82,0x75,0x6F,0x23,0x14,0x14,0x17,0x19,0x1C,0x23,0x2C,0x36,0x40,0x83,0x8B,0x51,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x1C,0x37,0x46,0x6F,0xB0,0xD7,0xE0,0xE3,0xBF,0xA9,0x46,0x57,0xA3,0xB7,0xCC,0xE0,0x9F,0x33,0x23,0x46,0x69,0xA3,0xAB,0xA9,0xA9,0xC5,0x67,0xA6,0xBD,
    0x1E,0x1C,0x23,0x2C,0x32,0x36,0x36,0x36,0x37,0x40,0x4C,0x66,0x69,0x6F,0x64,0x17,0x14,0x14,0x14,0x14,0x19,0x23,0x29,0x36,0x4C,0x75,0x51,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x0B,0x32,0x40,0x57,0x95,0xB0,0xC5,0xD9,0xE3,0xBA,0xA9,0x40,0x46,0x95,0xA6,0xB0,0xD2,0xE2,0x9E,0x46,0x5B,0x87,0xC4,0xC2,0xAD,0xA9,0xAC,0x46,0x87,0xB7,
    0x5F,0x14,0x1C,0x23,0x26,0x2C,0x2C,0x2C,0x2C,0x36,0x46,0x5B,0x61,0x8F,0xAC,0x36,0x14,0x14,0x14,0x14,0x14,0x19,0x23,0x2C,0x37,0x57,0x46,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x1C,0x37,0x46,0x61,0xA2,0xB1,0xBE,0xD7,0xE0,0xB7,0xA6,0x3B,0x3B,0x7D,0xA3,0xAB,0xBF,0x92,0x54,0x5B,0x6F,0xA8,0xD7,0xCC,0xC9,0xAC,0x87,0x26,0x3B,0x61,
    0x97,0x48,0x17,0x14,0x19,0x19,0x1C,0x1C,0x26,0x36,0x46,0x51,0x51,0x78,0x82,0x32,0x00,0x10,0x14,0x14,0x14,0x14,0x17,0x22,0x29,0x40,0x23,0x00,0x00,0x00,0x00,0x00,
    0x00,0x0E,0x32,0x3B,0x51,0x7D,0xA3,0xB0,0xBE,0xD7,0xD9,0xB1,0xA6,0x36,0x36,0x69,0xA2,0xA6,0xB0,0x48,0x57,0x61,0x87,0xB9,0xC8,0xDB,0xD9,0xA6,0x57,0x1C,0x2C,0x3B,
    0x69,0xA2,0x59,0x19,0x14,0x14,0x14,0x17,0x26,0x36,0x32,0x2C,0x32,0x37,0x36,0x0B,0x00,0x00,0x00,0x0E,0x10,0x10,0x14,0x10,0x14,0x10,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x19,0x36,0x40,0x5B,0x87,0xA6,0xAD,0xBA,0xD4,0xD2,0xAD,0xA6,0x2C,0x32,0x5B,0xA2,0xA3,0x53,0x46,0x57,0x6F,0xA6,0xC5,0xC5,0xE0,0xC5,0xA3,0x10,0x10,0x22,0x2C,
    0x46,0x7D,0xA2,0x90,0x49,0x34,0x2E,0x23,0x10,0x0E,0x10,0x10,0x14,0x0E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x26,0x37,0x46,0x61,0x95,0xA6,0xAC,0xBA,0xD4,0xC9,0xAC,0xA3,0x26,0x2C,0x51,0x95,0x72,0x3B,0x46,0x5B,0x87,0xB3,0xC1,0xD2,0xDE,0xAC,0x72,0x00,0x0E,0x19,0x23,
    0x36,0x5B,0x95,0xA3,0xBA,0xE0,0xC9,0x8A,0x0E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x10,0x2C,0x37,0x46,0x6F,0xA2,0xA6,0xAC,0xBE,0xD4,0xC3,0xAB,0x96,0x23,0x2C,0x40,0x87,0x3B,0x40,0x51,0x61,0x8B,0xB7,0xBE,0xDB,0xC5,0xA6,0x3B,0x00,0x00,0x14,0x1C,
    0x26,0x46,0x6F,0xA2,0xA6,0xC5,0xDB,0xBA,0x40,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x19,0x2C,0x37,0x51,0x7D,0xA3,0xA8,0xB0,0xBF,0xD4,0xBE,0xAB,0x72,0x1C,0x26,0x37,0x46,0x37,0x46,0x51,0x69,0xA8,0xB3,0xC8,0xCF,0xB3,0xA2,0x1C,0x00,0x00,0x12,0x19,
    0x23,0x32,0x5B,0x87,0xA2,0xAC,0xCB,0xD2,0xAC,0x12,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x1C,0x2C,0x36,0x46,0x7D,0xA3,0xAB,0xB0,0xC3,0xD2,0xB7,0xA9,0x58,0x19,0x1C,0x32,0x2C,0x37,0x40,0x46,0x69,0xA8,0xB9,0xCC,0xBE,0xA8,0x87,0x00,0x00,0x00,0x0E,0x17,
    0x1C,0x23,0x40,0x6F,0xA2,0xA6,0xB9,0xCF,0xC2,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x1C,0x2C,0x32,0x46,0x69,0xA2,0xA3,0xAC,0xC2,0xC5,0xAC,0x8B,0x22,0x1C,0x1C,0x22,0x2C,0x36,0x3B,0x46,0x6F,0xA8,0xC2,0xC8,0xB6,0xA6,0x40,0x00,0x00,0x00,0x0B,0x17,
    0x1C,0x23,0x36,0x61,0x95,0xA6,0xB4,0xC8,0xC8,0x6E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x1C,0x26,0x2C,0x40,0x61,0x87,0xA2,0xA3,0xAB,0xAB,0xA2,0x69,0x0B,0x1C,0x23,0x23,0x2C,0x32,0x37,0x40,0x7D,0xAB,0xC8,0xC8,0xB4,0xA3,0x23,0x00,0x00,0x00,0x00,0x14,
    0x22,0x23,0x2C,0x57,0x87,0xA2,0xAF,0xC4,0xC5,0xA6,0x0B,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x1C,0x23,0x2C,0x40,0x61,0x87,0xA2,0xA2,0xA3,0xA3,0xA2,0x46,0x0B,0x1C,0x23,0x1C,0x26,0x32,0x36,0x3B,0x7D,0xAB,0xC5,0xC5,0xB0,0xA2,0x10,0x00,0x00,0x00,0x00,0x14,
    0x23,0x26,0x2C,0x46,0x7D,0xA2,0xAB,0xBE,0xC2,0xA6,0x14,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x19,0x23,0x29,0x40,0x61,0x87,0xA2,0xA2,0xA6,0xA3,0xA2,0x32,0x00,0x1C,0x23,0x1C,0x23,0x2C,0x32,0x3B,0x7D,0xAB,0xC4,0xC2,0xAB,0x7D,0x00,0x00,0x00,0x00,0x00,0x10,
    0x23,0x2C,0x2C,0x3B,0x69,0xA2,0xA6,0xB9,0xBE,0xA6,0x1C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x17,0x22,0x26,0x3B,0x5B,0x87,0xA2,0xA2,0xA3,0xA3,0xA2,0x1C,0x00,0x19,0x23,0x1C,0x23,0x26,0x2C,0x3B,0x7D,0xA8,0xBE,0xBE,0xA6,0x57,0x00,0x00,0x00,0x00,0x00,0x0E,
    0x23,0x2C,0x2C,0x37,0x61,0x95,0xA2,0xB4,0xB7,0xA6,0x1C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x12,0x1C,0x23,0x36,0x57,0x6F,0x95,0xA2,0xA2,0xA2,0x95,0x0E,0x00,0x14,0x23,0x1C,0x1C,0x23,0x29,0x3B,0x7D,0xA6,0xB9,0xB7,0xA3,0x46,0x00,0x00,0x00,0x00,0x00,0x0B,
    0x23,0x2C,0x32,0x37,0x5B,0x87,0xA2,0xB3,0xB4,0xA2,0x14,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x0E,0x14,0x1C,0x2C,0x46,0x61,0x7D,0xA2,0xA2,0xA2,0x46,0x00,0x00,0x0E,0x19,0x1C,0x1C,0x22,0x23,0x36,0x69,0xA2,0xB4,0xB6,0xA3,0x36,0x00,0x00,0x00,0x00,0x00,0x00,
    0x23,0x2C,0x32,0x3B,0x57,0x7D,0xA2,0xAF,0xAB,0x95,0x0E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x0E,0x14,0x1C,0x2C,0x40,0x57,0x6F,0x7D,0x5B,0x14,0x00,0x00,0x00,0x10,0x14,0x19,0x1C,0x23,0x2C,0x5B,0x95,0xAC,0xB4,0xA3,0x32,0x00,0x00,0x00,0x00,0x00,0x00,
    0x1C,0x32,0x36,0x40,0x57,0x6F,0x95,0xA8,0xA3,0x7D,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x0B,0x10,0x19,0x22,0x2C,0x37,0x36,0x14,0x00,0x00,0x00,0x00,0x00,0x0E,0x14,0x1C,0x22,0x26,0x51,0x6F,0xA3,0xAB,0xA2,0x32,0x00,0x00,0x00,0x00,0x00,0x00,
    0x1C,0x32,0x37,0x46,0x5B,0x6F,0x95,0xA6,0xA2,0x51,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x0B,0x0E,0x0E,0x0E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x14,0x19,0x1C,0x26,0x46,0x69,0x95,0xA6,0xA2,0x37,0x00,0x00,0x00,0x00,0x00,0x00,
    0x19,0x2C,0x37,0x46,0x61,0x7D,0xA2,0xA6,0xA2,0x36,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x14,0x1C,0x23,0x46,0x69,0x95,0xA8,0xA2,0x37,0x00,0x00,0x00,0x00,0x00,0x00,
    0x10,0x26,0x32,0x46,0x5B,0x6F,0x95,0xA2,0x95,0x1C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x14,0x17,0x1C,0x37,0x5B,0x87,0xA6,0xA2,0x37,0x00,0x00,0x00,0x00,0x00,0x00,
    0x0E,0x1C,0x26,0x37,0x46,0x5B,0x6F,0x7D,0x5B,0x0B,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x14,0x14,0x19,0x2C,0x46,0x61,0x87,0x95,0x26,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x10,0x19,0x1C,0x26,0x36,0x40,0x46,0x1C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0E,0x14,0x14,0x19,0x2C,0x3B,0x51,0x40,0x0B,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x10,0x14,0x14,0x1C,0x1C,0x0E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0B,0x14,0x14,0x19,0x23,0x23,0x0B,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x0B,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    },
    {
    0x00,0x00,0x00,0x7F,0xFF,0xE0,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0xF8,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0xFC,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0xFC,0x00,0x00,
    0x00,0x00,0x00,0xFF,0xFF,0xFE,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0xFE,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0xFC,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0xFC,0x00,0x00,
    0x00,0x00,0x00,0x7F,0xFE,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0xFC,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0xFC,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0xFC,0x00,0x00,0x00,
    0x00,0x00,0x00,0x3F,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0xF0,0x00,0x00,0x00,
    0x00,0x18,0x00,0x0F,0xFC,0x00,0x00,0x00,0x00,0x18,0x00,0x0F,0xFF,0x80,0x00,0x00,0x00,0x78,0x00,0x0F,0xFF,0xF0,0x00,0x00,0x00,0xF8,0x00,0x1F,0xFF,0xF8,0x00,0x00,
    0x00,0xF8,0x00,0x1F,0xFF,0xFE,0x00,0x00,0x00,0xF8,0x00,0x3F,0xFF,0xFF,0x00,0x00,0x00,0xF8,0x00,0x3F,0xFF,0xFF,0x00,0x00,0x01,0xF8,0x00,0x7F,0xFF,0xFF,0x80,0x00,
    0x01,0xF8,0x00,0x7F,0xFF,0xFF,0x80,0x00,0x01,0xFC,0x00,0x7F,0xFF,0xFF,0xC0,0x00,0x01,0xFC,0x00,0x7F,0xFF,0xFF,0xC0,0x00,0x00,0xFC,0x00,0xFF,0xFF,0xFF,0xC0,0x00,
    0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0xF0,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0xF8,0x00,0x00,0x7F,0xFF,0xFF,0xFF,0xFF,0xFC,0x00,0x00,0x7F,0xFF,0xFF,0xFF,0xFF,0xFE,0x00,
    0x00,0x7F,0xFF,0xFF,0xFF,0xFF,0xFF,0x00,0x00,0x7F,0xFF,0xFF,0xFF,0xFF,0xFF,0x80,0x00,0x7F,0xFF,0xFF,0xFF,0xFF,0xFF,0x80,0x00,0x7F,0xFF,0xFF,0xFF,0xFF,0xFF,0xC0,
    0x01,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xC0,0x07,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xE0,0x0F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xE0,0x0F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xE0,
    0x1F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xE0,0x1F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xE0,0x3F,0xFF,0xFF,0xFF,0xFF,0xFF,0x7F,0xE0,0x3F,0xFF,0xFF,0xFF,0xFF,0xFE,0x0F,0xC0,
    0x7F,0xFF,0xFF,0xFF,0xFF,0xB8,0x00,0x00,0x7F,0xFF,0xFF,0xF3,0xFF,0x00,0x00,0x00,0xFF,0xFF,0xFF,0xF3,0xFF,0x80,0x00,0x00,0xFF,0xFF,0xFF,0xF3,0xFF,0xC0,0x00,0x00,
    0xFF,0xFF,0xFF,0xE1,0xFF,0xC0,0x00,0x00,0xFF,0xFF,0xFF,0xE1,0xFF,0xC0,0x00,0x00,0xFF,0xF7,0xFF,0xE1,0xFF,0xC0,0x00,0x00,0xFF,0xF7,0xFF,0xE1,0xFF,0xE0,0x00,0x00,
    0xFF,0xF7,0xFF,0xC1,0xFF,0xE0,0x00,0x00,0xFF,0xF7,0xFF,0xC0,0xFF,0xE0,0x00,0x00,0xFF,0xE7,0xFF,0xC0,0xFF,0xE0,0x00,0x00,0x7F,0xE3,0xFF,0xC0,0xFF,0xC0,0x00,0x00,
    0x3F,0xE3,0xFF,0xC0,0xFF,0xC0,0x00,0x00,0x1F,0xC0,0xFF,0xC0,0xFF,0xC0,0x00,0x00,0x00,0x00,0xFF,0xC0,0xFF,0xC0,0x00,0x00,0x00,0x00,0xFF,0xC0,0xFF,0xC0,0x00,0x00,
    0x00,0x00,0xFF,0xC0,0x7F,0x80,0x00,0x00,0x00,0x00,0x7F,0xC0,0x7F,0x80,0x00,0x00,0x00,0x00,0x3F,0x80,0x3E,0x00,0x00,0x00,0x00,0x00,0x1F,0x00,0x00,0x00,0x00,0x00,
    },
    {
    {0x00,0x00,0x00,0}, {0x00,0x00,0x80,0}, {0x00,0x80,0x00,0}, {0x00,0x80,0x80,0},
    {0x80,0x00,0x00,0}, {0x80,0x00,0x80,0}, {0x80,0x80,0x00,0}, {0xC0,0xC0,0xC0,0},
    {0xC0,0xDC,0xC0,0}, {0xF0,0xCA,0xA6,0}, {0x10,0x08,0x31,0}, {0x00,0x00,0x08,0},
    {0x00,0x00,0x10,0}, {0x00,0x00,0x18,0}, {0x08,0x00,0x18,0}, {0x08,0x00,0x21,0},
    {0x08,0x08,0x21,0}, {0x08,0x00,0x29,0}, {0x08,0x08,0x29,0}, {0x08,0x08,0x31,0},
    {0x10,0x08,0x31,0}, {0x18,0x10,0x31,0}, {0x08,0x08,0x39,0}, {0x10,0x08,0x39,0},
    {0x10,0x10,0x39,0}, {0x10,0x08,0x42,0}, {0x18,0x10,0x42,0}, {0x10,0x08,0x4A,0},
    {0x10,0x10,0x4A,0}, {0x21,0x18,0x4A,0}, {0x21,0x21,0x4A,0}, {0x10,0x08,0x52,0},
    {0x18,0x08,0x52,0}, {0x10,0x10,0x52,0}, {0x18,0x10,0x52,0}, {0x18,0x10,0x5A,0},
    {0x21,0x10,0x5A,0}, {0x18,0x10,0x63,0}, {0x21,0x10,0x63,0}, {0x29,0x18,0x63,0},
    {0x18,0x10,0x6B,0}, {0x21,0x10,0x6B,0}, {0x29,0x18,0x6B,0}, {0x21,0x10,0x73,0},
    {0x21,0x18,0x73,0}, {0x29,0x18,0x73,0}, {0x31,0x21,0x73,0}, {0x42,0x31,0x73,0},
    {0x21,0x10,0x7B,0}, {0x21,0x18,0x7B,0}, {0x29,0x18,0x7B,0}, {0x39,0x31,0x7B,0},
    {0x5A,0x52,0x7B,0}, {0x21,0x18,0x84,0}, {0x29,0x18,0x84,0}, {0x29,0x18,0x8C,0},
    {0x31,0x21,0x8C,0}, {0x42,0x31,0x8C,0}, {0x7B,0x63,0x8C,0}, {0x29,0x18,0x94,0},
    {0x31,0x18,0x94,0}, {0x29,0x18,0x9C,0}, {0x31,0x18,0x9C,0}, {0x29,0x21,0x9C,0},
    {0x31,0x21,0x9C,0}, {0x39,0x29,0x9C,0}, {0x73,0x63,0x9C,0}, {0x29,0x18,0xA5,0},
    {0x31,0x18,0xA5,0}, {0x29,0x21,0xA5,0}, {0x31,0x21,0xA5,0}, {0x39,0x29,0xA5,0},
    {0x42,0x31,0xA5,0}, {0x7B,0x63,0xA5,0}, {0x31,0x21,0xAD,0}, {0x39,0x21,0xAD,0},
    {0x39,0x29,0xAD,0}, {0x42,0x31,0xAD,0}, {0x52,0x31,0xAD,0}, {0x63,0x4A,0xAD,0},
    {0x31,0x21,0xB5,0}, {0x39,0x21,0xB5,0}, {0x39,0x29,0xB5,0}, {0x42,0x29,0xB5,0},
    {0x4A,0x31,0xB5,0}, {0x31,0x21,0xBD,0}, {0x39,0x21,0xBD,0}, {0x39,0x29,0xBD,0},
    {0x42,0x29,0xBD,0}, {0x42,0x31,0xBD,0}, {0x39,0x21,0xC6,0}, {0x39,0x29,0xC6,0},
    {0x42,0x29,0xC6,0}, {0x4A,0x31,0xC6,0}, {0x4A,0x39,0xC6,0}, {0x9C,0x84,0xC6,0},
    {0x39,0x21,0xCE,0}, {0x39,0x29,0xCE,0}, {0x42,0x29,0xCE,0}, {0x42,0x31,0xCE,0},
    {0x4A,0x31,0xCE,0}, {0x4A,0x39,0xCE,0}, {0x52,0x42,0xCE,0}, {0x6B,0x5A,0xCE,0},
    {0x39,0x29,0xD6,0}, {0x42,0x29,0xD6,0}, {0x42,0x31,0xD6,0}, {0x4A,0x31,0xD6,0},
    {0x52,0x31,0xD6,0}, {0x4A,0x39,0xD6,0}, {0x52,0x39,0xD6,0}, {0x42,0x29,0xDE,0},
    {0x4A,0x29,0xDE,0}, {0x42,0x31,0xDE,0}, {0x4A,0x31,0xDE,0}, {0x52,0x39,0xDE,0},
    {0x5A,0x39,0xDE,0}, {0x52,0x42,0xDE,0}, {0x5A,0x42,0xDE,0}, {0x5A,0x4A,0xDE,0},
    {0x6B,0x52,0xDE,0}, {0xB5,0x9C,0xDE,0}, {0x42,0x29,0xE7,0}, {0x4A,0x29,0xE7,0},
    {0x42,0x31,0xE7,0}, {0x4A,0x31,0xE7,0}, {0x52,0x31,0xE7,0}, {0x52,0x39,0xE7,0},
    {0x5A,0x4A,0xE7,0}, {0x63,0x4A,0xE7,0}, {0x6B,0x52,0xE7,0}, {0x6B,0x5A,0xE7,0},
    {0x42,0x29,0xEF,0}, {0x4A,0x29,0xEF,0}, {0x42,0x31,0xEF,0}, {0x4A,0x31,0xEF,0},
    {0x52,0x31,0xEF,0}, {0x52,0x39,0xEF,0}, {0x5A,0x39,0xEF,0}, {0x5A,0x42,0xEF,0},
    {0x63,0x4A,0xEF,0}, {0x63,0x52,0xEF,0}, {0x6B,0x52,0xEF,0}, {0x73,0x52,0xEF,0},
    {0x6B,0x5A,0xEF,0}, {0x9C,0x7B,0xEF,0}, {0xD6,0xBD,0xEF,0}, {0x4A,0x31,0xF7,0},
    {0x52,0x31,0xF7,0}, {0x52,0x39,0xF7,0}, {0x5A,0x39,0xF7,0}, {0x5A,0x42,0xF7,0},
    {0x63,0x4A,0xF7,0}, {0x6B,0x52,0xF7,0}, {0x6B,0x5A,0xF7,0}, {0x73,0x63,0xF7,0},
    {0x8C,0x63,0xF7,0}, {0x7B,0x6B,0xF7,0}, {0x94,0x73,0xF7,0}, {0xD6,0xBD,0xF7,0},
    {0x4A,0x31,0xFF,0}, {0x52,0x31,0xFF,0}, {0x52,0x39,0xFF,0}, {0x5A,0x39,0xFF,0},
    {0x63,0x39,0xFF,0}, {0x5A,0x42,0xFF,0}, {0x63,0x42,0xFF,0}, {0x6B,0x42,0xFF,0},
    {0x63,0x4A,0xFF,0}, {0x6B,0x4A,0xFF,0}, {0x73,0x4A,0xFF,0}, {0x6B,0x52,0xFF,0},
    {0x73,0x52,0xFF,0}, {0x7B,0x52,0xFF,0}, {0x6B,0x5A,0xFF,0}, {0x73,0x5A,0xFF,0},
    {0x7B,0x5A,0xFF,0}, {0x84,0x5A,0xFF,0}, {0x73,0x63,0xFF,0}, {0x7B,0x63,0xFF,0},
    {0x84,0x63,0xFF,0}, {0x8C,0x63,0xFF,0}, {0x84,0x6B,0xFF,0}, {0x8C,0x6B,0xFF,0},
    {0x84,0x73,0xFF,0}, {0x8C,0x73,0xFF,0}, {0x94,0x73,0xFF,0}, {0x9C,0x73,0xFF,0},
    {0x8C,0x7B,0xFF,0}, {0x94,0x7B,0xFF,0}, {0x9C,0x7B,0xFF,0}, {0xA5,0x7B,0xFF,0},
    {0x94,0x84,0xFF,0}, {0x9C,0x84,0xFF,0}, {0xA5,0x84,0xFF,0}, {0xAD,0x84,0xFF,0},
    {0xA5,0x8C,0xFF,0}, {0xAD,0x8C,0xFF,0}, {0xB5,0x8C,0xFF,0}, {0xAD,0x94,0xFF,0},
    {0xB5,0x94,0xFF,0}, {0xBD,0x94,0xFF,0}, {0xAD,0x9C,0xFF,0}, {0xB5,0x9C,0xFF,0},
    {0xBD,0x9C,0xFF,0}, {0xC6,0x9C,0xFF,0}, {0xBD,0xA5,0xFF,0}, {0xC6,0xA5,0xFF,0},
    {0xCE,0xA5,0xFF,0}, {0xBD,0xAD,0xFF,0}, {0xC6,0xAD,0xFF,0}, {0xCE,0xAD,0xFF,0},
    {0xD6,0xAD,0xFF,0}, {0xC6,0xB5,0xFF,0}, {0xCE,0xB5,0xFF,0}, {0xD6,0xB5,0xFF,0},
    {0xDE,0xB5,0xFF,0}, {0xDE,0xBD,0xFF,0}, {0xE7,0xBD,0xFF,0}, {0xDE,0xC6,0xFF,0},
    {0xE7,0xC6,0xFF,0}, {0xDE,0xCE,0xFF,0}, {0xE7,0xCE,0xFF,0}, {0xEF,0xCE,0xFF,0},
    {0xEF,0xD6,0xFF,0}, {0xF7,0xD6,0xFF,0}, {0xF7,0xDE,0xFF,0}, {0xF7,0xE7,0xFF,0},
    {0xFF,0xE7,0xFF,0}, {0xFF,0xEF,0xFF,0}, {0xFF,0xFF,0xFF,0}, {0xFF,0xFF,0xFF,0},
    {0xFF,0xFF,0xFF,0}, {0xFF,0xFF,0xFF,0}, {0xFF,0xFF,0xFF,0}, {0xFF,0xFF,0xFF,0},
    {0xFF,0xFF,0xFF,0}, {0xFF,0xFF,0xFF,0}, {0xFF,0xFF,0xFF,0}, {0xFF,0xFF,0xFF,0},
    {0xFF,0xFF,0xFF,0}, {0xFF,0xFF,0xFF,0}, {0xFF,0xFF,0xFF,0}, {0xFF,0xFF,0xFF,0},
    {0xFF,0xFF,0xFF,0}, {0xFF,0xFF,0xFF,0}, {0xF0,0xFB,0xFF,0}, {0xA4,0xA0,0xA0,0},
    {0x80,0x80,0x80,0}, {0x00,0x00,0xFF,0}, {0x00,0xFF,0x00,0}, {0x00,0xFF,0xFF,0},
    {0xFF,0x00,0x00,0}, {0xFF,0x00,0xFF,0}, {0xFF,0xFF,0x00,0}, {0xFF,0xFF,0xFF,0},
    },
    32,32
    };

GA_colorCursorRGB   rgbCursor = {
    {
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x22,0x16,0x73,0x32,0x21,0xA8,0x36,0x24,0xB5,0x38,0x25,0xBC,
    0x39,0x25,0xBE,0x39,0x25,0xBF,0x30,0x20,0xA1,0x1A,0x12,0x57,0x34,0x22,0xAD,0x3B,0x27,0xC6,0x3D,0x29,0xCC,0x3D,0x29,0xCD,
    0x3C,0x28,0xCB,0x3C,0x28,0xC7,0x38,0x25,0xBB,0x2A,0x1C,0x8E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x21,0x16,0x6E,0x31,0x20,0xA2,0x36,0x24,0xB2,0x38,0x25,0xBA,0x39,0x26,0xBE,
    0x3D,0x29,0xCC,0x45,0x2E,0xE5,0x4E,0x34,0xFC,0x4C,0x32,0xEF,0x3D,0x29,0xCC,0x3D,0x28,0xCA,0x3F,0x2A,0xD3,0x41,0x2B,0xD6,
    0x41,0x2B,0xD8,0x42,0x2C,0xDE,0x47,0x2F,0xED,0x4E,0x34,0xFC,0x3E,0x29,0xCB,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x24,0x17,0x75,0x2C,0x1E,0x94,0x31,0x20,0xA1,0x33,0x22,0xAB,0x36,0x24,0xB4,
    0x3D,0x29,0xCE,0x47,0x30,0xE8,0x54,0x3A,0xFE,0x58,0x3A,0xFE,0x54,0x38,0xFB,0x3D,0x29,0xCA,0x3C,0x28,0xC8,0x3F,0x29,0xD1,
    0x41,0x2B,0xDA,0x46,0x2E,0xE6,0x4E,0x34,0xF8,0x53,0x37,0xFE,0x53,0x37,0xFD,0x35,0x24,0xB1,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x10,0x50,0x22,0x16,0x6F,0x29,0x1B,0x89,0x2C,0x1D,0x94,0x2F,0x1F,0x9E,
    0x38,0x25,0xB8,0x46,0x2F,0xDD,0x7F,0x64,0xFD,0xA5,0x87,0xFE,0x63,0x43,0xFD,0x4E,0x34,0xE5,0x30,0x1F,0x9E,0x37,0x25,0xBA,
    0x3E,0x29,0xCE,0x48,0x31,0xE4,0x9F,0x85,0xFE,0x7E,0x60,0xFD,0x5F,0x3F,0xFE,0x52,0x37,0xF7,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x0A,0x33,0x11,0x0B,0x36,0x17,0x0F,0x4D,0x20,0x15,0x6C,0x27,0x19,0x81,
    0x2D,0x1E,0x99,0x39,0x26,0xBA,0x74,0x5B,0xF2,0x9D,0x81,0xFE,0x8E,0x6D,0xFE,0x5D,0x3F,0xF9,0x1C,0x12,0x5E,0x24,0x17,0x78,
    0x30,0x1F,0xA2,0x3D,0x29,0xC8,0x75,0x5B,0xFB,0x71,0x53,0xFE,0x90,0x72,0xFE,0x59,0x3E,0xF9,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0x0A,0x33,0x11,0x0B,0x38,0x12,0x0B,0x3C,0x12,0x0B,0x3C,0x14,0x0D,0x44,
    0x1D,0x13,0x62,0x29,0x1B,0x8B,0x3D,0x28,0xCB,0x4B,0x32,0xF3,0x90,0x74,0xFE,0x53,0x39,0xF3,0x24,0x17,0x79,0x1A,0x11,0x59,
    0x18,0x10,0x51,0x22,0x16,0x73,0x38,0x25,0xBA,0x4F,0x36,0xF4,0x75,0x5A,0xFC,0x40,0x2B,0xCE,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0E,0x09,0x2C,0x18,0x10,0x52,0x29,0x1B,0x8A,0x34,0x23,0xAE,0x3A,0x26,0xBE,
    0x2F,0x20,0x90,0x19,0x10,0x54,0x1C,0x13,0x60,0x2E,0x1E,0x9C,0x48,0x32,0xDB,0x4E,0x34,0xF7,0x4D,0x34,0xF6,0x3E,0x29,0xCE,
    0x00,0x00,0x00,0x0B,0x08,0x25,0x12,0x0D,0x42,0x26,0x18,0x7D,0x2C,0x1E,0x90,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1A,0x11,0x56,0x30,0x1F,0x9F,0x41,0x2B,0xD7,0x56,0x3B,0xFC,
    0x63,0x46,0xFE,0x39,0x26,0xB9,0x31,0x21,0xA6,0x41,0x2B,0xD8,0x4E,0x34,0xFA,0x63,0x46,0xFE,0x53,0x39,0xF9,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x17,0x10,0x52,0x2D,0x1D,0x96,0x3F,0x2A,0xD3,0x5A,0x3F,0xFB,
    0x77,0x57,0xFE,0x3E,0x29,0xC0,0x39,0x26,0xBF,0x50,0x36,0xF9,0x5A,0x3D,0xFE,0x7B,0x5D,0xFE,0x40,0x2A,0xCC,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x11,0x0C,0x3B,0x2C,0x1C,0x91,0x42,0x2C,0xDD,0x5C,0x40,0xFD,
    0xA7,0x85,0xFE,0x48,0x30,0xD3,0x3D,0x29,0xC8,0x62,0x46,0xFE,0x78,0x58,0xFE,0x92,0x73,0xFE,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x24,0x16,0x76,0x3E,0x29,0xCF,0x54,0x38,0xFD,
    0xB8,0x97,0xFE,0x55,0x39,0xE5,0x3D,0x28,0xC7,0x6A,0x4D,0xFE,0x96,0x77,0xFE,0x7C,0x5E,0xFC,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x15,0x0F,0x4C,0x33,0x21,0xA8,0x4D,0x33,0xF6,
    0xAF,0x90,0xFE,0x64,0x46,0xF2,0x3A,0x27,0xC2,0x63,0x47,0xFE,0xA7,0x87,0xFE,0x5A,0x40,0xE3,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x25,0x18,0x7C,0x44,0x2D,0xE1,
    0x95,0x78,0xFE,0x7A,0x5A,0xF9,0x3E,0x29,0xCB,0x6A,0x4D,0xFE,0xAB,0x8B,0xFE,0x3C,0x28,0xAE,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1C,0x12,0x5E,0x37,0x24,0xBA,
    0x6D,0x50,0xFC,0x8B,0x6C,0xFB,0x3C,0x27,0xC5,0x53,0x39,0xE6,0x76,0x5C,0xE8,0x27,0x1A,0x7F,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x3C,0x2B,0x95,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x25,0x18,0x7B,
    0x43,0x2D,0xD7,0x48,0x33,0xC9,0x35,0x23,0xB1,0x3B,0x27,0xC5,0x40,0x2A,0xD3,0x41,0x2B,0xD9,0x42,0x2C,0xDE,0x3D,0x29,0xCB,
    0x2D,0x1E,0x97,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x30,0x1F,0x9E,
    0x52,0x39,0xC7,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x2C,0x1D,0x94,
    0x34,0x23,0xAC,0x31,0x21,0xA7,0x39,0x26,0xBF,0x40,0x2A,0xD3,0x42,0x2C,0xDE,0x45,0x2E,0xE5,0x4A,0x31,0xF6,0x4F,0x35,0xFD,
    0x52,0x36,0xFE,0x51,0x36,0xF9,0x42,0x2C,0xCD,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x34,0x23,0xAF,0x4F,0x35,0xFB,
    0x72,0x50,0xFE,0x4B,0x32,0xC7,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x2A,0x1C,0x8E,0x3C,0x28,0xC9,
    0x31,0x20,0xA2,0x36,0x23,0xB3,0x3D,0x28,0xCB,0x42,0x2C,0xDC,0x46,0x2E,0xE9,0x4C,0x33,0xF7,0x52,0x38,0xFE,0x56,0x39,0xFE,
    0x58,0x3A,0xFE,0x5A,0x3B,0xFE,0x5A,0x3B,0xFE,0x57,0x3A,0xFE,0x47,0x2F,0xD6,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x41,0x2B,0xD9,0x53,0x37,0xFE,
    0x68,0x47,0xFE,0x4C,0x33,0xCC,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x17,0x0F,0x4A,0x31,0x21,0xA5,0x2F,0x1F,0x9D,
    0x31,0x20,0xA2,0x38,0x25,0xBA,0x3E,0x29,0xCD,0x44,0x2E,0xE0,0x4E,0x37,0xF3,0x5B,0x40,0xFE,0x5F,0x43,0xFF,0x5E,0x40,0xFE,
    0x5C,0x3E,0xFE,0x5B,0x3D,0xFE,0x5C,0x3D,0xFE,0x5D,0x3D,0xFE,0x5B,0x3C,0xFE,0x54,0x37,0xF4,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1D,0x13,0x61,0x4A,0x32,0xEF,0x5E,0x3F,0xFE,
    0x7E,0x5B,0xFE,0x50,0x35,0xCD,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x22,0x16,0x74,0x2E,0x1E,0x9A,0x29,0x1B,0x8C,
    0x32,0x21,0xA6,0x37,0x25,0xB8,0x3C,0x28,0xC7,0x42,0x2D,0xD7,0x59,0x42,0xF4,0x7D,0x64,0xFE,0x8A,0x6D,0xFD,0x7E,0x61,0xFC,
    0x6F,0x51,0xFD,0x64,0x45,0xFE,0x60,0x40,0xFE,0x5E,0x3F,0xFE,0x5E,0x3E,0xFE,0x5C,0x3D,0xFE,0x51,0x36,0xEE,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x26,0x19,0x7F,0x51,0x35,0xF6,0x68,0x47,0xFE,
    0x8D,0x69,0xFE,0x54,0x38,0xD4,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x29,0x1B,0x88,0x29,0x1C,0x8A,0x2A,0x1C,0x8E,
    0x31,0x20,0xA2,0x35,0x23,0xAF,0x38,0x25,0xBB,0x3D,0x29,0xC8,0x54,0x3E,0xE6,0x9C,0x83,0xFF,0xD1,0xB7,0xFF,0xC5,0xA9,0xFF,
    0x9D,0x80,0xFE,0x7B,0x5C,0xFD,0x67,0x48,0xFE,0x61,0x41,0xFE,0x60,0x40,0xFE,0x5F,0x3F,0xFE,0x5C,0x3D,0xFE,0x3F,0x2A,0xC0,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x2C,0x1D,0x93,0x57,0x3B,0xFA,0x7B,0x59,0xFE,
    0xA4,0x7F,0xFE,0x58,0x3B,0xD3,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1A,0x11,0x56,0x2B,0x1C,0x90,0x25,0x19,0x7D,0x2A,0x1A,0x88,
    0x2D,0x1E,0x97,0x31,0x20,0xA3,0x34,0x22,0xAE,0x38,0x26,0xBA,0x42,0x2F,0xCA,0x7A,0x65,0xF4,0xD8,0xBE,0xFD,0xDF,0xC3,0xFE,
    0xAE,0x91,0xFF,0x81,0x64,0xFE,0x68,0x4A,0xFB,0x54,0x39,0xF1,0x52,0x38,0xF5,0x55,0x39,0xFB,0x57,0x3A,0xFD,0x54,0x38,0xFC,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x2D,0x1E,0x95,0x63,0x45,0xFB,0xAA,0x85,0xFD,
    0xCE,0xAD,0xFE,0x61,0x41,0xDD,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x20,0x15,0x6F,0x2B,0x1D,0x92,0x21,0x15,0x6D,0x26,0x18,0x7B,
    0x2B,0x1B,0x8C,0x2C,0x1E,0x97,0x31,0x20,0xA0,0x33,0x21,0xAA,0x37,0x25,0xB3,0x45,0x32,0xC8,0x6D,0x56,0xF4,0x7B,0x62,0xFE,
    0x70,0x55,0xFE,0x65,0x49,0xFD,0x45,0x2F,0xD0,0x53,0x3D,0xE5,0x8C,0x75,0xFD,0x67,0x4A,0xFE,0x62,0x45,0xFE,0x6C,0x4E,0xFE,
    0x3B,0x29,0xAD,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x29,0x1B,0x89,0x6F,0x51,0xF9,0xE6,0xC7,0xFE,
    0xDA,0xBB,0xFE,0x6A,0x48,0xE9,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x24,0x17,0x78,0x2C,0x1D,0x90,0x1A,0x12,0x5D,0x1F,0x15,0x69,
    0x27,0x18,0x7D,0x2A,0x1B,0x89,0x2B,0x1D,0x93,0x2C,0x1E,0x99,0x2D,0x1E,0x9A,0x31,0x21,0xA2,0x3C,0x29,0xC3,0x47,0x30,0xE4,
    0x4D,0x34,0xF5,0x4E,0x35,0xF0,0x29,0x1A,0x89,0x31,0x21,0x9D,0x3E,0x2A,0xC1,0x4B,0x34,0xE9,0x88,0x70,0xFE,0xCC,0xB2,0xFE,
    0x59,0x42,0xE1,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x20,0x15,0x6A,0x5E,0x43,0xED,0xEF,0xDB,0xFF,
    0xD2,0xAF,0xFE,0x6F,0x4C,0xEF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x0B,0x38,0x24,0x17,0x78,0x2B,0x1B,0x8A,0x19,0x11,0x57,0x18,0x10,0x52,
    0x1F,0x15,0x6B,0x25,0x17,0x79,0x29,0x19,0x81,0x28,0x19,0x82,0x28,0x19,0x83,0x2A,0x1C,0x8B,0x30,0x20,0xA3,0x3A,0x27,0xC1,
    0x41,0x2B,0xD6,0x47,0x30,0xE8,0x29,0x1B,0x85,0x15,0x0E,0x49,0x1E,0x13,0x64,0x2D,0x1D,0x93,0x3D,0x2D,0xB2,0x4C,0x39,0xCA,
    0x37,0x25,0xAD,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x14,0x0D,0x44,0x43,0x2D,0xD0,0xD1,0xBA,0xFF,
    0xD7,0xB5,0xFE,0x66,0x48,0xDD,0x1C,0x13,0x60,0x29,0x1C,0x8B,0x30,0x20,0xA1,0x34,0x23,0xAF,0x38,0x25,0xBC,0x3B,0x27,0xC5,
    0x3B,0x27,0xC6,0x38,0x24,0xBB,0x2F,0x1F,0x9D,0x1A,0x11,0x5A,0x23,0x17,0x75,0x28,0x1A,0x84,0x1C,0x13,0x5F,0x11,0x0C,0x3B,
    0x19,0x10,0x53,0x1E,0x14,0x65,0x20,0x15,0x6C,0x21,0x16,0x6E,0x21,0x16,0x71,0x24,0x18,0x78,0x2C,0x1C,0x93,0x3C,0x28,0xC8,
    0x44,0x2E,0xE5,0x49,0x31,0xF1,0x4D,0x34,0xFB,0x4E,0x34,0xEE,0x46,0x2E,0xCD,0x35,0x23,0xA5,0x39,0x27,0xB5,0x54,0x3E,0xE4,
    0x58,0x3B,0xFD,0x51,0x36,0xEC,0x38,0x26,0xA7,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x30,0x1F,0x9E,0x89,0x6F,0xEF,
    0x67,0x55,0xA5,0x2B,0x1C,0x8B,0x2E,0x1F,0x9C,0x33,0x21,0xAA,0x37,0x25,0xB7,0x39,0x26,0xC0,0x3D,0x28,0xCA,0x40,0x2A,0xD6,
    0x43,0x2C,0xE1,0x48,0x30,0xEE,0x4C,0x33,0xF9,0x23,0x18,0x77,0x21,0x16,0x72,0x27,0x19,0x7F,0x24,0x18,0x78,0x0F,0x0A,0x33,
    0x10,0x0B,0x38,0x15,0x0E,0x4A,0x19,0x11,0x56,0x1C,0x12,0x5B,0x1E,0x12,0x5F,0x22,0x17,0x73,0x3A,0x26,0xC1,0x48,0x31,0xE6,
    0x5B,0x43,0xF5,0x72,0x5A,0xFD,0x82,0x68,0xFD,0x79,0x5E,0xFE,0x66,0x49,0xFE,0x59,0x3B,0xF8,0x3C,0x28,0xBE,0x6E,0x5A,0xEE,
    0xAC,0x93,0xFE,0x64,0x47,0xFE,0x5B,0x3C,0xFE,0x4D,0x33,0xE3,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x0F,0x4F,0x22,0x15,0x6D,
    0x23,0x17,0x73,0x2A,0x19,0x83,0x2B,0x1D,0x92,0x30,0x20,0xA2,0x36,0x23,0xB4,0x3A,0x27,0xC2,0x3E,0x28,0xCD,0x41,0x2B,0xDA,
    0x47,0x2E,0xE9,0x4B,0x32,0xF9,0x50,0x35,0xFC,0x1F,0x14,0x65,0x20,0x16,0x6F,0x26,0x18,0x7A,0x2A,0x1C,0x8D,0x18,0x10,0x50,
    0x0F,0x0A,0x32,0x0F,0x0A,0x34,0x11,0x0C,0x3A,0x12,0x0D,0x43,0x19,0x11,0x59,0x35,0x24,0xB2,0x42,0x2D,0xD2,0x63,0x4E,0xF2,
    0x99,0x83,0xFE,0xC5,0xAF,0xFC,0xDE,0xC6,0xFE,0xD6,0xBC,0xFF,0x91,0x75,0xFE,0x5F,0x40,0xFE,0x3D,0x29,0xC5,0x3C,0x2A,0xB6,
    0x76,0x61,0xEC,0x81,0x68,0xFD,0x5D,0x3F,0xFE,0x5A,0x3C,0xFE,0x4C,0x32,0xE8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0x0B,0x39,0x1B,0x10,0x55,
    0x1F,0x14,0x66,0x24,0x17,0x76,0x29,0x19,0x84,0x2C,0x1E,0x94,0x31,0x21,0xA5,0x37,0x24,0xB5,0x3B,0x27,0xC4,0x3F,0x29,0xD2,
    0x45,0x2E,0xE4,0x4B,0x31,0xF9,0x4E,0x34,0xF3,0x1C,0x13,0x5D,0x20,0x16,0x6E,0x24,0x18,0x76,0x2A,0x1C,0x8E,0x2F,0x1F,0x9D,
    0x12,0x0B,0x3B,0x0F,0x0A,0x33,0x0F,0x0A,0x32,0x10,0x0B,0x37,0x2D,0x1E,0x96,0x3B,0x28,0xC3,0x4E,0x39,0xDA,0x75,0x61,0xFA,
    0x9F,0x8A,0xFD,0xBE,0xA9,0xFF,0xDB,0xC4,0xFE,0xE4,0xCC,0xFE,0x9C,0x82,0xFE,0x66,0x48,0xFE,0x3F,0x2A,0xCB,0x2C,0x1E,0x94,
    0x36,0x25,0xA8,0x48,0x33,0xD2,0x53,0x3A,0xF5,0x5E,0x41,0xFE,0x57,0x3A,0xFE,0x47,0x2F,0xDE,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x0B,0x38,0x13,0x0E,0x48,
    0x1B,0x11,0x58,0x1F,0x15,0x68,0x24,0x17,0x77,0x2A,0x1A,0x87,0x2D,0x1E,0x96,0x31,0x20,0xA4,0x36,0x24,0xB4,0x3A,0x27,0xC3,
    0x42,0x2B,0xDC,0x4C,0x32,0xF9,0x4F,0x35,0xEC,0x1A,0x10,0x54,0x1F,0x15,0x69,0x22,0x17,0x75,0x2B,0x1C,0x8F,0x36,0x23,0xB2,
    0x31,0x20,0xA2,0x12,0x0C,0x3D,0x0F,0x09,0x32,0x1E,0x14,0x65,0x34,0x23,0xAE,0x3C,0x29,0xC1,0x52,0x3F,0xD8,0x70,0x5C,0xF4,
    0x8A,0x76,0xFE,0xA0,0x8B,0xFC,0xBB,0xA6,0xFD,0xC3,0xAB,0xFF,0x82,0x68,0xFD,0x74,0x57,0xFE,0x43,0x2C,0xD9,0x2B,0x1C,0x8B,
    0x2C,0x1E,0x96,0x36,0x25,0xB1,0x42,0x2D,0xD5,0x58,0x3E,0xF8,0x62,0x45,0xFE,0x53,0x37,0xFE,0x37,0x25,0xB4,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0E,0x0A,0x30,0x0F,0x0B,0x34,
    0x12,0x0D,0x42,0x1B,0x11,0x58,0x1F,0x15,0x68,0x25,0x17,0x78,0x29,0x1A,0x85,0x2C,0x1E,0x94,0x31,0x20,0xA1,0x36,0x24,0xB2,
    0x3C,0x28,0xCB,0x4E,0x34,0xF7,0x61,0x46,0xED,0x17,0x10,0x4C,0x1C,0x12,0x5F,0x20,0x16,0x6D,0x2A,0x1B,0x8C,0x34,0x23,0xAF,
    0x3C,0x28,0xC9,0x3C,0x28,0xC7,0x20,0x16,0x68,0x28,0x1B,0x89,0x32,0x21,0xA6,0x39,0x27,0xB5,0x48,0x36,0xC6,0x5A,0x48,0xDA,
    0x6C,0x59,0xEE,0x7D,0x6A,0xFC,0x94,0x7F,0xFD,0x93,0x7C,0xFF,0x68,0x4E,0xFE,0x8B,0x70,0xFE,0x45,0x2D,0xE1,0x28,0x19,0x82,
    0x2A,0x1C,0x8B,0x2F,0x1F,0x9D,0x39,0x26,0xBA,0x43,0x2D,0xDC,0x73,0x59,0xFB,0x5D,0x41,0xFE,0x4F,0x34,0xFA,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x12,0x0C,0x3C,0x0F,0x0A,0x32,
    0x0F,0x0A,0x32,0x11,0x0B,0x37,0x16,0x0E,0x49,0x1C,0x13,0x5F,0x22,0x16,0x71,0x28,0x19,0x81,0x2C,0x1D,0x92,0x31,0x20,0xA4,
    0x38,0x25,0xB9,0x4C,0x34,0xE9,0xA1,0x84,0xF9,0x1E,0x18,0x49,0x1A,0x10,0x54,0x1D,0x13,0x62,0x27,0x19,0x81,0x31,0x21,0xA5,
    0x3A,0x27,0xC2,0x43,0x2C,0xDC,0x38,0x26,0xB8,0x29,0x1A,0x87,0x2D,0x1F,0x9A,0x32,0x22,0xA4,0x39,0x28,0xAF,0x44,0x32,0xBC,
    0x50,0x3E,0xCB,0x5E,0x4B,0xDE,0x69,0x56,0xF1,0x64,0x4E,0xF6,0x6C,0x53,0xFB,0x95,0x7C,0xFD,0x43,0x2D,0xDD,0x20,0x15,0x6D,
    0x24,0x17,0x78,0x28,0x1A,0x84,0x2F,0x20,0x9E,0x38,0x25,0xB9,0x54,0x3D,0xE3,0x8F,0x74,0xFE,0x52,0x37,0xFE,0x3A,0x26,0xBF,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x2A,0x1C,0x8F,0x47,0x2F,0xE1,0x3A,0x27,0x9B,0x0F,0x0A,0x33,
    0x0F,0x0A,0x32,0x0F,0x0A,0x32,0x0F,0x0A,0x32,0x10,0x0B,0x34,0x13,0x0D,0x40,0x1A,0x12,0x5A,0x27,0x18,0x7B,0x2E,0x1E,0x96,
    0x34,0x22,0xAC,0x41,0x2C,0xD7,0x75,0x59,0xFB,0x37,0x2A,0x6B,0x13,0x0D,0x42,0x18,0x10,0x53,0x21,0x15,0x6A,0x2B,0x1C,0x8F,
    0x34,0x22,0xAB,0x3B,0x27,0xC4,0x27,0x1A,0x84,0x28,0x1A,0x82,0x2B,0x1D,0x92,0x2F,0x1F,0x9A,0x33,0x22,0xA0,0x37,0x27,0xA8,
    0x3C,0x2C,0xB0,0x44,0x33,0xBD,0x49,0x36,0xCC,0x47,0x32,0xD9,0x94,0x7C,0xF7,0x74,0x5D,0xF6,0x3C,0x27,0xC5,0x1B,0x11,0x56,
    0x1E,0x13,0x62,0x1F,0x15,0x69,0x27,0x19,0x7F,0x2C,0x1F,0x98,0x38,0x25,0xB6,0x89,0x72,0xF0,0x72,0x58,0xFE,0x49,0x30,0xF2,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x2C,0x1C,0x91,0x3F,0x2A,0xD2,0x6F,0x4F,0xFD,0x91,0x6E,0xF6,0x3B,0x2B,0x74,
    0x0F,0x0A,0x32,0x0F,0x0A,0x32,0x0F,0x0A,0x32,0x0F,0x0A,0x33,0x0F,0x0A,0x32,0x0F,0x0A,0x32,0x15,0x0E,0x47,0x27,0x18,0x7B,
    0x32,0x20,0xA3,0x40,0x2B,0xD6,0x4C,0x34,0xF3,0x57,0x40,0xD4,0x15,0x0F,0x40,0x11,0x0C,0x3C,0x17,0x10,0x4F,0x20,0x15,0x6B,
    0x28,0x1A,0x85,0x2C,0x1D,0x93,0x1C,0x12,0x5D,0x23,0x16,0x72,0x2B,0x1C,0x8A,0x2B,0x1D,0x94,0x2F,0x1F,0x9A,0x32,0x21,0x9C,
    0x34,0x24,0x9F,0x37,0x27,0xA9,0x39,0x27,0xB8,0x42,0x2D,0xCD,0x98,0x83,0xFC,0x4E,0x37,0xE7,0x2B,0x1C,0x8E,0x13,0x0D,0x43,
    0x16,0x0F,0x4F,0x1A,0x10,0x55,0x1F,0x14,0x64,0x27,0x19,0x7D,0x2C,0x1E,0x95,0x42,0x30,0xBD,0x97,0x7F,0xFB,0x4D,0x34,0xF8,
    0x2D,0x1E,0x97,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x22,0x16,0x73,0x33,0x22,0xAA,0x4A,0x31,0xEA,0xBA,0x9B,0xFE,0xE8,0xC8,0xFE,0xBE,0x96,0xFD,
    0x69,0x4D,0xC2,0x2B,0x1D,0x73,0x12,0x0C,0x3F,0x14,0x0D,0x42,0x21,0x1A,0x4B,0x49,0x3F,0x65,0x46,0x39,0x6D,0x18,0x11,0x47,
    0x28,0x1A,0x83,0x3C,0x28,0xC7,0x49,0x31,0xF1,0x55,0x3A,0xFD,0x4D,0x35,0xD4,0x23,0x17,0x63,0x13,0x0D,0x3D,0x15,0x0E,0x49,
    0x1E,0x14,0x67,0x29,0x1B,0x83,0x17,0x10,0x51,0x1C,0x12,0x58,0x22,0x16,0x73,0x2A,0x1B,0x88,0x2B,0x1E,0x93,0x2C,0x1F,0x96,
    0x2C,0x1F,0x96,0x31,0x20,0x9D,0x34,0x23,0xAD,0x52,0x3E,0xD4,0x65,0x50,0xED,0x42,0x2C,0xD9,0x15,0x0E,0x47,0x0F,0x0A,0x33,
    0x11,0x0B,0x38,0x11,0x0C,0x3E,0x15,0x0E,0x48,0x1D,0x13,0x61,0x25,0x18,0x78,0x2D,0x1E,0x93,0x5F,0x4C,0xD3,0x5E,0x47,0xF6,
    0x3C,0x28,0xC7,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x14,0x0D,0x44,0x2B,0x1D,0x90,0x35,0x23,0xB2,0x51,0x37,0xF1,0xB6,0x96,0xFF,0xEE,0xD0,0xFF,0xF8,0xE0,0xFD,
    0x9A,0x74,0xFD,0x61,0x40,0xF3,0x2D,0x1E,0x97,0x4A,0x32,0xE8,0x80,0x61,0xFD,0xC3,0x9F,0xFF,0xF1,0xD4,0xFE,0xA2,0x86,0xCE,
    0x20,0x17,0x5A,0x2D,0x1D,0x96,0x3E,0x29,0xD0,0x57,0x3C,0xF9,0x6C,0x48,0xFE,0x69,0x46,0xFE,0x72,0x54,0xEF,0x89,0x72,0xC8,
    0x4E,0x36,0xDF,0x8A,0x6D,0xF0,0x1D,0x18,0x47,0x19,0x0F,0x51,0x1E,0x14,0x67,0x25,0x17,0x7A,0x2A,0x1A,0x85,0x2B,0x1A,0x87,
    0x2B,0x1B,0x87,0x2C,0x1D,0x91,0x31,0x21,0xA2,0x4F,0x3C,0xD0,0x44,0x2F,0xD5,0x4A,0x31,0xE0,0x36,0x25,0x96,0x0E,0x0A,0x31,
    0x0F,0x0A,0x32,0x0F,0x0A,0x32,0x0F,0x0A,0x33,0x13,0x0D,0x42,0x1B,0x12,0x5B,0x23,0x17,0x74,0x31,0x21,0x99,0x51,0x3B,0xDF,
    0x3D,0x29,0xCA,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x24,0x17,0x77,0x2E,0x1F,0x9D,0x3C,0x28,0xC9,0x5C,0x41,0xFB,0x9D,0x7B,0xFF,0xD0,0xAC,0xFD,0xFB,0xE7,0xFE,
    0x91,0x6C,0xFE,0x5E,0x3E,0xF3,0x27,0x19,0x81,0x40,0x2B,0xD7,0x5B,0x3E,0xFE,0x77,0x55,0xFE,0xD0,0xB2,0xFF,0xE6,0xC8,0xFD,
    0x56,0x3E,0xC2,0x3A,0x27,0xC2,0x49,0x31,0xE8,0xA8,0x8B,0xFE,0xA1,0x7D,0xFE,0x78,0x53,0xFD,0x67,0x45,0xFE,0x48,0x34,0xB5,
    0x44,0x2F,0xD5,0x80,0x65,0xFB,0x7A,0x68,0xAB,0x0F,0x0B,0x34,0x15,0x0F,0x4A,0x1C,0x13,0x5F,0x20,0x15,0x69,0x21,0x15,0x6B,
    0x21,0x16,0x6D,0x24,0x17,0x78,0x2E,0x1E,0x95,0x3A,0x28,0xBB,0x3D,0x29,0xCA,0x80,0x63,0xF3,0x6B,0x4D,0xFC,0x13,0x0D,0x3F,
    0x0F,0x0A,0x32,0x0F,0x0A,0x32,0x0E,0x0A,0x32,0x0F,0x0A,0x33,0x12,0x0D,0x40,0x1B,0x11,0x5B,0x25,0x18,0x7B,0x35,0x24,0xAE,
    0x39,0x26,0xBF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x14,0x0D,0x44,0x2A,0x1C,0x8D,0x33,0x22,0xAA,0x42,0x2C,0xDE,0x66,0x48,0xFE,0x91,0x6F,0xFF,0xC7,0xA4,0xFD,0xF2,0xD4,0xFE,
    0x86,0x61,0xFE,0x5B,0x3C,0xF0,0x24,0x17,0x78,0x3A,0x27,0xC4,0x55,0x38,0xFE,0x68,0x48,0xFE,0xA8,0x85,0xFE,0x9D,0x85,0xD1,
    0x38,0x25,0xB7,0x3F,0x2A,0xD2,0x5E,0x45,0xF8,0xCA,0xAB,0xFE,0xCD,0xA8,0xFF,0xA7,0x84,0xFD,0x5B,0x3D,0xF9,0x27,0x1A,0x84,
    0x27,0x19,0x82,0x3B,0x27,0xC4,0x57,0x3D,0xF4,0x32,0x23,0x85,0x0F,0x0A,0x33,0x0F,0x0B,0x34,0x11,0x0B,0x3A,0x12,0x0C,0x3E,
    0x16,0x0F,0x4A,0x21,0x15,0x6E,0x2E,0x1F,0x9B,0x35,0x23,0xB0,0x36,0x25,0xB2,0x57,0x43,0xD3,0x52,0x3D,0xDF,0x00,0x00,0x00,
    0x00,0x00,0x00,0x0E,0x09,0x2D,0x0F,0x0A,0x32,0x0F,0x0A,0x33,0x0F,0x0A,0x32,0x12,0x0D,0x3F,0x1B,0x12,0x5D,0x29,0x1B,0x8B,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x1F,0x14,0x6C,0x2D,0x1E,0x95,0x38,0x25,0xBA,0x49,0x30,0xEC,0x6A,0x4B,0xFF,0x89,0x68,0xFF,0xC3,0xA0,0xFF,0xE2,0xBD,0xFF,
    0x7C,0x59,0xFE,0x57,0x39,0xE8,0x21,0x16,0x70,0x34,0x23,0xB0,0x50,0x35,0xFA,0x61,0x42,0xFE,0x6E,0x50,0xE3,0x36,0x25,0xA9,
    0x3A,0x27,0xC2,0x48,0x31,0xE5,0x82,0x67,0xFE,0xB6,0x95,0xFD,0xEF,0xD3,0xFE,0xAB,0x89,0xFE,0x4B,0x31,0xDD,0x18,0x10,0x50,
    0x1D,0x13,0x60,0x2B,0x1C,0x8D,0x3F,0x2A,0xD3,0x50,0x36,0xF7,0x3C,0x2B,0x96,0x14,0x10,0x3A,0x0D,0x0B,0x30,0x0F,0x0A,0x32,
    0x11,0x0C,0x3C,0x20,0x14,0x69,0x22,0x16,0x71,0x1E,0x13,0x64,0x22,0x15,0x70,0x26,0x19,0x7F,0x1C,0x13,0x60,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0B,0x08,0x25,0x0B,0x07,0x24,0x0B,0x08,0x27,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x26,0x19,0x7E,0x2E,0x1F,0x9D,0x3C,0x28,0xC9,0x4F,0x35,0xF6,0x6B,0x4C,0xFE,0x86,0x64,0xFE,0xC2,0x9F,0xFD,0xCB,0xA6,0xFD,
    0x75,0x52,0xFE,0x50,0x35,0xDC,0x1F,0x14,0x69,0x30,0x1F,0x9D,0x4B,0x32,0xF2,0x5A,0x3C,0xF9,0x35,0x23,0xA2,0x36,0x23,0xB2,
    0x3E,0x29,0xCC,0x56,0x3E,0xF5,0xA2,0x84,0xFF,0xBB,0x9A,0xFF,0xED,0xD3,0xFE,0x76,0x56,0xFE,0x35,0x23,0xA5,0x06,0x04,0x14,
    0x14,0x0D,0x46,0x20,0x15,0x69,0x33,0x21,0xA9,0x46,0x2E,0xE8,0x58,0x3C,0xFE,0x94,0x77,0xEE,0xB3,0x9E,0xC7,0x66,0x4E,0xBE,
    0x28,0x1B,0x73,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x17,0x10,0x52,
    0x29,0x1A,0x84,0x31,0x21,0xA7,0x41,0x2B,0xD8,0x55,0x3A,0xFC,0x6B,0x4C,0xFE,0x87,0x65,0xFF,0xC4,0xA1,0xFF,0xB8,0x93,0xFF,
    0x70,0x4D,0xFD,0x47,0x2F,0xCA,0x1D,0x13,0x61,0x2C,0x1B,0x8D,0x46,0x2E,0xE4,0x3C,0x28,0xBA,0x30,0x1F,0xA0,0x37,0x24,0xB6,
    0x43,0x2D,0xDA,0x71,0x57,0xFC,0x99,0x79,0xFE,0xDA,0xB9,0xFD,0xB9,0x9A,0xFE,0x5E,0x41,0xFE,0x00,0x00,0x00,0x00,0x00,0x00,
    0x10,0x0A,0x35,0x19,0x10,0x53,0x27,0x18,0x7E,0x3D,0x29,0xCC,0x4C,0x33,0xF7,0x65,0x49,0xFE,0xC1,0xA3,0xFF,0xD7,0xB5,0xFD,
    0x6D,0x4E,0xF2,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1D,0x13,0x63,
    0x29,0x1A,0x84,0x33,0x22,0xAC,0x46,0x2E,0xE6,0x5B,0x3E,0xFE,0x6D,0x4D,0xFE,0x8C,0x6A,0xFF,0xC6,0xA3,0xFD,0xA7,0x83,0xFF,
    0x6B,0x49,0xFD,0x3C,0x28,0xB0,0x19,0x11,0x56,0x27,0x19,0x7E,0x3A,0x26,0xBF,0x29,0x1B,0x8A,0x30,0x20,0xA2,0x37,0x25,0xB8,
    0x4A,0x33,0xE5,0x7C,0x5F,0xFE,0xA2,0x83,0xFF,0xCA,0xAB,0xFD,0x7F,0x61,0xFE,0x50,0x36,0xF1,0x00,0x00,0x00,0x00,0x00,0x00,
    0x0B,0x08,0x27,0x12,0x0C,0x40,0x1C,0x12,0x5C,0x31,0x1F,0xA0,0x44,0x2D,0xE2,0x52,0x38,0xFD,0x78,0x5C,0xFE,0xC6,0xA7,0xFF,
    0xB1,0x90,0xFD,0x48,0x31,0xBC,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1E,0x14,0x65,
    0x27,0x19,0x81,0x31,0x21,0xA6,0x46,0x2E,0xE5,0x5C,0x3F,0xFE,0x6F,0x4F,0xFE,0x94,0x72,0xFF,0xCB,0xA8,0xFE,0x98,0x75,0xFE,
    0x69,0x46,0xFE,0x2F,0x1F,0x8F,0x13,0x0D,0x44,0x1F,0x14,0x68,0x27,0x19,0x80,0x2A,0x1B,0x8B,0x2F,0x20,0x9E,0x37,0x25,0xB7,
    0x52,0x3A,0xED,0x7B,0x5C,0xFE,0xB4,0x96,0xFF,0x9E,0x80,0xFF,0x65,0x48,0xFE,0x3C,0x28,0xBF,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x11,0x0B,0x37,0x16,0x0F,0x4D,0x24,0x16,0x74,0x3C,0x27,0xC8,0x4C,0x32,0xF6,0x60,0x45,0xFE,0x95,0x77,0xFF,
    0xC6,0xA6,0xFD,0x7B,0x5C,0xF7,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x09,0x07,0x25,0x1D,0x13,0x60,
    0x24,0x17,0x78,0x2F,0x1E,0x9B,0x40,0x2B,0xD9,0x51,0x36,0xFD,0x62,0x43,0xFE,0x89,0x67,0xFF,0xB1,0x8E,0xFF,0x77,0x56,0xFE,
    0x50,0x35,0xE6,0x12,0x0C,0x3B,0x14,0x0E,0x49,0x16,0x0F,0x4E,0x21,0x15,0x6A,0x29,0x1A,0x85,0x2D,0x1E,0x97,0x35,0x23,0xB1,
    0x54,0x3A,0xF4,0x90,0x72,0xFE,0xB4,0x96,0xFC,0x89,0x6B,0xFE,0x5C,0x3F,0xFE,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x11,0x0B,0x38,0x15,0x0F,0x4C,0x1E,0x13,0x62,0x32,0x21,0xAA,0x48,0x30,0xEE,0x5B,0x40,0xFE,0x83,0x66,0xFE,
    0xB8,0x9A,0xFF,0x90,0x71,0xFD,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0B,0x07,0x27,0x1B,0x11,0x59,
    0x22,0x16,0x70,0x2D,0x1D,0x95,0x3E,0x29,0xCF,0x49,0x30,0xF2,0x52,0x36,0xFE,0x5F,0x41,0xFE,0x67,0x48,0xFE,0x56,0x39,0xFE,
    0x3A,0x27,0xC0,0x09,0x06,0x20,0x19,0x0F,0x53,0x19,0x11,0x57,0x1F,0x14,0x65,0x27,0x18,0x7D,0x2A,0x1B,0x8A,0x33,0x22,0xAC,
    0x55,0x3A,0xF8,0x9B,0x7E,0xFF,0xB6,0x98,0xFD,0x84,0x66,0xFE,0x55,0x3A,0xFA,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x0F,0x0B,0x38,0x19,0x10,0x55,0x1E,0x14,0x63,0x2B,0x1C,0x8F,0x43,0x2C,0xDE,0x53,0x39,0xFD,0x75,0x58,0xFE,
    0xAC,0x8E,0xFF,0x91,0x73,0xFE,0x3A,0x27,0xAD,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x09,0x07,0x23,0x18,0x0F,0x51,
    0x1F,0x15,0x6A,0x2D,0x1D,0x94,0x3F,0x2A,0xD1,0x4A,0x30,0xF3,0x51,0x36,0xFE,0x5B,0x3D,0xFE,0x5E,0x3F,0xFE,0x56,0x39,0xFD,
    0x32,0x20,0xA0,0x08,0x06,0x1E,0x19,0x10,0x53,0x18,0x10,0x54,0x1B,0x12,0x5D,0x22,0x17,0x74,0x27,0x19,0x81,0x33,0x22,0xAC,
    0x54,0x3A,0xF8,0x96,0x78,0xFF,0xB0,0x91,0xFF,0x75,0x57,0xFE,0x48,0x30,0xDD,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x0F,0x0B,0x35,0x1C,0x11,0x5C,0x1F,0x15,0x69,0x27,0x19,0x81,0x3C,0x28,0xCB,0x4D,0x33,0xF8,0x67,0x4B,0xFF,
    0x9E,0x80,0xFE,0x8B,0x6D,0xFD,0x41,0x2B,0xC2,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x15,0x0E,0x49,
    0x1D,0x13,0x62,0x2A,0x1C,0x8E,0x3E,0x29,0xCD,0x48,0x30,0xF0,0x50,0x35,0xFE,0x59,0x3C,0xFE,0x5B,0x3D,0xFE,0x54,0x38,0xFF,
    0x24,0x19,0x79,0x00,0x00,0x00,0x18,0x10,0x50,0x18,0x10,0x53,0x19,0x10,0x52,0x1F,0x15,0x6A,0x25,0x18,0x7A,0x33,0x22,0xAB,
    0x52,0x38,0xF8,0x8C,0x6F,0xFE,0xA4,0x86,0xFD,0x69,0x4B,0xFE,0x3C,0x27,0xBC,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x0C,0x08,0x2B,0x1D,0x13,0x62,0x20,0x16,0x6F,0x26,0x19,0x7E,0x38,0x25,0xBC,0x48,0x30,0xF0,0x5C,0x41,0xFE,
    0x8E,0x71,0xFF,0x80,0x62,0xFE,0x41,0x2C,0xC7,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x11,0x0C,0x3F,
    0x1B,0x11,0x5A,0x26,0x19,0x81,0x3A,0x26,0xC2,0x46,0x2E,0xE8,0x4E,0x33,0xFC,0x56,0x39,0xFE,0x57,0x3A,0xFE,0x4F,0x35,0xFB,
    0x00,0x00,0x00,0x00,0x00,0x00,0x14,0x0E,0x47,0x18,0x10,0x51,0x14,0x0E,0x47,0x1D,0x13,0x5D,0x21,0x16,0x70,0x33,0x21,0xAA,
    0x4E,0x35,0xF5,0x7E,0x62,0xFE,0x95,0x77,0xFE,0x60,0x43,0xFE,0x33,0x22,0xA6,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x1E,0x14,0x66,0x22,0x17,0x75,0x27,0x19,0x81,0x36,0x23,0xB4,0x46,0x2E,0xE7,0x56,0x3B,0xFE,
    0x85,0x67,0xFF,0x72,0x55,0xFE,0x3B,0x28,0xBE,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0E,0x09,0x2E,
    0x13,0x0D,0x40,0x1F,0x14,0x6B,0x34,0x22,0xAD,0x40,0x2B,0xD7,0x49,0x30,0xF1,0x4F,0x35,0xFE,0x4F,0x35,0xFD,0x3E,0x29,0xCD,
    0x00,0x00,0x00,0x00,0x00,0x00,0x0E,0x09,0x31,0x14,0x0E,0x47,0x11,0x0C,0x3E,0x19,0x10,0x52,0x1F,0x13,0x62,0x2E,0x1F,0x9C,
    0x48,0x30,0xEA,0x70,0x55,0xFE,0x8D,0x6F,0xFE,0x5C,0x3F,0xFE,0x2C,0x1D,0x8E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x1D,0x13,0x63,0x25,0x18,0x79,0x28,0x1A,0x86,0x34,0x24,0xB1,0x44,0x2D,0xE0,0x53,0x38,0xFC,
    0x79,0x5C,0xFE,0x60,0x44,0xFE,0x33,0x22,0xA7,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x0D,0x08,0x2D,0x12,0x0C,0x3D,0x20,0x15,0x6E,0x2F,0x1F,0x9D,0x3A,0x26,0xC2,0x41,0x2B,0xDB,0x3C,0x28,0xCB,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0E,0x09,0x30,0x0F,0x0B,0x37,0x14,0x0E,0x49,0x1C,0x11,0x58,0x29,0x1B,0x88,
    0x41,0x2B,0xD7,0x5E,0x43,0xFC,0x81,0x64,0xFE,0x59,0x3C,0xFE,0x28,0x1A,0x84,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x1B,0x12,0x5F,0x27,0x18,0x7E,0x2A,0x1C,0x8E,0x35,0x23,0xB2,0x40,0x2A,0xD6,0x4D,0x34,0xF6,
    0x62,0x47,0xFE,0x51,0x37,0xFB,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x0A,0x06,0x20,0x0E,0x09,0x32,0x15,0x0E,0x49,0x1E,0x14,0x68,0x23,0x17,0x75,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0E,0x09,0x2F,0x12,0x0D,0x41,0x19,0x10,0x52,0x24,0x17,0x79,
    0x3B,0x27,0xC4,0x4D,0x34,0xF1,0x66,0x4A,0xFE,0x54,0x39,0xFE,0x29,0x1B,0x88,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x19,0x11,0x5A,0x26,0x18,0x7F,0x2E,0x1F,0x9A,0x3A,0x27,0xC2,0x43,0x2D,0xDF,0x4E,0x35,0xF7,
    0x5D,0x43,0xFE,0x4E,0x34,0xF9,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0C,0x08,0x28,0x10,0x0B,0x37,0x15,0x0F,0x4B,0x23,0x16,0x72,
    0x39,0x25,0xBE,0x48,0x31,0xEA,0x61,0x47,0xFE,0x57,0x3A,0xFE,0x2E,0x1F,0x93,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x16,0x0E,0x4C,0x24,0x17,0x78,0x2D,0x1E,0x98,0x3B,0x27,0xC5,0x44,0x2D,0xE1,0x50,0x37,0xF9,
    0x5B,0x40,0xFE,0x48,0x2F,0xEB,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x09,0x06,0x1F,0x0F,0x0A,0x32,0x11,0x0C,0x3E,0x1E,0x13,0x63,
    0x36,0x23,0xB4,0x46,0x2F,0xE4,0x5E,0x44,0xFE,0x56,0x3A,0xFE,0x2D,0x1E,0x93,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x0D,0x09,0x31,0x1D,0x13,0x62,0x27,0x1A,0x84,0x35,0x23,0xB0,0x3E,0x29,0xCF,0x47,0x30,0xEA,
    0x4A,0x31,0xEE,0x36,0x24,0xB4,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0E,0x0A,0x31,0x10,0x0A,0x34,0x14,0x0E,0x49,
    0x2D,0x1D,0x95,0x3C,0x28,0xCA,0x4C,0x34,0xEE,0x4C,0x32,0xF6,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x11,0x0B,0x39,0x15,0x0F,0x4A,0x20,0x15,0x6E,0x2C,0x1D,0x93,0x34,0x22,0xAE,
    0x34,0x23,0xB0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x09,0x06,0x20,0x0E,0x0A,0x32,0x0F,0x0A,0x33,
    0x1A,0x11,0x58,0x2A,0x1C,0x8D,0x35,0x23,0xB1,0x33,0x22,0xAE,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0D,0x09,0x2E,0x0F,0x0A,0x33,0x14,0x0D,0x44,0x19,0x11,0x57,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0E,0x09,0x2E,
    0x10,0x0A,0x34,0x14,0x0E,0x48,0x1B,0x12,0x5C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    },
    {
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0xFF,0xF0,0x00,0x00,
    0x00,0x00,0x00,0x1F,0xFF,0xF8,0x00,0x00,0x00,0x00,0x00,0x1F,0xFF,0xFC,0x00,0x00,0x00,0x00,0x00,0x1F,0xFF,0xFC,0x00,0x00,0x00,0x00,0x00,0x1F,0xFF,0xFC,0x00,0x00,
    0x00,0x00,0x00,0x1F,0xFF,0xFC,0x00,0x00,0x00,0x00,0x00,0x1F,0xFF,0x78,0x00,0x00,0x00,0x00,0x00,0x0F,0xFE,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0xFE,0x00,0x00,0x00,
    0x00,0x00,0x00,0x0F,0xFC,0x00,0x00,0x00,0x00,0x00,0x00,0x07,0xFC,0x00,0x00,0x00,0x00,0x00,0x00,0x07,0xFC,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0xFC,0x00,0x00,0x00,
    0x00,0x00,0x00,0x03,0xFC,0x00,0x00,0x00,0x00,0x00,0x80,0x01,0xFF,0x80,0x00,0x00,0x00,0x01,0x80,0x01,0xFF,0xE0,0x00,0x00,0x00,0x03,0xC0,0x03,0xFF,0xF8,0x00,0x00,
    0x00,0x03,0xC0,0x07,0xFF,0xFC,0x00,0x00,0x00,0x07,0xC0,0x07,0xFF,0xFE,0x00,0x00,0x00,0x07,0xC0,0x07,0xFF,0xFF,0x00,0x00,0x00,0x07,0xC0,0x0F,0xFF,0xFF,0x00,0x00,
    0x00,0x07,0xC0,0x0F,0xFF,0xFF,0x80,0x00,0x00,0x07,0xC0,0x0F,0xFF,0xFF,0x80,0x00,0x00,0x07,0xC0,0x1F,0xFF,0xFF,0x80,0x00,0x00,0x07,0xFF,0xFF,0xFF,0xFF,0xE0,0x00,
    0x00,0x03,0xFF,0xFF,0xFF,0xFF,0xF0,0x00,0x00,0x03,0xFF,0xFF,0xFF,0xFF,0xF8,0x00,0x00,0x03,0xFF,0xFF,0xFF,0xFF,0xFC,0x00,0x00,0x03,0xFF,0xFF,0xFF,0xFF,0xFE,0x00,
    0x00,0x03,0xFF,0xFF,0xFF,0xFF,0xFE,0x00,0x00,0x03,0xFF,0xFF,0xFF,0xFF,0xFF,0x00,0x00,0x0F,0xFF,0xFF,0xFF,0xFF,0xFF,0x00,0x00,0x1F,0xFF,0xFF,0xFF,0xFF,0xFF,0x80,
    0x00,0x3F,0xFF,0xFF,0xFF,0xFF,0xFF,0x80,0x00,0x7F,0xFF,0xFF,0xFF,0xFF,0xFF,0x80,0x00,0x7F,0xFF,0xFF,0xFF,0xFF,0xFF,0x80,0x00,0xFF,0xFF,0xFF,0xFF,0xFE,0x7F,0x00,
    0x00,0xFF,0xFF,0xFF,0xFF,0xFE,0x0E,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0x80,0x00,0x00,0x01,0xFF,0xFF,0xFC,0xFF,0x80,0x00,0x00,0x01,0xFF,0xFF,0xFC,0xFF,0xC0,0x00,0x00,
    0x01,0xFF,0xFF,0xFC,0x7F,0xC0,0x00,0x00,0x03,0xFF,0xFF,0xF8,0x7F,0xC0,0x00,0x00,0x03,0xFF,0xFF,0xF8,0x7F,0xE0,0x00,0x00,0x03,0xFF,0xFF,0xF8,0x7F,0xE0,0x00,0x00,
    0x01,0xFF,0xBF,0xF8,0x7F,0xE0,0x00,0x00,0x01,0xFF,0x3F,0xF8,0x3F,0xE0,0x00,0x00,0x01,0xFF,0x3F,0xF8,0x3F,0xE0,0x00,0x00,0x00,0xFE,0x1F,0xF8,0x3F,0xC0,0x00,0x00,
    0x00,0x7C,0x0F,0xF8,0x3F,0xC0,0x00,0x00,0x00,0x00,0x0F,0xF8,0x3F,0xC0,0x00,0x00,0x00,0x00,0x0F,0xF8,0x3F,0xC0,0x00,0x00,0x00,0x00,0x07,0xF0,0x1F,0x80,0x00,0x00,
    0x00,0x00,0x07,0xF0,0x0F,0x00,0x00,0x00,0x00,0x00,0x01,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    },
    32,32
    };

GA_colorCursorRGBA  alphaCursor = {
    {
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x01,0x00,0x03,0x00,0x01,0x00,0x07,0x00,0x01,0x00,0x07,
    0x00,0x01,0x00,0x06,0x00,0x01,0x00,0x03,0x00,0x01,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x01,0x00,0x03,0x00,0x01,0x00,0x06,0x00,0x01,0x00,0x07,0x00,0x01,0x00,0x07,
    0x00,0x01,0x00,0x07,0x00,0x01,0x00,0x06,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x01,0x00,0x04,0x00,0x01,0x00,0x1C,0x0B,0x08,0x26,0x4C,0x1B,0x13,0x5C,0x6E,0x20,0x16,0x6D,0x74,
    0x1A,0x12,0x57,0x6E,0x0D,0x09,0x2B,0x4E,0x00,0x01,0x01,0x23,0x00,0x01,0x00,0x14,0x07,0x06,0x18,0x42,0x1D,0x13,0x61,0x6D,0x23,0x17,0x75,0x74,0x24,0x17,0x76,0x74,
    0x23,0x17,0x73,0x73,0x19,0x11,0x55,0x66,0x04,0x03,0x0C,0x37,0x00,0x01,0x00,0x12,0x00,0x01,0x00,0x02,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x06,0x05,0x05,0x12,0x3E,0x22,0x16,0x73,0x9F,0x32,0x21,0xA8,0xDD,0x36,0x24,0xB5,0xF0,0x38,0x25,0xBC,0xF2,
    0x39,0x25,0xBE,0xF0,0x39,0x25,0xBF,0xE0,0x30,0x20,0xA1,0xB0,0x1A,0x12,0x57,0x93,0x34,0x22,0xAD,0xD1,0x3B,0x27,0xC6,0xEF,0x3D,0x29,0xCC,0xF2,0x3D,0x29,0xCD,0xF2,
    0x3C,0x28,0xCB,0xF2,0x3C,0x28,0xC7,0xEC,0x38,0x25,0xBB,0xCD,0x2A,0x1C,0x8E,0x8C,0x05,0x04,0x13,0x35,0x00,0x01,0x00,0x06,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x01,0x01,0x02,0x04,0x28,0x21,0x16,0x6E,0xB0,0x31,0x20,0xA2,0xF4,0x36,0x24,0xB2,0xFE,0x38,0x25,0xBA,0xFF,0x39,0x26,0xBE,0xFF,
    0x3D,0x29,0xCC,0xFF,0x45,0x2E,0xE5,0xFE,0x4E,0x34,0xFC,0xFA,0x4C,0x32,0xEF,0xF6,0x3D,0x29,0xCC,0xFC,0x3D,0x28,0xCA,0xFF,0x3F,0x2A,0xD3,0xFF,0x41,0x2B,0xD6,0xFF,
    0x41,0x2B,0xD8,0xFF,0x42,0x2C,0xDE,0xFF,0x47,0x2F,0xED,0xFD,0x4E,0x34,0xFC,0xF1,0x3E,0x29,0xCB,0xB1,0x06,0x05,0x17,0x39,0x00,0x01,0x00,0x04,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x03,0x06,0x05,0x18,0x52,0x24,0x17,0x75,0xE3,0x2C,0x1E,0x94,0xFE,0x31,0x20,0xA1,0xFF,0x33,0x22,0xAB,0xFF,0x36,0x24,0xB4,0xFF,
    0x3D,0x29,0xCE,0xFF,0x47,0x30,0xE8,0xFF,0x54,0x3A,0xFE,0xFF,0x58,0x3A,0xFE,0xFF,0x54,0x38,0xFB,0xFF,0x3D,0x29,0xCA,0xFF,0x3C,0x28,0xC8,0xFF,0x3F,0x29,0xD1,0xFF,
    0x41,0x2B,0xDA,0xFF,0x46,0x2E,0xE6,0xFF,0x4E,0x34,0xF8,0xFF,0x53,0x37,0xFE,0xFE,0x53,0x37,0xFD,0xF4,0x35,0x24,0xB1,0x9D,0x00,0x01,0x01,0x1C,0x00,0x01,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x04,0x06,0x05,0x17,0x5F,0x18,0x10,0x50,0xEA,0x22,0x16,0x6F,0xFF,0x29,0x1B,0x89,0xFF,0x2C,0x1D,0x94,0xFF,0x2F,0x1F,0x9E,0xFF,
    0x38,0x25,0xB8,0xFF,0x46,0x2F,0xDD,0xFF,0x7F,0x64,0xFD,0xFF,0xA5,0x87,0xFE,0xFF,0x63,0x43,0xFD,0xFF,0x4E,0x34,0xE5,0xFF,0x30,0x1F,0x9E,0xFF,0x37,0x25,0xBA,0xFF,
    0x3E,0x29,0xCE,0xFF,0x48,0x31,0xE4,0xFF,0x9F,0x85,0xFE,0xFF,0x7E,0x60,0xFD,0xFF,0x5F,0x3F,0xFE,0xFE,0x52,0x37,0xF7,0xDB,0x0E,0x09,0x2F,0x48,0x00,0x01,0x00,0x02,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x02,0x04,0x03,0x0E,0x49,0x10,0x0A,0x33,0xDF,0x11,0x0B,0x36,0xFE,0x17,0x0F,0x4D,0xFF,0x20,0x15,0x6C,0xFF,0x27,0x19,0x81,0xFF,
    0x2D,0x1E,0x99,0xFF,0x39,0x26,0xBA,0xFF,0x74,0x5B,0xF2,0xFF,0x9D,0x81,0xFE,0xFF,0x8E,0x6D,0xFE,0xFF,0x5D,0x3F,0xF9,0xFF,0x1C,0x12,0x5E,0xFF,0x24,0x17,0x78,0xFF,
    0x30,0x1F,0xA2,0xFF,0x3D,0x29,0xC8,0xFF,0x75,0x5B,0xFB,0xFF,0x71,0x53,0xFE,0xFF,0x90,0x72,0xFE,0xFE,0x59,0x3E,0xF9,0xE3,0x10,0x0B,0x38,0x51,0x00,0x01,0x00,0x03,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x01,0x00,0x01,0x02,0x2E,0x0F,0x0A,0x33,0xC7,0x11,0x0B,0x38,0xFD,0x12,0x0B,0x3C,0xFF,0x12,0x0B,0x3C,0xFF,0x14,0x0D,0x44,0xFF,
    0x1D,0x13,0x62,0xFF,0x29,0x1B,0x8B,0xFF,0x3D,0x28,0xCB,0xFF,0x4B,0x32,0xF3,0xFF,0x90,0x74,0xFE,0xFF,0x53,0x39,0xF3,0xFF,0x24,0x17,0x79,0xFF,0x1A,0x11,0x59,0xFB,
    0x18,0x10,0x51,0xF1,0x22,0x16,0x73,0xF5,0x38,0x25,0xBA,0xFB,0x4F,0x36,0xF4,0xFB,0x75,0x5A,0xFC,0xF4,0x40,0x2B,0xCE,0xB4,0x03,0x03,0x0C,0x2C,0x00,0x01,0x00,0x01,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x01,0x00,0x16,0x0E,0x09,0x2C,0x9F,0x18,0x10,0x52,0xF9,0x29,0x1B,0x8A,0xFF,0x34,0x23,0xAE,0xFF,0x3A,0x26,0xBE,0xFF,
    0x2F,0x20,0x90,0xFF,0x19,0x10,0x54,0xFF,0x1C,0x13,0x60,0xFF,0x2E,0x1E,0x9C,0xFF,0x48,0x32,0xDB,0xFF,0x4E,0x34,0xF7,0xFF,0x4D,0x34,0xF6,0xFC,0x3E,0x29,0xCE,0xD2,
    0x0C,0x09,0x2A,0x7F,0x0B,0x08,0x25,0x8B,0x12,0x0D,0x42,0xAC,0x26,0x18,0x7D,0xB1,0x2C,0x1E,0x90,0x8F,0x0B,0x09,0x26,0x3F,0x00,0x01,0x00,0x08,0x00,0x01,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x08,0x08,0x06,0x1D,0x6F,0x1A,0x11,0x56,0xEE,0x30,0x1F,0x9F,0xFF,0x41,0x2B,0xD7,0xFF,0x56,0x3B,0xFC,0xFF,
    0x63,0x46,0xFE,0xFF,0x39,0x26,0xB9,0xFF,0x31,0x21,0xA6,0xFF,0x41,0x2B,0xD8,0xFF,0x4E,0x34,0xFA,0xFF,0x63,0x46,0xFE,0xFE,0x53,0x39,0xF9,0xE9,0x20,0x16,0x6D,0x75,
    0x00,0x01,0x00,0x13,0x00,0x01,0x00,0x0E,0x00,0x01,0x00,0x19,0x00,0x01,0x00,0x1B,0x00,0x01,0x00,0x11,0x00,0x01,0x00,0x03,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x02,0x03,0x03,0x0A,0x3F,0x17,0x10,0x52,0xD4,0x2D,0x1D,0x96,0xFE,0x3F,0x2A,0xD3,0xFF,0x5A,0x3F,0xFB,0xFF,
    0x77,0x57,0xFE,0xFF,0x3E,0x29,0xC0,0xFF,0x39,0x26,0xBF,0xFF,0x50,0x36,0xF9,0xFF,0x5A,0x3D,0xFE,0xFF,0x7B,0x5D,0xFE,0xFB,0x40,0x2A,0xCC,0xB6,0x01,0x02,0x04,0x28,
    0x00,0x01,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x01,0x00,0x18,0x11,0x0C,0x3B,0x9F,0x2C,0x1C,0x91,0xF8,0x42,0x2C,0xDD,0xFF,0x5C,0x40,0xFD,0xFF,
    0xA7,0x85,0xFE,0xFF,0x48,0x30,0xD3,0xFF,0x3D,0x29,0xC8,0xFF,0x62,0x46,0xFE,0xFF,0x78,0x58,0xFE,0xFF,0x92,0x73,0xFE,0xF2,0x2B,0x1D,0x8A,0x7D,0x00,0x01,0x00,0x0B,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x06,0x06,0x05,0x18,0x5B,0x24,0x16,0x76,0xE4,0x3E,0x29,0xCF,0xFE,0x54,0x38,0xFD,0xFF,
    0xB8,0x97,0xFE,0xFF,0x55,0x39,0xE5,0xFF,0x3D,0x28,0xC7,0xFF,0x6A,0x4D,0xFE,0xFF,0x96,0x77,0xFE,0xFE,0x7C,0x5E,0xFC,0xE2,0x12,0x0C,0x3B,0x51,0x00,0x01,0x00,0x03,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x01,0x00,0x25,0x15,0x0F,0x4C,0xB6,0x33,0x21,0xA8,0xFB,0x4D,0x33,0xF6,0xFF,
    0xAF,0x90,0xFE,0xFF,0x64,0x46,0xF2,0xFF,0x3A,0x27,0xC2,0xFF,0x63,0x47,0xFE,0xFF,0xA7,0x87,0xFE,0xFD,0x5A,0x40,0xE3,0xC5,0x00,0x01,0x01,0x2C,0x00,0x01,0x00,0x01,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,
    0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x01,0x00,0x09,0x09,0x07,0x22,0x73,0x25,0x18,0x7C,0xED,0x44,0x2D,0xE1,0xFF,
    0x95,0x78,0xFE,0xFF,0x7A,0x5A,0xF9,0xFF,0x3E,0x29,0xCB,0xFF,0x6A,0x4D,0xFE,0xFF,0xAB,0x8B,0xFE,0xF8,0x3C,0x28,0xAE,0x9D,0x00,0x01,0x00,0x15,0x00,0x01,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x01,0x00,0x0D,
    0x15,0x0F,0x3A,0x32,0x03,0x03,0x0A,0x1B,0x00,0x01,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x01,0x02,0x03,0x07,0x34,0x1C,0x12,0x5E,0xC5,0x37,0x24,0xBA,0xFC,
    0x6D,0x50,0xFC,0xFF,0x8B,0x6C,0xFB,0xFF,0x3C,0x27,0xC5,0xFF,0x53,0x39,0xE6,0xFF,0x76,0x5C,0xE8,0xF7,0x27,0x1A,0x7F,0xA8,0x0C,0x08,0x27,0x4A,0x00,0x01,0x00,0x26,
    0x00,0x01,0x00,0x0E,0x00,0x01,0x00,0x03,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x01,0x00,0x08,0x00,0x01,0x01,0x36,
    0x3C,0x2B,0x95,0x8E,0x1D,0x15,0x49,0x42,0x00,0x01,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x01,0x00,0x0E,0x0C,0x09,0x2B,0x7B,0x25,0x18,0x7B,0xED,
    0x43,0x2D,0xD7,0xFF,0x48,0x33,0xC9,0xFF,0x35,0x23,0xB1,0xFF,0x3B,0x27,0xC5,0xFF,0x40,0x2A,0xD3,0xFD,0x41,0x2B,0xD9,0xF1,0x42,0x2C,0xDE,0xDC,0x3D,0x29,0xCB,0xBB,
    0x2D,0x1E,0x97,0x88,0x12,0x0D,0x3E,0x51,0x00,0x01,0x01,0x23,0x00,0x01,0x00,0x08,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x01,0x00,0x0D,0x11,0x0B,0x3A,0x57,0x30,0x1F,0x9E,0xAC,
    0x52,0x39,0xC7,0xC0,0x18,0x10,0x41,0x53,0x00,0x01,0x00,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x01,0x00,0x0A,0x09,0x07,0x1E,0x63,0x2C,0x1D,0x94,0xE4,
    0x34,0x23,0xAC,0xFE,0x31,0x21,0xA7,0xFF,0x39,0x26,0xBF,0xFF,0x40,0x2A,0xD3,0xFF,0x42,0x2C,0xDE,0xFF,0x45,0x2E,0xE5,0xFF,0x4A,0x31,0xF6,0xFE,0x4F,0x35,0xFD,0xFC,
    0x52,0x36,0xFE,0xF4,0x51,0x36,0xF9,0xE0,0x42,0x2C,0xCD,0xB1,0x23,0x17,0x72,0x65,0x01,0x02,0x03,0x25,0x00,0x01,0x00,0x07,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x02,0x04,0x04,0x0F,0x3C,0x34,0x23,0xAF,0xC8,0x4F,0x35,0xFB,0xF9,
    0x72,0x50,0xFE,0xF7,0x4B,0x32,0xC7,0xA8,0x00,0x01,0x00,0x1C,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x02,0x03,0x03,0x0B,0x37,0x2A,0x1C,0x8E,0xBD,0x3C,0x28,0xC9,0xF9,
    0x31,0x20,0xA2,0xFF,0x36,0x23,0xB3,0xFF,0x3D,0x28,0xCB,0xFF,0x42,0x2C,0xDC,0xFF,0x46,0x2E,0xE9,0xFF,0x4C,0x33,0xF7,0xFF,0x52,0x38,0xFE,0xFF,0x56,0x39,0xFE,0xFF,
    0x58,0x3A,0xFE,0xFF,0x5A,0x3B,0xFE,0xFE,0x5A,0x3B,0xFE,0xFA,0x57,0x3A,0xFE,0xE7,0x47,0x2F,0xD6,0xB2,0x1B,0x11,0x51,0x56,0x00,0x01,0x00,0x10,0x00,0x01,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x09,0x11,0x0C,0x3B,0x75,0x41,0x2B,0xD9,0xEF,0x53,0x37,0xFE,0xFF,
    0x68,0x47,0xFE,0xFD,0x4C,0x33,0xCC,0xC3,0x00,0x01,0x00,0x26,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x01,0x00,0x11,0x17,0x0F,0x4A,0x89,0x31,0x21,0xA5,0xF1,0x2F,0x1F,0x9D,0xFE,
    0x31,0x20,0xA2,0xFF,0x38,0x25,0xBA,0xFF,0x3E,0x29,0xCD,0xFF,0x44,0x2E,0xE0,0xFF,0x4E,0x37,0xF3,0xFF,0x5B,0x40,0xFE,0xFF,0x5F,0x43,0xFF,0xFF,0x5E,0x40,0xFE,0xFF,
    0x5C,0x3E,0xFE,0xFF,0x5B,0x3D,0xFE,0xFF,0x5C,0x3D,0xFE,0xFF,0x5D,0x3D,0xFE,0xFE,0x5B,0x3C,0xFE,0xF9,0x54,0x37,0xF4,0xD3,0x20,0x15,0x65,0x62,0x00,0x01,0x00,0x0C,
    0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x01,0x00,0x14,0x1D,0x13,0x61,0xA1,0x4A,0x32,0xEF,0xF9,0x5E,0x3F,0xFE,0xFF,
    0x7E,0x5B,0xFE,0xFE,0x50,0x35,0xCD,0xC4,0x00,0x01,0x00,0x27,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x01,0x01,0x02,0x05,0x33,0x22,0x16,0x74,0xCA,0x2E,0x1E,0x9A,0xFD,0x29,0x1B,0x8C,0xFF,
    0x32,0x21,0xA6,0xFF,0x37,0x25,0xB8,0xFF,0x3C,0x28,0xC7,0xFF,0x42,0x2D,0xD7,0xFF,0x59,0x42,0xF4,0xFF,0x7D,0x64,0xFE,0xFF,0x8A,0x6D,0xFD,0xFF,0x7E,0x61,0xFC,0xFF,
    0x6F,0x51,0xFD,0xFF,0x64,0x45,0xFE,0xFF,0x60,0x40,0xFE,0xFF,0x5E,0x3F,0xFE,0xFF,0x5E,0x3E,0xFE,0xFF,0x5C,0x3D,0xFE,0xFB,0x51,0x36,0xEE,0xCA,0x11,0x0C,0x37,0x48,
    0x00,0x01,0x00,0x04,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x01,0x00,0x25,0x26,0x19,0x7F,0xC0,0x51,0x35,0xF6,0xFD,0x68,0x47,0xFE,0xFF,
    0x8D,0x69,0xFE,0xFE,0x54,0x38,0xD4,0xC6,0x00,0x01,0x00,0x29,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x08,0x0F,0x0A,0x31,0x69,0x29,0x1B,0x88,0xEB,0x29,0x1C,0x8A,0xFF,0x2A,0x1C,0x8E,0xFF,
    0x31,0x20,0xA2,0xFF,0x35,0x23,0xAF,0xFF,0x38,0x25,0xBB,0xFF,0x3D,0x29,0xC8,0xFF,0x54,0x3E,0xE6,0xFF,0x9C,0x83,0xFF,0xFF,0xD1,0xB7,0xFF,0xFF,0xC5,0xA9,0xFF,0xFF,
    0x9D,0x80,0xFE,0xFF,0x7B,0x5C,0xFD,0xFF,0x67,0x48,0xFE,0xFF,0x61,0x41,0xFE,0xFF,0x60,0x40,0xFE,0xFF,0x5F,0x3F,0xFE,0xFF,0x5C,0x3D,0xFE,0xF7,0x3F,0x2A,0xC0,0xA5,
    0x00,0x01,0x00,0x1E,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x01,0x00,0x01,0x01,0x38,0x2C,0x1D,0x93,0xD5,0x57,0x3B,0xFA,0xFE,0x7B,0x59,0xFE,0xFF,
    0xA4,0x7F,0xFE,0xFE,0x58,0x3B,0xD3,0xC7,0x00,0x01,0x01,0x2A,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x01,0x00,0x1A,0x1A,0x11,0x56,0xA6,0x2B,0x1C,0x90,0xFA,0x25,0x19,0x7D,0xFF,0x2A,0x1A,0x88,0xFF,
    0x2D,0x1E,0x97,0xFF,0x31,0x20,0xA3,0xFF,0x34,0x22,0xAE,0xFF,0x38,0x26,0xBA,0xFF,0x42,0x2F,0xCA,0xFF,0x7A,0x65,0xF4,0xFF,0xD8,0xBE,0xFD,0xFF,0xDF,0xC3,0xFE,0xFF,
    0xAE,0x91,0xFF,0xFF,0x81,0x64,0xFE,0xFF,0x68,0x4A,0xFB,0xFF,0x54,0x39,0xF1,0xFF,0x52,0x38,0xF5,0xFF,0x55,0x39,0xFB,0xFF,0x57,0x3A,0xFD,0xFE,0x54,0x38,0xFC,0xE0,
    0x12,0x0D,0x3D,0x53,0x00,0x01,0x00,0x05,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x02,0x00,0x01,0x03,0x47,0x2D,0x1E,0x95,0xE0,0x63,0x45,0xFB,0xFF,0xAA,0x85,0xFD,0xFF,
    0xCE,0xAD,0xFE,0xFE,0x61,0x41,0xDD,0xC4,0x00,0x01,0x00,0x27,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x01,0x02,0x02,0x08,0x37,0x20,0x15,0x6F,0xD0,0x2B,0x1D,0x92,0xFE,0x21,0x15,0x6D,0xFF,0x26,0x18,0x7B,0xFF,
    0x2B,0x1B,0x8C,0xFF,0x2C,0x1E,0x97,0xFF,0x31,0x20,0xA0,0xFF,0x33,0x21,0xAA,0xFF,0x37,0x25,0xB3,0xFF,0x45,0x32,0xC8,0xFF,0x6D,0x56,0xF4,0xFF,0x7B,0x62,0xFE,0xFF,
    0x70,0x55,0xFE,0xFF,0x65,0x49,0xFD,0xFF,0x45,0x2F,0xD0,0xFF,0x53,0x3D,0xE5,0xFF,0x8C,0x75,0xFD,0xFF,0x67,0x4A,0xFE,0xFF,0x62,0x45,0xFE,0xFF,0x6C,0x4E,0xFE,0xF7,
    0x3B,0x29,0xAD,0x99,0x00,0x01,0x00,0x17,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x01,0x00,0x01,0x01,0x39,0x29,0x1B,0x89,0xD5,0x6F,0x51,0xF9,0xFE,0xE6,0xC7,0xFE,0xFF,
    0xDA,0xBB,0xFE,0xFE,0x6A,0x48,0xE9,0xC6,0x00,0x01,0x00,0x29,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,
    0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x00,0x00,0x01,0x00,0x05,0x0A,0x08,0x25,0x5C,0x24,0x17,0x78,0xE8,0x2C,0x1D,0x90,0xFF,0x1A,0x12,0x5D,0xFF,0x1F,0x15,0x69,0xFF,
    0x27,0x18,0x7D,0xFF,0x2A,0x1B,0x89,0xFF,0x2B,0x1D,0x93,0xFF,0x2C,0x1E,0x99,0xFF,0x2D,0x1E,0x9A,0xFF,0x31,0x21,0xA2,0xFF,0x3C,0x29,0xC3,0xFF,0x47,0x30,0xE4,0xFF,
    0x4D,0x34,0xF5,0xFF,0x4E,0x35,0xF0,0xFF,0x29,0x1A,0x89,0xFF,0x31,0x21,0x9D,0xFF,0x3E,0x2A,0xC1,0xFF,0x4B,0x34,0xE9,0xFF,0x88,0x70,0xFE,0xFF,0xCC,0xB2,0xFE,0xFD,
    0x59,0x42,0xE1,0xC3,0x01,0x02,0x04,0x2A,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x01,0x00,0x21,0x20,0x15,0x6A,0xB7,0x5E,0x43,0xED,0xFC,0xEF,0xDB,0xFF,0xFF,
    0xD2,0xAF,0xFE,0xFE,0x6F,0x4C,0xEF,0xD7,0x01,0x02,0x05,0x4B,0x00,0x01,0x00,0x27,0x04,0x03,0x10,0x3A,0x0D,0x09,0x2A,0x40,0x0E,0x0A,0x30,0x40,0x0C,0x08,0x28,0x40,
    0x03,0x02,0x0B,0x37,0x00,0x01,0x00,0x24,0x00,0x01,0x00,0x20,0x10,0x0B,0x38,0x8A,0x24,0x17,0x78,0xF5,0x2B,0x1B,0x8A,0xFF,0x19,0x11,0x57,0xFF,0x18,0x10,0x52,0xFF,
    0x1F,0x15,0x6B,0xFF,0x25,0x17,0x79,0xFF,0x29,0x19,0x81,0xFF,0x28,0x19,0x82,0xFF,0x28,0x19,0x83,0xFF,0x2A,0x1C,0x8B,0xFF,0x30,0x20,0xA3,0xFF,0x3A,0x27,0xC1,0xFF,
    0x41,0x2B,0xD6,0xFF,0x47,0x30,0xE8,0xFF,0x29,0x1B,0x85,0xFF,0x15,0x0E,0x49,0xFF,0x1E,0x13,0x64,0xFF,0x2D,0x1D,0x93,0xFF,0x3D,0x2D,0xB2,0xFF,0x4C,0x39,0xCA,0xFD,
    0x37,0x25,0xAD,0xC8,0x04,0x04,0x0F,0x48,0x00,0x01,0x00,0x13,0x00,0x01,0x00,0x03,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x01,0x00,0x0D,0x14,0x0D,0x44,0x85,0x43,0x2D,0xD0,0xF3,0xD1,0xBA,0xFF,0xFF,
    0xD7,0xB5,0xFE,0xFF,0x66,0x48,0xDD,0xF2,0x1C,0x13,0x60,0xBF,0x29,0x1C,0x8B,0xC0,0x30,0x20,0xA1,0xD5,0x34,0x23,0xAF,0xDB,0x38,0x25,0xBC,0xDB,0x3B,0x27,0xC5,0xDA,
    0x3B,0x27,0xC6,0xD2,0x38,0x24,0xBB,0xBE,0x2F,0x1F,0x9D,0xA7,0x1A,0x11,0x5A,0xD0,0x23,0x17,0x75,0xFC,0x28,0x1A,0x84,0xFF,0x1C,0x13,0x5F,0xFF,0x11,0x0C,0x3B,0xFF,
    0x19,0x10,0x53,0xFF,0x1E,0x14,0x65,0xFF,0x20,0x15,0x6C,0xFF,0x21,0x16,0x6E,0xFF,0x21,0x16,0x71,0xFF,0x24,0x18,0x78,0xFF,0x2C,0x1C,0x93,0xFF,0x3C,0x28,0xC8,0xFF,
    0x44,0x2E,0xE5,0xFF,0x49,0x31,0xF1,0xFF,0x4D,0x34,0xFB,0xFF,0x4E,0x34,0xEE,0xFF,0x46,0x2E,0xCD,0xFF,0x35,0x23,0xA5,0xFF,0x39,0x27,0xB5,0xFF,0x54,0x3E,0xE4,0xFE,
    0x58,0x3B,0xFD,0xF2,0x51,0x36,0xEC,0xCC,0x38,0x26,0xA7,0x8E,0x0B,0x08,0x22,0x38,0x00,0x01,0x00,0x08,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x03,0x06,0x04,0x14,0x4E,0x30,0x1F,0x9E,0xDE,0x89,0x6F,0xEF,0xFE,
    0x67,0x55,0xA5,0xFF,0x2B,0x1C,0x8B,0xFE,0x2E,0x1F,0x9C,0xFC,0x33,0x21,0xAA,0xFD,0x37,0x25,0xB7,0xFE,0x39,0x26,0xC0,0xFF,0x3D,0x28,0xCA,0xFF,0x40,0x2A,0xD6,0xFE,
    0x43,0x2C,0xE1,0xFE,0x48,0x30,0xEE,0xFD,0x4C,0x33,0xF9,0xFA,0x23,0x18,0x77,0xFB,0x21,0x16,0x72,0xFE,0x27,0x19,0x7F,0xFF,0x24,0x18,0x78,0xFF,0x0F,0x0A,0x33,0xFF,
    0x10,0x0B,0x38,0xFF,0x15,0x0E,0x4A,0xFF,0x19,0x11,0x56,0xFF,0x1C,0x12,0x5B,0xFF,0x1E,0x12,0x5F,0xFF,0x22,0x17,0x73,0xFF,0x3A,0x26,0xC1,0xFF,0x48,0x31,0xE6,0xFF,
    0x5B,0x43,0xF5,0xFF,0x72,0x5A,0xFD,0xFF,0x82,0x68,0xFD,0xFF,0x79,0x5E,0xFE,0xFF,0x66,0x49,0xFE,0xFF,0x59,0x3B,0xF8,0xFF,0x3C,0x28,0xBE,0xFF,0x6E,0x5A,0xEE,0xFF,
    0xAC,0x93,0xFE,0xFF,0x64,0x47,0xFE,0xFD,0x5B,0x3C,0xFE,0xF2,0x4D,0x33,0xE3,0xBC,0x15,0x0E,0x40,0x4A,0x00,0x01,0x00,0x09,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x01,0x00,0x21,0x18,0x0F,0x4F,0xB1,0x22,0x15,0x6D,0xFB,
    0x23,0x17,0x73,0xFF,0x2A,0x19,0x83,0xFF,0x2B,0x1D,0x92,0xFF,0x30,0x20,0xA2,0xFF,0x36,0x23,0xB4,0xFF,0x3A,0x27,0xC2,0xFF,0x3E,0x28,0xCD,0xFF,0x41,0x2B,0xDA,0xFF,
    0x47,0x2E,0xE9,0xFF,0x4B,0x32,0xF9,0xFF,0x50,0x35,0xFC,0xFF,0x1F,0x14,0x65,0xFF,0x20,0x16,0x6F,0xFF,0x26,0x18,0x7A,0xFF,0x2A,0x1C,0x8D,0xFF,0x18,0x10,0x50,0xFF,
    0x0F,0x0A,0x32,0xFF,0x0F,0x0A,0x34,0xFF,0x11,0x0C,0x3A,0xFF,0x12,0x0D,0x43,0xFF,0x19,0x11,0x59,0xFF,0x35,0x24,0xB2,0xFF,0x42,0x2D,0xD2,0xFF,0x63,0x4E,0xF2,0xFF,
    0x99,0x83,0xFE,0xFF,0xC5,0xAF,0xFC,0xFF,0xDE,0xC6,0xFE,0xFF,0xD6,0xBC,0xFF,0xFF,0x91,0x75,0xFE,0xFF,0x5F,0x40,0xFE,0xFF,0x3D,0x29,0xC5,0xFF,0x3C,0x2A,0xB6,0xFF,
    0x76,0x61,0xEC,0xFF,0x81,0x68,0xFD,0xFF,0x5D,0x3F,0xFE,0xFE,0x5A,0x3C,0xFE,0xF8,0x4C,0x32,0xE8,0xC2,0x13,0x0E,0x40,0x4B,0x00,0x01,0x00,0x08,0x00,0x01,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x01,0x00,0x1A,0x0F,0x0B,0x39,0xA7,0x1B,0x10,0x55,0xFA,
    0x1F,0x14,0x66,0xFF,0x24,0x17,0x76,0xFF,0x29,0x19,0x84,0xFF,0x2C,0x1E,0x94,0xFF,0x31,0x21,0xA5,0xFF,0x37,0x24,0xB5,0xFF,0x3B,0x27,0xC4,0xFF,0x3F,0x29,0xD2,0xFF,
    0x45,0x2E,0xE4,0xFF,0x4B,0x31,0xF9,0xFF,0x4E,0x34,0xF3,0xFF,0x1C,0x13,0x5D,0xFF,0x20,0x16,0x6E,0xFF,0x24,0x18,0x76,0xFF,0x2A,0x1C,0x8E,0xFF,0x2F,0x1F,0x9D,0xFF,
    0x12,0x0B,0x3B,0xFF,0x0F,0x0A,0x33,0xFF,0x0F,0x0A,0x32,0xFF,0x10,0x0B,0x37,0xFF,0x2D,0x1E,0x96,0xFF,0x3B,0x28,0xC3,0xFF,0x4E,0x39,0xDA,0xFF,0x75,0x61,0xFA,0xFF,
    0x9F,0x8A,0xFD,0xFF,0xBE,0xA9,0xFF,0xFF,0xDB,0xC4,0xFE,0xFF,0xE4,0xCC,0xFE,0xFF,0x9C,0x82,0xFE,0xFF,0x66,0x48,0xFE,0xFF,0x3F,0x2A,0xCB,0xFF,0x2C,0x1E,0x94,0xFF,
    0x36,0x25,0xA8,0xFF,0x48,0x33,0xD2,0xFF,0x53,0x3A,0xF5,0xFF,0x5E,0x41,0xFE,0xFE,0x57,0x3A,0xFE,0xF8,0x47,0x2F,0xDE,0xBB,0x09,0x07,0x1D,0x39,0x00,0x01,0x00,0x03,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x01,0x01,0x01,0x03,0x31,0x10,0x0B,0x38,0xCB,0x13,0x0E,0x48,0xFD,
    0x1B,0x11,0x58,0xFF,0x1F,0x15,0x68,0xFF,0x24,0x17,0x77,0xFF,0x2A,0x1A,0x87,0xFF,0x2D,0x1E,0x96,0xFF,0x31,0x20,0xA4,0xFF,0x36,0x24,0xB4,0xFF,0x3A,0x27,0xC3,0xFF,
    0x42,0x2B,0xDC,0xFF,0x4C,0x32,0xF9,0xFF,0x4F,0x35,0xEC,0xFF,0x1A,0x10,0x54,0xFF,0x1F,0x15,0x69,0xFF,0x22,0x17,0x75,0xFF,0x2B,0x1C,0x8F,0xFF,0x36,0x23,0xB2,0xFF,
    0x31,0x20,0xA2,0xFF,0x12,0x0C,0x3D,0xFF,0x0F,0x09,0x32,0xFF,0x1E,0x14,0x65,0xFF,0x34,0x23,0xAE,0xFF,0x3C,0x29,0xC1,0xFF,0x52,0x3F,0xD8,0xFF,0x70,0x5C,0xF4,0xFF,
    0x8A,0x76,0xFE,0xFF,0xA0,0x8B,0xFC,0xFF,0xBB,0xA6,0xFD,0xFF,0xC3,0xAB,0xFF,0xFF,0x82,0x68,0xFD,0xFF,0x74,0x57,0xFE,0xFF,0x43,0x2C,0xD9,0xFF,0x2B,0x1C,0x8B,0xFF,
    0x2C,0x1E,0x96,0xFF,0x36,0x25,0xB1,0xFF,0x42,0x2D,0xD5,0xFF,0x58,0x3E,0xF8,0xFF,0x62,0x45,0xFE,0xFE,0x53,0x37,0xFE,0xF3,0x37,0x25,0xB4,0x9B,0x00,0x01,0x01,0x1D,
    0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x02,0x01,0x02,0x06,0x3C,0x0E,0x0A,0x30,0xD6,0x0F,0x0B,0x34,0xFE,
    0x12,0x0D,0x42,0xFF,0x1B,0x11,0x58,0xFF,0x1F,0x15,0x68,0xFF,0x25,0x17,0x78,0xFF,0x29,0x1A,0x85,0xFF,0x2C,0x1E,0x94,0xFF,0x31,0x20,0xA1,0xFF,0x36,0x24,0xB2,0xFF,
    0x3C,0x28,0xCB,0xFF,0x4E,0x34,0xF7,0xFF,0x61,0x46,0xED,0xFF,0x17,0x10,0x4C,0xFF,0x1C,0x12,0x5F,0xFF,0x20,0x16,0x6D,0xFF,0x2A,0x1B,0x8C,0xFF,0x34,0x23,0xAF,0xFF,
    0x3C,0x28,0xC9,0xFF,0x3C,0x28,0xC7,0xFF,0x20,0x16,0x68,0xFF,0x28,0x1B,0x89,0xFF,0x32,0x21,0xA6,0xFF,0x39,0x27,0xB5,0xFF,0x48,0x36,0xC6,0xFF,0x5A,0x48,0xDA,0xFF,
    0x6C,0x59,0xEE,0xFF,0x7D,0x6A,0xFC,0xFF,0x94,0x7F,0xFD,0xFF,0x93,0x7C,0xFF,0xFF,0x68,0x4E,0xFE,0xFF,0x8B,0x70,0xFE,0xFF,0x45,0x2D,0xE1,0xFF,0x28,0x19,0x82,0xFF,
    0x2A,0x1C,0x8B,0xFF,0x2F,0x1F,0x9D,0xFF,0x39,0x26,0xBA,0xFF,0x43,0x2D,0xDC,0xFF,0x73,0x59,0xFB,0xFF,0x5D,0x41,0xFE,0xFE,0x4F,0x34,0xFA,0xE2,0x18,0x11,0x52,0x5D,
    0x00,0x01,0x00,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x01,0x00,0x06,0x01,0x01,0x03,0x23,0x0E,0x0A,0x30,0x6A,0x12,0x0C,0x3C,0xDC,0x0F,0x0A,0x32,0xFE,
    0x0F,0x0A,0x32,0xFF,0x11,0x0B,0x37,0xFF,0x16,0x0E,0x49,0xFF,0x1C,0x13,0x5F,0xFF,0x22,0x16,0x71,0xFF,0x28,0x19,0x81,0xFF,0x2C,0x1D,0x92,0xFF,0x31,0x20,0xA4,0xFF,
    0x38,0x25,0xB9,0xFF,0x4C,0x34,0xE9,0xFF,0xA1,0x84,0xF9,0xFF,0x1E,0x18,0x49,0xFF,0x1A,0x10,0x54,0xFF,0x1D,0x13,0x62,0xFF,0x27,0x19,0x81,0xFF,0x31,0x21,0xA5,0xFF,
    0x3A,0x27,0xC2,0xFF,0x43,0x2C,0xDC,0xFF,0x38,0x26,0xB8,0xFF,0x29,0x1A,0x87,0xFF,0x2D,0x1F,0x9A,0xFF,0x32,0x22,0xA4,0xFF,0x39,0x28,0xAF,0xFF,0x44,0x32,0xBC,0xFF,
    0x50,0x3E,0xCB,0xFF,0x5E,0x4B,0xDE,0xFF,0x69,0x56,0xF1,0xFF,0x64,0x4E,0xF6,0xFF,0x6C,0x53,0xFB,0xFF,0x95,0x7C,0xFD,0xFF,0x43,0x2D,0xDD,0xFF,0x20,0x15,0x6D,0xFF,
    0x24,0x17,0x78,0xFF,0x28,0x1A,0x84,0xFF,0x2F,0x20,0x9E,0xFF,0x38,0x25,0xB9,0xFF,0x54,0x3D,0xE3,0xFF,0x8F,0x74,0xFE,0xFF,0x52,0x37,0xFE,0xF9,0x3A,0x26,0xBF,0xAA,
    0x00,0x01,0x01,0x20,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x01,0x00,0x0C,0x09,0x07,0x22,0x4B,0x2A,0x1C,0x8F,0xAC,0x47,0x2F,0xE1,0xE3,0x3A,0x27,0x9B,0xF9,0x0F,0x0A,0x33,0xFF,
    0x0F,0x0A,0x32,0xFF,0x0F,0x0A,0x32,0xFF,0x0F,0x0A,0x32,0xFF,0x10,0x0B,0x34,0xFF,0x13,0x0D,0x40,0xFF,0x1A,0x12,0x5A,0xFF,0x27,0x18,0x7B,0xFF,0x2E,0x1E,0x96,0xFF,
    0x34,0x22,0xAC,0xFF,0x41,0x2C,0xD7,0xFF,0x75,0x59,0xFB,0xFF,0x37,0x2A,0x6B,0xFF,0x13,0x0D,0x42,0xFF,0x18,0x10,0x53,0xFF,0x21,0x15,0x6A,0xFF,0x2B,0x1C,0x8F,0xFF,
    0x34,0x22,0xAB,0xFF,0x3B,0x27,0xC4,0xFF,0x27,0x1A,0x84,0xFF,0x28,0x1A,0x82,0xFF,0x2B,0x1D,0x92,0xFF,0x2F,0x1F,0x9A,0xFF,0x33,0x22,0xA0,0xFF,0x37,0x27,0xA8,0xFF,
    0x3C,0x2C,0xB0,0xFF,0x44,0x33,0xBD,0xFF,0x49,0x36,0xCC,0xFF,0x47,0x32,0xD9,0xFF,0x94,0x7C,0xF7,0xFF,0x74,0x5D,0xF6,0xFF,0x3C,0x27,0xC5,0xFF,0x1B,0x11,0x56,0xFF,
    0x1E,0x13,0x62,0xFF,0x1F,0x15,0x69,0xFF,0x27,0x19,0x7F,0xFF,0x2C,0x1F,0x98,0xFF,0x38,0x25,0xB6,0xFF,0x89,0x72,0xF0,0xFF,0x72,0x58,0xFE,0xFE,0x49,0x30,0xF2,0xDE,
    0x11,0x0C,0x3C,0x50,0x00,0x01,0x00,0x04,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x01,0x00,0x00,0x00,0x01,0x00,0x09,0x0B,0x08,0x27,0x57,0x2C,0x1C,0x91,0xC9,0x3F,0x2A,0xD2,0xF8,0x6F,0x4F,0xFD,0xFE,0x91,0x6E,0xF6,0xFF,0x3B,0x2B,0x74,0xFF,
    0x0F,0x0A,0x32,0xFF,0x0F,0x0A,0x32,0xFF,0x0F,0x0A,0x32,0xFF,0x0F,0x0A,0x33,0xFF,0x0F,0x0A,0x32,0xFF,0x0F,0x0A,0x32,0xFF,0x15,0x0E,0x47,0xFF,0x27,0x18,0x7B,0xFF,
    0x32,0x20,0xA3,0xFF,0x40,0x2B,0xD6,0xFF,0x4C,0x34,0xF3,0xFF,0x57,0x40,0xD4,0xFF,0x15,0x0F,0x40,0xFF,0x11,0x0C,0x3C,0xFF,0x17,0x10,0x4F,0xFF,0x20,0x15,0x6B,0xFF,
    0x28,0x1A,0x85,0xFF,0x2C,0x1D,0x93,0xFF,0x1C,0x12,0x5D,0xFF,0x23,0x16,0x72,0xFF,0x2B,0x1C,0x8A,0xFF,0x2B,0x1D,0x94,0xFF,0x2F,0x1F,0x9A,0xFF,0x32,0x21,0x9C,0xFF,
    0x34,0x24,0x9F,0xFF,0x37,0x27,0xA9,0xFF,0x39,0x27,0xB8,0xFF,0x42,0x2D,0xCD,0xFF,0x98,0x83,0xFC,0xFF,0x4E,0x37,0xE7,0xFE,0x2B,0x1C,0x8E,0xFE,0x13,0x0D,0x43,0xFF,
    0x16,0x0F,0x4F,0xFF,0x1A,0x10,0x55,0xFF,0x1F,0x14,0x64,0xFF,0x27,0x19,0x7D,0xFF,0x2C,0x1E,0x95,0xFF,0x42,0x30,0xBD,0xFF,0x97,0x7F,0xFB,0xFF,0x4D,0x34,0xF8,0xF5,
    0x2D,0x1E,0x97,0x8C,0x00,0x01,0x00,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x01,0x00,0x02,0x02,0x02,0x09,0x38,0x22,0x16,0x73,0xC0,0x33,0x22,0xAA,0xF9,0x4A,0x31,0xEA,0xFF,0xBA,0x9B,0xFE,0xFF,0xE8,0xC8,0xFE,0xFF,0xBE,0x96,0xFD,0xFF,
    0x69,0x4D,0xC2,0xFF,0x2B,0x1D,0x73,0xFF,0x12,0x0C,0x3F,0xFF,0x14,0x0D,0x42,0xFF,0x21,0x1A,0x4B,0xFF,0x49,0x3F,0x65,0xFF,0x46,0x39,0x6D,0xFF,0x18,0x11,0x47,0xFF,
    0x28,0x1A,0x83,0xFF,0x3C,0x28,0xC7,0xFF,0x49,0x31,0xF1,0xFF,0x55,0x3A,0xFD,0xFF,0x4D,0x35,0xD4,0xFF,0x23,0x17,0x63,0xFF,0x13,0x0D,0x3D,0xFF,0x15,0x0E,0x49,0xFF,
    0x1E,0x14,0x67,0xFF,0x29,0x1B,0x83,0xFF,0x17,0x10,0x51,0xFF,0x1C,0x12,0x58,0xFF,0x22,0x16,0x73,0xFF,0x2A,0x1B,0x88,0xFF,0x2B,0x1E,0x93,0xFF,0x2C,0x1F,0x96,0xFF,
    0x2C,0x1F,0x96,0xFF,0x31,0x20,0x9D,0xFF,0x34,0x23,0xAD,0xFF,0x52,0x3E,0xD4,0xFF,0x65,0x50,0xED,0xFF,0x42,0x2C,0xD9,0xFB,0x15,0x0E,0x47,0xF6,0x0F,0x0A,0x33,0xFE,
    0x11,0x0B,0x38,0xFF,0x11,0x0C,0x3E,0xFF,0x15,0x0E,0x48,0xFF,0x1D,0x13,0x61,0xFF,0x25,0x18,0x78,0xFF,0x2D,0x1E,0x93,0xFF,0x5F,0x4C,0xD3,0xFF,0x5E,0x47,0xF6,0xFB,
    0x3C,0x28,0xC7,0xA7,0x00,0x01,0x00,0x16,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,
    0x00,0x01,0x00,0x13,0x14,0x0D,0x44,0x8B,0x2B,0x1D,0x90,0xF2,0x35,0x23,0xB2,0xFE,0x51,0x37,0xF1,0xFF,0xB6,0x96,0xFF,0xFF,0xEE,0xD0,0xFF,0xFF,0xF8,0xE0,0xFD,0xFF,
    0x9A,0x74,0xFD,0xFF,0x61,0x40,0xF3,0xFF,0x2D,0x1E,0x97,0xFF,0x4A,0x32,0xE8,0xFF,0x80,0x61,0xFD,0xFF,0xC3,0x9F,0xFF,0xFF,0xF1,0xD4,0xFE,0xFF,0xA2,0x86,0xCE,0xFF,
    0x20,0x17,0x5A,0xFF,0x2D,0x1D,0x96,0xFF,0x3E,0x29,0xD0,0xFF,0x57,0x3C,0xF9,0xFF,0x6C,0x48,0xFE,0xFF,0x69,0x46,0xFE,0xFF,0x72,0x54,0xEF,0xFF,0x89,0x72,0xC8,0xFF,
    0x4E,0x36,0xDF,0xFF,0x8A,0x6D,0xF0,0xFF,0x1D,0x18,0x47,0xFF,0x19,0x0F,0x51,0xFF,0x1E,0x14,0x67,0xFF,0x25,0x17,0x7A,0xFF,0x2A,0x1A,0x85,0xFF,0x2B,0x1A,0x87,0xFF,
    0x2B,0x1B,0x87,0xFF,0x2C,0x1D,0x91,0xFF,0x31,0x21,0xA2,0xFF,0x4F,0x3C,0xD0,0xFF,0x44,0x2F,0xD5,0xFF,0x4A,0x31,0xE0,0xFC,0x36,0x25,0x96,0xF7,0x0E,0x0A,0x31,0xFA,
    0x0F,0x0A,0x32,0xFD,0x0F,0x0A,0x32,0xFF,0x0F,0x0A,0x33,0xFF,0x13,0x0D,0x42,0xFF,0x1B,0x12,0x5B,0xFF,0x23,0x17,0x74,0xFF,0x31,0x21,0x99,0xFF,0x51,0x3B,0xDF,0xFB,
    0x3D,0x29,0xCA,0xAA,0x00,0x01,0x00,0x17,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x03,
    0x04,0x04,0x10,0x41,0x24,0x17,0x77,0xD1,0x2E,0x1F,0x9D,0xFD,0x3C,0x28,0xC9,0xFF,0x5C,0x41,0xFB,0xFF,0x9D,0x7B,0xFF,0xFF,0xD0,0xAC,0xFD,0xFF,0xFB,0xE7,0xFE,0xFF,
    0x91,0x6C,0xFE,0xFF,0x5E,0x3E,0xF3,0xFF,0x27,0x19,0x81,0xFF,0x40,0x2B,0xD7,0xFF,0x5B,0x3E,0xFE,0xFF,0x77,0x55,0xFE,0xFF,0xD0,0xB2,0xFF,0xFF,0xE6,0xC8,0xFD,0xFF,
    0x56,0x3E,0xC2,0xFF,0x3A,0x27,0xC2,0xFF,0x49,0x31,0xE8,0xFF,0xA8,0x8B,0xFE,0xFF,0xA1,0x7D,0xFE,0xFF,0x78,0x53,0xFD,0xFF,0x67,0x45,0xFE,0xFF,0x48,0x34,0xB5,0xFF,
    0x44,0x2F,0xD5,0xFF,0x80,0x65,0xFB,0xFF,0x7A,0x68,0xAB,0xFF,0x0F,0x0B,0x34,0xFF,0x15,0x0F,0x4A,0xFF,0x1C,0x13,0x5F,0xFF,0x20,0x15,0x69,0xFF,0x21,0x15,0x6B,0xFF,
    0x21,0x16,0x6D,0xFF,0x24,0x17,0x78,0xFF,0x2E,0x1E,0x95,0xFF,0x3A,0x28,0xBB,0xFF,0x3D,0x29,0xCA,0xFF,0x80,0x63,0xF3,0xFE,0x6B,0x4D,0xFC,0xF5,0x13,0x0D,0x3F,0xC8,
    0x0F,0x0A,0x32,0xDD,0x0F,0x0A,0x32,0xFA,0x0E,0x0A,0x32,0xFE,0x0F,0x0A,0x33,0xFF,0x12,0x0D,0x40,0xFF,0x1B,0x11,0x5B,0xFF,0x25,0x18,0x7B,0xFF,0x35,0x24,0xAE,0xFA,
    0x39,0x26,0xBF,0xA5,0x00,0x01,0x00,0x16,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x01,0x00,0x13,
    0x14,0x0D,0x44,0x8D,0x2A,0x1C,0x8D,0xF4,0x33,0x22,0xAA,0xFF,0x42,0x2C,0xDE,0xFF,0x66,0x48,0xFE,0xFF,0x91,0x6F,0xFF,0xFF,0xC7,0xA4,0xFD,0xFF,0xF2,0xD4,0xFE,0xFF,
    0x86,0x61,0xFE,0xFF,0x5B,0x3C,0xF0,0xFF,0x24,0x17,0x78,0xFF,0x3A,0x27,0xC4,0xFF,0x55,0x38,0xFE,0xFF,0x68,0x48,0xFE,0xFF,0xA8,0x85,0xFE,0xFF,0x9D,0x85,0xD1,0xFF,
    0x38,0x25,0xB7,0xFF,0x3F,0x2A,0xD2,0xFF,0x5E,0x45,0xF8,0xFF,0xCA,0xAB,0xFE,0xFF,0xCD,0xA8,0xFF,0xFF,0xA7,0x84,0xFD,0xFF,0x5B,0x3D,0xF9,0xFE,0x27,0x1A,0x84,0xFE,
    0x27,0x19,0x82,0xFF,0x3B,0x27,0xC4,0xFF,0x57,0x3D,0xF4,0xFF,0x32,0x23,0x85,0xFF,0x0F,0x0A,0x33,0xFF,0x0F,0x0B,0x34,0xFF,0x11,0x0B,0x3A,0xFF,0x12,0x0C,0x3E,0xFF,
    0x16,0x0F,0x4A,0xFF,0x21,0x15,0x6E,0xFE,0x2E,0x1F,0x9B,0xFF,0x35,0x23,0xB0,0xFF,0x36,0x25,0xB2,0xFF,0x57,0x43,0xD3,0xFD,0x52,0x3D,0xDF,0xDB,0x11,0x0C,0x39,0x5F,
    0x05,0x04,0x13,0x5E,0x0E,0x09,0x2D,0xB7,0x0F,0x0A,0x32,0xE5,0x0F,0x0A,0x33,0xF3,0x0F,0x0A,0x32,0xF7,0x12,0x0D,0x3F,0xF8,0x1B,0x12,0x5D,0xF4,0x29,0x1B,0x8B,0xDE,
    0x21,0x16,0x70,0x73,0x00,0x01,0x00,0x0B,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x02,0x02,0x02,0x09,0x3A,
    0x1F,0x14,0x6C,0xCE,0x2D,0x1E,0x95,0xFD,0x38,0x25,0xBA,0xFF,0x49,0x30,0xEC,0xFF,0x6A,0x4B,0xFF,0xFF,0x89,0x68,0xFF,0xFF,0xC3,0xA0,0xFF,0xFF,0xE2,0xBD,0xFF,0xFF,
    0x7C,0x59,0xFE,0xFF,0x57,0x39,0xE8,0xFF,0x21,0x16,0x70,0xFF,0x34,0x23,0xB0,0xFF,0x50,0x35,0xFA,0xFF,0x61,0x42,0xFE,0xFF,0x6E,0x50,0xE3,0xFF,0x36,0x25,0xA9,0xFF,
    0x3A,0x27,0xC2,0xFF,0x48,0x31,0xE5,0xFF,0x82,0x67,0xFE,0xFF,0xB6,0x95,0xFD,0xFF,0xEF,0xD3,0xFE,0xFF,0xAB,0x89,0xFE,0xFE,0x4B,0x31,0xDD,0xEA,0x18,0x10,0x50,0xE0,
    0x1D,0x13,0x60,0xFB,0x2B,0x1C,0x8D,0xFF,0x3F,0x2A,0xD3,0xFF,0x50,0x36,0xF7,0xFF,0x3C,0x2B,0x96,0xFF,0x14,0x10,0x3A,0xFF,0x0D,0x0B,0x30,0xFF,0x0F,0x0A,0x32,0xFE,
    0x11,0x0C,0x3C,0xF1,0x20,0x14,0x69,0xDF,0x22,0x16,0x71,0xE4,0x1E,0x13,0x64,0xED,0x22,0x15,0x70,0xE7,0x26,0x19,0x7F,0xCD,0x1C,0x13,0x60,0x81,0x00,0x01,0x00,0x19,
    0x00,0x01,0x00,0x09,0x01,0x02,0x04,0x2A,0x07,0x04,0x16,0x5B,0x09,0x06,0x1F,0x7E,0x0B,0x08,0x25,0x91,0x0B,0x07,0x24,0x95,0x0B,0x08,0x27,0x82,0x0C,0x08,0x28,0x5A,
    0x00,0x01,0x02,0x1A,0x00,0x01,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x0A,0x0E,0x09,0x31,0x76,
    0x26,0x19,0x7E,0xEF,0x2E,0x1F,0x9D,0xFF,0x3C,0x28,0xC9,0xFF,0x4F,0x35,0xF6,0xFF,0x6B,0x4C,0xFE,0xFF,0x86,0x64,0xFE,0xFF,0xC2,0x9F,0xFD,0xFF,0xCB,0xA6,0xFD,0xFF,
    0x75,0x52,0xFE,0xFF,0x50,0x35,0xDC,0xFF,0x1F,0x14,0x69,0xFF,0x30,0x1F,0x9D,0xFF,0x4B,0x32,0xF2,0xFF,0x5A,0x3C,0xF9,0xFF,0x35,0x23,0xA2,0xFF,0x36,0x23,0xB2,0xFF,
    0x3E,0x29,0xCC,0xFF,0x56,0x3E,0xF5,0xFF,0xA2,0x84,0xFF,0xFF,0xBB,0x9A,0xFF,0xFF,0xED,0xD3,0xFE,0xFF,0x76,0x56,0xFE,0xF8,0x35,0x23,0xA5,0xA5,0x06,0x04,0x14,0x81,
    0x14,0x0D,0x46,0xEC,0x20,0x15,0x69,0xFF,0x33,0x21,0xA9,0xFF,0x46,0x2E,0xE8,0xFF,0x58,0x3C,0xFE,0xFF,0x94,0x77,0xEE,0xFF,0xB3,0x9E,0xC7,0xFF,0x66,0x4E,0xBE,0xFB,
    0x28,0x1B,0x73,0xC0,0x01,0x02,0x06,0x5B,0x05,0x04,0x11,0x54,0x06,0x05,0x18,0x67,0x07,0x06,0x1C,0x5A,0x02,0x02,0x08,0x36,0x00,0x01,0x00,0x13,0x00,0x01,0x00,0x02,
    0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x04,0x00,0x01,0x00,0x0A,0x00,0x01,0x00,0x0F,0x00,0x01,0x00,0x10,0x00,0x01,0x00,0x0A,0x00,0x01,0x00,0x05,
    0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x01,0x00,0x1E,0x17,0x10,0x52,0xB0,
    0x29,0x1A,0x84,0xFB,0x31,0x21,0xA7,0xFF,0x41,0x2B,0xD8,0xFF,0x55,0x3A,0xFC,0xFF,0x6B,0x4C,0xFE,0xFF,0x87,0x65,0xFF,0xFF,0xC4,0xA1,0xFF,0xFF,0xB8,0x93,0xFF,0xFF,
    0x70,0x4D,0xFD,0xFF,0x47,0x2F,0xCA,0xFF,0x1D,0x13,0x61,0xFF,0x2C,0x1B,0x8D,0xFF,0x46,0x2E,0xE4,0xFF,0x3C,0x28,0xBA,0xFF,0x30,0x1F,0xA0,0xFF,0x37,0x24,0xB6,0xFF,
    0x43,0x2D,0xDA,0xFF,0x71,0x57,0xFC,0xFF,0x99,0x79,0xFE,0xFF,0xDA,0xB9,0xFD,0xFF,0xB9,0x9A,0xFE,0xFF,0x5E,0x41,0xFE,0xED,0x22,0x17,0x6E,0x6D,0x01,0x02,0x04,0x3C,
    0x10,0x0A,0x35,0xCF,0x19,0x10,0x53,0xFE,0x27,0x18,0x7E,0xFF,0x3D,0x29,0xCC,0xFF,0x4C,0x33,0xF7,0xFF,0x65,0x49,0xFE,0xFF,0xC1,0xA3,0xFF,0xFF,0xD7,0xB5,0xFD,0xFE,
    0x6D,0x4E,0xF2,0xDB,0x12,0x0D,0x37,0x54,0x00,0x01,0x00,0x08,0x00,0x01,0x00,0x05,0x00,0x01,0x00,0x04,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x02,0x04,0x03,0x0D,0x43,0x1D,0x13,0x63,0xD9,
    0x29,0x1A,0x84,0xFE,0x33,0x22,0xAC,0xFF,0x46,0x2E,0xE6,0xFF,0x5B,0x3E,0xFE,0xFF,0x6D,0x4D,0xFE,0xFF,0x8C,0x6A,0xFF,0xFF,0xC6,0xA3,0xFD,0xFF,0xA7,0x83,0xFF,0xFF,
    0x6B,0x49,0xFD,0xFF,0x3C,0x28,0xB0,0xFF,0x19,0x11,0x56,0xFF,0x27,0x19,0x7E,0xFF,0x3A,0x26,0xBF,0xFF,0x29,0x1B,0x8A,0xFF,0x30,0x20,0xA2,0xFF,0x37,0x25,0xB8,0xFF,
    0x4A,0x33,0xE5,0xFF,0x7C,0x5F,0xFE,0xFF,0xA2,0x83,0xFF,0xFF,0xCA,0xAB,0xFD,0xFF,0x7F,0x61,0xFE,0xFE,0x50,0x36,0xF1,0xD7,0x09,0x07,0x1F,0x42,0x00,0x01,0x00,0x1A,
    0x0B,0x08,0x27,0xA6,0x12,0x0C,0x40,0xFA,0x1C,0x12,0x5C,0xFF,0x31,0x1F,0xA0,0xFF,0x44,0x2D,0xE2,0xFF,0x52,0x38,0xFD,0xFF,0x78,0x5C,0xFE,0xFF,0xC6,0xA7,0xFF,0xFF,
    0xB1,0x90,0xFD,0xF7,0x48,0x31,0xBC,0x9E,0x00,0x01,0x00,0x19,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x06,0x08,0x07,0x20,0x68,0x1E,0x14,0x65,0xED,
    0x27,0x19,0x81,0xFF,0x31,0x21,0xA6,0xFF,0x46,0x2E,0xE5,0xFF,0x5C,0x3F,0xFE,0xFF,0x6F,0x4F,0xFE,0xFF,0x94,0x72,0xFF,0xFF,0xCB,0xA8,0xFE,0xFF,0x98,0x75,0xFE,0xFF,
    0x69,0x46,0xFE,0xFC,0x2F,0x1F,0x8F,0xF9,0x13,0x0D,0x44,0xFE,0x1F,0x14,0x68,0xFF,0x27,0x19,0x80,0xFF,0x2A,0x1B,0x8B,0xFF,0x2F,0x20,0x9E,0xFF,0x37,0x25,0xB7,0xFF,
    0x52,0x3A,0xED,0xFF,0x7B,0x5C,0xFE,0xFF,0xB4,0x96,0xFF,0xFF,0x9E,0x80,0xFF,0xFF,0x65,0x48,0xFE,0xFB,0x3C,0x28,0xBF,0xAD,0x00,0x01,0x00,0x1E,0x00,0x01,0x00,0x09,
    0x08,0x06,0x1B,0x73,0x11,0x0B,0x37,0xEF,0x16,0x0F,0x4D,0xFF,0x24,0x16,0x74,0xFF,0x3C,0x27,0xC8,0xFF,0x4C,0x32,0xF6,0xFF,0x60,0x45,0xFE,0xFF,0x95,0x77,0xFF,0xFF,
    0xC6,0xA6,0xFD,0xFE,0x7B,0x5C,0xF7,0xD9,0x0F,0x0A,0x2E,0x47,0x00,0x01,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x0B,0x09,0x07,0x25,0x85,0x1D,0x13,0x60,0xF5,
    0x24,0x17,0x78,0xFF,0x2F,0x1E,0x9B,0xFF,0x40,0x2B,0xD9,0xFF,0x51,0x36,0xFD,0xFF,0x62,0x43,0xFE,0xFF,0x89,0x67,0xFF,0xFF,0xB1,0x8E,0xFF,0xFF,0x77,0x56,0xFE,0xFE,
    0x50,0x35,0xE6,0xE5,0x12,0x0C,0x3B,0xCD,0x14,0x0E,0x49,0xF9,0x16,0x0F,0x4E,0xFF,0x21,0x15,0x6A,0xFF,0x29,0x1A,0x85,0xFF,0x2D,0x1E,0x97,0xFF,0x35,0x23,0xB1,0xFF,
    0x54,0x3A,0xF4,0xFF,0x90,0x72,0xFE,0xFF,0xB4,0x96,0xFC,0xFF,0x89,0x6B,0xFE,0xFF,0x5C,0x3F,0xFE,0xF1,0x25,0x18,0x7A,0x77,0x00,0x01,0x00,0x0A,0x00,0x01,0x00,0x02,
    0x02,0x03,0x0A,0x44,0x11,0x0B,0x38,0xDB,0x15,0x0F,0x4C,0xFE,0x1E,0x13,0x62,0xFF,0x32,0x21,0xAA,0xFF,0x48,0x30,0xEE,0xFF,0x5B,0x40,0xFE,0xFF,0x83,0x66,0xFE,0xFF,
    0xB8,0x9A,0xFF,0xFF,0x90,0x71,0xFD,0xF2,0x2C,0x1D,0x84,0x78,0x00,0x01,0x00,0x0A,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x0E,0x0B,0x07,0x27,0x90,0x1B,0x11,0x59,0xF8,
    0x22,0x16,0x70,0xFF,0x2D,0x1D,0x95,0xFF,0x3E,0x29,0xCF,0xFF,0x49,0x30,0xF2,0xFF,0x52,0x36,0xFE,0xFF,0x5F,0x41,0xFE,0xFF,0x67,0x48,0xFE,0xFF,0x56,0x39,0xFE,0xFC,
    0x3A,0x27,0xC0,0xC1,0x09,0x06,0x20,0xA2,0x19,0x0F,0x53,0xF5,0x19,0x11,0x57,0xFF,0x1F,0x14,0x65,0xFF,0x27,0x18,0x7D,0xFF,0x2A,0x1B,0x8A,0xFF,0x33,0x22,0xAC,0xFF,
    0x55,0x3A,0xF8,0xFF,0x9B,0x7E,0xFF,0xFF,0xB6,0x98,0xFD,0xFF,0x84,0x66,0xFE,0xFE,0x55,0x3A,0xFA,0xE0,0x0A,0x08,0x22,0x4A,0x00,0x01,0x00,0x03,0x00,0x01,0x00,0x00,
    0x00,0x01,0x00,0x28,0x0F,0x0B,0x38,0xC2,0x19,0x10,0x55,0xFD,0x1E,0x14,0x63,0xFF,0x2B,0x1C,0x8F,0xFF,0x43,0x2C,0xDE,0xFF,0x53,0x39,0xFD,0xFF,0x75,0x58,0xFE,0xFF,
    0xAC,0x8E,0xFF,0xFF,0x91,0x73,0xFE,0xF9,0x3A,0x27,0xAD,0x99,0x00,0x01,0x00,0x12,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x0D,0x09,0x07,0x23,0x8F,0x18,0x0F,0x51,0xF8,
    0x1F,0x15,0x6A,0xFF,0x2D,0x1D,0x94,0xFF,0x3F,0x2A,0xD1,0xFF,0x4A,0x30,0xF3,0xFF,0x51,0x36,0xFE,0xFF,0x5B,0x3D,0xFE,0xFF,0x5E,0x3F,0xFE,0xFF,0x56,0x39,0xFD,0xF9,
    0x32,0x20,0xA0,0xA3,0x08,0x06,0x1E,0x92,0x19,0x10,0x53,0xF4,0x18,0x10,0x54,0xFF,0x1B,0x12,0x5D,0xFF,0x22,0x17,0x74,0xFF,0x27,0x19,0x81,0xFF,0x33,0x22,0xAC,0xFF,
    0x54,0x3A,0xF8,0xFF,0x96,0x78,0xFF,0xFF,0xB0,0x91,0xFF,0xFF,0x75,0x57,0xFE,0xFE,0x48,0x30,0xDD,0xC9,0x01,0x01,0x02,0x2C,0x00,0x01,0x00,0x01,0x00,0x00,0x00,0x00,
    0x00,0x01,0x00,0x16,0x0F,0x0B,0x35,0xA3,0x1C,0x11,0x5C,0xFA,0x1F,0x15,0x69,0xFF,0x27,0x19,0x81,0xFF,0x3C,0x28,0xCB,0xFF,0x4D,0x33,0xF8,0xFF,0x67,0x4B,0xFF,0xFF,
    0x9E,0x80,0xFE,0xFF,0x8B,0x6D,0xFD,0xFC,0x41,0x2B,0xC2,0xB0,0x00,0x01,0x00,0x1C,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x09,0x09,0x05,0x1F,0x7B,0x15,0x0E,0x49,0xF3,
    0x1D,0x13,0x62,0xFF,0x2A,0x1C,0x8E,0xFF,0x3E,0x29,0xCD,0xFF,0x48,0x30,0xF0,0xFF,0x50,0x35,0xFE,0xFF,0x59,0x3C,0xFE,0xFF,0x5B,0x3D,0xFE,0xFF,0x54,0x38,0xFF,0xF3,
    0x24,0x19,0x79,0x81,0x08,0x05,0x1A,0x7A,0x18,0x10,0x50,0xF0,0x18,0x10,0x53,0xFF,0x19,0x10,0x52,0xFF,0x1F,0x15,0x6A,0xFF,0x25,0x18,0x7A,0xFF,0x33,0x22,0xAB,0xFF,
    0x52,0x38,0xF8,0xFF,0x8C,0x6F,0xFE,0xFF,0xA4,0x86,0xFD,0xFF,0x69,0x4B,0xFE,0xFB,0x3C,0x27,0xBC,0xB0,0x00,0x01,0x00,0x1B,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x01,0x00,0x0C,0x0C,0x08,0x2B,0x84,0x1D,0x13,0x62,0xF5,0x20,0x16,0x6F,0xFF,0x26,0x19,0x7E,0xFF,0x38,0x25,0xBC,0xFF,0x48,0x30,0xF0,0xFF,0x5C,0x41,0xFE,0xFF,
    0x8E,0x71,0xFF,0xFF,0x80,0x62,0xFE,0xFD,0x41,0x2C,0xC7,0xBD,0x00,0x01,0x00,0x22,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x04,0x06,0x04,0x17,0x5B,0x11,0x0C,0x3F,0xE6,
    0x1B,0x11,0x5A,0xFE,0x26,0x19,0x81,0xFF,0x3A,0x26,0xC2,0xFF,0x46,0x2E,0xE8,0xFF,0x4E,0x33,0xFC,0xFF,0x56,0x39,0xFE,0xFF,0x57,0x3A,0xFE,0xFE,0x4F,0x35,0xFB,0xE3,
    0x10,0x0B,0x39,0x56,0x05,0x03,0x11,0x54,0x14,0x0E,0x47,0xE1,0x18,0x10,0x51,0xFE,0x14,0x0E,0x47,0xFF,0x1D,0x13,0x5D,0xFF,0x21,0x16,0x70,0xFF,0x33,0x21,0xAA,0xFF,
    0x4E,0x35,0xF5,0xFF,0x7E,0x62,0xFE,0xFF,0x95,0x77,0xFE,0xFF,0x60,0x43,0xFE,0xF9,0x33,0x22,0xA6,0x9A,0x00,0x01,0x00,0x11,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x01,0x00,0x06,0x08,0x06,0x1E,0x66,0x1E,0x14,0x66,0xEC,0x22,0x17,0x75,0xFF,0x27,0x19,0x81,0xFF,0x36,0x23,0xB4,0xFF,0x46,0x2E,0xE7,0xFF,0x56,0x3B,0xFE,0xFF,
    0x85,0x67,0xFF,0xFF,0x72,0x55,0xFE,0xFC,0x3B,0x28,0xBE,0xB1,0x00,0x01,0x00,0x1D,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x01,0x01,0x01,0x02,0x29,0x0E,0x09,0x2E,0xB4,
    0x13,0x0D,0x40,0xF8,0x1F,0x14,0x6B,0xFE,0x34,0x22,0xAD,0xFF,0x40,0x2B,0xD7,0xFF,0x49,0x30,0xF1,0xFF,0x4F,0x35,0xFE,0xFF,0x4F,0x35,0xFD,0xFB,0x3E,0x29,0xCD,0xBB,
    0x00,0x01,0x00,0x28,0x00,0x01,0x02,0x28,0x0E,0x09,0x31,0xB5,0x14,0x0E,0x47,0xF9,0x11,0x0C,0x3E,0xFE,0x19,0x10,0x52,0xFF,0x1F,0x13,0x62,0xFF,0x2E,0x1F,0x9C,0xFF,
    0x48,0x30,0xEA,0xFF,0x70,0x55,0xFE,0xFF,0x8D,0x6F,0xFE,0xFF,0x5C,0x3F,0xFE,0xF8,0x2C,0x1D,0x8E,0x93,0x00,0x01,0x00,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x01,0x00,0x02,0x03,0x03,0x0E,0x48,0x1D,0x13,0x63,0xDF,0x25,0x18,0x79,0xFF,0x28,0x1A,0x86,0xFF,0x34,0x24,0xB1,0xFF,0x44,0x2D,0xE0,0xFF,0x53,0x38,0xFC,0xFF,
    0x79,0x5C,0xFE,0xFF,0x60,0x44,0xFE,0xF9,0x33,0x22,0xA7,0x9A,0x00,0x01,0x00,0x12,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x01,0x00,0x07,0x04,0x03,0x0F,0x4A,
    0x0D,0x08,0x2D,0xB6,0x12,0x0C,0x3D,0xEF,0x20,0x15,0x6E,0xFC,0x2F,0x1F,0x9D,0xFE,0x3A,0x26,0xC2,0xFE,0x41,0x2B,0xDB,0xFA,0x3C,0x28,0xCB,0xDE,0x1A,0x12,0x59,0x69,
    0x00,0x01,0x00,0x0A,0x00,0x01,0x00,0x08,0x05,0x03,0x0F,0x4E,0x0E,0x09,0x30,0xBD,0x0F,0x0B,0x37,0xF6,0x14,0x0E,0x49,0xFF,0x1C,0x11,0x58,0xFF,0x29,0x1B,0x88,0xFF,
    0x41,0x2B,0xD7,0xFF,0x5E,0x43,0xFC,0xFF,0x81,0x64,0xFE,0xFF,0x59,0x3C,0xFE,0xF8,0x28,0x1A,0x84,0x8F,0x00,0x01,0x00,0x0D,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x01,0x00,0x01,0x02,0x01,0x07,0x3A,0x1B,0x12,0x5F,0xD7,0x27,0x18,0x7E,0xFE,0x2A,0x1C,0x8E,0xFF,0x35,0x23,0xB2,0xFF,0x40,0x2A,0xD6,0xFF,0x4D,0x34,0xF6,0xFF,
    0x62,0x47,0xFE,0xFF,0x51,0x37,0xFB,0xF4,0x27,0x1A,0x83,0x80,0x00,0x01,0x00,0x0B,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x01,0x00,0x07,
    0x01,0x01,0x05,0x32,0x0A,0x06,0x20,0x82,0x0E,0x09,0x32,0xBE,0x15,0x0E,0x49,0xD7,0x1E,0x14,0x68,0xD5,0x23,0x17,0x75,0xB2,0x14,0x0D,0x44,0x67,0x00,0x01,0x00,0x18,
    0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x00,0x00,0x01,0x00,0x08,0x01,0x01,0x05,0x45,0x0E,0x09,0x2F,0xCE,0x12,0x0D,0x41,0xFD,0x19,0x10,0x52,0xFF,0x24,0x17,0x79,0xFF,
    0x3B,0x27,0xC4,0xFF,0x4D,0x34,0xF1,0xFF,0x66,0x4A,0xFE,0xFF,0x54,0x39,0xFE,0xF8,0x29,0x1B,0x88,0x8F,0x00,0x01,0x00,0x0D,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x01,0x00,0x01,0x00,0x01,0x01,0x31,0x19,0x11,0x5A,0xCD,0x26,0x18,0x7F,0xFE,0x2E,0x1F,0x9A,0xFF,0x3A,0x27,0xC2,0xFF,0x43,0x2D,0xDF,0xFF,0x4E,0x35,0xF7,0xFF,
    0x5D,0x43,0xFE,0xFF,0x4E,0x34,0xF9,0xEC,0x1A,0x11,0x58,0x63,0x00,0x01,0x00,0x05,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,
    0x00,0x01,0x00,0x02,0x00,0x01,0x00,0x0F,0x00,0x01,0x00,0x28,0x02,0x02,0x09,0x3C,0x01,0x01,0x08,0x3B,0x00,0x01,0x00,0x21,0x00,0x01,0x00,0x09,0x00,0x01,0x00,0x01,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x01,0x00,0x17,0x0C,0x08,0x28,0xA5,0x10,0x0B,0x37,0xFA,0x15,0x0F,0x4B,0xFF,0x23,0x16,0x72,0xFF,
    0x39,0x25,0xBE,0xFF,0x48,0x31,0xEA,0xFF,0x61,0x47,0xFE,0xFF,0x57,0x3A,0xFE,0xF8,0x2E,0x1F,0x93,0x91,0x00,0x01,0x00,0x0E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x01,0x00,0x00,0x00,0x01,0x00,0x21,0x16,0x0E,0x4C,0xBA,0x24,0x17,0x78,0xFD,0x2D,0x1E,0x98,0xFF,0x3B,0x27,0xC5,0xFF,0x44,0x2D,0xE1,0xFF,0x50,0x37,0xF9,0xFF,
    0x5B,0x40,0xFE,0xFE,0x48,0x2F,0xEB,0xDB,0x07,0x05,0x19,0x43,0x00,0x01,0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x0B,0x09,0x06,0x1F,0x81,0x0F,0x0A,0x32,0xF3,0x11,0x0C,0x3E,0xFF,0x1E,0x13,0x63,0xFF,
    0x36,0x23,0xB4,0xFF,0x46,0x2F,0xE4,0xFF,0x5E,0x44,0xFE,0xFF,0x56,0x3A,0xFE,0xF8,0x2D,0x1E,0x93,0x92,0x00,0x01,0x00,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x14,0x0D,0x09,0x31,0x9A,0x1D,0x13,0x62,0xF8,0x27,0x1A,0x84,0xFF,0x35,0x23,0xB0,0xFF,0x3E,0x29,0xCF,0xFF,0x47,0x30,0xEA,0xFF,
    0x4A,0x31,0xEE,0xFA,0x36,0x24,0xB4,0xB3,0x01,0x01,0x02,0x22,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x03,0x03,0x02,0x0C,0x4C,0x0E,0x0A,0x31,0xD8,0x10,0x0A,0x34,0xFD,0x14,0x0E,0x49,0xFF,
    0x2D,0x1D,0x95,0xFF,0x3C,0x28,0xCA,0xFF,0x4C,0x34,0xEE,0xFE,0x4C,0x32,0xF6,0xEF,0x26,0x19,0x7E,0x75,0x00,0x01,0x00,0x09,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x06,0x05,0x03,0x11,0x55,0x11,0x0B,0x39,0xD3,0x15,0x0F,0x4A,0xFA,0x20,0x15,0x6E,0xFE,0x2C,0x1D,0x93,0xFE,0x34,0x22,0xAE,0xF9,
    0x34,0x23,0xB0,0xD8,0x17,0x10,0x4F,0x62,0x00,0x01,0x00,0x09,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x01,0x00,0x16,0x09,0x06,0x20,0x81,0x0E,0x0A,0x32,0xDF,0x0F,0x0A,0x33,0xFA,
    0x1A,0x11,0x58,0xFE,0x2A,0x1C,0x8D,0xFE,0x35,0x23,0xB1,0xF6,0x33,0x22,0xAE,0xBD,0x09,0x07,0x21,0x38,0x00,0x01,0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x01,0x00,0x0F,0x07,0x05,0x19,0x5D,0x0D,0x09,0x2E,0xB8,0x0F,0x0A,0x33,0xDC,0x14,0x0D,0x44,0xD8,0x19,0x11,0x57,0xAE,
    0x0D,0x09,0x2C,0x5B,0x00,0x01,0x00,0x13,0x00,0x01,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x18,0x08,0x05,0x1B,0x5F,0x0E,0x09,0x2E,0xAF,
    0x10,0x0A,0x34,0xDB,0x14,0x0E,0x48,0xD9,0x1B,0x12,0x5C,0xA3,0x09,0x06,0x21,0x44,0x00,0x01,0x00,0x08,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x01,0x00,0x09,0x00,0x01,0x01,0x27,0x04,0x03,0x0F,0x43,0x02,0x03,0x0C,0x3E,0x00,0x01,0x00,0x20,
    0x00,0x01,0x00,0x07,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x01,0x00,0x07,0x00,0x01,0x01,0x21,
    0x02,0x01,0x09,0x43,0x02,0x01,0x09,0x41,0x00,0x01,0x01,0x1D,0x00,0x01,0x00,0x05,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x00,
    0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,
    0x00,0x01,0x00,0x02,0x00,0x01,0x00,0x02,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
    },
    32,32
    };
