/*
  openhtml - open a html file with the PM's default browser.
  
  license: Public Domain
           (You may use/modify/redistribute it freely with NO WARRANTY.)
*/

#define INCL_DOS
#define INCL_DOSERRORS
#define INCL_WIN
#include <os2.h>

#include <sys/types.h>
#include <sys/stat.h>
#include <malloc.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <locale.h>

static FILE *ferr;
static PPIB ppib;

#define isPM() (ppib && ppib->pib_ultype==3)

#if defined(__EMX__)
static int my_chdrive(int d)
{
  char s[3];
  
  if (d < 1 || d > 26) return -1;
  s[0] = 'A' - d - 1;
  s[1] = ':';
  s[2] = '\0';
  
  return _chdir2 (s);
}
static int my_getdrive(void)
{
  return _getdrive() - 'A' + 1;
}
#else
# include <direct.h>
# define my_chdrive(d) _chdrive(d)
# define my_getdrive _getdrive
#endif


static int my_toupper(int c)
{
  return ('a' <= c && c <= 'z') ? c - 'a' + 'A' : c;
}

struct OPENAPP {
  char *prog;
  char *param;
  char *execdir;
  int opt;
};


static
char *
dup_profile_string(HINI hini, const char *app, const char *key)
{
  const size_t s_lim = 4096;
  char *s;
  ULONG ul;
  
  s = alloca(s_lim + 1);
  *s = '\0';
  ul = PrfQueryProfileString(hini, (PSZ)app, (PSZ)key, (PSZ)"", s, s_lim);
  if (ul >= s_lim || ul == 0) {
    return NULL; /* string too long (or error) */
  }
  
  return strdup(s);
}

static
int
openapp_prepare_browser(struct OPENAPP *openapp)
{
  static const char sz_app[] = "WPURLDEFAULTSETTINGS";
  static const char sz_prog[] = "DefaultBrowserExe";
  static const char sz_param[] = "DefaultParameters";
  static const char sz_execdir[] = "DefaultWorkingDir";
  HINI hini = HINI_USERPROFILE;
  struct OPENAPP oa;
  struct stat st;
  
  memset(&oa, 0, sizeof(oa));
  oa.prog = dup_profile_string(hini, sz_app, sz_prog);
  if (!oa.prog) return -1;
  if (!oa.prog[0] || stat(oa.prog, &st) < 0 || !S_ISREG(st.st_mode)) {
    free(oa.prog);
    return -1;
  }
  oa.param = dup_profile_string(hini, sz_app, sz_param);
  oa.execdir = dup_profile_string(hini, sz_app, sz_execdir);
  
  *openapp = oa;
  return 0;
}

static
void
openapp_free(struct OPENAPP *oa)
{
  if (oa->execdir) { free(oa->execdir); oa->execdir = NULL; }
  if (oa->param) { free(oa->param); oa->param = NULL; }
  if (oa->prog) { free(oa->prog); oa->prog = NULL; }
}


APIRET
openapp_browser(const struct OPENAPP *oa, const char *doc)
{
  APIRET rc;
  STARTDATA sd;
  char *s_prm;
  size_t n_prm;
  ULONG ul;
  PID pid;
  char *doc2;
  
  memset(&sd, 0, sizeof(sd));
  sd.Length = sizeof(sd);
  
  n_prm = doc ? strlen(doc) : 0;
  doc2 = alloca(n_prm + 1);
  if (doc) memcpy(doc2, doc, n_prm+1);
  else doc2[0] = '\0';
  /* WebExplorer needs backslashified pathnames */
  if (stricmp(_getname(oa->prog), "EXPLORE.EXE")==0) {
    for(n_prm=0; doc2[n_prm]; ++n_prm)
      if (doc2[n_prm] == '/') doc2[n_prm] = '\\';
  }
  else
    _fnslashify(doc2);
  
  n_prm = (oa->param ? strlen(oa->param):0) + (doc ? n_prm+3:0) + 1;
  s_prm = alloca(n_prm);
  s_prm[0] = '\0';
  if (oa->param) strcat(s_prm, oa->param);
  if (doc) {
    if (s_prm[0]) strcat(s_prm, " ");
    if (strchr(doc2, ' ') && !(strchr(doc2, '\"') || strchr(doc2, '\''))) {
      /* enquoting minimally (workaround) */
      strcat(s_prm, "\"");
      strcat(s_prm, doc2);
      strcat(s_prm, "\"");
    }
    else
      strcat(s_prm, doc2);
  }
  
  sd.PgmName = (PSZ)(oa->prog);
  sd.PgmInputs = (PBYTE)(s_prm);

  if (oa->execdir) {
    int orgdrv, drv;
    char orgdir[_MAX_PATH+1];
    
    orgdrv = my_getdrive();
    drv = my_toupper(oa->execdir[0]);
    if ('A'<=drv && drv<='Z' && oa->execdir[1]==':') {
      drv = drv - 'A' + 1;
      my_chdrive(drv);
    }
    *orgdir = '\0';
    getcwd(orgdir, sizeof(orgdir));
    chdir(oa->execdir);
    rc = DosStartSession(&sd, &ul, &pid);
    chdir(orgdir);
    my_chdrive(orgdrv);
  }
  else
    rc = DosStartSession(&sd, &ul, &pid);
  
  return rc;
}


int
main(int argc, char **argv)
{
  APIRET rc = 0;
  struct OPENAPP oa;
  PTIB ptib;
  struct stat st;
  
  DosGetInfoBlocks(&ptib, &ppib);
  if (isPM())
    ferr = fopen("nul", "wb");
  else
    ferr = stderr;

#if defined(__INNOTEK_LIBC__) || defined(__KLIBC__)
  {
    /* set current locale (with proper langinfo) */
    char *env, *s, sloc[64], lcstr[128];
    
    *lcstr = '\0';
    env = getenv("LC_ALL");
    if (!env) env = getenv("LOCALE");
    if (!env) env = getenv("LANG");
    if (!env) env = "";
    snprintf(sloc, sizeof(sloc), "%s", env);
    s = strchr(sloc, '.');
    if (s || *sloc == '\0') strcpy(lcstr, sloc);
    else {
      ULONG ulcp, ulncp;
      DosQueryCp(sizeof(ulcp), &ulcp, &ulncp);
      snprintf(lcstr, sizeof(lcstr), "%s.IBM-%lu", sloc, ulcp);
    }
    setlocale(LC_ALL, lcstr);
  }
#else
  setlocale(LC_ALL, "");
#endif

  if (openapp_prepare_browser(&oa) < 0 || !oa.prog || !oa.prog[0]) {
    fprintf(ferr, "openhtml: no default browser.\n");
  }
  
  if (argv[1]) {
    if (stat(argv[1], &st) < 0 && !S_ISREG(st.st_mode)) {
      fprintf(ferr, "openhtml: file \"%s\" not found.\n", argv[1]);
      return -1;
    }
    rc = openapp_browser(&oa, argv[1]);
  } else
    fprintf(ferr, "usage: openhtml [pathname]\n");
  openapp_free(&oa);
  
  return rc;
}

