/* RexxPong version 1.0 */
/* written by Stephen Hobbie (shobbie@ibm.net) beginning 19APR1997 */
/* Global Variable Settings are stored at the end of this program */
/* for best results run in full screen OS/2 session */

call rxfuncadd 'sysloadfuncs', 'rexxutil', 'sysloadfuncs'
call sysloadfuncs
call SysCls
call SysCurState OFF
call GLVARINI
call DRAWBORD;
call PADINIT;
call SHOWSCORE;
call STBALL;

do until byebi=1
   call MVBALL;
end /* main event loop */
call SysCls
say "CUL8R!"
return 1

MVPADDLE:
   select 
   when keyz ='H' & prow>1 then do
      /* move paddle (up key) */
      prow =prow -1
      plst =syscurpos(prow,pcol);
      say paddle
      plst =syscurpos(prow+psize,pcol);
      say ' ';
      pslide =pslide +1
      end
   when keyz ='P' & prow<vsize-psize then do
      /* move paddle (down key) */
      plst =syscurpos(prow,pcol);
      say ' '
      plst =syscurpos(prow+psize,pcol)
      say paddle
      prow =prow +1
      pslide =pslide +1
      end
   when keyz='S' then call SETUPVAR
   when keyz='Q' then byebi =1
   otherwise NOP
   end; /* key logic select */
 return;

MVBALL:
/* this function keeps the ball bouncing */
/* put timing delay here */
   i=time('R')
   do while time('E')<speedo
   /* check for keypress */
   if chars() >0 then do
      keyz2 = SysGetKey("NOECHO")
      if keyz2 ="" then keyz2 =SysGetKey("NOECHO")
      parse upper var keyz2 keyz keyz2
      pslide=0
   end
    if pslide<pslidemax then call MVPADDLE
       do while time('E')<speedo/pslidemax
           nop
       end
   end 

/* blank out current ball */
blst =syscurpos(brow,bcol)
say ' '

/* calculate next tentative position */
if hdir='E' then bcol=bcol +1
else bcol =bcol -1
if vdir ='S' then brow =brow +1
else brow =brow -1

/* ball rules:test for bounce or miss */
select
when bcol=1 then do  
   if brow>=prow-1 & brow<=prow+psize+1 then do
     /* player hit the ball! */
      bcol =bcol +1
      hdir ='E'
      plyr1 =plyr1 +1
      if sndon=1 then CALL SOUNDBUMP
      call SHOWSCORE
      if brow=prow-1 & vdir='S' then vdir ='N'
      if brow =prow+psize+1 & vdir='N' then vdir ='S'
   end
   else  do
      /* player missed the ball */
      plyr2 =plyr2 +1
      if sndon=1 then CALL SOUNDMISS
      call SHOWSCORE;
      call STBALL;
   end
end
when  bcol =hsize then do
   /* east wall */
   bcol =bcol -1
   hdir ='W'
   if sndon=1 then CALL SOUNDBUMP
end
when brow =0 then do
   /* north wall */
   brow =brow +1
   vdir ='S'
   if sndon=1 then CALL SOUNDBUMP
end
when brow =vsize then do
  /* south wall */
   brow =brow -1
   vdir ='N'
   if sndon=1 then CALL SOUNDBUMP
end
otherwise
   NOP
end;

/* perform bounds check to handle corners */
 select
   when brow>=vsize then brow=vsize-1
   when brow<=0 then brow=1
   when bcol>=hsize then bcol=hsize-1
   when bcol<=0 then bcol=1
   otherwise nop
   end

/* draw new ball */
blst =syscurpos(brow,bcol)
say ''
RETURN 1

STBALL:
/* initialize ball starting point */
if byebi=0 then do
   blast =call syscurpos(trunc(vsize/2),trunc(hsize/2)-5)
   say "GET READY"
   call syssleep 2
   blast =syscurpos(trunc(vsize/2),trunc(hsize/2)-5)
   say "         "
   brow =random(2,vsize-1)
   bcol =random(trunc(hsize*.75),hsize-1)
   vdir ='S'
   hdir ='W'
end
return 1

SHOWSCORE:
/* show score and check for finish */
plst =syscurpos(vsize+1,0)
say "Player:"plyr1"  Computer:"plyr2"  Q=Quit  S=Setup =Up  =Down"
select
   when plyr1>=gmpt then do
      if sndon=1 then call SOUNDWIN
      winner ="GAME OVER: YOU WON!"
      call SHOWOVER
   end
   when plyr2>=gmpt then do
      if sndon=1 then CALL SOUNDLOSE
      winner ="GAME OVER: YOU LOST."
      call SHOWOVER
   end
otherwise
   NOP
end  /* select */
return 1

SHOWOVER:
plst =syscurpos(trunc(vsize/2),trunc(hsize/2)-10)
say winner
plst =syscurpos(trunc(vsize/2)+1,trunc(hsize/2)-10)
say "Play Again? Y/N?"
i=time('R')
keyz =' '
do until time('E')>i+25 |keyz ='Y' |keyz ='N'
   call syssleep(1)
   if chars()>0 then do
      keyz2 =SysGetKey("NOECHO")
      parse upper var keyz2 keyz keyz2
   end
end
/* timeout with no reply starts automatic game */
if keyz <>'Y' &keyz<>'N' then psize =vsize-1
else psize =trunc(vsize/5)

/* prepare to start over */
plyr1=0
plyr2=0
if keyz='N' then byebi=1
plst =syscurpos(trunc(vsize/2),trunc(hsize/2)-10)
say copies(" ",25)
plst =syscurpos(trunc(vsize/2)+1,trunc(hsize/2)-10)
say copies(" ",16)
call PADINIT
call SHOWSCORE
call STBALL
return 1

DRAWBORD:
/* draw borders */
do i =0 to hsize
  /* horizontal border */
  plst =syscurpos(0,i)
  say brick
  plst =syscurpos(vsize,i)
  say brick
  if i <vsize & i>0 then
  do
    /* vertical border */
    plst =syscurpos(i,0)
    say brick
    plst =syscurpos(i,hsize)
    say brick
  end
end
return 1;

SOUNDLOSE:
 do i=8 to 1 by -1
   call beep note.i,1
 end
return 1

SOUNDWIN:
 do i=1 to 8
   call beep note.i,1
 end
return 1

SOUNDBUMP:
call beep note.7,1
return 1

SOUNDMISS:
call beep note.1,250
return 1

PADINIT:
/* initialize paddle */
prow =1; pcol =1;

do i=1 to vsize-1
   plast =syscurpos(i,pcol)
   say ' '
end /* do */

do i=0 to psize-1
   plst =syscurpos(prow+i,pcol);
   say paddle
end /* do */
return 1

SETUPVAR:
call syscls
call syscurstate ON
say ' '
say '**** REXXPONG SETUP VARIABLES ****'
say sndon       'sound on=1 off=0'
say speedo      'game speed delay in seconds (0.01-1.00)'
say hsize       'horizontal screen size (30-78)'
say vsize       'vertical screen size (7-22)'
say gmpt        'game point 1-9999'
say paddle      'character to use as paddle'
say brick       'character to use for walls'
say psize       'size of paddle in #chars (max =vertical size-2)'
say pslidemax   'paddle slippage (0-9)'

plst =syscurpos(2,0)
pull keyz2
if keyz2=0 | keyz2=1 then sndon =keyz2

pull keyz2
if keyz2>=0 & keyz2<=0.09 then speedo =keyz2

pull keyz2
if keyz2>=30 & keyz2<=78 then hsize =keyz2

pull keyz2
if keyz2>=7 & keyz2<=22 then vsize =keyz2

pull keyz2
if keyz2>=1 & keyz2<=9999 then gmpt =keyz2

pull keyz2
if length(keyz2)=1 then paddle =keyz2

pull keyz2
if length(keyz2)=1 then brick =keyz2

pull keyz2
if keyz2>=0 & keyz2<vsize-1 then psize =keyz2

pull keyz2
if keyz2>=0 & keyz2<=9 then pslidemax =keyz2

keyz =' '
call syscurstate off;
call syscls;
plyr1=0
plyr2=0
call DRAWBORD;
call PADINIT;
call SHOWSCORE;
call STBALL;
return 1

GLVARINI:
/* Global Variables Initialization */
i =0; /* generic counting var */
byebi  =0; /* 0=play & 1=stop */
keyz   =' '; /* keyboard input */
keyz2  =' '; /* temp keyboard input */
plyr1 =0; /* score for player */
plyr2 =0; /* score for computer */
prow=1; /* paddle row */
pcol=1; /* paddle column */
pslide=0; /* sliding counter */

/* C scale constants */
note.1 = 262    /* middle C */
note.2 = 294    /*    D     */
note.3 = 330    /*    E     */
note.4 = 349    /*    F     */
note.5 = 392    /*    G     */
note.6 = 440    /*    A     */
note.7 = 494    /*    B     */
note.8 = 524    /*    C     */

/* game setting variables */
sndon=1; /* sound on=1 off=0 */
speedo =0.04; /* game speed delay in seconds (0.01-1.00) */
hsize =56; /* horizontal screen size min=30, max=78 */
vsize =16; /* vertical screen size min=7, max=22 */
gmpt =5; /* game point */
paddle =''; /* char for Paddle */
brick =''; /* char for walls */
psize  =trunc(vsize/5) /* size of paddle in #chars (max=vsize-2) */
pslidemax =trunc(vsize/3); /* paddle slide maximum (0-9)*/
return 1


