echo off

copy autoconf.h.os2 autoconf.h
set save_gccopt=%GCCOPT
set GCCOPT=

echo Deleting previous object files...
del *.o > nul

echo Building UnterMUD database layer.

rem ---------------------------------------------------------------------
rem Comment out one of the following two lines, depending on whether you
rem want object-level or attribute-level cacheing.  Object-level cacheing
rem is more efficient.
rem ---------------------------------------------------------------------

rem gcc -c -DCACHE_ATTRS -DOS2 udb_acache.c udb_achunk.c udb_attr.c
gcc -c -DCACHE_OBJS -DOS2 udb_ocache.c udb_ochunk.c udb_obj.c

gcc -c -DOS2 udb_misc.c myndbm.c

echo Building version data...
gcc -c -DOS2 -DMUSH_BUILD_DATE="\"07-13-99\"" -DMUSH_BUILD_NUM="\"2\"" version.c

echo Building NETMUSH...
gcc -c -DOS2 alloc.c boolexp.c bsd.c command.c compat.c conf.c
gcc -c -DOS2 cque.c create.c db.c db_rw.c eval.c file_c.c
gcc -c -DOS2 flags.c functions.c game.c help.c htab.c log.c look.c
gcc -c -DOS2 match.c move.c netcommon.c object.c player.c player_c.c
gcc -c -DOS2 predicates.c quota.c regexp.c rob.c
gcc -c -DOS2 set.c speech.c stringutil.c timer.c unparse.c vattr.c
gcc -c -DOS2 walkdb.c wild.c wiz.c

echo Linking NETMUSH.EXE...
gcc -s -Zbsd-signals -Zbin-files -O3 -o netmush.exe alloc.o boolexp.o bsd.o command.o compat.o conf.o cque.o create.o db.o db_rw.o eval.o file_c.o flags.o functions.o game.o help.o htab.o log.o look.o match.o move.o netcommon.o object.o player.o player_c.o predicates.o quota.o regexp.o rob.o set.o speech.o stringutil.o timer.o unparse.o vattr.o walkdb.o wild.o wiz.o udb_ocache.o udb_ochunk.o udb_obj.o udb_misc.o version.o myndbm.o -lsocket

echo Building DBCONVERT...
gcc -c boolexp.c -o sa-boolexp.o -DSTANDALONE
gcc -c conf.c -o sa-conf.o -DSTANDALONE
gcc -c db.c -o sa-db.o -DSTANDALONE
gcc -c db_rw.c -o sa-db_rw.o -DSTANDALONE
gcc -c flags.c -o sa-flags.o -DSTANDALONE
gcc -c htab.c -o sa-htab.o -DSTANDALONE
gcc -c log.c -o sa-log.o -DSTANDALONE
gcc -c object.c -o sa-object.o -DSTANDALONE
gcc -c player_c.c -o sa-player_c.o -DSTANDALONE
gcc -c predicates.c -o sa-predicates.o -DSTANDALONE
gcc -c stringutil.c -o sa-stringutil.o -DSTANDALONE
gcc -c unparse.c -o sa-unparse.o -DSTANDALONE
gcc -c vattr.c -o sa-vattr.o -DSTANDALONE
gcc -c dbconvert.c

echo Linking DBCONVERT.EXE...
gcc -s -O3 -Zbin-files -o dbconvert.exe dbconvert.o sa-boolexp.o sa-conf.o sa-db.o sa-db_rw.o sa-flags.o sa-htab.o sa-log.o sa-object.o sa-player_c.o sa-predicates.o sa-stringutil.o sa-unparse.o sa-vattr.o udb_ocache.o udb_ochunk.o udb_obj.o udb_misc.o myndbm.o

echo Building MKINDX...
gcc -s -O3 -Zbin-files -o mkindx.exe mkindx.c

echo Building UNSPLIT...
gcc -s -O3 -Zbin-files -o unsplit.exe unsplit.c

set GCCOPT=%save_gccopt
