// File: consts.h
// Purpose: global constants and macro definitions


/*
 * Do not edit this file unless you know *exactly* what you are doing.
 *
 * Some of the values in this file were chosen to preserve game balance,
 * while others are hard-coded based on the format of old save-files, the
 * definition of arrays in various places, mathematical properties, fast
 * computation, storage limits, or the format of external text files.
 *
 * Changing some of these values will induce crashes or memory errors or
 * savefile mis-reads.  Most of the comments in this file are meant as
 * reminders, not complete descriptions, and even a complete knowledge
 * of the source may not be sufficient to fully understand the effects
 * of changing certain definitions.
 *
 * Lastly, note that the code does not always use the symbolic constants
 * below, and sometimes uses various hard-coded values that may not even
 * be defined in this file, but which may be related to definitions here.
 * This is of course bad programming practice, but nobody is perfect...
 *
 * You have been warned.
 */


/*
 * Current version number of Utumno: 1.0a5
 */
const int VERSION_MAJOR = 1,
          VERSION_MINOR = 0,
          VERSION_PATCH = 5,
          VERSION_TYPE  = 0; // 0 = alpha, 1 = beta, 2 = release
const char VERSION_STRING[] = "v1.0a5";

// Isometric defines
const int ISO_WIDTH  = 64,
          ISO_HEIGHT = 31,
          ISO_ACROSS = 32,
          ISO_DOWN   = 16;


// Maximum dungeon height and width in grids.
const int MAX_HGT = 66;
const int MAX_WID = 198;


// Total number of stores
const int MAX_STORES = 8;

// Total number of owners per store
const int MAX_OWNERS = 4;


// Maximum array bounds for template based arrays
const int MAX_F_IDX = 64;
const int MAX_K_IDX = 512;
const int MAX_A_IDX = 128;
const int MAX_E_IDX = 128;
const int MAX_R_IDX = 544;
const int MAX_V_IDX = 16;
const int MAX_PROJECTILES = 1024;


/*
 * Hack -- Maximum number of quests
 */
const int MAX_Q_IDX = 8;

/*
 * Maximum number of high scores in the high score file
 */
const int MAX_HISCORES = 100;


/*
 * Maximum dungeon level.  The player can never reach this level
 * in the dungeon, and this value is used for various calculations
 * involving object and monster creation.  It must be at least 100.
 * Setting it below 128 may prevent the creation of some objects.
 */
const int MAX_DEPTH = 128;


/*
 * Maximum size of the "lite" array (see "cave.c")
 * Note that the "lite radius" will NEVER exceed 5, and even if the "lite"
 * was rectangular, we would never require more than 81 entries in the array.
 */
const int LITE_MAX = 128;

/*
 * Maximum size of the "view" array (see "cave.c")
 * Note that the "view radius" will NEVER exceed 20, and even if the "view"
 * was octagonal, we would never require more than 1520 entries in the array.
 */
const int VIEW_MAX = 1536;

/*
 * Maximum size of the "temp" array (see "cave.c")
 * We must be as large as "VIEW_MAX" and "LITE_MAX" for proper functioning
 * of "update_view()" and "update_lite()".  We must also be as large as the
 * largest illuminatable room, but no room is larger than 800 grids.  We
 * must also be large enough to allow "good enough" use as a circular queue,
 * to calculate monster flow, but note that the flow code is "paranoid".
 */
const int TEMP_MAX = 1536;


// Maximum value storable in a byte
const byte MAX_UCHAR = 255;

// Maximum value storable in an s16b
const s16b MAX_SHORT = 32767;


// Store constants
const int STORE_INVEN_MAX = 24;      // Max number of discrete objs in inven
const int STORE_CHOICES   = 32;      // Number of items to choose stock from
const int STORE_OBJ_LEVEL = 5;       // Magic Level for normal stores
const int STORE_TURNOVER  = 9;       // Normal shop turnover, per day
const int STORE_MIN_KEEP  = 6;       // Min slots to "always" keep full
const int STORE_MAX_KEEP  = 18;      // Max slots to "always" keep full
const int STORE_SHUFFLE   = 25;      // 1/Chance (per day) of an owner changing
const int STORE_TURNS     = 1000;    // Number of turns between turnovers


// Misc constants
const int TOWN_DAWN       = 10000;   // Number of turns from dawn to dawn XXX
const int BREAK_GLYPH     = 550;     // Rune of protection resistance
const int BTH_PLUS_ADJ    = 3;       // Adjust BTH per plus-to-hit
const int MON_MULT_ADJ    = 8;       // High value slows multiplication
const int MON_SUMMON_ADJ  = 2;       // Adjust level of summoned creatures
const int MON_DRAIN_LIFE  = 2;       // Percent of player exp drained per hit
const int USE_DEVICE      = 3;       // x> Harder devices x< Easier devices

/*
 * There is a 1/20 (5%) chance of inflating the requested object_level
 * during the creation of an object (see "get_obj_num()" in "object.c").
 * Lower values yield better objects more often.
 */
const int GREAT_OBJ = 20;

/*
 * There is a 1/50 (2%) chance of inflating the requested monster_level
 * during the creation of a monsters (see "get_mon_num()" in "monster.c").
 * Lower values yield harder monsters more often.
 */
const int NASTY_MON = 50;       // 1/chance of inflated monster level



/*
 * Refueling constants
 */
const int FUEL_TORCH = 5000;    // Maximum amount of fuel in a torch
const int FUEL_LAMP  = 15000;   // Maximum amount of fuel in a lantern


// More maximum values
const int MAX_SIGHT     = 10;   // Maximum view distance
const int MAX_RANGE     = 9;    // Maximum range (spells, etc)
const int MAX_DETECT    = 15;   // Maximum range of detect spells



// There is a 1/160 chance per round of creating a new monster
const int MAX_M_ALLOC_CHANCE = 160;

// Normal levels get at least 14 monsters
const int MIN_M_ALLOC_LEVEL = 14;

// The town starts out with 4 residents during the day
const int MIN_M_ALLOC_TD = 4;

// The town starts out with 8 residents during the night
const int MIN_M_ALLOC_TN = 8;


/*
 * A monster can only "multiply" (reproduce) if there are fewer than 100
 * monsters on the level capable of such spontaneous reproduction.  This
 * is a hack which prevents the "m_list[]" array from exploding due to
 * reproducing monsters.  Messy, but necessary.
 */
const int MAX_REPRO = 100;


// Player constants
const s32b PY_MAX_EXP     = 99999999L;    // Maximum exp
const s32b PY_MAX_GOLD    = 999999999L;   // Maximum gold
const int  PY_MAX_LEVEL   = 50;           // Maximum level

// Player "food" crucial values
const int PY_FOOD_MAX     = 15000;   // Food value (Bloated)
const int PY_FOOD_FULL    = 10000;   // Food value (Normal)
const int PY_FOOD_ALERT   = 2000;    // Food value (Hungry)
const int PY_FOOD_WEAK    = 1000;    // Food value (Weak)
const int PY_FOOD_FAINT   = 500;     // Food value (Fainting)
const int PY_FOOD_STARVE  = 100;     // Food value (Starving)

// Player regeneration constants
const int PY_REGEN_NORMAL = 197;     // Regen factor*2^16 when full
const int PY_REGEN_WEAK   = 98;      // Regen factor*2^16 when weak
const int PY_REGEN_FAINT  = 33;      // Regen factor*2^16 when fainting
const int PY_REGEN_HPBASE = 1442;    // Min amount hp regen*2^16
const int PY_REGEN_MNBASE = 524;     // Min amount mana regen*2^16


// Skills
const int SKILL_DIS    = 0;
const int SKILL_DEV    = 1;
const int SKILL_SAV    = 2;
const int SKILL_STL    = 3;
const int SKILL_SRH    = 4;
const int SKILL_FOS    = 5;
const int SKILL_THN    = 6;
const int SKILL_THB    = 7;
const int SKILL_THT    = 8;
const int SKILL_DIG    = 9;
const int MAX_SKILL    = 10;

// Immunities
const int IMMUNE_ACID  = 0;
const int IMMUNE_ELEC  = 1;
const int IMMUNE_FIRE  = 2;
const int IMMUNE_COLD  = 3;
const int MAX_IMMUNE   = 4;

// Resistances
const int RESIST_ACID  = 0;
const int RESIST_ELEC  = 1;
const int RESIST_FIRE  = 2;
const int RESIST_COLD  = 3;
const int RESIST_POIS  = 4;
const int RESIST_CONF  = 5;
const int RESIST_SOUND = 6;
const int RESIST_LITE  = 7;
const int RESIST_DARK  = 8;
const int RESIST_CHAOS = 9;
const int RESIST_DISEN = 10;
const int RESIST_SHARD = 11;
const int RESIST_NEXUS = 12;
const int RESIST_BLIND = 13;
const int RESIST_NETH  = 14;
const int RESIST_FEAR  = 15;
const int MAX_RESIST   = 16;



/*
 * Maximum number of "normal" pack slots, and the index of the "overflow"
 * slot, which can hold an item, but only temporarily, since it causes the
 * pack to "overflow", dropping the "last" item onto the ground.  Since this
 * value is used as an actual slot, it must be less than "INVEN_WIELD" (below).
 * Note that "INVEN_PACK" is probably hard-coded by its use in savefiles, and
 * by the fact that the screen can only show 23 items plus a one-line prompt.
 */
const int INVEN_PACK     = 23;

// Indexes used for various "equipment" slots (hard-coded by savefiles, etc).
const int INVEN_WIELD    = 24;
const int INVEN_BOW      = 25;
const int INVEN_ARROW    = 26;
const int INVEN_LEFT     = 27;
const int INVEN_RIGHT    = 28;
const int INVEN_NECK     = 29;
const int INVEN_LITE     = 30;
const int INVEN_BODY     = 31;
const int INVEN_OUTER    = 32;
const int INVEN_ARM      = 33;
const int INVEN_HEAD     = 34;
const int INVEN_HANDS    = 35;
const int INVEN_FEET     = 36;

// Total number of inventory slots (hard-coded).
const int INVEN_TOTAL    = 37;


// A "stack" of items is limited to less than 100 items (hard-coded).
const int MAX_STACK_SIZE = 100;



// Indexes of the various "stats" (hard-coded by savefiles, etc).
const int STAT_STR = 0,
          STAT_INT = 1,
          STAT_WIS = 2,
          STAT_DEX = 3,
          STAT_CON = 4,
          STAT_CHR = 5;

// Player race constants (hard-coded by save-files, arrays, etc)
const int RACE_HUMAN      = 0,
          RACE_HALF_ELF   = 1,
          RACE_ELF        = 2,
          RACE_HOBBIT     = 3,
          RACE_GNOME      = 4,
          RACE_DWARF      = 5,
          RACE_HALF_ORC   = 6,
          RACE_HALF_TROLL = 7,
          RACE_DUNADAN    = 8, 
          RACE_HIGH_ELF   = 9,
          MAX_RACES       = 10;

// Player class constants (hard-coded by save-files, arrays, etc)
const int CLASS_WARRIOR   = 0,
          CLASS_MAGE      = 1,
          CLASS_PRIEST    = 2,
          CLASS_ROGUE     = 3,
          CLASS_RANGER    = 4,
          CLASS_PALADIN   = 5,
          MAX_CLASS       = 6;




/*** Artifact indexes (see "lib/edit/a_info.txt") ***/


// Lites
const int ART_GALADRIEL          = 1,
          ART_ELENDIL            = 2,
          ART_THRAIN             = 3;

// Amulets
const int ART_CARLAMMAS          = 4;
const int ART_INGWE              = 5;
const int ART_DWARVES            = 6;

// Rings
const int ART_BARAHIR            = 8;
const int ART_TULKAS             = 9;
const int ART_NARYA              = 10;
const int ART_NENYA              = 11;
const int ART_VILYA              = 12;
const int ART_POWER              = 13;

// Dragon Scale
const int ART_RAZORBACK          = 16;
const int ART_BLADETURNER        = 17;

	// Hard Armor
const int ART_SOULKEEPER         = 19;
const int ART_ISILDUR            = 20;
const int ART_ROHIRRIM           = 21;
const int ART_BELEGENNON         = 22;
const int ART_CELEBORN           = 23;
const int ART_ARVEDUI            = 24;
const int ART_CASPANION          = 25;

	// Soft Armor
const int ART_HITHLOMIR          = 27;
const int ART_THALKETTOTH        = 28;

	// Shields
const int ART_THORIN             = 30;
const int ART_CELEGORM           = 31;
const int ART_ANARION            = 32;

// Helms and Crowns
const int ART_MORGOTH            = 34;
const int ART_BERUTHIEL          = 35;
const int ART_THRANDUIL          = 36;
const int ART_THENGEL            = 37;
const int ART_HAMMERHAND         = 38;
const int ART_DOR                = 39;
const int ART_HOLHENNETH         = 40;
const int ART_GORLIM             = 41;
const int ART_GONDOR             = 42;

	// Cloaks
const int ART_COLLUIN            = 44;
const int ART_HOLCOLLETH         = 45;
const int ART_THINGOL            = 46;
const int ART_THORONGIL          = 47;
const int ART_COLANNON           = 48;
const int ART_LUTHIEN            = 49;
const int ART_TUOR               = 50;

	// Gloves
const int ART_CAMBELEG           = 52;
const int ART_CAMMITHRIM         = 53;
const int ART_PAURHACH           = 54;
const int ART_PAURNIMMEN         = 55;
const int ART_PAURAEGEN          = 56;
const int ART_PAURNEN            = 57;
const int ART_CAMLOST            = 58;
const int ART_FINGOLFIN          = 59;

	/* Boots */
const int ART_FEANOR             = 60;
const int ART_DAL                = 61;
const int ART_THROR              = 62;

	/* Swords */
const int ART_MAEDHROS           = 64;
const int ART_ANGRIST            = 65;
const int ART_NARTHANC           = 66;
const int ART_NIMTHANC           = 67;
const int ART_DETHANC            = 68;
const int ART_RILIA              = 69;
const int ART_BELANGIL           = 70;
const int ART_CALRIS             = 71;
const int ART_ARANRUTH           = 72;
const int ART_GLAMDRING          = 73;
const int ART_AEGLIN             = 74;
const int ART_ORCRIST            = 75;
const int ART_GURTHANG           = 76;
const int ART_ZARCUTHRA          = 77;
const int ART_MORMEGIL           = 78;
const int ART_GONDRICAM          = 79;
const int ART_CRISDURIAN         = 80;
const int ART_AGLARANG           = 81;
const int ART_RINGIL             = 82;
const int ART_ANDURIL            = 83;
const int ART_ANGUIREL           = 84;
const int ART_ELVAGIL            = 85;
const int ART_FORASGIL           = 86;
const int ART_CARETH             = 87;
const int ART_STING              = 88;
const int ART_HARADEKKET         = 89;
const int ART_GILETTAR           = 90;
const int ART_DOOMCALLER         = 91;

	// Polearms
const int ART_THEODEN            = 93;
const int ART_PAIN               = 94;
const int ART_OSONDIR            = 95;
const int ART_TIL                = 96;
const int ART_AEGLOS             = 97;
const int ART_OROME              = 98;
const int ART_NIMLOTH            = 99;
const int ART_EORLINGAS          = 100;
const int ART_DURIN              = 101;
const int ART_EONWE              = 102;
const int ART_BALLI              = 103;
const int ART_LOTHARANG          = 104;
const int ART_MUNDWINE           = 105;
const int ART_BARUKKHELED        = 106;
const int ART_WRATH              = 107;
const int ART_ULMO               = 108;
const int ART_AVAVIR             = 109;

	// Hafted
const int ART_GROND              = 111;
const int ART_TOTILA             = 112;
const int ART_THUNDERFIST        = 113;
const int ART_BLOODSPIKE         = 114;
const int ART_FIRESTAR           = 115;
const int ART_TARATOL            = 116;
const int ART_AULE               = 117;
const int ART_NAR                = 118;
const int ART_ERIRIL             = 119;
const int ART_OLORIN             = 120;
const int ART_DEATHWREAKER       = 121;
const int ART_TURMIL             = 122;

	// Bows
const int ART_BELTHRONDING       = 124;
const int ART_BARD               = 125;
const int ART_CUBRAGOL           = 126;



/*** Ego-Item indexes (see "lib/edit/e_info.txt") ***/


    /* Nothing */
// xxx
// xxx
// xxx

	/* Body Armor */
const int EGO_RESIST_ACID        = 4;
const int EGO_RESIST_ELEC        = 5;
const int EGO_RESIST_FIRE        = 6;
const int EGO_RESIST_COLD        = 7;
const int EGO_RESISTANCE         = 8;
const int EGO_ELVENKIND          = 9;
// xxx
const int EGO_PERMANENCE         = 11;
// xxx
// xxx
// xxx
// xxx

	// Shields
const int EGO_ENDURE_ACID        = 16;
const int EGO_ENDURE_ELEC        = 17;
const int EGO_ENDURE_FIRE        = 18;
const int EGO_ENDURE_COLD        = 19;
const int EGO_ENDURANCE          = 20;
// xxx
// xxx
// xxx

	// Crowns and Helms
const int EGO_INTELLIGENCE       = 24;
const int EGO_WISDOM             = 25;
const int EGO_BEAUTY             = 26;
const int EGO_MAGI               = 27;
const int EGO_MIGHT              = 28;
const int EGO_LORDLINESS         = 29;
const int EGO_SEEING             = 30;
const int EGO_INFRAVISION        = 31;
const int EGO_LITE               = 32;
const int EGO_TELEPATHY          = 33;
const int EGO_REGENERATION       = 34;
const int EGO_TELEPORTATION      = 35;
const int EGO_STUPIDITY          = 36;
const int EGO_NAIVETY            = 37;
const int EGO_UGLINESS           = 38;
const int EGO_SICKLINESS         = 39;

	// Cloaks
const int EGO_PROTECTION         = 40;
const int EGO_STEALTH            = 41;
const int EGO_AMAN               = 42;
// xxx
const int EGO_ENVELOPING         = 44;
const int EGO_VULNERABILITY      = 45;
const int EGO_IRRITATION         = 46;
// xxx

	// Gloves
const int EGO_FREE_ACTION        = 48;
const int EGO_SLAYING            = 49;
const int EGO_AGILITY            = 50;
const int EGO_POWER              = 51;
// xxx
// xxx
const int EGO_WEAKNESS           = 54;
const int EGO_CLUMSINESS         = 55;

	// Boots
const int EGO_SLOW_DESCENT       = 56;
const int EGO_QUIET              = 57;
const int EGO_MOTION             = 58;
const int EGO_SPEED              = 59;
/* xxx */
const int EGO_NOISE              = 61;
const int EGO_SLOWNESS           = 62;
const int EGO_ANNOYANCE          = 63;

	/* Weapons */
const int EGO_HA                 = 64;
const int EGO_DF                 = 65;
const int EGO_BLESS_BLADE        = 66;
// xxx
const int EGO_WEST               = 68;
const int EGO_ATTACKS            = 69;
// xxx
// xxx
const int EGO_BRAND_ACID         = 72;
const int EGO_BRAND_ELEC         = 73;
const int EGO_BRAND_FIRE         = 74;
const int EGO_BRAND_COLD         = 75;
// xxx
// xxx
// xxx
// xxx
const int EGO_SLAY_ANIMAL        = 80;
const int EGO_SLAY_EVIL          = 81;
const int EGO_SLAY_UNDEAD        = 82;
const int EGO_SLAY_DEMON         = 83;
const int EGO_SLAY_ORC           = 84;
const int EGO_SLAY_TROLL         = 85;
const int EGO_SLAY_GIANT         = 86;
const int EGO_SLAY_DRAGON        = 87;
// xxx
// xxx
// xxx
// xxx
// xxx
// xxx
// xxx
// xxx
// xxx
// xxx
// xxx
// xxx
const int EGO_DIGGING            = 100;
// xxx 
const int EGO_MORGUL             = 102;
// xxx

	/* Bows */
const int EGO_ACCURACY           = 104;
const int EGO_VELOCITY           = 105;
// xxx
// xxx
const int EGO_EXTRA_MIGHT        = 108;
const int EGO_EXTRA_SHOTS        = 109;
// xxx
// xxx

	/* Ammo */
const int EGO_HURT_ANIMAL        = 112;
const int EGO_HURT_EVIL          = 113;
// xxx
// xxx
// xxx
// xxx
// xxx
const int EGO_HURT_DRAGON        = 119;
// xxx 
const int EGO_VENOM              = 121;
const int EGO_FLAME              = 122;
const int EGO_FROST              = 123;
const int EGO_WOUNDING           = 124;
const int EGO_BACKBITING         = 125;
const int EGO_SHATTERED          = 126;
const int EGO_BLASTED            = 127;


/*** Cave Features ***/

const byte CF_NOTHING            = 0x00;
const byte CF_FLOOR              = 0x01;
const byte CF_TRAP_INVIS         = 0x02;
const byte CF_GLYPH              = 0x03;
const byte CF_DOOR_OPEN          = 0x04;
const byte CF_DOOR_BROKEN        = 0x05;
// XXX 0x06
// XXX 0x07
const byte CF_SHOP_GENERAL       = 0x08;
const byte CF_SHOP_ARMORER       = 0x09;
const byte CF_SHOP_WEAPON        = 0x0A;
const byte CF_SHOP_TEMPLE        = 0x0B;
const byte CF_SHOP_ALCHEMIST     = 0x0C;
const byte CF_SHOP_MAGIC         = 0x0D;
const byte CF_SHOP_BLACK         = 0x0E;
const byte CF_SHOP_HOME          = 0x0F;
const byte CF_TRAP_TRAP_DOOR     = 0x10;
const byte CF_TRAP_OPEN_PIT      = 0x11;
const byte CF_TRAP_SPIKED_PIT    = 0x12;
const byte CF_TRAP_POISON_PIT    = 0x13;
const byte CF_TRAP_SUMMON        = 0x14;
const byte CF_TRAP_TELEPORT      = 0x15;
const byte CF_TRAP_FIRE          = 0x16;
const byte CF_TRAP_ACID          = 0x17;
const byte CF_TRAP_DART_SLOW     = 0x18;
const byte CF_TRAP_DART_STR      = 0x19;
const byte CF_TRAP_DART_DEX      = 0x1A;
const byte CF_TRAP_DART_CON      = 0x1B;
const byte CF_TRAP_GAS_BLIND     = 0x1C;
const byte CF_TRAP_GAS_CONFUSE   = 0x1D;
const byte CF_TRAP_GAS_POISON    = 0x1E;
const byte CF_TRAP_GAS_SLEEP     = 0x1F;
const byte CF_DOOR_CLOSED        = 0x20;
const byte CF_DOOR_LOCKED_1      = 0x21;
const byte CF_DOOR_LOCKED_2      = 0x22;
const byte CF_DOOR_LOCKED_3      = 0x23;
const byte CF_DOOR_LOCKED_4      = 0x24;
const byte CF_DOOR_LOCKED_5      = 0x25;
const byte CF_DOOR_LOCKED_6      = 0x26;
const byte CF_DOOR_LOCKED_7      = 0x27;
const byte CF_STAIR_UP_NE        = 0x28;
const byte CF_STAIR_UP_NW        = 0x29;
const byte CF_STAIR_UP_SW        = 0x2A;
const byte CF_STAIR_UP_SE        = 0x2B;
const byte CF_STAIR_DOWN_NE      = 0x2C;
const byte CF_STAIR_DOWN_NW      = 0x2D;
const byte CF_STAIR_DOWN_SW      = 0x2E;
const byte CF_STAIR_DOWN_SE      = 0x2F;
const byte CF_DOOR_SECRET        = 0x30;
const byte CF_RUBBLE             = 0x31;
// XXX 0x32
// XXX 0x33
// XXX 0x34
// XXX 0x35
// XXX 0x36
// XXX 0x37
const byte CF_GRANITE_BASIC      = 0x38;
const byte CF_GRANITE_INNER      = 0x39;
const byte CF_GRANITE_OUTER      = 0x3A;
const byte CF_GRANITE_SOLID      = 0x3B;
const byte CF_PERMANENT_BASIC    = 0x3C;
const byte CF_PERMANENT_INNER    = 0x3D;
const byte CF_PERMANENT_OUTER    = 0x3E;
const byte CF_PERMANENT_SOLID    = 0x3F;


/*** Item "tval" and "sval" codes ***/


/*
 * The values for the "tval" field of various objects.
 *
 * This value is the primary means by which items are sorted in the
 * player inventory, followed by "sval" and "cost".
 *
 * Note that a "BOW" with tval = 19 and sval S = 10*N+P takes a missile
 * weapon with tval = 16+N, and does (xP) damage when so combined.  This
 * fact is not actually used in the source, but it kind of interesting.
 *
 * Note that as of 2.7.8, the "item flags" apply to all items, though
 * only armor and weapons and a few other items use any of these flags.
 */
const int TV_NOTHING     = 0;      // Nothing
const int TV_SKELETON    = 1;      // Skeletons ('s')
const int TV_BOTTLE      = 2;      // Empty bottles ('!')
const int TV_CHEST       = 7;      // Chests ('~')
const int TV_SHOT        = 16;     // Ammo for slings
const int TV_ARROW       = 17;     // Ammo for bows
const int TV_BOLT        = 18;     // Ammo for x-bows
const int TV_BOW         = 19;     // Slings/Bows/Xbows
const int TV_DIGGING     = 20;     // Shovels/Picks
const int TV_HAFTED      = 21;     // Priest Weapons
const int TV_POLEARM     = 22;     // Axes and Pikes
const int TV_SWORD       = 23;     // Edged Weapons
const int TV_BOOTS       = 30;     // Boots
const int TV_GLOVES      = 31;     // Gloves
const int TV_HELM        = 32;     // Helms
const int TV_CROWN       = 33;     // Crowns
const int TV_SHIELD      = 34;     // Shields
const int TV_CLOAK       = 35;     // Cloaks
const int TV_SOFT_ARMOR  = 36;     // Soft Armor
const int TV_HARD_ARMOR  = 37;     // Hard Armor
const int TV_DRAG_ARMOR  = 38;     // Dragon Scale Mail
const int TV_LITE        = 39;     // Lites (including Specials)
const int TV_AMULET      = 40;     // Amulets (including Specials)
const int TV_RING        = 45;     // Rings (including Specials)
const int TV_STAFF       = 55;
const int TV_WAND        = 65;
const int TV_ROD         = 66;
const int TV_SCROLL      = 70;
const int TV_POTION      = 75;
const int TV_FLASK       = 77;
const int TV_FOOD        = 80;
const int TV_MAGIC_BOOK  = 90;
const int TV_PRAYER_BOOK = 91;
const int TV_GOLD        = 100;    // Gold can only be picked up by players


// The "sval" codes for TV_SHOT/TV_ARROW/TV_BOLT
const int SV_AMMO_LIGHT          = 0;       // pebbles
const int SV_AMMO_NORMAL         = 1;       // shots, arrows, bolts
const int SV_AMMO_HEAVY          = 2;       // seeker arrows and bolts

// The "sval" codes for TV_BOW (note information in "sval")
const int SV_SLING               = 2;       // (x2)
const int SV_SHORT_BOW           = 12;      // (x2)
const int SV_LONG_BOW            = 13;      // (x3)
const int SV_LIGHT_XBOW          = 23;      // (x3)
const int SV_HEAVY_XBOW          = 24;      // (x4)

// The "sval" codes for TV_DIGGING
const int SV_SHOVEL              = 1;
const int SV_GNOMISH_SHOVEL      = 2;
const int SV_DWARVEN_SHOVEL      = 3;
const int SV_PICK                = 4;
const int SV_ORCISH_PICK         = 5;
const int SV_DWARVEN_PICK        = 6;

// The sval values for TV_HAFTED
const int SV_WHIP                = 2;       // 1d6
const int SV_QUARTERSTAFF        = 3;       // 1d9
const int SV_MACE                = 5;       // 2d4
const int SV_BALL_AND_CHAIN      = 6;       // 2d4
const int SV_WAR_HAMMER          = 8;       // 3d3
const int SV_LUCERN_HAMMER       = 10;      // 2d5
const int SV_MORNING_STAR        = 12;      // 2d6
const int SV_FLAIL               = 13;      // 2d6
const int SV_LEAD_FILLED_MACE    = 15;      // 3d4
const int SV_TWO_HANDED_FLAIL    = 18;      // 3d6
const int SV_MACE_OF_DISRUPTION  = 20;      // 5d8
const int SV_GROND               = 50;      // 3d4

// The sval values for TV_POLEARM
const int SV_SPEAR               = 2;       // 1d6
const int SV_AWL_PIKE            = 4;       // 1d8
const int SV_TRIDENT             = 5;       // 1d9
const int SV_PIKE                = 8;       // 2d5
const int SV_BEAKED_AXE          = 10;      // 2d6
const int SV_BROAD_AXE           = 11;      // 2d6
const int SV_GLAIVE              = 13;      // 2d6
const int SV_HALBERD             = 15;      // 3d4
const int SV_SCYTHE              = 17;      // 5d3
const int SV_LANCE               = 20;      // 2d8
const int SV_BATTLE_AXE          = 22;      // 2d8
const int SV_GREAT_AXE           = 25;      // 4d4
const int SV_LOCHABER_AXE        = 28;      // 3d8
const int SV_SCYTHE_OF_SLICING   = 30;      // 8d4

// The sval codes for TV_SWORD
const int SV_BROKEN_DAGGER       = 1;       // 1d1
const int SV_BROKEN_SWORD        = 2;       // 1d2
const int SV_DAGGER              = 4;       // 1d4
const int SV_MAIN_GAUCHE         = 5;       // 1d5
const int SV_RAPIER              = 7;       // 1d6
const int SV_SMALL_SWORD         = 8;       // 1d6
const int SV_SHORT_SWORD         = 10;      // 1d7
const int SV_SABRE               = 11;      // 1d7
const int SV_CUTLASS             = 12;      // 1d7
const int SV_TULWAR              = 15;      // 2d4
const int SV_BROAD_SWORD         = 16;      // 2d5
const int SV_LONG_SWORD          = 17;      // 2d5
const int SV_SCIMITAR            = 18;      // 2d5
const int SV_KATANA              = 20;      // 3d4
const int SV_BASTARD_SWORD       = 21;      // 3d4
const int SV_TWO_HANDED_SWORD    = 25;      // 3d6
const int SV_EXECUTIONERS_SWORD  = 28;      // 4d5
const int SV_BLADE_OF_CHAOS      = 30;      // 6d5

// The "sval" codes for TV_SHIELD
const int SV_SMALL_LEATHER_SHIELD        = 2;
const int SV_SMALL_METAL_SHIELD          = 3;
const int SV_LARGE_LEATHER_SHIELD        = 4;
const int SV_LARGE_METAL_SHIELD          = 5;
const int SV_SHIELD_OF_DEFLECTION        = 10;

// The "sval" codes for TV_HELM
const int SV_HARD_LEATHER_CAP            = 2;
const int SV_METAL_CAP                   = 3;
const int SV_IRON_HELM                   = 5;
const int SV_STEEL_HELM                  = 6;
const int SV_DRAGON_HELM                 = 8;
const int SV_IRON_CROWN                  = 10;
const int SV_GOLDEN_CROWN                = 11;
const int SV_JEWELED_CROWN               = 12;
const int SV_MORGOTH                     = 50;

/* The "sval" codes for TV_BOOTS */
const int SV_PAIR_OF_SOFT_LEATHER_BOOTS  = 2;
const int SV_PAIR_OF_HARD_LEATHER_BOOTS  = 3;
const int SV_PAIR_OF_METAL_SHOD_BOOTS    = 6;

// The "sval" codes for TV_CLOAK
const int SV_CLOAK                       = 1;
const int SV_ELVEN_CLOAK                 = 6;

/* The "sval" codes for TV_GLOVES */
const int SV_SET_OF_LEATHER_GLOVES       = 1;
const int SV_SET_OF_GAUNTLETS            = 2;
const int SV_SET_OF_CESTI                = 5;

/* The "sval" codes for TV_SOFT_ARMOR */
const int SV_FILTHY_RAG                  = 1;
const int SV_ROBE                        = 2;
const int SV_SOFT_LEATHER_ARMOR          = 4;
const int SV_SOFT_STUDDED_LEATHER        = 5;
const int SV_HARD_LEATHER_ARMOR          = 6;
const int SV_HARD_STUDDED_LEATHER        = 7;
const int SV_LEATHER_SCALE_MAIL          = 11;

/* The "sval" codes for TV_HARD_ARMOR */
const int SV_RUSTY_CHAIN_MAIL            = 1;       // 14-
const int SV_METAL_SCALE_MAIL            = 3;       // 13
const int SV_CHAIN_MAIL                  = 4;       // 14
const int SV_AUGMENTED_CHAIN_MAIL        = 6;       // 16
const int SV_DOUBLE_CHAIN_MAIL           = 7;       // 16
const int SV_BAR_CHAIN_MAIL              = 8;       // 18
const int SV_METAL_BRIGANDINE_ARMOR      = 9;       // 19
const int SV_PARTIAL_PLATE_ARMOR         = 12;      // 22
const int SV_METAL_LAMELLAR_ARMOR        = 13;      // 23
const int SV_FULL_PLATE_ARMOR            = 15;      // 25
const int SV_RIBBED_PLATE_ARMOR          = 18;      // 28
const int SV_MITHRIL_CHAIN_MAIL          = 20;      // 28+
const int SV_MITHRIL_PLATE_MAIL          = 25;      // 35+
const int SV_ADAMANTITE_PLATE_MAIL       = 30;      // 40+

// The "sval" codes for TV_DRAG_ARMOR
const int SV_DRAGON_BLACK                = 1;
const int SV_DRAGON_BLUE                 = 2;
const int SV_DRAGON_WHITE                = 3;
const int SV_DRAGON_RED                  = 4;
const int SV_DRAGON_GREEN                = 5;
const int SV_DRAGON_MULTIHUED            = 6;
const int SV_DRAGON_SHINING              = 10;
const int SV_DRAGON_LAW                  = 12;
const int SV_DRAGON_BRONZE               = 14;
const int SV_DRAGON_GOLD                 = 16;
const int SV_DRAGON_CHAOS                = 18;
const int SV_DRAGON_BALANCE              = 20;
const int SV_DRAGON_POWER                = 30;

/* The sval codes for TV_LITE */
const int SV_LITE_TORCH          = 0;
const int SV_LITE_LANTERN        = 1;
const int SV_LITE_GALADRIEL      = 4;
const int SV_LITE_ELENDIL        = 5;
const int SV_LITE_THRAIN         = 6;

/* The "sval" codes for TV_AMULET */
const int SV_AMULET_DOOM         = 0;
const int SV_AMULET_TELEPORT     = 1;
const int SV_AMULET_ADORNMENT    = 2;
const int SV_AMULET_SLOW_DIGEST  = 3;
const int SV_AMULET_RESIST_ACID  = 4;
const int SV_AMULET_SEARCHING    = 5;
const int SV_AMULET_WISDOM       = 6;
const int SV_AMULET_CHARISMA     = 7;
const int SV_AMULET_THE_MAGI     = 8;
// xxx
const int SV_AMULET_CARLAMMAS    = 10;
const int SV_AMULET_INGWE        = 11;
const int SV_AMULET_DWARVES      = 12;

// The sval codes for TV_RING
const int SV_RING_WOE            = 0;
const int SV_RING_AGGRAVATION    = 1;
const int SV_RING_SUSTAINING     = 2;
// xxx
const int SV_RING_TELEPORTATION  = 4;
const int SV_RING_TELEPATHY      = 5;
const int SV_RING_SLOW_DIGESTION = 6;
const int SV_RING_FEATHER_FALL   = 7;
const int SV_RING_RESIST_FIRE    = 8;
const int SV_RING_RESIST_COLD    = 9;
const int SV_RING_SUSTAIN_STR    = 10;
const int SV_RING_SUSTAIN_INT    = 11;
const int SV_RING_SUSTAIN_WIS    = 12;
const int SV_RING_SUSTAIN_DEX    = 13;
const int SV_RING_SUSTAIN_CON    = 14;
const int SV_RING_SUSTAIN_CHR    = 15;
const int SV_RING_PROTECTION     = 16;
const int SV_RING_ACID           = 17;
const int SV_RING_FLAMES         = 18;
const int SV_RING_ICE            = 19;
const int SV_RING_RESIST_POIS    = 20;
const int SV_RING_FREE_ACTION    = 21;
const int SV_RING_SEE_INVIS      = 22;
const int SV_RING_SEARCHING      = 23;
const int SV_RING_STR            = 24;
const int SV_RING_INT            = 25;
const int SV_RING_DEX            = 26;
const int SV_RING_CON            = 27;
const int SV_RING_ACCURACY       = 28;
const int SV_RING_DAMAGE         = 29;
const int SV_RING_SLAYING        = 30;
const int SV_RING_SPEED          = 31;
const int SV_RING_BARAHIR        = 32;
const int SV_RING_TULKAS         = 33;
const int SV_RING_NARYA          = 34;
const int SV_RING_NENYA          = 35;
const int SV_RING_VILYA          = 36;
const int SV_RING_POWER          = 37;




// The "sval" codes for TV_STAFF
const int SV_STAFF_DARKNESS       = 0;
const int SV_STAFF_SLOWNESS       = 1;
const int SV_STAFF_HASTE_MONSTERS = 2;
const int SV_STAFF_SUMMONING      = 3;
const int SV_STAFF_TELEPORTATION  = 4;
const int SV_STAFF_IDENTIFY       = 5;
const int SV_STAFF_REMOVE_CURSE   = 6;
const int SV_STAFF_STARLITE       = 7;
const int SV_STAFF_LITE           = 8;
const int SV_STAFF_MAPPING        = 9;
const int SV_STAFF_DETECT_GOLD    = 10;
const int SV_STAFF_DETECT_ITEM    = 11;
const int SV_STAFF_DETECT_TRAP    = 12;
const int SV_STAFF_DETECT_DOOR    = 13;
const int SV_STAFF_DETECT_INVIS   = 14;
const int SV_STAFF_DETECT_EVIL    = 15;
const int SV_STAFF_CURE_LIGHT     = 16;
const int SV_STAFF_CURING         = 17;
const int SV_STAFF_HEALING        = 18;
const int SV_STAFF_THE_MAGI       = 19;
const int SV_STAFF_SLEEP_MONSTERS = 20;
const int SV_STAFF_SLOW_MONSTERS  = 21;
const int SV_STAFF_SPEED          = 22;
const int SV_STAFF_PROBING        = 23;
const int SV_STAFF_DISPEL_EVIL    = 24;
const int SV_STAFF_POWER          = 25;
const int SV_STAFF_HOLINESS       = 26;
const int SV_STAFF_GENOCIDE       = 27;
const int SV_STAFF_EARTHQUAKES    = 28;
const int SV_STAFF_DESTRUCTION    = 29;


// The "sval" codes for TV_WAND
const int SV_WAND_HEAL_MONSTER    = 0;
const int SV_WAND_HASTE_MONSTER   = 1;
const int SV_WAND_CLONE_MONSTER   = 2;
const int SV_WAND_TELEPORT_AWAY   = 3;
const int SV_WAND_DISARMING       = 4;
const int SV_WAND_TRAP_DOOR_DEST  = 5;
const int SV_WAND_STONE_TO_MUD    = 6;
const int SV_WAND_LITE            = 7;
const int SV_WAND_SLEEP_MONSTER   = 8;
const int SV_WAND_SLOW_MONSTER    = 9;
const int SV_WAND_CONFUSE_MONSTER = 10;
const int SV_WAND_FEAR_MONSTER    = 11;
const int SV_WAND_DRAIN_LIFE      = 12;
const int SV_WAND_POLYMORPH       = 13;
const int SV_WAND_STINKING_CLOUD  = 14;
const int SV_WAND_MAGIC_MISSILE   = 15;
const int SV_WAND_ACID_BOLT       = 16;
const int SV_WAND_ELEC_BOLT       = 17;
const int SV_WAND_FIRE_BOLT       = 18;
const int SV_WAND_COLD_BOLT       = 19;
const int SV_WAND_ACID_BALL       = 20;
const int SV_WAND_ELEC_BALL       = 21;
const int SV_WAND_FIRE_BALL       = 22;
const int SV_WAND_COLD_BALL       = 23;
const int SV_WAND_WONDER          = 24;
const int SV_WAND_ANNIHILATION    = 25;
const int SV_WAND_DRAGON_FIRE     = 26;
const int SV_WAND_DRAGON_COLD     = 27;
const int SV_WAND_DRAGON_BREATH   = 28;

/* The "sval" codes for TV_ROD */
const int SV_ROD_DETECT_TRAP      = 0;
const int SV_ROD_DETECT_DOOR      = 1;
const int SV_ROD_IDENTIFY         = 2;
const int SV_ROD_RECALL           = 3;
const int SV_ROD_ILLUMINATION     = 4;
const int SV_ROD_MAPPING          = 5;
const int SV_ROD_DETECTION        = 6;
const int SV_ROD_PROBING          = 7;
const int SV_ROD_CURING           = 8;
const int SV_ROD_HEALING          = 9;
const int SV_ROD_RESTORATION      = 10;
const int SV_ROD_SPEED            = 11;
// xxx (aimed)
const int SV_ROD_TELEPORT_AWAY    = 13;
const int SV_ROD_DISARMING        = 14;
const int SV_ROD_LITE             = 15;
const int SV_ROD_SLEEP_MONSTER    = 16;
const int SV_ROD_SLOW_MONSTER     = 17;
const int SV_ROD_DRAIN_LIFE       = 18;
const int SV_ROD_POLYMORPH        = 19;
const int SV_ROD_ACID_BOLT        = 20;
const int SV_ROD_ELEC_BOLT        = 21;
const int SV_ROD_FIRE_BOLT        = 22;
const int SV_ROD_COLD_BOLT        = 23;
const int SV_ROD_ACID_BALL        = 24;
const int SV_ROD_ELEC_BALL        = 25;
const int SV_ROD_FIRE_BALL        = 26;
const int SV_ROD_COLD_BALL        = 27;


/* The "sval" codes for TV_SCROLL */

const int SV_SCROLL_DARKNESS              = 0;
const int SV_SCROLL_AGGRAVATE_MONSTER     = 1;
const int SV_SCROLL_CURSE_ARMOR           = 2;
const int SV_SCROLL_CURSE_WEAPON          = 3;
const int SV_SCROLL_SUMMON_MONSTER        = 4;
const int SV_SCROLL_SUMMON_UNDEAD         = 5;
/* xxx (summon?) */
const int SV_SCROLL_TRAP_CREATION         = 7;
const int SV_SCROLL_PHASE_DOOR            = 8;
const int SV_SCROLL_TELEPORT              = 9;
const int SV_SCROLL_TELEPORT_LEVEL        = 10;
const int SV_SCROLL_WORD_OF_RECALL        = 11;
const int SV_SCROLL_IDENTIFY              = 12;
const int SV_SCROLL_STAR_IDENTIFY         = 13;
const int SV_SCROLL_REMOVE_CURSE          = 14;
const int SV_SCROLL_STAR_REMOVE_CURSE     = 15;
const int SV_SCROLL_ENCHANT_ARMOR         = 16;
const int SV_SCROLL_ENCHANT_WEAPON_TO_HIT = 17;
const int SV_SCROLL_ENCHANT_WEAPON_TO_DAM = 18;
/* xxx enchant missile? */
const int SV_SCROLL_STAR_ENCHANT_ARMOR    = 20;
const int SV_SCROLL_STAR_ENCHANT_WEAPON   = 21;
const int SV_SCROLL_RECHARGING            = 22;
// xxx
const int SV_SCROLL_LIGHT                 = 24;
const int SV_SCROLL_MAPPING               = 25;
const int SV_SCROLL_DETECT_GOLD           = 26;
const int SV_SCROLL_DETECT_ITEM           = 27;
const int SV_SCROLL_DETECT_TRAP           = 28;
const int SV_SCROLL_DETECT_DOOR           = 29;
const int SV_SCROLL_DETECT_INVIS          = 30;
/* xxx (detect evil?) */
const int SV_SCROLL_SATISFY_HUNGER        = 32;
const int SV_SCROLL_BLESSING              = 33;
const int SV_SCROLL_HOLY_CHANT            = 34;
const int SV_SCROLL_HOLY_PRAYER           = 35;
const int SV_SCROLL_MONSTER_CONFUSION     = 36;
const int SV_SCROLL_PROTECTION_FROM_EVIL  = 37;
const int SV_SCROLL_RUNE_OF_PROTECTION    = 38;
const int SV_SCROLL_TRAP_DOOR_DESTRUCTION = 39;
/* xxx */
const int SV_SCROLL_STAR_DESTRUCTION      = 41;
const int SV_SCROLL_DISPEL_UNDEAD         = 42;
/* xxx */
const int SV_SCROLL_GENOCIDE              = 44;
const int SV_SCROLL_MASS_GENOCIDE         = 45;
const int SV_SCROLL_ACQUIREMENT           = 46;
const int SV_SCROLL_STAR_ACQUIREMENT      = 47;

// The "sval" codes for TV_POTION
const int SV_POTION_WATER                 = 0;
const int SV_POTION_APPLE_JUICE           = 1;
const int SV_POTION_SLIME_MOLD            = 2;
/* xxx (fixed color) */
const int SV_POTION_SLOWNESS              = 4;
const int SV_POTION_SALT_WATER            = 5;
const int SV_POTION_POISON                = 6;
const int SV_POTION_BLINDNESS             = 7;
/* xxx */
const int SV_POTION_CONFUSION             = 9;
/* xxx */
const int SV_POTION_SLEEP                 = 11;
/* xxx */
const int SV_POTION_LOSE_MEMORIES         = 13;
/* xxx */
const int SV_POTION_RUINATION             = 15;
const int SV_POTION_DEC_STR               = 16;
const int SV_POTION_DEC_INT               = 17;
const int SV_POTION_DEC_WIS               = 18;
const int SV_POTION_DEC_DEX               = 19;
const int SV_POTION_DEC_CON               = 20;
const int SV_POTION_DEC_CHR               = 21;
const int SV_POTION_DETONATIONS           = 22;
const int SV_POTION_DEATH                 = 23;
const int SV_POTION_INFRAVISION           = 24;
const int SV_POTION_DETECT_INVIS          = 25;
const int SV_POTION_SLOW_POISON           = 26;
const int SV_POTION_CURE_POISON           = 27;
const int SV_POTION_BOLDNESS              = 28;
const int SV_POTION_SPEED                 = 29;
const int SV_POTION_RESIST_HEAT           = 30;
const int SV_POTION_RESIST_COLD           = 31;
const int SV_POTION_HEROISM               = 32;
const int SV_POTION_BESERK_STRENGTH       = 33;
const int SV_POTION_CURE_LIGHT            = 34;
const int SV_POTION_CURE_SERIOUS          = 35;
const int SV_POTION_CURE_CRITICAL         = 36;
const int SV_POTION_HEALING               = 37;
const int SV_POTION_STAR_HEALING          = 38;
const int SV_POTION_LIFE                  = 39;
const int SV_POTION_RESTORE_MANA          = 40;
const int SV_POTION_RESTORE_EXP           = 41;
const int SV_POTION_RES_STR               = 42;
const int SV_POTION_RES_INT               = 43;
const int SV_POTION_RES_WIS               = 44;
const int SV_POTION_RES_DEX               = 45;
const int SV_POTION_RES_CON               = 46;
const int SV_POTION_RES_CHR               = 47;
const int SV_POTION_INC_STR               = 48;
const int SV_POTION_INC_INT               = 49;
const int SV_POTION_INC_WIS               = 50;
const int SV_POTION_INC_DEX               = 51;
const int SV_POTION_INC_CON               = 52;
const int SV_POTION_INC_CHR               = 53;
/* xxx */
const int SV_POTION_AUGMENTATION          = 55;
const int SV_POTION_ENLIGHTENMENT         = 56;
const int SV_POTION_STAR_ENLIGHTENMENT    = 57;
const int SV_POTION_SELF_KNOWLEDGE        = 58;
const int SV_POTION_EXPERIENCE            = 59;

// The "sval" codes for TV_FOOD
const int SV_FOOD_POISON         = 0;
const int SV_FOOD_BLINDNESS      = 1;
const int SV_FOOD_PARANOIA       = 2;
const int SV_FOOD_CONFUSION      = 3;
// xxx
const int SV_FOOD_PARALYSIS      = 5;
const int SV_FOOD_WEAKNESS       = 6;
const int SV_FOOD_SICKNESS       = 7;
const int SV_FOOD_STUPIDITY      = 8;
const int SV_FOOD_NAIVETY        = 9;
const int SV_FOOD_UNHEALTH       = 10;
const int SV_FOOD_DISEASE        = 11;
const int SV_FOOD_CURE_POISON    = 12;
const int SV_FOOD_CURE_BLINDNESS = 13;
const int SV_FOOD_CURE_PARANOIA  = 14;
const int SV_FOOD_CURE_CONFUSION = 15;
const int SV_FOOD_CURE_SERIOUS   = 16;
const int SV_FOOD_RESTORE_STR    = 17;
const int SV_FOOD_RESTORE_CON    = 18;
const int SV_FOOD_RESTORING      = 19;
// many missing mushrooms
const int SV_FOOD_BISCUIT        = 32;
const int SV_FOOD_JERKY          = 33;
const int SV_FOOD_RATION         = 35;
const int SV_FOOD_SLIME_MOLD     = 36;
const int SV_FOOD_WAYBREAD       = 37;
const int SV_FOOD_PINT_OF_ALE    = 38;
const int SV_FOOD_PINT_OF_WINE   = 39;


// Special sval limits
const int SV_FOOD_MIN_FOOD     = 32,   // First "normal" food
          SV_ROD_MIN_DIRECTION = 12,   // First "aimed" rod
          SV_CHEST_MIN_LARGE   = 4,    // First "large" chest
          SV_BOOK_MIN_GOOD     = 4;    // First "good" magic/prayer book



/*** General flag values ***/


// Special grid flags
const byte MAP_KNOW = 0x01; // memorized feature
const byte MAP_GLOW = 0x02; // self-illuminating
const byte MAP_ICKY = 0x04; // part of a vault
const byte MAP_ROOM = 0x08; // part of a room
const byte MAP_LITE = 0x10; // lite flag
const byte MAP_VIEW = 0x20; // view flag
const byte MAP_TEMP = 0x40; // temp flag
const byte MAP_XTRA = 0x80; // misc flag



/*
 * Bit flags for the "project()" function
 */
const byte PROJECT_JUMP = 0x01; // Hack -- jump directly to the target location
const byte PROJECT_BEAM = 0x02; // Work as a beam weapon (affect every grid passed through)
const byte PROJECT_THRU = 0x04; // Continue "through" the target (used for "bolts"/"beams")
const byte PROJECT_STOP = 0x08; // Stop as soon as we hit a monster (used for "bolts")
const byte PROJECT_GRID = 0x10; // Affect each grid in the "blast area" in some way
const byte PROJECT_ITEM = 0x20; // Affect each object in the "blast area" in some way
const byte PROJECT_KILL = 0x40; // Affect each monster in the "blast area" in some way
const byte PROJECT_HIDE = 0x80; // Hack -- disable "visual" feedback from projection

/*
 * Bit flags for the "enchant()" function
 */
const byte ENCH_TOHIT  = 0x01;
const byte ENCH_TODAM  = 0x02;
const byte ENCH_TOAC   = 0x04;


// Bit flags for the p_ptr->notice variable
const u32b PN_COMBINE   = 0x00000001L;  // Combine the pack
const u32b PN_REORDER   = 0x00000002L;  // Reorder the pack


// Bit flags for the p_ptr->update variable
const u32b PU_BONUS     = 0x00000001L;  // Calculate bonuses
const u32b PU_TORCH     = 0x00000002L;  // Calculate torch radius
const u32b PU_HP        = 0x00000010L;  // Calculate chp and mhp
const u32b PU_MANA      = 0x00000020L;  // Calculate csp and msp
const u32b PU_SPELLS    = 0x00000040L;  // Calculate spells
const u32b PU_UN_VIEW   = 0x00010000L;  // Forget view
const u32b PU_UN_LITE   = 0x00020000L;  // Forget lite
const u32b PU_VIEW      = 0x00100000L;  // Update view
const u32b PU_LITE      = 0x00200000L;  // Update lite
const u32b PU_MONSTERS  = 0x01000000L;  // Update monsters
const u32b PU_DISTANCE  = 0x02000000L;  // Update distances
const u32b PU_FLOW      = 0x10000000L;  // Update flow


/*** General index values ***/


/*
 * Legal restrictions for "summon_specific()"
 */
const int SUMMON_ANT             = 11;
const int SUMMON_SPIDER          = 12;
const int SUMMON_HOUND           = 13;
const int SUMMON_HYDRA           = 14;
const int SUMMON_ANGEL           = 15;
const int SUMMON_DEMON           = 16;
const int SUMMON_UNDEAD          = 17;
const int SUMMON_DRAGON          = 18;
const int SUMMON_HI_UNDEAD       = 21;
const int SUMMON_HI_DRAGON       = 22;
const int SUMMON_WRAITH          = 31;
const int SUMMON_UNIQUE          = 32;


/*
 * Spell types used by project(), and related functions.
 */
const int GF_ELEC        = 1;
const int GF_POIS        = 2;
const int GF_ACID        = 3;
const int GF_COLD        = 4;
const int GF_FIRE        = 5;
const int GF_MISSILE     = 10;
const int GF_ARROW       = 11;
const int GF_PLASMA      = 12;
const int GF_HOLY_ORB    = 13;
const int GF_WATER       = 14;
const int GF_LITE        = 15;
const int GF_DARK        = 16;
const int GF_LITE_WEAK   = 17;
const int GF_DARK_WEAK   = 18;
const int GF_SHARDS      = 20;
const int GF_SOUND       = 21;
const int GF_CONFUSION   = 22;
const int GF_FORCE       = 23;
const int GF_INERTIA     = 24;
const int GF_MANA        = 26;
const int GF_METEOR      = 27;
const int GF_ICE         = 28;
const int GF_CHAOS       = 30;
const int GF_NETHER      = 31;
const int GF_DISENCHANT  = 32;
const int GF_NEXUS       = 33;
const int GF_TIME        = 34;
const int GF_GRAVITY     = 35;
const int GF_KILL_WALL   = 40;
const int GF_KILL_DOOR   = 41;
const int GF_KILL_TRAP   = 42;
const int GF_MAKE_WALL   = 45;
const int GF_MAKE_DOOR   = 46;
const int GF_MAKE_TRAP   = 47;
const int GF_OLD_CLONE   = 51;
const int GF_OLD_POLY    = 52;
const int GF_OLD_HEAL    = 53;
const int GF_OLD_SPEED   = 54;
const int GF_OLD_SLOW    = 55;
const int GF_OLD_CONF    = 56;
const int GF_OLD_SLEEP   = 57;
const int GF_OLD_DRAIN   = 58;
const int GF_AWAY_UNDEAD = 61;
const int GF_AWAY_EVIL   = 62;
const int GF_AWAY_ALL    = 63;
const int GF_TURN_UNDEAD = 64;
const int GF_TURN_EVIL   = 65;
const int GF_TURN_ALL    = 66;
const int GF_DISP_UNDEAD = 67;
const int GF_DISP_EVIL   = 68;
const int GF_DISP_ALL    = 69;


/*
 * Hack -- first "normal" artifact in the artifact list.  All of
 * the artifacts with indexes from 1 to 15 are "special" (lights,
 * rings, amulets), and the ones from 16 to 127 are "normal".
 */
const int ART_MIN_NORMAL = 16;


/*
 * Hack -- special "xtra" object powers
 */
const int EGO_XTRA_SUSTAIN   = 1; // Sustain one stat
const int EGO_XTRA_POWER     = 2; // High resist
const int EGO_XTRA_ABILITY   = 3; // Special ability





/*** Item flag values ***/


/*
 * Chest trap flags (see "tables.c")
 */
const byte CHEST_LOSE_STR  = 0x01;
const byte CHEST_LOSE_CON  = 0x02;
const byte CHEST_POISON    = 0x04;
const byte CHEST_PARALYZE  = 0x08;
const byte CHEST_EXPLODE   = 0x10;
const byte CHEST_SUMMON    = 0x20;



/*
 * Special "Item Flags"
 */
const byte ID_SENSE   = 0x01;   // Item has been "sensed" 
const byte ID_FIXED   = 0x02;   // Item has been "haggled"
const byte ID_EMPTY   = 0x04;   // Item charges are known
const byte ID_KNOWN   = 0x08;   // Item abilities are known
const byte ID_RUMOUR  = 0x10;   // Item background is known
const byte ID_MENTAL  = 0x20;   // Item information is known
const byte ID_CURSED  = 0x40;   // Item is temporarily cursed
const byte ID_BROKEN  = 0x80;   // Item is permanently worthless



/*
 * Note that "flags1" contains all flags dependant on "pval" (including
 * stat bonuses, but NOT stat sustainers), plus all "extra attack damage"
 * flags (SLAY_XXX and BRAND_XXX).
 *
 * Note that "flags2" contains all "resistances" (including "Stat Sustainers",
 * actual immunities, and resistances).  Note that "Hold Life" is really an
 * "immunity" to ExpLoss, and "Free Action" is "immunity to paralysis".
 *
 * Note that "flags3" contains everything else -- including the three "CURSED"
 * flags, and the "BLESSED" flag, several "item display" parameters, some new
 * flags for powerful Bows, and flags which affect the player in a "general"
 * way (LITE, TELEPATHY, SEE_INVIS, SLOW_DIGEST, REGEN, FEATHER), including
 * all the "general" curses (TELEPORT, AGGRAVATE, EXP_DRAIN).  It also has
 * four new flags called "ITEM_IGNORE_XXX" which lets an item specify that
 * it can not be affected by various forms of destruction.  This is NOT as
 * powerful as actually granting resistance/immunity to the wearer.
 */

const u32b TR1_STR            = 0x00000001L;    // STR += pval
const u32b TR1_INT            = 0x00000002L;    // INT += pval
const u32b TR1_WIS            = 0x00000004L;    // WIS += pval
const u32b TR1_DEX            = 0x00000008L;    // DEX += pval
const u32b TR1_CON            = 0x00000010L;    // CON += pval
const u32b TR1_CHR            = 0x00000020L;    // CHR += pval
const u32b TR1_XXX1           = 0x00000040L;
const u32b TR1_XXX2           = 0x00000080L;
const u32b TR1_STEALTH        = 0x00000100L;    // Stealth += pval
const u32b TR1_SEARCH         = 0x00000200L;    // Search += pval
const u32b TR1_INFRA          = 0x00000400L;    // Infra += pval
const u32b TR1_TUNNEL         = 0x00000800L;    // Tunnel += pval
const u32b TR1_SPEED          = 0x00001000L;    // Speed += pval
const u32b TR1_BLOWS          = 0x00002000L;    // Blows += pval
const u32b TR1_XXX3           = 0x00004000L;
const u32b TR1_XXX4           = 0x00008000L;
const u32b TR1_SLAY_ANIMAL    = 0x00010000L;    // Slay animal
const u32b TR1_SLAY_EVIL      = 0x00020000L;    // Slay evil
const u32b TR1_SLAY_UNDEAD    = 0x00040000L;    // Slay undead
const u32b TR1_SLAY_DEMON     = 0x00080000L;    // Slay demon
const u32b TR1_SLAY_ORC       = 0x00100000L;    // Slay orc
const u32b TR1_SLAY_TROLL     = 0x00200000L;    // Slay troll
const u32b TR1_SLAY_GIANT     = 0x00400000L;    // Slay giant
const u32b TR1_SLAY_DRAGON    = 0x00800000L;    // Slay dragon
const u32b TR1_KILL_DRAGON    = 0x01000000L;    // Execute dragon
const u32b TR1_XXX5           = 0x02000000L;      
const u32b TR1_IMPACT         = 0x04000000L;    // Cause Earthquakes
const u32b TR1_BRAND_POIS     = 0x08000000L;    // Poison brand
const u32b TR1_BRAND_ACID     = 0x10000000L;    // Acid brand
const u32b TR1_BRAND_ELEC     = 0x20000000L;    // Lightning brand
const u32b TR1_BRAND_FIRE     = 0x40000000L;    // Fire brand
const u32b TR1_BRAND_COLD     = 0x80000000L;    // Cold brand

const u32b TR2_SUST_STR       = 0x00000001L;    // Sustain STR
const u32b TR2_SUST_INT       = 0x00000002L;    // Sustain INT
const u32b TR2_SUST_WIS       = 0x00000004L;    // Sustain WIS
const u32b TR2_SUST_DEX       = 0x00000008L;    // Sustain DEX
const u32b TR2_SUST_CON       = 0x00000010L;    // Sustain CON
const u32b TR2_SUST_CHR       = 0x00000020L;    // Sustain CHR
const u32b TR2_XXX1           = 0x00000040L;
const u32b TR2_XXX2           = 0x00000080L;
const u32b TR2_IM_ACID        = 0x00000100L;    // Immunity to acid
const u32b TR2_IM_ELEC        = 0x00000200L;    // Immunity to electicity
const u32b TR2_IM_FIRE        = 0x00000400L;    // Immunity to fire
const u32b TR2_IM_COLD        = 0x00000800L;    // Immunity to cold
const u32b TR2_XXX3           = 0x00001000L;
const u32b TR2_XXX4           = 0x00002000L;
const u32b TR2_FREE_ACT       = 0x00004000L;    // Free Action
const u32b TR2_HOLD_LIFE      = 0x00008000L;    // Hold Life
const u32b TR2_RES_ACID       = 0x00010000L;    // Resist acid
const u32b TR2_RES_ELEC       = 0x00020000L;    // Resist electricity
const u32b TR2_RES_FIRE       = 0x00040000L;    // Resist fire
const u32b TR2_RES_COLD       = 0x00080000L;    // Resist cold
const u32b TR2_RES_POIS       = 0x00100000L;    // Resist poison
const u32b TR2_XXX5           = 0x00200000L;
const u32b TR2_RES_LITE       = 0x00400000L;    // Resist light
const u32b TR2_RES_DARK       = 0x00800000L;    // Resist dark
const u32b TR2_RES_BLIND      = 0x01000000L;    // Resist blindness
const u32b TR2_RES_CONF       = 0x02000000L;    // Resist confusion
const u32b TR2_RES_SOUND      = 0x04000000L;    // Resist sound
const u32b TR2_RES_SHARDS     = 0x08000000L;    // Resist shards
const u32b TR2_RES_NETHER     = 0x10000000L;    // Resist nether
const u32b TR2_RES_NEXUS      = 0x20000000L;    // Resist nexus
const u32b TR2_RES_CHAOS      = 0x40000000L;    // Resist chaos
const u32b TR2_RES_DISEN      = 0x80000000L;    // Resist disenchantment

const u32b TR3_XXX1           = 0x00000001L;
const u32b TR3_XXX2           = 0x00000002L;
const u32b TR3_XXX3           = 0x00000004L;
const u32b TR3_XXX4           = 0x00000008L;
const u32b TR3_XXX5           = 0x00000010L;
const u32b TR3_XXX6           = 0x00000020L;
const u32b TR3_XXX7           = 0x00000040L;
const u32b TR3_XXX8           = 0x00000080L;     
const u32b TR3_EASY_KNOW      = 0x00000100L;    // Aware -> Known
const u32b TR3_HIDE_TYPE      = 0x00000200L;    // Hide "pval" description
const u32b TR3_SHOW_MODS      = 0x00000400L;    // Always show Tohit/Todam
const u32b TR3_INSTA_ART      = 0x00000800L;    // Item must be an artifact
const u32b TR3_FEATHER        = 0x00001000L;    // Feather Falling
const u32b TR3_LITE           = 0x00002000L;    // Permanent Light
const u32b TR3_SEE_INVIS      = 0x00004000L;    // See Invisible
const u32b TR3_TELEPATHY      = 0x00008000L;    // Telepathy
const u32b TR3_SLOW_DIGEST    = 0x00010000L;    // Item slows down digestion
const u32b TR3_REGEN          = 0x00020000L;    // Item induces regeneration
const u32b TR3_XTRA_MIGHT     = 0x00040000L;    // Bows get extra multiplier
const u32b TR3_XTRA_SHOTS     = 0x00080000L;    // Bows get extra shots
const u32b TR3_IGNORE_ACID    = 0x00100000L;    // Item ignores Acid Damage
const u32b TR3_IGNORE_ELEC    = 0x00200000L;    // Item ignores Elec Damage
const u32b TR3_IGNORE_FIRE    = 0x00400000L;    // Item ignores Fire Damage
const u32b TR3_IGNORE_COLD    = 0x00800000L;    // Item ignores Cold Damage 
const u32b TR3_ACTIVATE       = 0x01000000L;    // Item can be activated
const u32b TR3_DRAIN_EXP      = 0x02000000L;    // Item drains Experience
const u32b TR3_TELEPORT       = 0x04000000L;    // Item teleports player
const u32b TR3_AGGRAVATE      = 0x08000000L;    // Item aggravates monsters
const u32b TR3_BLESSED        = 0x10000000L;    // Item is Blessed
const u32b TR3_CURSED         = 0x20000000L;    // Item is Cursed
const u32b TR3_HEAVY_CURSE    = 0x40000000L;    // Item is Heavily Cursed
const u32b TR3_PERMA_CURSE    = 0x80000000L;    // Item is Perma Cursed


/*
 * Hack -- flag set 1 -- mask for "pval-dependant" flags.
 * Note that all "pval" dependant flags must be in "flags1".
 */
const u32b TR1_PVAL_MASK =
	TR1_STR | TR1_INT | TR1_WIS | TR1_DEX |
	TR1_CON | TR1_CHR | TR1_XXX1 | TR1_XXX2 |
	TR1_STEALTH | TR1_SEARCH | TR1_INFRA | TR1_TUNNEL |
	TR1_SPEED | TR1_BLOWS | TR1_XXX3 | TR1_XXX4;



/*** Monster blow constants ***/


/*
 * New monster blow methods
 */
const int RBM_HIT        = 1;
const int RBM_TOUCH      = 2;
const int RBM_PUNCH      = 3;
const int RBM_KICK       = 4;
const int RBM_CLAW       = 5;
const int RBM_BITE       = 6;
const int RBM_STING      = 7;
const int RBM_XXX1       = 8;
const int RBM_BUTT       = 9;
const int RBM_CRUSH      = 10;
const int RBM_ENGULF     = 11;
const int RBM_XXX2       = 12;
const int RBM_CRAWL      = 13;
const int RBM_DROOL      = 14;
const int RBM_SPIT       = 15;
const int RBM_XXX3       = 16;
const int RBM_GAZE       = 17;
const int RBM_WAIL       = 18;
const int RBM_SPORE      = 19;
const int RBM_XXX4       = 20;
const int RBM_BEG        = 21;
const int RBM_INSULT     = 22;
const int RBM_MOAN       = 23;
const int RBM_XXX5       = 24;


// New monster blow effects
const int RBE_HURT       = 1;
const int RBE_POISON     = 2;
const int RBE_UN_BONUS   = 3;
const int RBE_UN_POWER   = 4;
const int RBE_EAT_GOLD   = 5;
const int RBE_EAT_ITEM   = 6;
const int RBE_EAT_FOOD   = 7;
const int RBE_EAT_LITE   = 8;
const int RBE_ACID       = 9;
const int RBE_ELEC       = 10;
const int RBE_FIRE       = 11;
const int RBE_COLD       = 12;
const int RBE_BLIND      = 13;
const int RBE_CONFUSE    = 14;
const int RBE_TERRIFY    = 15;
const int RBE_PARALYZE   = 16;
const int RBE_LOSE_STR   = 17;
const int RBE_LOSE_INT   = 18;
const int RBE_LOSE_WIS   = 19;
const int RBE_LOSE_DEX   = 20;
const int RBE_LOSE_CON   = 21;
const int RBE_LOSE_CHR   = 22;
const int RBE_LOSE_ALL   = 23;
const int RBE_SHATTER    = 24;
const int RBE_EXP_10     = 25;
const int RBE_EXP_20     = 26;
const int RBE_EXP_40     = 27;
const int RBE_EXP_80     = 28;



/*** Monster types ***/

const int TYPE_NONE               = 0;
const int TYPE_TOWN               = 1;
const int TYPE_HUMAN_WARRIOR      = 2;
const int TYPE_HUMAN_MAGE         = 3;
const int TYPE_HUMAN_PRIEST       = 4;
const int TYPE_HUMAN_ROGUE        = 5;
const int TYPE_HUMAN_RANGER       = 6;
const int TYPE_HUMAN_MISC         = 7;
const int TYPE_HUMANOID_D_ELF     = 8;
const int TYPE_HUMANOID_ORC       = 9;
const int TYPE_HUMANOID_TROLL     = 10;
const int TYPE_HUMANOID_OGRE      = 11;
const int TYPE_HUMANOID_GIANT     = 12;
const int TYPE_HUMANOID_TITAN     = 13;
const int TYPE_HUMANOID_YEEK      = 14;
const int TYPE_HUMANOID_KOBOLD    = 15;
const int TYPE_HUMANOID_MISC      = 16;
const int TYPE_MAMMAL_QUAD        = 17;
const int TYPE_MAMMAL_YETI        = 18;
const int TYPE_MAMMAL_CAT         = 19;
const int TYPE_MAMMAL_DOG         = 20;
const int TYPE_MAMMAL_RODENT      = 21;
const int TYPE_MAMMAL_BAT         = 22;
const int TYPE_VERT_HARPY         = 23;
const int TYPE_VERT_BIRD          = 24;
const int TYPE_VERT_AMPHIB        = 25;
const int TYPE_VERT_NAGA          = 26;
const int TYPE_VERT_SNAKE         = 27;
const int TYPE_VERT_REPTILE       = 28;
const int TYPE_VERT_HYDRA         = 29;
const int TYPE_VERT_HYBRID        = 30;
const int TYPE_INSECT_SPIDER      = 31;
const int TYPE_INSECT_SCORPION    = 32;
const int TYPE_INSECT_ANT         = 33;
const int TYPE_INSECT_BEETLE      = 34;
const int TYPE_INSECT_CENTIPEDE   = 35;
const int TYPE_INSECT_TICK        = 36;
const int TYPE_INSECT_LOUSE       = 37;
const int TYPE_INSECT_DRAG_FLY    = 38;
const int TYPE_INSECT_FLY         = 39;
const int TYPE_LIFE_FUNGI         = 40;
const int TYPE_LIFE_ICKY_THING    = 41;
const int TYPE_LIFE_JELLY_IMMOB   = 42;
const int TYPE_LIFE_JELLY_MOB     = 43;
const int TYPE_LIFE_OOZE          = 44;
const int TYPE_LIFE_WORM          = 45;
const int TYPE_LIFE_EYE           = 46;
const int TYPE_LIFE_BEHOLDER      = 47;
const int TYPE_ELEMENT_SPIRIT     = 48;
const int TYPE_ELEMENT_HOUND      = 49;
const int TYPE_ELEMENT_VORTEX     = 50;
const int TYPE_DRAGON_BABY        = 51;
const int TYPE_DRAGON_YOUNG       = 52;
const int TYPE_DRAGON_MATURE      = 53;
const int TYPE_DRAGON_ANCIENT     = 54;
const int TYPE_DRAGON_GREAT_WYRM  = 55;
const int TYPE_DRAGON_UNUSUAL     = 56;
const int TYPE_DRAGON_UNIQUE      = 57;
const int TYPE_DEMON_MINOR        = 58;
const int TYPE_DEMON_MAJOR        = 59;
const int TYPE_UNDEAD_SKELETON    = 60;
const int TYPE_UNDEAD_DRUJ        = 61;
const int TYPE_UNDEAD_ZOMBIE      = 62;
const int TYPE_UNDEAD_MUMMY       = 63;
const int TYPE_UNDEAD_GHOST       = 64;
const int TYPE_UNDEAD_WIGHT       = 65;
const int TYPE_UNDEAD_NAZGUL      = 66;
const int TYPE_UNDEAD_VAMPIRE     = 67;
const int TYPE_UNDEAD_LICH        = 68;
const int TYPE_ANGEL              = 69;
const int TYPE_MIMIC              = 70;
const int TYPE_GOLEM              = 71;
const int TYPE_COINS              = 72;
const int TYPE_QUYLTHULG          = 73;
const int TYPE_MISC               = 74;
const int TYPE_QUESTOR            = 75;


/*** Monster flag values (hard-coded) ***/

const u32b RF1_UNIQUE         = 0x00000001,     // Unique Monster
           RF1_QUESTOR        = 0x00000002,     // Quest Monster
           RF1_MALE           = 0x00000004,     // Male gender
           RF1_FEMALE         = 0x00000008,     // Female gender
           RF1_CHAR_CLEAR     = 0x00000010,     // Absorbs symbol
           RF1_CHAR_MULTI     = 0x00000020,     // Changes symbol
           RF1_ATTR_CLEAR     = 0x00000040,     // Absorbs color
           RF1_ATTR_MULTI     = 0x00000080,     // Changes color
           RF1_FORCE_DEPTH    = 0x00000100,     // Start at "correct" depth
           RF1_FORCE_MAXHP    = 0x00000200,     // Start with max hitpoints
           RF1_FORCE_SLEEP    = 0x00000400,     // Start out sleeping
           RF1_FORCE_EXTRA    = 0x00000800,     // Start out something
           RF1_FRIEND         = 0x00001000,     // Arrive with a friend
           RF1_FRIENDS        = 0x00002000,     // Arrive with some friends 
           RF1_ESCORT         = 0x00004000,     // Arrive with an escort
           RF1_ESCORTS        = 0x00008000,     // Arrive with some escorts
           RF1_NEVER_BLOW     = 0x00010000,     // Never make physical blow
           RF1_NEVER_MOVE     = 0x00020000,     // Never make physical move
           RF1_RAND_25        = 0x00040000,     // Moves randomly (25%)
           RF1_RAND_50        = 0x00080000,     // Moves randomly (50%)
           RF1_ONLY_GOLD      = 0x00100000,     // Drop only gold
           RF1_ONLY_ITEM      = 0x00200000,     // Drop only items
           RF1_DROP_60        = 0x00400000,     // Drop an item/gold (60%)
           RF1_DROP_90        = 0x00800000,     // Drop an item/gold (90%)
           RF1_DROP_1D2       = 0x01000000,     // Drop 1d2 items/gold
           RF1_DROP_2D2       = 0x02000000,     // Drop 2d2 items/gold
           RF1_DROP_3D2       = 0x04000000,     // Drop 3d2 items/gold
           RF1_DROP_4D2       = 0x08000000,     // Drop 4d2 items/gold
           RF1_DROP_GOOD      = 0x10000000,     // Drop good items
           RF1_DROP_GREAT     = 0x20000000,     // Drop great items
           RF1_DROP_USEFUL    = 0x40000000,     // Drop "useful" items
           RF1_DROP_CHOSEN    = 0x80000000;     // Drop "chosen" items

const u32b RF2_STUPID         = 0x00000001,     // Monster is stupid
           RF2_SMART          = 0x00000002,     // Monster is smart
           RF2_XXX1           = 0x00000004,      
           RF2_XXX2           = 0x00000008,
           RF2_INVISIBLE      = 0x00000010,     // Monster avoids vision
           RF2_COLD_BLOOD     = 0x00000020,     // Monster avoids infra
           RF2_EMPTY_MIND     = 0x00000040,     // Monster avoids telepathy
           RF2_WEIRD_MIND     = 0x00000080,     // Monster avoids telepathy?
           RF2_MULTIPLY       = 0x00000100,     // Monster reproduces
           RF2_REGENERATE     = 0x00000200,     // Monster regenerates
           RF2_XXX3           = 0x00000400,      
           RF2_XXX4           = 0x00000800,
           RF2_POWERFUL       = 0x00001000,     // Monster has strong breath
           RF2_XXX5           = 0x00002000,
           RF2_XXX7           = 0x00004000,
           RF2_XXX6           = 0x00008000,
           RF2_OPEN_DOOR      = 0x00010000,     // Monster can open doors
           RF2_BASH_DOOR      = 0x00020000,     // Monster can bash doors
           RF2_PASS_WALL      = 0x00040000,     // Monster can pass walls
           RF2_KILL_WALL      = 0x00080000,     // Monster can destroy walls
           RF2_MOVE_BODY      = 0x00100000,     // Monster can move monsters
           RF2_KILL_BODY      = 0x00200000,     // Monster can kill monsters
           RF2_TAKE_ITEM      = 0x00400000,     // Monster can pick up items
           RF2_KILL_ITEM      = 0x00800000,     // Monster can crush items
           RF2_BRAIN_1        = 0x01000000,
           RF2_BRAIN_2        = 0x02000000,
           RF2_BRAIN_3        = 0x04000000,
           RF2_BRAIN_4        = 0x08000000,
           RF2_BRAIN_5        = 0x10000000,
           RF2_BRAIN_6        = 0x20000000,
           RF2_BRAIN_7        = 0x40000000,
           RF2_BRAIN_8        = 0x80000000;

const u32b RF3_ORC            = 0x00000001,     // Orc
           RF3_TROLL          = 0x00000002,     // Troll
           RF3_GIANT          = 0x00000004,     // Giant
           RF3_DRAGON         = 0x00000008,     // Dragon
           RF3_DEMON          = 0x00000010,     // Demon
           RF3_UNDEAD         = 0x00000020,     // Undead
           RF3_EVIL           = 0x00000040,     // Evil
           RF3_ANIMAL         = 0x00000080,     // Animal
           RF3_XXX1           = 0x00000100,
           RF3_XXX2           = 0x00000200,
           RF3_XXX3           = 0x00000400,     // Non-Vocal (?)
           RF3_XXX4           = 0x00000800,     // Non-Living (?)
           RF3_HURT_LITE      = 0x00001000,     // Hurt by lite
           RF3_HURT_ROCK      = 0x00002000,     // Hurt by rock remover
           RF3_HURT_FIRE      = 0x00004000,     // Hurt badly by fire
           RF3_HURT_COLD      = 0x00008000,     // Hurt badly by cold
           RF3_IM_ACID        = 0x00010000,     // Resist acid a lot
           RF3_IM_ELEC        = 0x00020000,     // Resist elec a lot
           RF3_IM_FIRE        = 0x00040000,     // Resist fire a lot
           RF3_IM_COLD        = 0x00080000,     // Resist cold a lot
           RF3_IM_POIS        = 0x00100000,     // Resist poison a lot
           RF3_XXX5           = 0x00200000,     // Immune to (?)
           RF3_RES_NETHER     = 0x00400000,     // Resist nether
           RF3_RES_WATER      = 0x00800000,     // Resist water
           RF3_RES_PLASMA     = 0x01000000,     // Resist plasma
           RF3_RES_NEXUS      = 0x02000000,     // Resist nexus
           RF3_RES_DISEN      = 0x04000000,     // Resist disenchantment
           RF3_RES_MAGIC      = 0x08000000,     // Resist magic 
           RF3_NO_FEAR        = 0x10000000,     // Cannot be scared
           RF3_NO_STUN        = 0x20000000,     // Cannot be stunned
           RF3_NO_CONF        = 0x40000000,     // Cannot be confused
           RF3_NO_SLEEP       = 0x80000000;     // Cannot be slept 

const u32b RF4_SHRIEK         = 0x00000001,     // Shriek for help
           RF4_XXX2           = 0x00000002,
           RF4_XXX3           = 0x00000004,
           RF4_XXX4           = 0x00000008,
           RF4_ARROW_1        = 0x00000010,     // Fire an arrow (light)
           RF4_ARROW_2        = 0x00000020,     // Fire an arrow (heavy)
           RF4_ARROW_3        = 0x00000040,     // Fire missiles (light)
           RF4_ARROW_4        = 0x00000080,     // Fire missiles (heavy)
           RF4_BR_ACID        = 0x00000100,     // Breathe Acid
           RF4_BR_ELEC        = 0x00000200,     // Breathe Elec
           RF4_BR_FIRE        = 0x00000400,     // Breathe Fire
           RF4_BR_COLD        = 0x00000800,     // Breathe Cold
           RF4_BR_POIS        = 0x00001000,     // Breathe Poison
           RF4_BR_NETH        = 0x00002000,     // Breathe Nether
           RF4_BR_LITE        = 0x00004000,     // Breathe Lite
           RF4_BR_DARK        = 0x00008000,     // Breathe Dark
           RF4_BR_CONF        = 0x00010000,     // Breathe Confusion
           RF4_BR_SOUN        = 0x00020000,     // Breathe Sound
           RF4_BR_CHAO        = 0x00040000,     // Breathe Chaos
           RF4_BR_DISE        = 0x00080000,     // Breathe Disenchant
           RF4_BR_NEXU        = 0x00100000,     // Breathe Nexus
           RF4_BR_TIME        = 0x00200000,     // Breathe Time
           RF4_BR_INER        = 0x00400000,     // Breathe Inertia
           RF4_BR_GRAV        = 0x00800000,     // Breathe Gravity
           RF4_BR_SHAR        = 0x01000000,     // Breathe Shards
           RF4_BR_PLAS        = 0x02000000,     // Breathe Plasma
           RF4_BR_WALL        = 0x04000000,     // Breathe Force
           RF4_BR_MANA        = 0x08000000,     // Breathe Mana
           RF4_XXX5           = 0x10000000,
           RF4_XXX6           = 0x20000000,
           RF4_XXX7           = 0x40000000,
           RF4_XXX8           = 0x80000000;

const u32b RF5_BA_ACID        = 0x00000001,     // Acid Ball 
           RF5_BA_ELEC        = 0x00000002,     // Elec Ball
           RF5_BA_FIRE        = 0x00000004,     // Fire Ball
           RF5_BA_COLD        = 0x00000008,     // Cold Ball
           RF5_BA_POIS        = 0x00000010,     // Poison Ball
           RF5_BA_NETH        = 0x00000020,     // Nether Ball
           RF5_BA_WATE        = 0x00000040,     // Water Ball
           RF5_BA_MANA        = 0x00000080,     // Mana Storm
           RF5_BA_DARK        = 0x00000100,     // Darkness Storm
           RF5_DRAIN_MANA     = 0x00000200,     // Drain Mana
           RF5_MIND_BLAST     = 0x00000400,     // Blast Mind
           RF5_BRAIN_SMASH    = 0x00000800,     // Smash Brain
           RF5_CAUSE_1        = 0x00001000,     // Cause Light Wound
           RF5_CAUSE_2        = 0x00002000,     // Cause Serious Wound
           RF5_CAUSE_3        = 0x00004000,     // Cause Critical Wound
           RF5_CAUSE_4        = 0x00008000,     // Cause Mortal Wound
           RF5_BO_ACID        = 0x00010000,     // Acid Bolt
           RF5_BO_ELEC        = 0x00020000,     // Elec Bolt (unused)
           RF5_BO_FIRE        = 0x00040000,     // Fire Bolt
           RF5_BO_COLD        = 0x00080000,     // Cold Bolt
           RF5_BO_POIS        = 0x00100000,     // Poison Bolt (unused)
           RF5_BO_NETH        = 0x00200000,     // Nether Bolt
           RF5_BO_WATE        = 0x00400000,     // Water Bolt
           RF5_BO_MANA        = 0x00800000,     // Mana Bolt
           RF5_BO_PLAS        = 0x01000000,     // Plasma Bolt
           RF5_BO_ICEE        = 0x02000000,     // Ice Bolt
           RF5_MISSILE        = 0x04000000,     // Magic Missile
           RF5_SCARE          = 0x08000000,     // Frighten Player
           RF5_BLIND          = 0x10000000,     // Blind Player
           RF5_CONF           = 0x20000000,     // Confuse Player
           RF5_SLOW           = 0x40000000,     // Slow Player
           RF5_HOLD           = 0x80000000;     // Paralyze Player

const u32b RF6_HASTE          = 0x00000001,     // Speed self 
           RF6_XXX1           = 0x00000002,     // Speed a lot (?)
           RF6_HEAL           = 0x00000004,     // Heal self
           RF6_XXX2           = 0x00000008,     // Heal a lot (?)
           RF6_BLINK          = 0x00000010,     // Teleport Short
           RF6_TPORT          = 0x00000020,     // Teleport Long
           RF6_XXX3           = 0x00000040,     // Move to Player (?)
           RF6_XXX4           = 0x00000080,     // Move to Monster (?)
           RF6_TELE_TO        = 0x00000100,     // Move player to monster
           RF6_TELE_AWAY      = 0x00000200,     // Move player far away
           RF6_TELE_LEVEL     = 0x00000400,     // Move player vertically
           RF6_XXX5           = 0x00000800,     // Move player (?)
           RF6_DARKNESS       = 0x00001000,     // Create Darkness
           RF6_TRAPS          = 0x00002000,     // Create Traps
           RF6_FORGET         = 0x00004000,     // Cause amnesia
           RF6_XXX6           = 0x00008000,
           RF6_XXX7           = 0x00010000,     // Summon (?)
           RF6_XXX8           = 0x00020000,     // Summon (?)
           RF6_S_MONSTER      = 0x00040000,     // Summon Monster
           RF6_S_MONSTERS     = 0x00080000,     // Summon Monsters
           RF6_S_ANT          = 0x00100000,     // Summon Ants
           RF6_S_SPIDER       = 0x00200000,     // Summon Spiders
           RF6_S_HOUND        = 0x00400000,     // Summon Hounds
           RF6_S_HYDRA        = 0x00800000,     // Summon Hydras
           RF6_S_ANGEL        = 0x01000000,     // Summon Angel
           RF6_S_DEMON        = 0x02000000,     // Summon Demon
           RF6_S_UNDEAD       = 0x04000000,     // Summon Undead
           RF6_S_DRAGON       = 0x08000000,     // Summon Dragon
           RF6_S_HI_UNDEAD    = 0x10000000,     // Summon Greater Undead
           RF6_S_HI_DRAGON    = 0x20000000,     // Summon Ancient Dragon
           RF6_S_WRAITH       = 0x40000000,     // Summon Unique Wraith
           RF6_S_UNIQUE       = 0x80000000;     // Summon Unique Monster 



/*
 * Hack -- choose "intelligent" spells when desperate
 */

const u32b RF4_INT_MASK = 0L;
const u32b RF5_INT_MASK = RF5_HOLD | RF5_SLOW | RF5_CONF | RF5_BLIND | RF5_SCARE;
const u32b RF6_INT_MASK =
    RF6_BLINK |  RF6_TPORT | RF6_TELE_LEVEL | RF6_TELE_AWAY |
    RF6_HEAL | RF6_HASTE | RF6_TRAPS |
    RF6_S_MONSTER | RF6_S_MONSTERS |
    RF6_S_ANT | RF6_S_SPIDER | RF6_S_HOUND | RF6_S_HYDRA |
    RF6_S_ANGEL | RF6_S_DRAGON | RF6_S_UNDEAD | RF6_S_DEMON |
    RF6_S_HI_DRAGON | RF6_S_HI_UNDEAD | RF6_S_WRAITH | RF6_S_UNIQUE;



/*** Macro Definitions ***/


// Determines if a map location is fully inside the outer walls
#define in_bounds(Y,X) \
   (((Y) > 0) && ((X) > 0) && ((Y) < cur_hgt-1) && ((X) < cur_wid-1))

// Determines if a map location is on or inside the outer walls
#define in_bounds2(Y,X) \
   (((Y) >= 0) && ((X) >= 0) && ((Y) < cur_hgt) && ((X) < cur_wid))


/*
 * Determine if a "legal" grid is a "floor" grid
 *
 * Line 1 -- forbid doors, rubble, seams, walls
 *
 * Note that the terrain features are split by a one bit test
 * into those features which block line of sight and those that
 * do not, allowing an abusively fast single bit check below.
 */
#define floor_grid_bold(Y,X) \
    (!(cave[Y][X].get_feat() & 0x20))

/*
 * Determine if a "legal" grid is a "clean" floor grid
 *
 * Line 1 -- forbid doors, rubble, seams, walls
 * Line 2 -- forbid terrain features
 * Line 3 -- forbid normal objects
 */
#define clean_grid_bold(Y,X) \
    (floor_grid_bold(Y,X) && \
     (cave[Y][X].get_feat() == CF_FLOOR) && \
     (!cave[Y][X].i_ptr))

/*
 * Determine if a "legal" grid is a "clean stackable" floor grid
 *
 * Line 1 -- forbid doors, rubble, seams, walls
 * Line 2 -- forbid terrain features
 */
#define clean_stackable_grid_bold(Y,X) \
    (floor_grid_bold(Y,X) && \
     (cave[Y][X].get_feat() == CF_FLOOR))

/*
 * Determine if a "legal" grid is an "empty" floor grid
 *
 * Line 1 -- forbid doors, rubble, seams, walls
 * Line 2 -- forbid normal monsters
 * Line 3 -- forbid the player
 */
#define empty_grid_bold(Y,X) \
    (floor_grid_bold(Y,X) && \
     !(cave[Y][X].m_ptr) && \
     !(((Y) == p_ptr->GetY()) && ((X) == p_ptr->GetX())))

/*
 * Determine if a "legal" grid is an "naked" floor grid
 *
 * Line 1 -- forbid doors, rubble, seams, walls
 * Line 2 -- forbid terrain features
 * Line 3 -- forbid normal objects
 * Line 4 -- forbid normal monsters
 * Line 5 -- forbid the player
 */
#define naked_grid_bold(Y,X) \
    (floor_grid_bold(Y,X) && \
     (cave[Y][X].get_feat() == CF_FLOOR) && \
     !(cave[Y][X].i_ptr) && \
     !(cave[Y][X].m_ptr) && \
     !(((Y) == p_ptr->GetY()) && ((X) == p_ptr->GetX())))


/*
 * Determine if a "legal" grid is within "los" of the player
 *
 * Note the use of comparison to zero to force a "boolean" result
 */
#define player_has_los_bold(Y,X) \
    ((cave[Y][X].flags & MAP_VIEW) != 0)


// Several basic colors
const int COLOR_BLACK    = 0;
const int COLOR_DK_GREY  = 9;
const int COLOR_GREY     = 5;
const int COLOR_LT_GREY  = 2;
const int COLOR_WHITE    = 1;
const int COLOR_RED      = 222;
const int COLOR_ORANGE   = 230;
const int COLOR_YELLOW   = 231;
const int COLOR_GREEN    = 174; //: significant change here
const int COLOR_BLUE     = 236;
const int COLOR_PURPLE   = 211; //: BAD
const int COLOR_BROWN    = 56;
const int COLOR_LT_RED   = 228; //: significant change here
const int COLOR_LT_GREEN = 232;
const int COLOR_LT_BLUE  = 233;
const int COLOR_LT_BROWN = 29;


// Flags for get_item
const byte GI_EQUIP = 0x01;
const byte GI_INVEN = 0x02;
const byte GI_FLOOR = 0x04;

// Flags for CItem::apply_magic
const byte AM_ALLOW_ART   = 0x01;
const byte AM_FORCE_GOOD  = 0x02;
const byte AM_FORCE_GREAT = 0x04;

// Flags for place_monster and place_monster_aux
const byte PM_FORCE_SLEEP = 0x01;
const byte PM_ALLOW_GROUP = 0x02;

// Typeids
const int TYPEID_CGRID       = 1;
const int TYPEID_CITEM       = 2;
const int TYPEID_CMONSTER    = 3;
const int TYPEID_CPLAYER     = 4;
const int TYPEID_CPROJECTILE = 5;


// Scancode constants
const int KEY_ESCAPE      = 1;
const int KEY_1           = 2;
const int KEY_2           = 3;
const int KEY_3           = 4;
const int KEY_4           = 5;
const int KEY_5           = 6;
const int KEY_6           = 7;
const int KEY_7           = 8;
const int KEY_8           = 9;
const int KEY_9           = 10;
const int KEY_0           = 11;
const int KEY_MINUS       = 12;
const int KEY_EQUAL       = 13;
const int KEY_BACKSPACE   = 14;
const int KEY_TAB         = 15;
const int KEY_Q           = 16;
const int KEY_W           = 17;
const int KEY_E           = 18;
const int KEY_R           = 19;
const int KEY_T           = 20;
const int KEY_Y           = 21;
const int KEY_U           = 22;
const int KEY_I           = 23;
const int KEY_O           = 24;
const int KEY_P           = 25;
const int KEY_LBRACKET    = 26;
const int KEY_RBRACKET    = 27;
const int KEY_ENTER       = 28;
const int KEY_A           = 30;
const int KEY_S           = 31;
const int KEY_D           = 32;
const int KEY_F           = 33;
const int KEY_G           = 34;
const int KEY_H           = 35;
const int KEY_J           = 36;
const int KEY_K           = 37;
const int KEY_L           = 38;
const int KEY_SEMICOLON   = 39;
const int KEY_QUOTE       = 40;
const int KEY_BACKQUOTE   = 41;
const int KEY_BACKSLASH   = 43;
const int KEY_Z           = 44;
const int KEY_X           = 45;
const int KEY_C           = 46;
const int KEY_V           = 47;
const int KEY_B           = 48;
const int KEY_N           = 49;
const int KEY_M           = 50;
const int KEY_COMMA       = 51;
const int KEY_PERIOD      = 52;
const int KEY_SLASH       = 53;
const int KEYPAD_STAR     = 55;
const int KEY_SPACE       = 57;
const int KEY_F1          = 59;
const int KEY_F2          = 60;
const int KEY_F3          = 61;
const int KEY_F4          = 62;
const int KEY_F5          = 63;
const int KEY_F6          = 64;
const int KEY_F7          = 65;
const int KEY_F8          = 66;
const int KEY_F9          = 67;
const int KEY_F10         = 68;
const int KEYPAD_7        = 71;
const int KEYPAD_8        = 72;
const int KEYPAD_9        = 73;
const int KEYPAD_MINUS    = 74;
const int KEYPAD_4        = 75;
const int KEYPAD_5        = 76;
const int KEYPAD_6        = 77;
const int KEYPAD_PLUS     = 78;
const int KEYPAD_1        = 79;
const int KEYPAD_2        = 80;
const int KEYPAD_3        = 81;
const int KEYPAD_0        = 82;
const int KEYPAD_PERIOD   = 83;
const int KEY_UP          = 72;
const int KEY_LEFT        = 75;
const int KEY_RIGHT       = 77;
const int KEY_DOWN        = 80;
const int KEY_HOME        = 71;
const int KEY_END         = 79;
const int KEY_PGUP        = 73;
const int KEY_PGDN        = 81;

// Defines for text
const int FONT_REGULAR = 0;
const int FONT_BOLD    = 1;

const int JUST_LEFT   = 0;
const int JUST_CENTER = 1;
const int JUST_RIGHT  = 2;


// Current things being shown in addition to just the map
const int SHOW_JUST_MAP   = 0;
const int SHOW_CONSOLE    = 1;
const int SHOW_CHARACTER  = 2;
const int SHOW_INVEN      = 3;
const int SHOW_EQUIP      = 4;

const int MESSAGE_LIMIT = 8;

const int ACTION_NOTHING = 0;
// Actions 1-9 reserved for walking
