/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.sf.gogui.go.GoColor;
import net.sf.gogui.gtp.GtpError;
import net.sf.gogui.gtp.GtpUtils;
import net.sf.gogui.gui.AnalyzeCommand;
import net.sf.gogui.gui.CommandThread;
import net.sf.gogui.gui.GuiUtils;
import net.sf.gogui.gui.SimpleDialogs;

public final class AnalyzeDialog
extends JDialog
implements ActionListener,
ListSelectionListener {
    private boolean m_onlySupportedCommands;
    private boolean m_sort;
    private boolean m_recentModified;
    private boolean m_firstIsTemp;
    private int m_boardSize = 19;
    private static final long serialVersionUID = 0L;
    private GoColor m_selectedColor = GoColor.EMPTY;
    private final CommandThread m_commandThread;
    private JButton m_clearButton;
    private JButton m_runButton;
    private JCheckBox m_autoRun;
    private JCheckBox m_clearBoard;
    private JComboBox m_comboBoxHistory;
    private JComboBox m_comboBoxColor;
    private JLabel m_labelColor;
    private JList m_list;
    private JPanel m_colorPanel;
    private final ArrayList m_commands = new ArrayList(128);
    private final ArrayList m_supportedCommands;
    private final ArrayList m_labels = new ArrayList(128);
    private final Callback m_callback;
    private final String m_programAnalyzeCommands;
    static final /* synthetic */ boolean $assertionsDisabled;

    public AnalyzeDialog(Frame frame, Callback callback, boolean bl, boolean bl2, ArrayList arrayList, String string, CommandThread commandThread) {
        super(frame, "Analyze");
        this.m_commandThread = commandThread;
        this.m_onlySupportedCommands = bl;
        this.m_sort = bl2;
        this.m_supportedCommands = arrayList;
        this.m_programAnalyzeCommands = string;
        this.m_callback = callback;
        this.setDefaultCloseOperation(0);
        WindowAdapter windowAdapter = new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                AnalyzeDialog.this.close();
            }
        };
        this.addWindowListener(windowAdapter);
        Container container = this.getContentPane();
        container.add((Component)this.createCommandPanel(), "Center");
        this.comboBoxChanged();
        this.pack();
        this.m_list.requestFocusInWindow();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("clear")) {
            this.clearCommand();
        } else if (string.equals("close")) {
            this.close();
        } else if (string.equals("comboBoxChanged")) {
            this.comboBoxChanged();
        } else if (string.equals("run")) {
            this.runCommand();
        } else if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    public void close() {
        if (!this.m_autoRun.isSelected()) {
            this.clearCommand();
        }
        this.saveRecent();
        this.setVisible(false);
    }

    public GoColor getSelectedColor() {
        String string = (String)this.m_comboBoxColor.getSelectedItem();
        if (string.equals("White")) {
            return GoColor.WHITE;
        }
        if (!$assertionsDisabled && !string.equals("Black")) {
            throw new AssertionError();
        }
        return GoColor.BLACK;
    }

    public void reload() {
        try {
            ArrayList arrayList = null;
            if (this.m_onlySupportedCommands) {
                arrayList = this.m_supportedCommands;
            }
            AnalyzeCommand.read(this.m_commands, this.m_labels, arrayList, this.m_programAnalyzeCommands);
            if (this.m_sort) {
                this.sortLists();
            }
            this.m_list.setListData(this.m_labels.toArray());
            this.comboBoxChanged();
        }
        catch (Exception exception) {
            SimpleDialogs.showError(this, exception.getMessage());
        }
    }

    public void saveRecent() {
        PrintStream printStream;
        if (!this.m_recentModified) {
            return;
        }
        File file = this.getRecentFile();
        try {
            printStream = new PrintStream(new FileOutputStream(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("FileNotFoundException in AnalyzeDialog.saveRecent");
            return;
        }
        int n = this.m_firstIsTemp ? 1 : 0;
        int n2 = Math.min(this.m_comboBoxHistory.getItemCount(), 20);
        for (int i = n; i < n2; ++i) {
            printStream.println(this.getComboBoxItem(i));
        }
        printStream.close();
    }

    public void setBoardSize(int n) {
        this.m_boardSize = n;
    }

    public void setOnlySupported(boolean bl) {
        this.m_onlySupportedCommands = bl;
        this.reload();
    }

    public void setRunButtonEnabled(boolean bl) {
        this.m_runButton.setEnabled(bl);
    }

    public void setSelectedColor(GoColor goColor) {
        this.m_selectedColor = goColor;
        this.selectColor();
    }

    public void setSort(boolean bl) {
        this.m_sort = bl;
        this.reload();
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        int n = this.m_list.getSelectedIndex();
        if (n >= 0) {
            this.selectCommand(n);
        } else {
            if (this.m_runButton.hasFocus()) {
                this.m_list.requestFocusInWindow();
            }
            this.m_runButton.setEnabled(false);
        }
    }

    private void clearCommand() {
        this.m_callback.clearAnalyzeCommand();
        this.m_autoRun.setSelected(false);
    }

    private void comboBoxChanged() {
        String string = (String)this.m_comboBoxHistory.getSelectedItem();
        if (!this.m_labels.contains(string)) {
            this.m_list.clearSelection();
            return;
        }
        String string2 = (String)this.m_list.getSelectedValue();
        if (string2 == null || !string2.equals(string)) {
            this.m_list.setSelectedValue(string, false);
        }
    }

    private JPanel createButtons() {
        JPanel jPanel = new JPanel(new GridLayout(1, 0, 5, 0));
        this.m_runButton = new JButton("Run");
        this.m_runButton.setToolTipText("Run command");
        this.m_runButton.setActionCommand("run");
        this.m_runButton.addActionListener(this);
        this.m_runButton.setMnemonic(82);
        this.getRootPane().setDefaultButton(this.m_runButton);
        jPanel.add(this.m_runButton);
        this.m_clearButton = new JButton("Clear");
        this.m_clearButton.setToolTipText("Clear board and cancel auto run");
        this.m_clearButton.setActionCommand("clear");
        this.m_clearButton.addActionListener(this);
        this.m_clearButton.setMnemonic(67);
        jPanel.add(this.m_clearButton);
        JPanel jPanel2 = new JPanel(new FlowLayout(1));
        jPanel2.add(jPanel);
        return jPanel2;
    }

    private JPanel createColorPanel() {
        this.m_colorPanel = new JPanel(new FlowLayout(0));
        this.m_labelColor = new JLabel("Color:");
        this.m_labelColor.setHorizontalAlignment(2);
        this.m_colorPanel.add(this.m_labelColor);
        String[] stringArray = new String[]{"Black", "White"};
        this.m_comboBoxColor = new JComboBox<String>(stringArray);
        this.m_comboBoxColor.setToolTipText("Color argument for command");
        this.m_colorPanel.add(this.m_comboBoxColor);
        return this.m_colorPanel;
    }

    private JPanel createCommandPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.m_list = new JList();
        this.m_list.setSelectionMode(0);
        this.m_list.setVisibleRowCount(25);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                int n = mouseEvent.getModifiers();
                int n2 = 8;
                if (mouseEvent.getClickCount() == 2 || (n & n2) != 0) {
                    AnalyzeDialog.this.runCommand();
                }
            }
        };
        this.m_list.addMouseListener(mouseAdapter);
        this.m_list.addListSelectionListener(this);
        JScrollPane jScrollPane = new JScrollPane(this.m_list);
        jPanel.add((Component)jScrollPane, "Center");
        jPanel.add((Component)this.createLowerPanel(), "South");
        this.reload();
        return jPanel;
    }

    private JPanel createLowerPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        this.m_comboBoxHistory = new JComboBox();
        jPanel.add(this.m_comboBoxHistory);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.setBorder(GuiUtils.createEmptyBorder());
        jPanel.add(jPanel2);
        JPanel jPanel3 = new JPanel(new GridLayout(0, 2, 5, 0));
        jPanel2.add(jPanel3);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 1));
        jPanel3.add(jPanel4);
        this.m_autoRun = new JCheckBox("Auto run");
        this.m_autoRun.setToolTipText("Automatically run after changes on board");
        jPanel4.add(this.m_autoRun);
        this.m_clearBoard = new JCheckBox("Clear board");
        this.m_clearBoard.setToolTipText("Clear board before displaying result");
        jPanel4.add(this.m_clearBoard);
        this.m_clearBoard.setSelected(true);
        JPanel jPanel5 = new JPanel();
        jPanel5.add(this.createColorPanel());
        jPanel3.add(jPanel5);
        jPanel2.add(this.createButtons());
        this.m_comboBoxHistory.addActionListener(this);
        this.loadRecent();
        return jPanel;
    }

    private String getComboBoxItem(int n) {
        return (String)this.m_comboBoxHistory.getItemAt(n);
    }

    private File getRecentFile() {
        String string = System.getProperty("user.home");
        return new File(new File(string, ".gogui"), "recent-analyze");
    }

    private void loadRecent() {
        BufferedReader bufferedReader;
        this.m_comboBoxHistory.removeAllItems();
        File file = this.getRecentFile();
        try {
            bufferedReader = new BufferedReader(new FileReader(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            return;
        }
        try {
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                this.m_comboBoxHistory.addItem(string);
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            System.err.println("IOException in AnalyzeDialog.loadRecent");
        }
        this.m_firstIsTemp = false;
    }

    private void runCommand() {
        Object object;
        String string;
        Object object2;
        if (this.m_commandThread.isCommandInProgress()) {
            SimpleDialogs.showError(this, "Command in progress");
            return;
        }
        int n = this.m_list.getSelectedIndex();
        if (n < 0) {
            return;
        }
        this.updateRecent(n);
        String string2 = (String)this.m_commands.get(n);
        AnalyzeCommand analyzeCommand = new AnalyzeCommand(string2);
        if (analyzeCommand.needsColorArg()) {
            analyzeCommand.setColorArg(this.getSelectedColor());
        }
        String string3 = analyzeCommand.getResultTitle();
        if (analyzeCommand.needsStringArg()) {
            object2 = JOptionPane.showInputDialog(this, (Object)string3);
            if (object2 == null) {
                return;
            }
            analyzeCommand.setStringArg((String)object2);
        }
        if (analyzeCommand.needsOptStringArg()) {
            try {
                analyzeCommand.setOptStringArg("");
                object2 = analyzeCommand.replaceWildCards(this.m_selectedColor);
                string = this.m_commandThread.send((String)object2);
                object = JOptionPane.showInputDialog(this, string3, string);
                if (object == null || ((String)object).equals(string)) {
                    return;
                }
                analyzeCommand.setOptStringArg((String)object);
            }
            catch (GtpError gtpError) {
                SimpleDialogs.showError(this, gtpError.getMessage());
                return;
            }
        }
        if (analyzeCommand.getType() == 3) {
            try {
                analyzeCommand.setPointListArg(new ArrayList());
                object2 = analyzeCommand.replaceWildCards(this.m_selectedColor) + " show";
                string = this.m_commandThread.send((String)object2);
                object = GtpUtils.parsePointArrayList(string, this.m_boardSize);
                analyzeCommand.setPointListArg((ArrayList)object);
            }
            catch (GtpError gtpError) {
                SimpleDialogs.showError(this, gtpError.getMessage());
                return;
            }
        }
        if (analyzeCommand.needsFileArg()) {
            object2 = SimpleDialogs.showSelectFile(this, string3);
            if (object2 == null) {
                return;
            }
            analyzeCommand.setFileArg((File)object2);
        }
        if (analyzeCommand.needsColorArg()) {
            analyzeCommand.setColorArg(this.getSelectedColor());
        }
        boolean bl = this.m_autoRun.isSelected();
        boolean bl2 = this.m_clearBoard.isSelected();
        if (bl2) {
            this.m_callback.clearAnalyzeCommand();
        }
        this.m_callback.setAnalyzeCommand(analyzeCommand, bl, false, false);
    }

    private void selectCommand(int n) {
        boolean bl = AnalyzeCommand.needsColorArg((String)this.m_commands.get(n));
        this.m_labelColor.setEnabled(bl);
        this.m_comboBoxColor.setEnabled(bl);
        this.m_runButton.setEnabled(true);
        String string = (String)this.m_labels.get(n);
        this.m_comboBoxHistory.removeActionListener(this);
        if (this.m_firstIsTemp && this.m_comboBoxHistory.getItemCount() > 0) {
            this.m_comboBoxHistory.removeItemAt(0);
        }
        this.m_comboBoxHistory.insertItemAt(string, 0);
        this.m_firstIsTemp = true;
        this.m_comboBoxHistory.setSelectedIndex(0);
        this.m_comboBoxHistory.addActionListener(this);
    }

    private void selectColor() {
        if (this.m_selectedColor == GoColor.BLACK) {
            this.m_comboBoxColor.setSelectedItem("Black");
        } else if (this.m_selectedColor == GoColor.WHITE) {
            this.m_comboBoxColor.setSelectedItem("White");
        }
    }

    private void sortLists() {
        for (int i = 0; i < this.m_labels.size() - 1; ++i) {
            for (int j = i + 1; j < this.m_labels.size(); ++j) {
                String string;
                String string2 = (String)this.m_labels.get(i);
                if (string2.compareTo(string = (String)this.m_labels.get(j)) <= 0) continue;
                this.m_labels.set(i, string);
                this.m_labels.set(j, string2);
                String string3 = (String)this.m_commands.get(i);
                String string4 = (String)this.m_commands.get(j);
                this.m_commands.set(i, string4);
                this.m_commands.set(j, string3);
            }
        }
    }

    private void updateRecent(int n) {
        this.m_comboBoxHistory.removeActionListener(this);
        String string = (String)this.m_labels.get(n);
        if (this.m_comboBoxHistory.getItemCount() == 0 || !this.getComboBoxItem(0).equals(string)) {
            this.m_comboBoxHistory.insertItemAt(string, 0);
        }
        for (int i = 1; i < this.m_comboBoxHistory.getItemCount(); ++i) {
            if (!this.getComboBoxItem(i).equals(string)) continue;
            this.m_comboBoxHistory.removeItemAt(i);
        }
        this.m_comboBoxHistory.setSelectedIndex(0);
        this.m_firstIsTemp = false;
        this.m_recentModified = true;
        this.m_comboBoxHistory.addActionListener(this);
    }

    static {
        $assertionsDisabled = !AnalyzeDialog.class.desiredAssertionStatus();
    }

    public static interface Callback {
        public void clearAnalyzeCommand();

        public void setAnalyzeCommand(AnalyzeCommand var1, boolean var2, boolean var3, boolean var4);
    }
}

