/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.twogtp;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.PrintStream;
import java.text.NumberFormat;
import java.util.ArrayList;
import net.sf.gogui.twogtp.Entry;
import net.sf.gogui.utils.ErrorMessage;
import net.sf.gogui.utils.FileUtils;
import net.sf.gogui.utils.Histogram;
import net.sf.gogui.utils.Statistics;
import net.sf.gogui.utils.StringUtils;
import net.sf.gogui.version.Version;

public class Analyze {
    private boolean m_hasReferee;
    private int m_duplicates;
    private int m_errors;
    private int m_games;
    private int m_gamesUsed;
    private int m_lineNumber;
    private String m_black = "Black";
    private static final String COLOR_HEADER = "#91aee8";
    private static final String COLOR_INFO = "#e0e0e0";
    private String m_white = "White";
    private String m_referee = "-";
    private String m_blackCommand = "";
    private String m_refereeCommand = "";
    private String m_whiteCommand = "";
    private String m_size = "";
    private String m_komi = "";
    private String m_date = "";
    private String m_host = "";
    private String m_openings;
    private final ArrayList m_entries = new ArrayList(128);
    private final Statistics m_length = new Statistics();
    private final ResultStatistics m_statisticsBlack = new ResultStatistics();
    private final ResultStatistics m_statisticsReferee = new ResultStatistics();
    private final ResultStatistics m_statisticsWhite = new ResultStatistics();
    private final Statistics m_cpuBlack = new Statistics();
    private final Statistics m_cpuWhite = new Statistics();
    static final /* synthetic */ boolean $assertionsDisabled;

    public Analyze(String string, boolean bl) throws Exception {
        File file = new File(string);
        this.readFile(file);
        File file2 = new File(FileUtils.replaceExtension(file, "dat", "html"));
        File file3 = new File(FileUtils.replaceExtension(file, "dat", "summary.dat"));
        if (!bl) {
            if (file2.exists()) {
                throw new ErrorMessage("File " + file2 + " exists");
            }
            if (file3.exists()) {
                throw new ErrorMessage("File " + file3 + " exists");
            }
        }
        this.calcStatistics();
        this.writeHtml(file2);
        this.writeData(file3);
    }

    private void calcStatistics() {
        for (int i = 0; i < this.m_entries.size(); ++i) {
            Entry entry = (Entry)this.m_entries.get(i);
            ++this.m_games;
            if (entry.m_error) {
                ++this.m_errors;
                continue;
            }
            if (!entry.m_duplicate.equals("") && !entry.m_duplicate.equals("-")) {
                ++this.m_duplicates;
                continue;
            }
            ++this.m_gamesUsed;
            this.parseResult(entry.m_resultBlack, this.m_statisticsBlack);
            this.parseResult(entry.m_resultWhite, this.m_statisticsWhite);
            this.parseResult(entry.m_resultReferee, this.m_statisticsReferee);
            this.m_cpuBlack.add(entry.m_cpuBlack);
            this.m_cpuWhite.add(entry.m_cpuWhite);
            this.m_length.add(entry.m_length);
        }
    }

    private String getCommentValue(String string, String string2) {
        if (!$assertionsDisabled && !string.startsWith(string2)) {
            throw new AssertionError();
        }
        return string.substring(string2.length()).trim();
    }

    private String getCommentValueNbsp(String string, String string2) {
        return this.getCommentValue(string, string2).replaceAll(" ", "&nbsp;");
    }

    private void handleComment(String string) {
        if ((string = string.trim()).startsWith("Black:")) {
            this.m_black = this.getCommentValueNbsp(string, "Black:");
        } else if (string.startsWith("White:")) {
            this.m_white = this.getCommentValueNbsp(string, "White:");
        } else if (string.startsWith("Referee:")) {
            this.m_referee = this.getCommentValueNbsp(string, "Referee:");
            this.m_hasReferee = !this.m_referee.equals("") && !this.m_referee.equals("-");
        } else if (string.startsWith("BlackCommand:")) {
            this.m_blackCommand = this.getCommentValue(string, "BlackCommand:");
        } else if (string.startsWith("RefereeCommand:")) {
            this.m_refereeCommand = this.getCommentValue(string, "RefereeCommand:");
        } else if (string.startsWith("WhiteCommand:")) {
            this.m_whiteCommand = this.getCommentValue(string, "WhiteCommand:");
        } else if (string.startsWith("Size:")) {
            this.m_size = this.getCommentValue(string, "Size:");
        } else if (string.startsWith("Komi:")) {
            this.m_komi = this.getCommentValue(string, "Komi:");
        } else if (string.startsWith("Openings:")) {
            this.m_openings = this.getCommentValue(string, "Openings:");
        } else if (string.startsWith("Date:")) {
            this.m_date = this.getCommentValue(string, "Date:");
        } else if (string.startsWith("Host:")) {
            this.m_host = this.getCommentValue(string, "Host:");
        }
    }

    private void handleLine(String string) throws ErrorMessage {
        if ((string = string.trim()).startsWith("#")) {
            this.handleComment(string.substring(1));
            return;
        }
        String[] stringArray = string.split("\\t");
        if (stringArray.length < 10 || stringArray.length > 11) {
            this.throwErrorMessage("Wrong file format");
        }
        try {
            int n = Integer.parseInt(stringArray[0]);
            String string2 = stringArray[1];
            String string3 = stringArray[2];
            String string4 = stringArray[3];
            boolean bl = Integer.parseInt(stringArray[4]) != 0;
            String string5 = stringArray[5];
            int n2 = Integer.parseInt(stringArray[6]);
            double d = Double.parseDouble(stringArray[7]);
            double d2 = Double.parseDouble(stringArray[8]);
            boolean bl2 = Integer.parseInt(stringArray[9]) != 0;
            String string6 = "";
            if (stringArray.length == 11) {
                string6 = stringArray[10];
            }
            this.m_entries.add(new Entry(n, string2, string3, string4, bl, string5, n2, d, d2, bl2, string6));
        }
        catch (NumberFormatException numberFormatException) {
            this.throwErrorMessage("Wrong file format");
        }
    }

    private void parseResult(String string, ResultStatistics resultStatistics) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        double d = 0.0;
        String string2 = string.trim();
        try {
            if (!string2.equals("?")) {
                if (string2.indexOf("B+") >= 0) {
                    bl = true;
                    bl3 = true;
                    d = Double.parseDouble(string2.substring(2));
                    bl2 = true;
                } else if (string2.indexOf("W+") >= 0) {
                    bl = true;
                    bl3 = false;
                    d = -Double.parseDouble(string2.substring(2));
                    bl2 = true;
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        resultStatistics.m_unknownResult.add(bl ? 0.0 : 1.0);
        if (bl) {
            resultStatistics.m_win.add(bl3 ? 1.0 : 0.0);
        }
        resultStatistics.m_unknownScore.add(bl2 ? 0.0 : 1.0);
        if (bl2) {
            resultStatistics.m_histo.add(d);
        }
    }

    private void readFile(File file) throws Exception {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        this.m_lineNumber = 0;
        String string = null;
        while ((string = bufferedReader.readLine()) != null) {
            ++this.m_lineNumber;
            this.handleLine(string);
        }
        bufferedReader.close();
    }

    private void throwErrorMessage(String string) throws ErrorMessage {
        throw new ErrorMessage("Line " + this.m_lineNumber + ": " + string);
    }

    private void writeHtml(File file) throws Exception {
        Object object;
        String string = "game";
        if (file.getName().endsWith(".html")) {
            object = file.getName();
            string = ((String)object).substring(0, ((String)object).length() - 5);
        }
        object = new PrintStream(new FileOutputStream(file));
        NumberFormat numberFormat = StringUtils.getNumberFormat(1);
        String string2 = StringUtils.getDefaultEncoding();
        ((PrintStream)object).print("<html>\n<head>\n<title>" + this.m_black + " - " + this.m_white + "</title>\n" + "<meta http-equiv=\"Content-Type\"" + " content=\"text/html; charset=" + string2 + "\">\n" + "<meta name=\"generator\" content=\"TwoGtp " + Version.get() + "\">\n" + "</head>\n" + "<body bgcolor=\"white\" text=\"black\" link=\"#0000ee\"" + " vlink=\"#551a8b\">\n" + "<table border=\"0\" width=\"100%\" bgcolor=\"" + COLOR_HEADER + "\">\n" + "<tr><td>\n" + "<h1>" + this.m_black + " - " + this.m_white + "</h1>\n" + "</td></tr>\n" + "</table>\n" + "<table width=\"100%\" bgcolor=\"" + COLOR_INFO + "\">\n");
        this.writeHtmlRow((PrintStream)object, "Black", this.m_black);
        this.writeHtmlRow((PrintStream)object, "White", this.m_white);
        this.writeHtmlRow((PrintStream)object, "Size", this.m_size);
        this.writeHtmlRow((PrintStream)object, "Komi", this.m_komi);
        if (this.m_openings != null) {
            this.writeHtmlRow((PrintStream)object, "Openings", this.m_openings);
        }
        this.writeHtmlRow((PrintStream)object, "Date", this.m_date);
        this.writeHtmlRow((PrintStream)object, "Host", this.m_host);
        if (this.m_hasReferee) {
            this.writeHtmlRow((PrintStream)object, "Referee", this.m_referee);
        }
        this.writeHtmlRow((PrintStream)object, "Black command", this.m_blackCommand);
        this.writeHtmlRow((PrintStream)object, "White command", this.m_whiteCommand);
        if (this.m_hasReferee) {
            this.writeHtmlRow((PrintStream)object, "Referee command", this.m_refereeCommand);
        }
        this.writeHtmlRow((PrintStream)object, "Games", this.m_games);
        this.writeHtmlRow((PrintStream)object, "Errors", this.m_errors);
        this.writeHtmlRow((PrintStream)object, "Duplicates", this.m_duplicates);
        this.writeHtmlRow((PrintStream)object, "Games used", this.m_gamesUsed);
        this.writeHtmlRow((PrintStream)object, "Game length", this.m_length, numberFormat);
        this.writeHtmlRow((PrintStream)object, "CpuTime Black", this.m_cpuBlack, numberFormat);
        this.writeHtmlRow((PrintStream)object, "CpuTime White", this.m_cpuWhite, numberFormat);
        ((PrintStream)object).print("</table>\n<hr>\n");
        if (this.m_hasReferee) {
            this.writeHtmlResults((PrintStream)object, this.m_referee, this.m_statisticsReferee);
            ((PrintStream)object).println("<hr>");
        }
        this.writeHtmlResults((PrintStream)object, this.m_black, this.m_statisticsBlack);
        ((PrintStream)object).println("<hr>");
        this.writeHtmlResults((PrintStream)object, this.m_white, this.m_statisticsWhite);
        ((PrintStream)object).println("<hr>");
        ((PrintStream)object).print("<table border=\"0\">\n<thead>\n<tr bgcolor=\"#91aee8\">\n<th>Game</th>\n");
        if (this.m_hasReferee) {
            ((PrintStream)object).print("<th>Result [" + this.m_referee + "]</th>\n");
        }
        ((PrintStream)object).print("<th>Result [" + this.m_black + "]</th>\n" + "<th>Result [" + this.m_white + "]</th>\n");
        ((PrintStream)object).print("<th>Colors Exchanged</th>\n<th>Duplicate</th>\n<th>Length</th>\n<th>CpuTime Black</th>\n<th>CpuTime White</th>\n<th>Error</th>\n<th>Error Message</th>\n</tr>\n</thead>\n");
        for (int i = 0; i < this.m_entries.size(); ++i) {
            Entry entry = (Entry)this.m_entries.get(i);
            String string3 = string + "-" + entry.m_gameIndex + ".sgf";
            ((PrintStream)object).print("<tr align=\"center\" bgcolor=\"#e0e0e0\"><td><a href=\"" + string3 + "\">" + string3 + "</a></td>\n");
            if (this.m_hasReferee) {
                ((PrintStream)object).print("<td>" + entry.m_resultReferee + "</td>");
            }
            ((PrintStream)object).print("<td>" + entry.m_resultBlack + "</td>" + "<td>" + entry.m_resultWhite + "</td>");
            ((PrintStream)object).print("<td>" + (entry.m_alternated ? "1" : "0") + "</td>" + "<td>" + entry.m_duplicate + "</td>" + "<td>" + entry.m_length + "</td>" + "<td>" + entry.m_cpuBlack + "</td>" + "<td>" + entry.m_cpuWhite + "</td>" + "<td>" + (entry.m_error ? "1" : "") + "</td>" + "<td>" + entry.m_errorMessage + "</td>" + "</tr>\n");
        }
        ((PrintStream)object).print("</table>\n<hr>\n<address><small>Generated on " + StringUtils.getDateShort() + " by TwoGtp " + Version.get() + " (<a href=\"http://gogui.sf.net\">" + "http://gogui.sf.net</a>)</small></address>\n" + "</body>\n" + "</html>\n");
        ((PrintStream)object).close();
    }

    private void writeHtmlResults(PrintStream printStream, String string, ResultStatistics resultStatistics) throws Exception {
        NumberFormat numberFormat = StringUtils.getNumberFormat(1);
        printStream.print("<h2>Result [" + string + "]</h2>\n" + "<p>\n" + "<table border=\"0\">\n");
        this.writeHtmlRow(printStream, "Black score", resultStatistics.m_histo, numberFormat);
        this.writeHtmlRowPercentData(printStream, "Black wins", resultStatistics.m_win, numberFormat);
        printStream.print("<tr><th align=\"left\">Unknown Result:</th><td align=\"left\">" + numberFormat.format(resultStatistics.m_unknownResult.getMean() * 100.0) + "%" + "</td></tr>\n" + "<tr><th align=\"left\">Unknown Score" + ":</th><td align=\"left\">" + numberFormat.format(resultStatistics.m_unknownScore.getMean() * 100.0) + "%" + "</td></tr>\n" + "</table>\n" + "</p>\n");
        resultStatistics.m_histo.printHtml(printStream);
    }

    private void writeHtmlRow(PrintStream printStream, String string, String string2) throws Exception {
        printStream.print("<tr><th align=\"left\">" + string + ":</th>" + "<td align=\"left\">" + string2 + "</td></tr>\n");
    }

    private void writeHtmlRow(PrintStream printStream, String string, int n) throws Exception {
        this.writeHtmlRow(printStream, string, Integer.toString(n));
    }

    private void writeHtmlRow(PrintStream printStream, String string, Statistics statistics, NumberFormat numberFormat) throws Exception {
        String string2 = numberFormat.format(statistics.getMean()) + " (&plusmn;" + numberFormat.format(statistics.getError()) + ") <small>min=" + numberFormat.format(statistics.getMin()) + " max=" + numberFormat.format(statistics.getMax()) + " deviation=" + numberFormat.format(statistics.getDeviation()) + "</small>";
        this.writeHtmlRow(printStream, string, string2);
    }

    private void writeHtmlRowPercentData(PrintStream printStream, String string, Statistics statistics, NumberFormat numberFormat) throws Exception {
        printStream.print("<tr><th align=\"left\">" + string + ":</th>" + "<td align=\"left\">" + numberFormat.format(statistics.getMean() * 100.0) + "% (&plusmn;" + numberFormat.format(statistics.getError() * 100.0) + ")</td></tr>\n");
    }

    private void writeData(File file) throws Exception {
        PrintStream printStream = new PrintStream(new FileOutputStream(file));
        NumberFormat numberFormat = StringUtils.getNumberFormat(1);
        NumberFormat numberFormat2 = StringUtils.getNumberFormat(2);
        Histogram histogram = this.m_statisticsBlack.m_histo;
        Histogram histogram2 = this.m_statisticsWhite.m_histo;
        Histogram histogram3 = this.m_statisticsReferee.m_histo;
        Statistics statistics = this.m_statisticsBlack.m_win;
        Statistics statistics2 = this.m_statisticsWhite.m_win;
        Statistics statistics3 = this.m_statisticsReferee.m_win;
        Statistics statistics4 = this.m_statisticsBlack.m_unknownScore;
        Statistics statistics5 = this.m_statisticsWhite.m_unknownScore;
        Statistics statistics6 = this.m_statisticsReferee.m_unknownScore;
        printStream.print("#GAMES\tERR\tDUP\tUSED\tRES_B\tERR_B\tWIN_B\tERRW_B\tUNKN_B\tRES_W\tERR_W\tWIN_W\tERRW_W\tUNKN_W\tRES_R\tERR_R\tWIN_R\tERRW_R\tUNKN_R\n" + this.m_games + "\t" + this.m_errors + "\t" + this.m_duplicates + "\t" + this.m_gamesUsed + "\t" + numberFormat.format(histogram.getMean()) + "\t" + numberFormat.format(histogram.getError()) + "\t" + numberFormat2.format(statistics.getMean()) + "\t" + numberFormat2.format(statistics.getError()) + "\t" + numberFormat2.format(statistics4.getMean()) + "\t" + numberFormat.format(histogram2.getMean()) + "\t" + numberFormat.format(histogram2.getError()) + "\t" + numberFormat2.format(statistics2.getMean()) + "\t" + numberFormat2.format(statistics2.getError()) + "\t" + numberFormat2.format(statistics5.getMean()) + "\t" + numberFormat.format(histogram3.getMean()) + "\t" + numberFormat.format(histogram3.getError()) + "\t" + numberFormat2.format(statistics3.getMean()) + "\t" + numberFormat2.format(statistics3.getError()) + "\t" + numberFormat2.format(statistics6.getMean()) + "\n");
        printStream.close();
    }

    static {
        $assertionsDisabled = !Analyze.class.desiredAssertionStatus();
    }

    private static final class ResultStatistics {
        public Statistics m_unknownResult = new Statistics();
        public Statistics m_unknownScore = new Statistics();
        public Statistics m_win = new Statistics();
        public Histogram m_histo = new Histogram(-400.0, 400.0, 10.0);

        private ResultStatistics() {
        }
    }
}

