//----------------------------------------------------------------------------
// $Id: Print.java,v 1.2 2005/08/17 20:27:06 enz Exp $
// $Source: /cvsroot/gogui/gogui/src/net/sf/gogui/gogui/Print.java,v $
//----------------------------------------------------------------------------

package net.sf.gogui.gogui;

import java.awt.Component;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import net.sf.gogui.gui.SimpleDialogs;

//----------------------------------------------------------------------------

/** Print a printable. */
public final class Print
{
    public static void run(Component parent, Printable printable)
    {
        PrinterJob job = PrinterJob.getPrinterJob();
        job.setPrintable(printable);
        if (! job.printDialog())
            return;
        try
        {
            job.print();
        }
        catch (Exception e)
        {
            SimpleDialogs.showError(parent, "Printing failed");
        }
        SimpleDialogs.showInfo(parent, "Printing done");
    }

    /** Make constructor unavailable; class is for namespace only. */
    private Print()
    {
    }
}

//----------------------------------------------------------------------------
