// mode: -*- C++ -*-
#ifndef CONFIG_H
#define CONFIG_H

#include "SDL_types.h"
#include "SDL_video.h"
#include "SDL_keysym.h"
#include <string>
#include "common.h"

namespace {
    const Uint8 NUMBINDABLE = 3;
}

enum KEY_TYPE {
    KEY_SIDEBAR = 0, KEY_STOP, KEY_ALLY
};

struct ConfigType
{
    Uint32 videoflags;
    Uint16 width, height, bpp, serverport;
    Uint8 intro, gamemode, totalplayers, playernum,
        scrollstep, scrolltime, maxscroll, finaldelay, dispatch_mode;
    bool nosound, playvqa, allowsandbagging, debug;
    gametypes gamenum;
    SDL_GrabMode grabmode;
    SDLKey bindablekeys[NUMBINDABLE];
    Uint8 bindablemods[NUMBINDABLE];
    Uint8 buildable_radius;
    std::string mapname, vqamovie, nick, side_colour, mside, serveraddr; // ,disp_logname;
    double buildable_ratio;
};

const ConfigType& getConfig();

#endif /* CONFIG_H */
