#ifndef LOADINGSCREEN_H
#define LOADINGSCREEN_H

#include <string>
#include "SDL.h"
#include "SDL_thread.h"

class GraphicsEngine;
class CPSImage;

class LoadingScreen {
public:
    LoadingScreen();
    ~LoadingScreen();
    void setCurrentTask(const std::string& task);
    void increaseThingsDone();
    int getThingsDone() const {return thingsDone;}
    const std::string& getCurrentTask() const {
        return task_;
    }
private:
    // Non-copyable
    LoadingScreen(const LoadingScreen&) {}
    LoadingScreen& operator=(const LoadingScreen&) {return *this;}

    static int runRenderThread(void *inst);
    SDL_Thread *renderThread;
    SDL_mutex *lsmutex;
    CPSImage* logo;
    bool done;
    int thingsDone;
    std::string task_;
};

#endif /* LOADINGSCREEN_H */
