#include "SDL.h"

#include "common.h"
#include "mixvfs.h"
#include "filename.h"

using namespace std;

Uint32 loff;

void usage()
{
    printf("Usage: mixshell filename.mix\n");
}

void ls(MIXFiles* mixes)
{
    FData file;
    int i = 0;
    map<Uint32, MIXEntry>::iterator walker;
    map<Uint32, MIXEntry>::const_iterator end = mixes->mixheaders.end();
    for (walker = mixes->mixheaders.begin(); walker != end; ++walker) {
        file = translateID(walker->first);
        printf("%s", file.filename);
        i++;
        if (i & 4) {
            printf("\n");
            i = 0;
        } else {
            printf("\t");
        }
    }
    if (i!=0) {
        printf("\n");
    }
}

int main(int argc, char* argv[])
{
    MIXFiles* mixes;
    Uint32 offset, size;
    FILE* mf;
    char line[1024];
    char cmd[128];
    if (argc < 2)
    {
        usage();
        exit(1);
    }

    loff = 0;

    mf = fopen(argv[1], "r");

    if (0 == mf)
    {
        usage();
        return 1;
    }

    mixes = new MIXFiles();

    mixes->loadMix(mf, 0, true);

    while (strcmp(cmd, "quit"))
    {
        printf("> ");
        fgets(line, 1024, stdin);
        sscanf(line, "%s", cmd);
        if (!strcmp(cmd, "ls")) {
            ls(mixes);
        } else if (!strcmp(cmd, "cd")) {
            sscanf(line, "%s %s", cmd, line);
            if (strcasecmp(line+strlen(line)-4, ".mix")) {
                printf("You can only \"cd\" into mixfiles\n");
            } else if (mixes->getOffsetAndSize(line, &offset, &size) != 0 ) {
                delete mixes;
                mf = fopen(argv[1], "r");
                mixes = new MIXFiles();
                mixes->loadMix(mf, offset, true);
                loff = offset;
            }
        } else if (!strcmp(cmd, "get")) {
            sscanf(line, "%s %s", cmd, line);
            if (mixes->getOffsetAndSize(line, &offset, &size) != 0) {
                Uint8 *buff = new Uint8[size];
                FILE *of;
                fseek(mf, offset, SEEK_SET);
                fread(buff, size, 1, mf);
                of = fopen(line, "w");
                fwrite(buff, size, 1, of);
                fclose(of);
                delete[] buff;
            }
        } else if (strcmp(cmd, "quit")) {
            printf("Unknown command. Valid commands are:\n\tls\n\tcd\n\tget\n\tquit\n");
        }
    }
    delete mixes;
    return 0;
}
