
#include "galciv.h"



//EXPORT FUNCTIONS
SHORT EXPENTRY _Export ShipAttack(SHORT attacker, SHORT defender, HWND hwndWindow, GalaxyType *Galaxy);



/*local Functions*/
short GetDefense(GalaxyType *,SHORT );


/*
--------- FUNCTION -------------------------------------------------------------
Ship Attack:
Receives the attacking ship and the defending ship.
Returns the ship that is destroyed.
---------------------------------------------------------------------------------
*/

// attacker:   The ship index of the attacking ship
// defender:   The ship index of the defending ship
// hwndWindow: handle to the main quadrant map
// Galaxy:     All the important variables in the game.

SHORT EXPENTRY ShipAttack(SHORT attacker, SHORT defender, HWND hwndWindow, GalaxyType *Galaxy)
{
BOOL Complete=FALSE;
SHORT Attack;
SHORT Defense;
SHORT Loser;
SHORT FirstRound=0;
SHORT Defender;
SHORT Strength_Defender;
SHORT Strength_Attacker;





//Strenght is how many hitpoints each ship has.
Strength_Defender=Galaxy->StarShip[defender].strength;
Strength_Attacker=Galaxy->StarShip[attacker].strength;



//Defense Value
//The defender gets a bonus if it is in orbit
if(Galaxy->StarShip[defender].orbitting>0)
	 Defender=GetDefense(Galaxy,defender)+3;
   else
    Defender=Galaxy->StarShip[defender].def;


//If the attacker has no weapons, it's doomed.
if(Galaxy->StarShip[attacker].att==0)return attacker;

//If the defender has no weapons and is in orbit it is doomed.
//This keeps people from parking colony ships and transports as defenders.
if((Galaxy->StarShip[defender].att==0)&&
   (Galaxy->StarShip[defender].orbitting>0))return defender;



//Begin the battle
while(Complete==FALSE)
{




   //Attack Value
	Attack=rand()%((Galaxy->StarShip[attacker].att)+1);

	//Defense Value.  First few rounds the attacker has the advantage.
	if(FirstRound<2)
		Defense=rand()%(Defender+1);
	else
		Defense=rand()%(Galaxy->StarShip[defender].att+1);


	//Whoever loses the round takes damage.
	if(Attack>=Defense)
		Strength_Defender-=((Attack-Defense)+1);
	else
		Strength_Attacker-=((Defense-Attack)+1);




	//If someone has no strength then they have been destroyed.
	if(Strength_Attacker<=0)
	{
      Galaxy->StarShip[defender].strength=Strength_Defender;
      return attacker;
	}
	else
	if(Strength_Defender<=0)
	{
      Galaxy->StarShip[attacker].strength=Strength_Attacker;
		return defender;
	}


}


return 0;
}


// Adds up bonus's for ships that are in orbit.
short GetDefense(GalaxyType *Galaxy,SHORT ship)
{
short Defense=0;
short subtotal=0;
short world;
short i;

Defense=Galaxy->StarShip[ship].def;

if(Galaxy->StarShip[ship].orbitting>0)
{
	world=Galaxy->StarShip[ship].orbitting;
	Defense=Defense*1.5;
	for(i=1;i<const_imps;i++)
		if(Galaxy->WorldNumber[world].attributes[i]>0)
		{
			subtotal=subtotal+Galaxy->Improvement[i].DefenseBonus;
			subtotal=subtotal+Galaxy->Improvement[i].PlanetDefenseBonus;
		}

	for(i=1;i<const_wonds;i++)
		if(Galaxy->WorldNumber[world].wonders[i]>0)
			subtotal=subtotal+Galaxy->Wonder[i].DefenseImprovement;

	subtotal+=100;
	Defense=(Defense*subtotal)/100;
}


return Defense;
}

