//=======================================================================
//@V@:Note: This file generated by vgen V1.02 (04:22:44 PM 04 Feb 1997).
//	wlnapp.cpp:	Source for wlnApp class
//=======================================================================

////////////////////////////////////////////////////////////////////////////
// This file is a module in the program Zero Point, a video game program  //
// for Linux X11 and Windows.                                             //
//                                                                        //
// Copyright (C) 1996, 1997, 1998 by Enumerate Inc.                       //
//                                                                        //
// Enumerate Inc. can be contacted at enumerate@rocketmail.com            //
//                                                                        //
// This file is licensed within the terms of the GNU General Public       //
// License version 2 or later. This source code may freely redistributed  //
// or modified within the terms of that license, as described in the file //
// 'COPYING' which should be included with any redistribution of this     //
// file. If the file COPYING is not available, a copy of the General      //
// Public License can be obtained from the Free Software Foundation, Inc. //
// 675 Mass Ave., Cambridge, MA 02139.                                    //
//                                                                        //
// THIS PROGRAM IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER  //
// EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED       //
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.    //
// THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THE PROGRAM IS    //
// WITH YOU.  SHOULD THE PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF  //
// ALL NECESSARY SERVICING, REPAIR OR CORRECTION.                         //
//////////////////////////////////////////////////////////////////////////// 

#include <string.h>
#include <v/vkeys.h>
#include <v/vnotice.h>
#include <v/vreply.h> 
#include <v/vutil.h>    //IntToStr()

#ifdef __WIN32S__
#include <strstrea.h>    //8-char file names
#else
#include <strstream.h>  //ostrstream in 
#endif


#include <fstream.h>
#include <values.h>
//#include <unistd.h>   //sleep() used in some diagnostic cerr's 

#include "wlndefs.h"    //lvlStat
#include "wlnynmdg.h"   //wlnYNDialog
#include "wlnapp.h"		// Header file
#include "genArray.h"
//#include "wlncnv.h"


#ifdef __WINDOWS__
//#define DBG
//#include "errline.h"

static int sleep(size_t tim){
  int revco;
  double ronco, walmart;
  ronco = MAXINT;
  for(revco = 0; revco++; revco < tim){
    for(size_t i = 0; i++ ; i < MAXLONG){
      walmart = ronco * i;
      walmart += revco;
    }
  }
  return (int)(walmart/MAXDOUBLE);
}

#endif //__WINDOWS__
//=========================>>> wlnApp::wlnApp <<<==========================

//The following commented definitions have all moved to wlndefs.h

//int Slow = 100;
//int pollies = 50, aLim = 15, MaxX = 600, MaxY = 400, stepsPerColor = 13, startLives = 4;

// indices:             0   1    2   3   4    5    6  7   8   9
//static int optInts[] = {1, 15, 100, 50, 1, 600, 400, 4, 15, 10, 0};

//sanity's helpers (these numbers are inclusive)
//static int optMins[] = {1, 6, 51, 7, 1, 200, 200, 1, 5, 5, 0};
//static int optMaxs[] = {99, 30, 600, 200, 50, 1024, 768, 12, 25, 10, 0};
//static int optDefs[] = {1, 15, 100, 50, 13, 600, 400, 4, 15, 10, 0};

//static char* optlist[] = {"DefStartLevel", "Speedlim", "MaxDelay", "NPollies",
//			  "StepPClr", "MaxX", "MaxY", "StartLives", "NSaved",
//				"NHigh", NULL};

//this enumeration allows a fake associative array
//enum {DefStartLevel, Speedlim, MaxDelay, NPollies, StepPClr, MaxX, MaxY,
//    StartLives, NSaved, NHigh};


#ifdef __WINDOWS__
extern const char* GAP = "\t";
//optInts[MaxDelay] = 75;
#else
extern const char* GAP = "     ";
#endif


wlnApp::wlnApp(char* name, int sdi, int h, int w) : vApp(name, sdi, h, w)
{
  // Constructor
  //size_t i;
  Notifier = NULL;  //ensure that we can test whether this exists or not
  if(!readrc()){
    parseOptions();
  }
  vPoint theSize = { optInts[MaxX], optInts[MaxY] };
  aWalk = new polyWalk(2, optInts[NPollies], optInts[Speedlim], optInts[MaxDelay], theSize);
  if(!aWalk) {
    tellIt("Unable to allocate memory for PolyWalk in wlnApp Constructor.");
    Exit();
  }
  _wlnCmdWin = 0;
  //level = 1;
  score = 0;
  stepping = 1;
  inPractice = 0;
  counter = 0;  //count number of steps--helps for status display and color
  level = optInts[DefStartLevel];
  lives = optInts[StartLives];
  inDemo = 0;
  starting = 3;
  // nextLevel();
}

//=========================>>> wlnApp::wlnApp <<<==========================
wlnApp::~wlnApp()
{
  // Destructor
  if (_wlnCmdWin)
    delete _wlnCmdWin;
  if(aWalk){
    delete aWalk;
  }
  delete Notifier;
}

//=====================>>> wlnApp::NewAppWin <<<==========================
vWindow* wlnApp::NewAppWin(vWindow* win, char* name,
			   int w, int h, vAppWinInfo* winInfo)
{
  vAppWinInfo* awinfo = winInfo;
  char *appname = name;

  if (!*name)
    {
      appname = "ZeroPoint";		// Default name
    }

  UserDebug1(Build,"wlnApp::NewAppWin(%s)\n",appname);

  // Create the first window using provided CmdWindow

  _wlnCmdWin = (wlnCmdWindow*) win;
  if (!_wlnCmdWin)
    {
      _wlnCmdWin = new wlnCmdWindow("ZeroPoint", w, h);
    }
  
  Notifier = new vNoticeDialog(this);
  
  if (!awinfo)
    awinfo = new vAppWinInfo(appname);

  return vApp::NewAppWin(_wlnCmdWin, appname, w, h, awinfo);
}

//============================>>> wlnApp::Exit <<<===========================
void wlnApp::Exit(void)
{
  // This is called to close all windows.

  vApp::Exit();		// Default behavior
}

//======================>>> wlnApp::CloseAppWin <<<===========================
int wlnApp::CloseAppWin(vWindow* win)
{
  // This will be called BEFORE a window has been unregistered or
  // closed.  Default behavior: unregister and close the window.

  UserDebug(Build,"wlnApp::CloseAppWin()\n");

  wlnYNDialog* Really;
  int theReply, stp;
  UserDebug(Build,"wlnApp::Exit()\n");
  pause(true);
  Really = new wlnYNDialog(_wlnCmdWin, "Quit the game");
  theReply = Really->AskYN("You want to quit?\n              ");
  if(theReply > 0){
    highScrQ();
    return vApp::CloseAppWin(win);
  } else {
    pause(false);
    return false;
  }
  delete Really;
  //return vApp::CloseAppWin(win);
}

//=====================>>> wlnApp::AppCommand <<<==============================
void wlnApp::AppCommand(vWindow* win, ItemVal id, ItemVal val, CmdType cType)
{
  // Commands not processed by the window will be passed here
  UserDebug1(Build,"wlnApp::AppCmd(ID: %d)\n",id);
  wlnYNDialog* Really;
  int theReply, stp;
  //cerr << "AppCommand: level " << level << endl; sleep(1);
  switch(id){
  case WLN_NewGame10:
    pause(true);
    Really = new wlnYNDialog(_wlnCmdWin, "Start at Level 10");
    theReply = Really->AskYN("So you want to try starting at level 10?\n     ");
    if(theReply > 0){
      highScrQ();
      pause(false);
      startAtLevel(10);
    } else {
      pause(false);
    }
    delete Really;
    break;
  case WLN_RestartLevel:
    pause(true);
    Really = new wlnYNDialog(_wlnCmdWin, "Restart the same level");
    theReply = Really->AskYN("Do you want to take another crack at this level?\n                    ");
    if(theReply > 0){
      pause(false);
      restartLevel();
    } else {
      pause(false);
    }
    delete Really;
    break;
  case M_Exit:
    Exit();
    break;
  case mnuPause:
    if(stepping){
      pause(true);
    }else {
      pause(false);
    }
    break;
  case M_New: 
    pause(true);
    Really = new wlnYNDialog(_wlnCmdWin, "New Game");
    theReply = Really->AskYN("Do you really want to start a new game?\n");
    //cout << "theReply == " << theReply << endl;
    if(theReply > 0){
      highScrQ();
      practiceMode(false);
      SetValueAll(mnuPractice, false, Checked);
      _wlnCmdWin->actMDlg("Starting ZeroPoint");
    } else {
      pause(false);
    }
    delete Really;
    break;
  case mnuPractice:
    pause(true);
    if(!practicing()){
      Really = new wlnYNDialog(_wlnCmdWin, "Change to Practice Mode");
      theReply = Really->AskYN("Do you want to change to Practice Mode?");
      if(theReply > 0){
	highScrQ();
	practiceMode(true);
	SetValueAll(mnuPractice, true, Checked);
	level--;
	pause(false);
	nextLevel();
      }
    } else {
      //SetValueAll(mnuPractice, false, Checked);
      //practiceMode(false);
      SendWindowCommandAll(M_New, 0, C_Menu);
    }
    pause(false);
    break;
  case btnDemo:
  case btnStartDemo:
    pause(true);
    highScrQ();
    pause(false);
    _wlnCmdWin->runTheDemo();
    break;
  case mnuHigh:
    pause(true);
    _wlnCmdWin->showHi();
    pause(false);
    break;
  default:
    vApp::AppCommand(win, id, val, cType);
  }//switch
}//AppCommand

int wlnApp::restartLevel(){
  //cerr << "restart: level " << level << endl; sleep(1);
  if(aWalk == NULL){
    tellIt("Don't try to use restartLevel() before constructing aWalk!\n");
    Exit();
  }
  counter = 0;
  _wlnCmdWin->getCanvas()->Clear();
  //vNoticeDialog noteThis(this);
  size_t nbrSides = aWalk->tellNumSides(),
    nbrPoly = optInts[NPollies],
    vlLim = optInts[Speedlim],
    aDelay = optInts[MaxDelay] - (((level + 2) % 3) * 25);
  vPoint aSize = aWalk->tellSize();
  bonus = setStart();
  delete aWalk;
  aWalk = new polyWalk(nbrSides, nbrPoly, vlLim, aDelay, aSize);
  if(!aWalk){
    if(_wlnCmdWin)
      tellIt("Unable to allocate memory for new walk in nextLevel()            ");
    Exit();
  }
  //noteThis.Notice("  Press OK when you're ready to start the level.");
  pause(false);
  EnableWorkSlice(aDelay);
  return level;
}//wlnApp::restartLevel()

int wlnApp::nextLevel(){
#ifdef DBG
  ostrstream debOut;
  debOut << "nextLevel, level is " << level << ends;
  debStat (debOut.str());
  sleep(2);
  delete debOut.str();
#endif
  //cerr << "nextlevel1: level " << level << endl; sleep(1);
  int sides, delay;
  vNoticeDialog noteThis(this, "Next Level      ");
  ostrstream output;
  //char tempStr[256];
  vPoint aSize;
  if(aWalk){
    aSize = aWalk->tellSize();
  } else {
    aSize.x = optInts[MaxX];
    aSize.y = optInts[MaxY];
  }
  sides = ((level - 1) / 3) + 2;  //this is still the previous level
  int stp = stepQ();
  if(stp) stepOff();           //hold everything while we figure this out
  EnableWorkSlice(0);     //ditto
  //cerr << "nextlevel2: level " << level << "  starting: " << starting << endl; sleep(1);

  //output the stat's from the previous level.
  if(level > 0 && starting <= 0 ){
    if(!practicing()){
      output << GAP << "Your score for this level is: " << bonus << endl;
      if(starting){
	score = (level - 1) * 1000L;
	starting = 0;
	if(level > 1){
	  output << GAP << "Your level " << level << " start bonus is: " <<
	    score << endl;
	}
      }
      score += bonus;
      output << GAP << "Your new total score is: " << score << endl << endl;
    }//if(!practicing())
    //cerr << "nextlevel3: level " << level << endl; sleep(1);
    output << endl << GAP << "Press OK or hit Enter to start level " <<
      (level + 1) << ends;
    if(!starting){
      noteThis.Notice(output.str());
    }
    //output.freeze(0); //free up the storage (not compatible with BCPP 4.5
    output.seekp(0);  //reset for further use
  }//if(level > 0 && starting < 0)
  if(starting > 0) starting -= 2;
  level++;

  //set up and create the new walking polygon.
  sides = ((level - 1) / 3) + 2;
  delay = optInts[MaxDelay] - (((level - 1) % 3) * 25);
  bonus = setStart();   //bonus depletes 1 every step
  if(aWalk) delete aWalk;
  aWalk = new polyWalk(sides, optInts[NPollies], optInts[Speedlim], delay, aSize);
  //  if(sides == 2) sides = 1; //not sensible to write about a 2-sided polygon
  if(!aWalk){
    if(_wlnCmdWin)
      tellIt("Unable to allocate memory for new walk in nextLevel()");
    Exit();
  }
  //cerr << "nextlevel4: level " << level << endl; sleep(1);

  counter = 0;
  if(_wlnCmdWin){
    _wlnCmdWin->getCanvas()->Clear();
  }

  writeStatus();
  //if(stp) stepOn();
  pause(false);
  EnableWorkSlice(delay);
  delete output.str();
  return level;
}//wlnApp::nextLevel()

void wlnApp::writeStatus(){
  char tempStr[256];
  int tempLives;
  //Put the score etc. into the status bar.
  IntToStr(level, tempStr);
  SetStringAll(lvlStat, tempStr);
  if(!practicing()){
    LongToStr(score, tempStr);
    SetStringAll(scrStat, tempStr);
    IntToStr(bonus, tempStr);
    SetStringAll(bonStat, tempStr);
    if(lives < 0){
      tempLives = 0;
    } else {
      tempLives = lives;
    }
    IntToStr(tempLives, tempStr);
    SetStringAll(liveStat, tempStr);
    SetStringAll(lblEscStat, "Esc: Quit, P: Pause");
  } else { //if(!practicing())
    strcpy(tempStr, " ");
    SetStringAll(scrStat, tempStr);
    SetStringAll(bonStat, tempStr);
    SetStringAll(liveStat, tempStr);
    if(!demoing()){
      SetStringAll(lblEscStat, " Practice Mode ");
      //    } else { 
      //SetStringAll(lblEscStat, " ");
    }
  }
}//writeStatus()

int wlnApp::startAtLevel(int theLevel){
  if(starting <= 0){
    starting = 1;
  }
  //cerr << "startatlevel: level " << level << "  starting=" << starting << endl; sleep(1);
  level = theLevel - 1;
  score = 0;
  counter = 0;
  lives = optInts[StartLives];
  writeStatus();
#ifdef DBG
  ostrstream debOut;
  debOut << "startAtLevel, level is " << level << ends;
  sleep(2);
  debStat (debOut.str());
  delete debOut.str();
#endif
  //cerr << "ending start: level " << level << endl; sleep(1);
  return nextLevel();
}//wlnApp::startAtLevel(int)

void wlnApp::KeyFake(vKey key, unsigned int shift){
  switch(key){
  case vk_Up:
  case vk_KP_Up:
  case vk_KP_8:
    pause(false);
    aWalk->getVels().yadd(-1);
    break;
  case vk_Down: 
  case vk_KP_Down:
  case vk_KP_2:
    pause(false);
    aWalk->getVels().yadd(1);
    break;
  case vk_Right:
  case vk_KP_Right:
  case vk_KP_6:
    pause(false);
    aWalk->getVels().xadd(1);
    break;
  case vk_Left:
  case vk_KP_Left:
  case vk_KP_4:
    pause(false);
    aWalk->getVels().xadd(-1);
    break;
  case vk_KP_Home:
  case vk_KP_7:
    pause(false);
    aWalk->getVels().xadd(-1);
    aWalk->getVels().yadd(-1);
    break;
  case vk_KP_Page_Up:
  case vk_KP_9:
    pause(false);
    aWalk->getVels().xadd(1);
    aWalk->getVels().yadd(-1);
    break;
  case vk_KP_Page_Down:
  case vk_KP_3:
    pause(false);
    aWalk->getVels().xadd(1);
    aWalk->getVels().yadd(1);
    break;
  case vk_KP_End:
  case vk_KP_1:
    pause(false);
    aWalk->getVels().xadd(-1);
    aWalk->getVels().yadd(1);
    break;
  case int('P'):
  case int('p'):
    if(stepQ()){
      pause(true);
    } else {
      pause(false);
    }
    break;
  case vk_Escape:
    if(practicing()){
      practiceMode(false);
      SetValueAll(mnuPractice, false, Checked);
      SendWindowCommandAll(M_New, 1, C_Blank);
    } else {
      CloseAppWin(_wlnCmdWin);
    }
    break;
  default: 
    pause(false);
  }//switch
}//keyFake()

//=========================>>> wlnApp::KeyIn <<<==============================
void wlnApp::KeyIn(vWindow* win, vKey key, unsigned int shift)
{
  // Key strokes not processed by the window will be passed here
  int t, l, w, h;
  _wlnCmdWin->GetPosition(l,t,w,h);
  if(w > minRun && h > minRun){
    KeyFake(key, shift);
  } else {  //if(size is big enough)
    stepping = 0;
  }
  vApp::KeyIn(win, key, shift);
}//void wlnApp::KeyIn

#ifdef DBG
void wlnApp::debStat(char* msg){   //send a debug message to the status bar
  SetStringAll(lblEscStat, msg);
}
#endif

int wlnApp::pause(bool on){
  if(on){
    stepOff();
    SetValueAll(mnuPause, true, Checked);
  } else {
    stepOn();
    SetValueAll(mnuPause, false, Checked);
  }
  return stepping;
}


int wlnApp::step(){
  char tempStr[256];
  static int alreadyHere;
  static int afterThis;
#ifdef DBG
  ostrstream dbgOut;
#endif
  if(!afterThis){
    afterThis = 1;
    stepping = 0;
    if(_wlnCmdWin->showShare("Welcome to ZeroPoint") == btnStartDemo){
      _wlnCmdWin->runTheDemo();
    }
  }//afterThis
  if(!alreadyHere && _wlnCmdWin->getCanvas()){  //odd that we need to check
    alreadyHere = 1;
    int anyVel = 0, colorIx;
#ifdef DBG
    dbgOut << "step: level is " << level << ends;
    debStat(dbgOut.str());
    sleep(2);
    delete dbgOut.str();
#endif
    //cerr << "step: level " << level << endl; sleep(1);
    if(stepping){
      if(!(counter % 10)){ //print every tenth iter
	if(counter >= 10){
	  bonus -= 10;
	  IntToStr(bonus, tempStr);
	  if(!practicing()){
	    _wlnCmdWin->SetString(bonStat, tempStr);
	  }
	} else {
	  writeStatus(); //first time through
	  if(practicing()){
	    SetValueAll(mnuPractice, true, Checked);
	  }
	}
      }
      if(bonus <= 0 && !practicing()) {
	loseALife();
      }
      vColor tempVC;
      wlnCanvasPane * tempCnv = _wlnCmdWin->getCanvas();
      aWalk->backPoly().setColor(0); //assume black for background
      tempCnv->drawWlnPoly(aWalk->backPoly()); //erase it
      colorIx = ((counter++ / optInts[StepPClr]) % (nSC - 1)) + 1;
      if(counter > 20000) counter %= nSC;
      anyVel = aWalk->step(colorIx);
      //IntToStr(colorIx, tempStr);
      //_wlnCmdWin->SetString(clrStat, tempStr);
      tempCnv->drawWlnPoly(aWalk->frontPoly());


      //demo stuff
      polygon tempVels;
      int velFlag, tempX, tempY;
      static int checkpt;
      if(demoing() ){
	checkpt++;
	//cerr << "Got to demo part of step, counter == " << counter << endl;
	if((counter % 5) == 4){
	  SendWindowCommandAll(demoClrKeys, 1, C_Button);
	  SetStringAll(lblEscStat, " ");
	  //cerr << "Sent command to clear keys. " << endl;
	}
	if(!(counter % 5) || checkpt > 50){
	  if(!anyVel){
	    SetStringAll(lblEscStat, " Wait for end ");
	  } else { //if(!anyVels)
	    velFlag = 0;
	    tempVels = aWalk->getVels();
	    tempX = tempVels.getPoints()[0].x + tempVels.getPoints()[1].x;
	    tempY = tempVels.getPoints()[0].y + tempVels.getPoints()[1].y;
	    if(tempX > 0) {
	      SendWindowCommandAll(arrowLeft, 1, C_IconButton);
	      KeyFake(vk_Left,0);
	      SetStringAll(lblEscStat, "Left          ");
	      checkpt = 0;
	      //velFlag += 2;
	    } else { //if(tempX > 0)
	      if(tempX < 0) {
		SendWindowCommandAll(arrowRight, 1, C_IconButton);
		KeyFake(vk_Right,0);
		SetStringAll(lblEscStat, "          Right");
		checkpt = 0;
		//velFlag += 4;
	      } else { //if(tempX < 0)
		if(tempY > 0) {
		  SendWindowCommandAll(arrowUp, 1, C_IconButton);
		  KeyFake(vk_Up,0);
		  SetStringAll(lblEscStat, "      Up      ");
		  checkpt = 0;
		  //velFlag += 8;
		} else { //if(tempY > 0)
		  if(tempY < 0) {
		    SendWindowCommandAll(arrowDown, 1, C_IconButton);
		    KeyFake(vk_Down,0);
		    SetStringAll(lblEscStat, "     Down     ");
		    checkpt = 0;
		    //velFlag += 16;
		  } else { //if(tempY < 0)
		    SetStringAll(lblEscStat, "");
		  }
		}
	      }
	    }//else if(tempX > 0)
	  }
	  //SendWindowCommandAll(demoKeyPress, velFlag, C_Button);
	  //cerr << "Sent cmd to press keys: velFlag == " << velFlag << endl;
	  if(checkpt > 300){
	    KeyFake(vk_Up, 0);
	    KeyFake(vk_Right, 0);
	    SetStringAll(lblEscStat, "Desperation: Up and Right");
	    checkpt = 0;
	  }//stir things up if it takes too long to resolve
	}//if(!(counter % 5))
      }//if(demoing()

      if(! anyVel) aWalk->closing(1);
      if(aWalk->allDone()) {
	aWalk->frontPoly().setColor(0);
	tempCnv->drawWlnPoly(aWalk->frontPoly());
	stepping = 0;
	SendWindowCommandAll(WLN_LevelDone, 1, C_Button);
	if(!demoing()){
	  nextLevel();
	} else {
	  restartLevel();
	}
      }
    }
    alreadyHere = 0;
    return anyVel;
  }
  return -1;
}//step()

int wlnApp::readrc() {
  genArray<char> tempArr; 
  char* templine;
  char tempc = ' ';
  ifstream rcFile("zeropt.rc");
  char * comment;
  long chunk;
  char * pointer;
  size_t tempst, length, i, n;
  //rcFile.open("zeropt.rc");
  highscores.setSize(0);
  saves.setSize(0);
  options.setSize(0);
  if(rcFile){
    while(rcFile.good()){
      //cerr << "\nrcFile.good() == " << rcFile.good();
      tempArr.setSize(0);
      //cerr << "tempArr is " << tempArr.getArray();
      while(tempc != '\n' && !rcFile.eof()){
	rcFile.get(tempc);
	tempArr.append(tempc);
      }
      tempc = '\0'; //reset for next time through the while loop
      tempArr.append(tempc); //terminate the string
      templine = tempArr.getArray();
      //rcFile.getline(templine, 255);
      //cerr << "\nThe current line of the rc file is: \n" << templine;
      if(rcFile.bad() && !rcFile.eof()){
	tellIt( "\nAborting rc file processing prematurely. There is a problem with the file.\n There may be a line that is too long.\n");
	return 1;
      }
      //cerr << "\nrcFile.good() == " << rcFile.good();
      if(comment = strchr(templine, '#')){ //discard comment if present
	length = comment - templine;
      } else {
	length = strlen(templine);
      }
      if(strchr(templine, '~')) {       //is this a saved game or high score?
	if(strcspn(templine, "~") == 4){ //high score
	  if(strstr(templine, "High") == templine){ //first thing
	    pointer = templine;
	    //cerr << "\nHigh score ";
	    tempst = highscores.tellSize();
	    pointer = strchr(templine, '~');  //throw away label
	    pointer = strchr(pointer, '=');      //throw away name
	    if(pointer)pointer++;
	    //if(chunk = strtok(NULL, "~");      //get the value
	    //cerr << chunk << " ";
	    //if(chunk == "") chunk = " ";
	    chunk = strchr(pointer, '~') - pointer;
	    if(chunk >= rcnamesz) chunk = rcnamesz - 1;
	    if(chunk > 0 && pointer != NULL){
	      strncpy(highscores[tempst].name, pointer, chunk);  //store name
	    }else{
	      highscores[tempst].name[0] = '\0';
	    }
	    highscores[tempst].name[rcnamesz - 1] = '\0';   //ensure null terminate
	    pointer = strchr(pointer, '=');
	    if(pointer) pointer++;
	    chunk = strchr(pointer, '~') - pointer;
	    //cerr << chunk << " ";
	    if(chunk > 0 && pointer != NULL){
	      highscores[tempst].aLevel = atoi(pointer);
	    }	else {
	      highscores[tempst].aLevel = highscores[tempst-1].aLevel;
	    }
	    pointer = strchr(pointer, '=');
	    if(pointer) pointer++;
	    chunk = strchr(pointer, '~') - pointer;
	    if(chunk < 0) { 
	      chunk = strchr(pointer, '\n') - pointer;
	    }
	    //cerr << chunk << " ";
	    if(chunk > 0 && pointer != NULL) {
	      highscores[tempst].aScore = atoi(pointer);
	    } else {
	      highscores[tempst].aScore = highscores[tempst-1].aScore;
	    }
	    //cerr << endl << highscores[tempst].name << "  " <<
	    //highscores[tempst].aLevel << "  " <<
	    //highscores[tempst].aScore ;
	  }//does it say High?
	} else {
	  if(strcspn(templine, "~") == 5){ // saved game
	    if(strstr(templine, "Saved") == templine){
	      pointer = templine;
	      tempst = saves.tellSize();
				//cerr << "\nSaved game  ";
	      pointer = strchr(templine, '~'); //throw away label
	      pointer = strchr(pointer, '=');      //throw away name
	      if(pointer) pointer++;
	      chunk = strchr(pointer, '~') - pointer;      //get the value
	      if(chunk >= rcnamesz) chunk = rcnamesz - 1;
	      if(chunk > 0 && pointer != NULL){
				//cerr << chunk << " ";
		strncpy(saves[tempst].name, pointer, chunk);  //store name
		saves[tempst].name[rcnamesz - 1] = '\0';   //ensure null terminate
	      }else{
		saves[tempst].name[0] = '\0';
	      }
	      pointer = strchr(pointer, '=');
	      if(pointer) pointer++;
	      chunk = strchr(pointer, '~') - pointer;
				//cerr << chunk << " ";
	      if(chunk > 0 && pointer != NULL) {
		saves[tempst].aLevel = atoi(pointer);
	      }else{
		saves[tempst].aLevel = 1;
	      }
	      pointer = strchr(pointer, '=');
	      if(pointer) pointer++;
	      chunk = strchr(pointer, '~') - pointer;
				//cerr << chunk << " ";
	      if(chunk > 0 && pointer != NULL){
		saves[tempst].aScore = atol(pointer);
	      }else{
		saves[tempst].aScore = 1;
	      }
	      pointer = strchr(pointer, '=');
	      if(pointer) pointer++;
	      chunk = strchr(pointer, '~') -  pointer;
				//cerr << chunk << " ";
	      if(chunk < 0){
		chunk = strchr(pointer, '\n') - pointer;
	      }
	      if(chunk > 0 && pointer != NULL){
		saves[tempst].nLives = atoi(pointer);
	      }else{
		saves[tempst].nLives = 1;
	      }
	    }//does it say Saved?
	  }//if(strcsp...   //saved game
	}//else   if(strcsp.... //high score
      } else {//if(strchr(templine...  //high score/saved game? or option value:
	if(strchr(templine, '=')) {  //name=value pair
	  //cerr << "\nOption value: ";
	  tempst = options.tellSize();
	  chunk = strchr(templine, '=') - templine;
	  //cerr << chunk << " ";
	  if(chunk > 0)
	    strncpy(options[tempst].name, templine, chunk);  //store name
	  options[tempst].name[rcnamesz - 1] = '\0';   //ensure null terminate
	  chunk++;
	  options[tempst].value = atoi(templine + chunk);
	  //cerr << chunk << " ";
	}
      }//else
    }//while(rcFile.good())
  }//if(rcfile)
  //filling out the high scores list
  //if(highscores.tellSize() < optInts[NHigh]){
  //n =  highscores.tellSize();
  //for(i = n; i < optInts[NHigh]; i++){
  //strcpy(highscores[i].name, "Ron");  //store name
  //highscores[i].aLevel = 1;
  //highscores[i].aScore = 10;
  //}
  //}
  return 0;
}//readrc

int wlnApp::parseOptions(){
  char* optstr = "Option";
  int optIdx = 0, i, n;
  n = options.tellSize();
  optstr = optInts.getList()[optIdx];
  while(optstr){
    for(i = 0; i < n; i++){
      if(!strcmp(options[i].name, optstr)){
	optInts[optIdx] = options[i].value;
	if(optInts[optIdx] < optInts.getMins()[optIdx]){
	  optInts[optIdx] = optInts.getMins()[optIdx];
	}
	if(optInts[optIdx] > optInts.getMaxs()[optIdx]){
	  optInts[optIdx] = optInts.getMaxs()[optIdx];
	}
	break;  //only take first match
      }
    }
    optstr = optInts.getList()[++optIdx];
  }
  return 0;
}//parseOptions()

//returns 0 on success
int wlnApp::writerc(){
  char tempstr[256];
  ifstream rcinfile("zeropt.rc", ios::ate|ios::in);
  if(rcinfile.bad()){
#ifdef __WINDOWS__
    //errLine lerr(_wlnCmdWin);
    //lerr << "writerc: unable to open previous config file.\n";
#else
    //cerr << "writerc: unable to open previous config file.\n";
#endif
    //return 1;
  } else {
    //cerr << "writerc: opened rc file\n";
    //copy file to bak file if it exists
    if(rcinfile.tellg()){
      //cerr << "writerc: opening bak file\n";
      ofstream bakfile("zeropt.bak", ios::trunc|ios::out);
      rcinfile.seekg(0, ios::beg);
      while(!rcinfile.eof()){
	rcinfile.getline(tempstr, 256);
				//cerr << tempstr << ".\n";
	bakfile << tempstr << endl;
      }
      //if copy didn't work, don't write rc file
      if(bakfile.bad()){
	((wlnApp*)theApp)->tellIt("writerc: bak file is bad\n");
	return 1;
      }
    }//if(rcinfile.tellg()
  }//else  from if(rcinfile.bad())
  rcinfile.close();
  //make sure we're at the start
  ofstream rcfile("zeropt.rc", ios::trunc|ios::out);
  //rcfile.seekg(0, ios::beg);
  //cerr << "writerc: writing new rc file.\n";
  if(!rcfile.good()){
    ((wlnApp*)theApp)->tellIt("writerc: unable to open rcfile for saving.\n");
    return 1;
  }
  int i, n;
  rcfile << "# This is an option file generated by Zero Point. Comments are\n";
  rcfile << "# set off by the pound symbol. They can start anywhere on the\n";
  rcfile << "# line, and they continue until the end of the line. Most \n";
  rcfile << "# options are rather obvious, and the program does some \n";
  rcfile << "# sanity checks, so no settings should break the program. \n";
  rcfile << "# The section headings in brackets are meaningless. \n";
  rcfile << endl << "[CONFIG]\n";
  i = 0;
  while(optInts.getList()[i]){
    rcfile << optInts.getList()[i] << "=" << optInts[i] << endl;
    i++;
  }
  rcfile << endl << "[SAVED]\n";
  n = saves.tellSize();
  for(i = 0; i < n; i++){
    rcfile << "Saved~Name=" << saves[i].name ;
    rcfile << "~Level=" << saves[i].aLevel;
    rcfile << "~Score=" << saves[i].aScore;
    rcfile << "~Lives=" << saves[i].nLives << endl;
  }
  rcfile << endl << "[HIGH]\n";
  n = highscores.tellSize();
  for(i = 0; i < n; i++){
    rcfile << "High~Name=" << highscores[i].name;
    rcfile << "~Level=" << highscores[i].aLevel;
    rcfile << "~Score=" << highscores[i].aScore << endl;
  }
  rcfile << endl;
  return 0;
}//writerc()

bool wlnApp::highScrQ(long aScore){
  long theScore, tempScr;
  size_t aPlace, anEnd;
  char* tempcp;
  int i, n, onFlag = 0;
  vReplyDialog tellMe(this);
  char tempStr[rcnamesz];
  if(aScore == 0) {
    theScore = score;
  } else {
    theScore = aScore;
  }
  if(theScore == 0) {  //still no score, just a mistake
    return false;
  }
  n = optInts[NHigh];
  for(i = n - 1; i >= 0; i--){
    if(theScore >= highscores[i].aScore){
      if(i < n - 1){
	strcpy(highscores[i + 1].name, highscores[i].name);
	highscores[i+1].aLevel = highscores[i].aLevel;
	highscores[i+1].aScore = highscores[i].aScore;
      }
    } else {
      break; //break for loop when no longer higher than score
    }
  }
  i++; //back to the previous entry
  if(i < n){
    if(tellMe.Reply("High Score! Enter your Name:", tempStr, rcnamesz - 1) != M_Cancel){
      if(strchr(tempStr, '~') || strchr(tempStr, '=')){
	//substitute for these characters or they'll screw up parsing
	if(tempStr == NULL) strcpy(tempStr, " ");
	anEnd = strlen(tempStr);
	aPlace = strcspn(tempStr, "~=");
	while(aPlace < anEnd){
	  tempStr[aPlace] = '_';
	  aPlace = strcspn(tempStr, "~=");
	}
      }
      strncpy(highscores[i].name, tempStr, rcnamesz - 1);
      highscores[i].name[rcnamesz - 1] = '\0';
      highscores[i].aLevel = level;
      highscores[i].aScore = score;
      int stp = stepQ();
      if(stp) stepOff();
      _wlnCmdWin->showHi();
      if(stp) stepOn();
      writerc();
      return true;
      //save new high scores list
    }//did dialog return OK?
  }//is it a high score?
  return false;
}//highScrQ()
    
int wlnApp::loseALife(){
  vNoticeDialog tellem(this, "You lost a life!\n   ");
  wlnYNDialog alldone(_wlnCmdWin, "This is it!\n   ");
  int answer;
  ostrstream output;
  --lives;
  writeStatus();
  switch(lives){
  case -1:   //decremented past 0
    output  << "You've lost all your lives!            " << endl <<
      "This game is over." << endl <<
      "Your final score is: " << score << endl <<
      "Better luck next time." << endl << endl <<
      "Press Yes (or Enter) to start a new game, " << endl <<
      "Or press No or Cancel to quit. " << ends;
    answer = alldone.AskYN(output.str());
    if(answer > 0){
      SendWindowCommandAll(M_New, 1, C_Blank);
    } else {
      Exit();
    }
    delete output.str();
    break;
  case 0:
    output << "This is your last life!!!" << endl <<
      "Make good use of it." << endl <<
      "Press OK (or hit Enter) to try this level one last time.\n    " << ends;
    tellem.Notice(output.str());
    delete output.str();
    restartLevel();
    break;
  default:
    if(lives == optInts[StartLives] - 1) {
      output << "You've lost a life!" << endl;
    } else {
      output << "You've lost another life!" << endl;
    }
    if(lives == 1) {
      output << "Only 1 life left! (after this one)" << endl << endl;
    } else {
      output << "Only " << lives << " lives left!" << endl << endl;
    }
    output << "Press OK (or hit Enter) to try this level again.     " << ends;
    tellem.Notice(output.str());
    delete output.str();
    restartLevel();
    break;
  }//switch(--lives)
  return lives;
}//loseALife    

void wlnApp::runDemo(bool truefalse){
  inDemo = truefalse;
}

void wlnApp::practiceMode(int onOrOff){
  //  static int oldStartLevel;
  static int oldSpeedLim;
  static int oldMaxDelay;
#ifdef DBG
  ostrstream dbgOut;
#endif
  if(onOrOff){
    if(!practicing()){  //don't save stuff and start practicing if no need
      score = 0;
      inPractice = true;
      //oldStartLevel = optInts[DefStartLevel];
      //optInts[DefStartLevel] = 1;
      oldSpeedLim = optInts[Speedlim];
      optInts[Speedlim] = 8;
      oldMaxDelay = optInts[MaxDelay];
      optInts[MaxDelay] = 200;
#ifdef DBG
      dbgOut << "Pstart: level = " << level << ends;
      debStat(dbgOut.str());
      delete dbgOut.str();
#endif //DBG
      //level--;
      //nextLevel();
    }
  } else {
    if(practicing()){  //have we been practicing, or is this call bogus
      inPractice = false;
      //optInts[DefStartLevel] = oldStartLevel;
      optInts[Speedlim] = oldSpeedLim;
      optInts[MaxDelay] = oldMaxDelay;
      level = optInts[DefStartLevel];
#ifdef DBG
      dbgOut << "P_end: level is " << level << ends;
      debStat(dbgOut.str());
      sleep(2);
      delete dbgOut.str();
#endif //DBG
    }
  }
  EnableWorkSlice(optInts[MaxDelay] - (((level - 1) % 3) * 25));
}//practiceMode(int)


//###########################################################################

static wlnApp wln_App("ZeroPoint",1);	// The instance of the app

//============================>>> AppMain <<<==============================
int AppMain(int argc, char** argv)
{
  // Use AppMain to create the main window

  (void) theApp->NewAppWin(0, "Main Window", optInts[MaxX], optInts[MaxY]);

  return 0;
}








