//=======================================================================
//@V@:Note: This file generated by vgen V1.02 (04:22:44 PM 04 Feb 1997).
//	wlncnv.cpp:	Source for wlnCanvasPane class
//=======================================================================

////////////////////////////////////////////////////////////////////////////
// This file is a module in the program Zero Point, a video game program  //
// for Linux X11 and Windows.                                             //
//                                                                        //
// Copyright (C) 1996, 1997, 1998 by Enumerate Inc.                       //
//                                                                        //
// Enumerate Inc. can be contacted at enumerate@rocketmail.com            //
//                                                                        //
// This file is licensed within the terms of the GNU General Public       //
// License version 2 or later. This source code may freely redistributed  //
// or modified within the terms of that license, as described in the file //
// 'COPYING' which should be included with any redistribution of this     //
// file. If the file COPYING is not available, a copy of the General      //
// Public License can be obtained from the Free Software Foundation, Inc. //
// 675 Mass Ave., Cambridge, MA 02139.                                    //
//                                                                        //
// THIS PROGRAM IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER  //
// EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED       //
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.    //
// THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THE PROGRAM IS    //
// WITH YOU.  SHOULD THE PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF  //
// ALL NECESSARY SERVICING, REPAIR OR CORRECTION.                         //
//////////////////////////////////////////////////////////////////////////// 


#include "wlncnv.h"
#include "wlnapp.h"  //wlnApp, theApp

//===================>>> wlnCanvasPane::wlnCanvasPane <<<====================
wlnCanvasPane::wlnCanvasPane(){
  wlnStdColors = new vColor[nSC];
  if(wlnStdColors == NULL){
    ((wlnApp*)theApp)->tellIt("Unable to allocate array of colors in wlnCanvasPane constructor");
    theApp->Exit();
  }
  wlnStdColors[0] = vColor(0,0,0);
  wlnStdColors[1] = vColor(254,0,0);
  wlnStdColors[2] = vColor(254,88,0);
  wlnStdColors[3] = vColor(254,176,0);
  wlnStdColors[4] = vColor(254,254,0);
  wlnStdColors[5] = vColor(176,254,0);
  wlnStdColors[6] = vColor(88,254,0);
  wlnStdColors[7] = vColor(0,254,0);
  wlnStdColors[8] = vColor(0,254,88);
  wlnStdColors[9] = vColor(0,254,176);
  wlnStdColors[10] = vColor(0,254,254);
  wlnStdColors[11] = vColor(0,176,254);
  wlnStdColors[12] = vColor(0,88,254);
  wlnStdColors[13] = vColor(0,0,254);
  wlnStdColors[14] = vColor(88,0,254);
  wlnStdColors[15] = vColor(176,0,254);
  wlnStdColors[16] = vColor(254,0,254);
  wlnStdColors[17] = vColor(254,0,176);
  wlnStdColors[18] = vColor(254,0,88);
}

//===================>>> wlnCanvasPane::~wlnCanvasPane <<<====================
  wlnCanvasPane::~wlnCanvasPane()
  {
    delete[] wlnStdColors;
  }

//======================>>> wlnCanvasPane::HPage <<<========================
  void wlnCanvasPane::HPage(int shown, int top)
  {
    vCanvasPane::HPage(shown, top);
  }

//======================>>> wlnCanvasPane::VPage <<<========================
  void wlnCanvasPane::VPage(int shown, int top)
  {
    vCanvasPane::VPage(shown, top);
  }

//=======================>>> wlnCanvasPane::HScroll <<<======================
  void wlnCanvasPane::HScroll(int step)
  {
    vCanvasPane::HScroll(step);
  }

//======================>>> wlnCanvasPane::VScroll <<<======================
  void wlnCanvasPane::VScroll(int step)
  {
    vCanvasPane::VScroll(step);
  }

//======================>>> wlnCanvasPane::MouseDown <<<======================
  void wlnCanvasPane::MouseDown(int X, int Y, int button)
  {
    vCanvasPane::MouseDown(X,Y,button);
  }

//========================>>> wlnCanvasPane::MouseUp <<<======================
  void wlnCanvasPane::MouseUp(int X, int Y, int button)
  {
    vCanvasPane::MouseUp(X,Y,button);
  }

//======================>>> wlnCanvasPane::MouseMove <<<======================
  void wlnCanvasPane::MouseMove(int x, int y, int button)
  {
    vCanvasPane::MouseMove(x,y,button);
  }

//=========================>>> wlnCanvasPane::Redraw <<<======================
void wlnCanvasPane::Redraw(int x, int y, int w, int h)
{
  int myStep, ht, wd;
  static int redrawing;
  static int later;
  if(!later){
    later = 1;
    //((wlnApp*)theApp)->nextLevel();
  }
  if(redrawing == 0){
    redrawing = 1;
    ht = GetHeight();
    wd = GetWidth();
    vPoint minim = {0,0};
    vPoint maxim = {wd,ht};
    myStep = ((wlnApp*)theApp)->stepQ();
    if(myStep) ((wlnApp*)theApp)->stepOff(); //don't step while redrawing
    polygon *tempPoly;
    polyWalk *tempPW = (((wlnApp*)theApp)->getPWalk());
    tempPW->setSize(minim, maxim);
    vBrush aBrush = GetBrush();
    aBrush.SetStyle(vTransparent);
    SetBrush(aBrush);
    SetBackground(vStdColors[vC_Black]);
    Clear();
    drawWlnPoly(tempPW->backPoly());
    while(!tempPW->iterDone()){
      drawWlnPoly(tempPW->nextPoly());
    }
    drawWlnPoly(tempPW->frontPoly());
    if(myStep) ((wlnApp*)theApp)->stepOn(); //step again if we were before
    redrawing = 0;
  }
}


//======================>>> wlnCanvasPane::Resize <<<======================
void wlnCanvasPane::Resize(int w, int h)
{
  if(w > minRun && h > minRun){ //windows minimize generates a resize event
    polyWalk *tempPW = ((wlnApp*)theApp)->getPWalk();
    vPoint mini = {0, 0};
    vPoint maxi = {w, h};
    int myStep = ((wlnApp*)theApp)->stepQ();
    if(myStep) ((wlnApp*)theApp)->stepOff();  //don't allow stepping now
    int tempColor = tempPW->frontPoly().getColor(); //remember color  
    tempPW->frontPoly().setColor(0); //erase front poly
    drawWlnPoly(tempPW->frontPoly());
    tempPW->setSize(mini, maxi);
    tempPW->frontPoly().setColor(tempColor); //restore the color
    drawWlnPoly(tempPW->frontPoly()); //draw the poly again now it's changed
    if(myStep) ((wlnApp*)theApp)->stepOn();  //turn it back on if it was  
  } else {
    ((wlnApp*)theApp)->stepOff();
  }
  vCanvasPane::Resize(w,h);
}

void wlnCanvasPane::drawWlnPoly(polygon &pg){
  vPen aPen = GetPen();
  int theColor = pg.getColor();
  //if(theColor < 0) theColor = 0;         //ensure sane color index into array
  //if(theColor >= nSC) theColor = nSC - 1; //needed for bad polygon c'tor
  aPen.SetColor(wlnStdColors[pg.getColor()]);
  SetPen(aPen);
  DrawPolygon(pg.numSides() + 1, pg.getPoints());
}
