/***
 This file belongs to the Xened distribution.
 Copyright (C) 1995-2001 Thorsten Thielen <thth@gmx.net>

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 ***/
/*
 * ed_event.c - Xened
 */

#include "xened.h"

/*************************************************************************/

extern SHORT       rgsValues[MAX_SECTORS][7];
extern PSZ         *rgpsz;
extern GADGET      rggad[];
extern PTILEBOX    ptboxFont;
extern CHAR        g_pszErr[];

/*************************************************************************/

#define LIM_MIN 0
#define LIM_MAX 1

enum
{
    VAL_TYPE, VAL_PATH, VAL_TIME, VAL_FREQ, VAL_SPEED, VAL_COUNT, VAL_DIST,
    cVAL,
};

SHORT rgsValLimits[cVAL][2] =
{
    { 0, 100 },
    { 0, 100 },
    { 0, 100 },
    { -100, 100 },
    { -100, 100 },
    { -100, 100 },
    { -100, 100 },
};

PSZ *pszValues;

/*************************************************************************/

VOID EditSectorEvents (PGADGETLIST pgadlist, PSZ pszPath, USHORT usSector,
                       USHORT xo, USHORT yo)
{
    CHAR     psz[51];
    SHORT    kcode, action;
    USHORT   value = 0, old_value = value+1, i;

    pszValues = &rgpsz[TXT_RANDOMIZE_TYPES];

    for (i = 0; i < cVAL; i++)
    {
        if (rgsValues[usSector][i] > rgsValLimits[i][LIM_MAX])
            rgsValues[usSector][i] = rgsValLimits[i][LIM_MAX];
        else if (rgsValues[usSector][i] < rgsValLimits[i][LIM_MIN])
            rgsValues[usSector][i] = rgsValLimits[i][LIM_MIN];
    }
    
    pgadlist->xo = xo;
    pgadlist->yo = yo;
    
    draw_stone (0+xo, 0+yo, 204+xo, 89+yo, LIGHTGRAY, WHITE, DARKGRAY);
    draw_stone (4+xo, 4+yo, 200+xo, 85+yo, CYAN, DARKGRAY, WHITE);
    draw_stone (8+xo, 8+yo, 132+xo, 81+yo, BLACK, WHITE, DARKGRAY);

    draw_stone (rggad[30].x1+xo, rggad[30].y1+yo,
                rggad[30].x2+xo, rggad[30].y2+yo, LIGHTGRAY, WHITE, DARKGRAY);
    draw_stone (rggad[31].x1+xo, rggad[31].y1+yo,
                rggad[31].x2+xo, rggad[31].y2+yo, LIGHTGRAY, WHITE, DARKGRAY);

    gadlist_draw (pgadlist);

    sprintf (psz, "Sector %d", usSector+1);
    show_string (ptboxFont, psz, 13+xo, 13+yo, 190);

    for (i = 0; i < 3; i++)
    {
        sprintf (psz, "%-18.18s %3d%%", pszValues[i], rgsValues[usSector][i]);
        show_string (ptboxFont, psz, 13+xo, 24+i*(ptboxFont->ys+2)+yo, 190);
    }
    for (i = 3; i < cVAL; i++)
    {
        sprintf (psz, "%-18.18s %+4d", pszValues[i], rgsValues[usSector][i]);
        show_string (ptboxFont, psz, 13+xo, 24+i*(ptboxFont->ys+2)+yo, 190);
    }

    do
    {
        if (value != old_value)
        {
            GFX_RECT (12+xo, 24+yo+old_value*(ptboxFont->ys+2)-1,
                      128+xo, 24+yo+(old_value+1)*(ptboxFont->ys+2)-2, BLACK);
            GFX_RECT (12+xo, 24+yo+value*(ptboxFont->ys+2)-1,
                      128+xo, 24+yo+(value+1)*(ptboxFont->ys+2)-2, RED);
            old_value = value;
        }
                                        
        if (value < 3)
            sprintf (psz, "%3d%%", rgsValues[usSector][value]);
        else
            sprintf (psz, "%+4d", rgsValues[usSector][value]);
        show_string (ptboxFont, psz, 13+19*(ptboxFont->xs+1)+xo,
                     24+value*(ptboxFont->ys+2)+yo, 190);
        
        kcode = -1;
        do
        {
            /*** Check for any user activities (keyboard,mouse) ***/
            kcode = _read_kbd (0, 0, 0);
            if (kcode == 0)
                kcode = _read_kbd (0, 0, 0);

            do_stars (xo+0, yo+0, xo+204, yo+89);
        }
        while (kcode == -1);
        action = -1;

        /*** Check what action user wants ***/
        if (kcode != -1)
        {
            switch (kcode)
                {
                case C_UP:       action = ACT_SECTOR_PREV;     break;
                case C_DOWN:     action = ACT_SECTOR_NEXT;     break;

                case '+':        action = ACT_SECTOR_1_MORE;   break;
                case '-':        action = ACT_SECTOR_1_LESS;   break;
                case PAGE_UP:    action = ACT_SECTOR_10_MORE;  break;
                case PAGE_DOWN:  action = ACT_SECTOR_10_LESS;  break;
                
                case 27:         action = ACT_SECTOR_OK;       break;
                case 's':        action = ACT_SECTOR_SAVE;     break;
                
                case 9:          action = ACT_GADGET_NEXT;     break;
                case K_BACKTAB:  action = ACT_GADGET_PREV;     break;
                case 13:         action = ACT_GADGET_SHOOT;    break;
            }
        }

        /*** Anything to do with the gadgets? ***/
        switch (action)
        {
        case ACT_GADGET_NEXT:
            gadlist_next (pgadlist);
            break;
 
        case ACT_GADGET_PREV:
            gadlist_prev (pgadlist);
            break;

        case ACT_GADGET_SHOOT:
            action = gadlist_shoot (pgadlist);
            break;
        }

        /*** Make action ***/
        switch (action)
        {
        case ACT_SECTOR_1_MORE:
            if (rgsValues[usSector][value] < rgsValLimits[value][LIM_MAX])
                rgsValues[usSector][value] ++;
            break;
            
        case ACT_SECTOR_1_LESS:
            if (rgsValues[usSector][value] > rgsValLimits[value][LIM_MIN])
                rgsValues[usSector][value] --;
            break;
            
        case ACT_SECTOR_10_MORE:
            if (rgsValues[usSector][value] <= rgsValLimits[value][LIM_MAX]-10)
                rgsValues[usSector][value] += 10;
            break;
            
        case ACT_SECTOR_10_LESS:
            if (rgsValues[usSector][value] >= rgsValLimits[value][LIM_MIN]+10)
                rgsValues[usSector][value] -= 10;
            break;
            
        case ACT_SECTOR_NEXT:
            if (value < cVAL-1)
                value ++;
            break;
            
        case ACT_SECTOR_PREV:
            if (value > 0)
                value --;
            break;
            
        case ACT_SECTOR_SAVE:
            if (ChangeSectorEvents (pszPath, usSector))
            {
                // FIXME perhaps show filename?
                sprintf (g_pszErr, rgpsz[TXT_WROTE_EVENTS_TO_FILE]);
                message (g_pszErr, GREEN, MSG_X, MSG_Y);
            }
            break;
        }
    }
    while (action != ACT_SECTOR_OK);

    GFX_BOX (0+xo, 0+yo, 204+xo, 89+yo, BLACK);
}
/*************************************************************************/

BOOL ChangeSectorEvents (PSZ pszPath, USHORT usSector)
{
    CHAR     pszOldFile[256], pszNewFile[256], pszBackupFile[256];
    SHORT    time, type, count, path, dist, freq, speed, add;
    FILE     *pfileNew, *pfileOld;

    sprintf (pszOldFile, "%s%cs%1d%cEVENTS.PC", pszPath, DIR_SEPERATOR_CHAR,
             usSector+1, DIR_SEPERATOR_CHAR);
    sprintf (pszNewFile, "%s%cs%1d%cEVENTS.NEW", pszPath, DIR_SEPERATOR_CHAR,
             usSector+1, DIR_SEPERATOR_CHAR);
    sprintf (pszBackupFile, "%s%cs%1d%cEVENTS.OLD", pszPath, DIR_SEPERATOR_CHAR,
             usSector+1, DIR_SEPERATOR_CHAR);
    
    if (! (pfileOld = fopen (pszOldFile, "rb")))
    {
        sprintf (g_pszErr, rgpsz[TXT_COULD_NOT_OPEN_FILE_X], pszOldFile);
        message (g_pszErr, RED, MSG_X, MSG_Y);
        return (FALSE);
    }

    if (! (pfileNew = fopen (pszNewFile, "wb")))
    {
        sprintf (g_pszErr, rgpsz[TXT_COULD_NOT_OPEN_FILE_X], pszNewFile);
        message (g_pszErr, RED, MSG_X, MSG_Y);
        fclose (pfileOld);
        return (FALSE);
    }

#ifdef _DEBUG_
    message ("Opened files.", MAGENTA, MSG_X, MSG_Y);
#endif
    
    while (! feof (pfileOld))
    {
        fread (&time, 1, 2, pfileOld);
        fread (&type, 1, 2, pfileOld);
        fread (&count, 1, 2, pfileOld);
        fread (&path, 1, 2, pfileOld);
        fread (&dist, 1, 2, pfileOld);
        fread (&freq, 1, 2, pfileOld);
        fread (&speed, 1, 2, pfileOld);

        /*** Not one of the bonus events? ***/ /*FOLD00*/
        if (type != 0)
        {
            if (RANDOM (100) < rgsValues[usSector][VAL_TYPE])
                if ((type = RANDOM (type)) == 0)
                    type = 1;

            if (RANDOM (100) < rgsValues[usSector][VAL_PATH])
                if ((path = RANDOM (path)) == 0)
                    path = 1;

            if (RANDOM (100) < rgsValues[usSector][VAL_TIME])
            {
                do { add = RANDOM (21)-10; } while (add == 0);

                time += add;
                if (time <= 0)
                    time = 1;
                if (time >= YS_MAP*YS_TILE)
                    time = YS_MAP*YS_TILE-10;
            }

            count += rgsValues[usSector][VAL_COUNT];
            if (count < 0)
                count = 1;
            if (count > 50)
                count = 50;

            speed += rgsValues[usSector][VAL_SPEED];
            if (speed < 0)
                speed = 1;
            if (speed > 50)
                speed = 50;

            dist += rgsValues[usSector][VAL_DIST];
            if (dist < 0)
                dist = 1;
            if (dist > 100)
                dist = 100;

            freq += rgsValues[usSector][VAL_FREQ];
            if (freq < 0)
                freq = 1;
            if (freq > 100)
                freq = 100;
        }
 /*FOLD00*/
        fwrite (&time, 1, 2, pfileNew);
        fwrite (&type, 1, 2, pfileNew);
        fwrite (&count, 1, 2, pfileNew);
        fwrite (&path, 1, 2, pfileNew);
        fwrite (&dist, 1, 2, pfileNew);
        fwrite (&freq, 1, 2, pfileNew);
        fwrite (&speed, 1, 2, pfileNew);
    }

#ifdef _DEBUG_
    message ("Done changes.", MAGENTA, MSG_X, MSG_Y);
#endif

    fclose (pfileNew);
    fclose (pfileOld);

    unlink (pszBackupFile);

    if (rename (pszOldFile, pszBackupFile) == -1)
    {
        sprintf (g_pszErr, rgpsz[TXT_COULD_NOT_RENAME_FILE_X], pszOldFile);
        message (g_pszErr, RED, MSG_X, MSG_Y);
        return (FALSE);
    }

    if (rename (pszNewFile, pszOldFile) == -1)
    {
        sprintf (g_pszErr, rgpsz[TXT_COULD_NOT_RENAME_FILE_X], pszNewFile);
        message (g_pszErr, RED, MSG_X, MSG_Y);
        return (FALSE);
    }

    return (TRUE);
}
/*************************************************************************/
