/* -----------------------------------------------------------------------

         Title: FORTUNES.CMD

        Author: Ralf Hauser

          Date: 29-07-92 / 29-07-92

      Contents: prints a random fortune

         Usage: fortunes  [switches]  [filename]  [message]

                Try "fortunes -?" for help

          Note: Program spawns "PMPOPUP.EXE" - requires it to be in path

--------------------------------------------------------------------------
History:
29-07-92   co Created.
-------------------------------------------------------------------------- */

/* ----------------------------------------------------------------------- */
/*      Interface dependencies                                             */
/* ----------------------------------------------------------------------- */

'@ECHO OFF'                       /* do not display any SHELL commands */

/* ----------------------------------------------------------------------- */
/*      Implementation dependencies                                        */
/* ----------------------------------------------------------------------- */

/* ----------------------------------------------------------------------- */
/*      Constants                                                          */
/* ----------------------------------------------------------------------- */

/* ----------------------------------------------------------------------- */
/*      Types / Classes                                                    */
/* ----------------------------------------------------------------------- */

/* ----------------------------------------------------------------------- */
/*      Globals                                                            */
/* ----------------------------------------------------------------------- */

global. = ""                      /* init */
filename = ""

/* ----------------------------------------------------------------------- */
/*      Function declarations                                              */
/* ----------------------------------------------------------------------- */

        CALL main_init            /* initialize global data structures */

/* ----------------------------------------------------------------------- */
/*      Implementation                                                     */
/* ----------------------------------------------------------------------- */

Main:
        /* handle arguments */
        Parse Arg switches filename message

        /* look whether switches are specified */
        IF Substr(switches, 1, 1) <> "-" & Substr(switches, 1, 1) <> "/" THEN DO
           /* no, so shift arguments */
           message  = filename
           filename = switches
           switches = ""
           END
        ELSE DO /* handle switches */
           IF Pos("?", switches) > 0 THEN
              CALL main_help
           global.debug     = Pos("d", switches)
           global.popup     = Pos("p", switches)
           global.quiet     = Pos("q", switches)
           global.rawmode   = Pos("r", switches)
           END

        /* should we use a default filename? */
        IF filename = "" THEN
           filename = global.filespec

        /* header */
        IF global.debug <> 0 THEN DO
           Say " "
           CALL main_msg "V" || global.version
           CALL main_msg "DEBUG: filename:" filename
           CALL main_msg "DEBUG: message:" message
        END

        /* open file */
        IF (Stream(filename, "C", "OPEN READ") <> "READY:") THEN
           CALL main_error "Could not open '" || filename || "' for reading"

        /* determine filesize */
        filesize = Stream(filename, "C", "QUERY SIZE")
        IF global.debug <> 0 THEN
           CALL main_msg "DEBUG: filesize:" filesize
        IF filesize = 0 THEN
           CALL main_error "Could not determine filesize: ",
                           "filesize: " filesize "bytes"

        /* determine random position */
        filepos = Random(filesize)
        IF global.debug <> 0 THEN
           CALL main_msg "DEBUG: random pos:" filepos
        CALL Stream filename, "C", "SEEK =" filepos

        /* file pointer now points to somewhere in a line, throw that away */
        buffer = Linein(filename)
        IF global.debug <> 0 THEN
           CALL main_msg "DEBUG: line skipped:" buffer

        /* now read line with fortune */
        buffer = Linein(filename)

        /* close file - no longer needed */
        CALL Stream filename, "C", "CLOSE"

        /* filter that line */
        IF global.debug <> 0 THEN
           CALL main_msg "DEBUG: line:" buffer
        /* if it is a QUOTE format file, skip leading linenums ans percent sign */
        offset = Pos("%", buffer) + 1
        /* otherwise display it as it is */
        buffer = Substr(buffer, offset)

        /* popup line if specified */
        IF global.popup <> 0 THEN
           IF message = "" THEN
              start pmpopup buffer
           ELSE
              start pmpopup message || ": " || buffer

        /* display line */
        IF global.debug <> 0 THEN
           Say " "
        CALL main_display buffer, message
EXIT

/* end: main */

/* ----------------------------------------------------------------------- */
/*      initialize                                                         */
/* ----------------------------------------------------------------------- */

main_init : PROCEDURE EXPOSE global.
/*
 *      initializes all global data
 */
        /* check whether RxFuncs are loaded, if not, load them */
        IF RxFuncQuery('SysLoadFuncs') THEN DO
           /* load the load-function */
           CALL RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
           /* load the Sys* utilities */
           CALL SysLoadFuncs
           END

        /* set default values */
        global.title         = "FORTUNES"
        global.version       = "1.00"
        global.debug         = 0
        global.popup         = 0
        global.quiet         = 0
        global.rawmode       = 0
        global.filespec      = "C:\APP\GAMES\FORTUNES.OS2\FORTUNES.TXT"
        /* default filename for my DATABASE */
        Parse Value SysTextScreenSize() with global.scrrows global.scrcols

        RETURN

/* end: main_init */

/* ----------------------------------------------------------------------- */
/*      main_display                                                       */
/* ----------------------------------------------------------------------- */

main_display : PROCEDURE EXPOSE global.
Parse Arg txt,msg

        IF global.quiet <> 0 THEN
           RETURN

        IF msg = "" THEN
           phrase = txt
        ELSE
           phrase = msg || ": " || txt

        IF global.rawmode <> 0 THEN
           Say phrase
        ELSE DO
           /* formatted output */
           numofwords = Words(phrase)
           txtlen = 0
           DO i = 1 TO numofwords
              buffer = Word(phrase, i) || " "
              len = Length(buffer)
              wouldbe = txtlen + len + 1    /* be shure to have enough space */
              IF wouldbe > global.scrcols THEN DO
                 Say ""          /* newline */
                 CALL Charout ,"        "
                 txtlen = 8
                 END
              CALL Charout , buffer
              txtlen = txtlen + len
           END
        END
        RETURN

/* end: main_display */

/* ----------------------------------------------------------------------- */
/*      Display message                                                    */
/* ----------------------------------------------------------------------- */

main_msg : PROCEDURE EXPOSE global.
PARSE ARG msg

        Say global.title || ": " || msg
        RETURN

/* end: main_msg */

/* ----------------------------------------------------------------------- */
/*      Error handler                                                      */
/* ----------------------------------------------------------------------- */

main_error : PROCEDURE EXPOSE global.
Parse Arg msg, msg1, msg2

        Say global.title || ": An error occured:"
        CALL Beep 500, 200
        CALL Beep 900, 200
        CALL Beep 500, 200
        Say " "
        Say "   Error: " || msg
        IF msg1 <> "" THEN
           Say "          " || msg1
        IF msg2 <> "" THEN
           Say "          " || msg2

        EXIT

/* end: main_error */

/* ----------------------------------------------------------------------- */
/*      main_help                                                          */
/* ----------------------------------------------------------------------- */

main_help : PROCEDURE EXPOSE global.
/*
 *      Prints a help
 */
        Say " "
        Say " Usage: " || global.title || " [{/|-}switches]  [filename]  [message]"
        Say " "
        Say "     Possible switches are:"
        Say " "
        Say "        ?      this help"
        Say "        d      display additional debug info"
        Say "        p      display fortune as PM popup"
        Say "        q      do not display fortune on stdout (quiet mode)"
        Say "        r      display fortune in raw mode"
        Say " "
        Say "     Manually generated by Ralf Hauser (co), 7400 Tbingen"
        Say "     e-mail: affie@frege.sns.neuphilologie.uni-tuebingen.de"

        EXIT

/* end: main_help */

/* <EOF> */

