/*
 * Stupid Report Generator.  (possibly a VSRG; very SRG)
 *  This is a very simplified report generating program based on
 *  a visual experience with "festoon".  The vocabulary was "strings"-ed
 *  (or strung?) from the binary of festoon and some words were added.
 *
 *  Author: argv@sri-spam.UUCP
 *  Several extensions: Sven. T. Wiberg, Chalmers, Gothenburg.
 *
 *
 *  Trivial OS/2 port by Lars Olofsson: larso@cs.chalmers.se
 */

#include <stdio.h>
#include <ctype.h>

/* Added process.h, removed pwd.h */
#include <process.h>
/*#include <pwd.h>*/

#define PICK1(list)	list[random()%(sizeof (list) / sizeof (char *))]
#define isvowel(c)	((c)=='a'||(c)=='e'||(c)=='i'||(c)=='o'||(c)=='u')

#define PRESENT 1
#define PAST 2

char *index(s, c) { return strchr(s, c); }
long random() { return rand(); }
int srandom(int i) { return srand(i); }


char *attributes[] = {
#if 1
    "concrete","abstract","procedural","real","ideal",
    "functional","prototype","effective","capable","incremental",
    "perceived","associated","interdepartmental",
    "diverse","characteristic","worst-case",
    "qualitative","fully automatic","candidate",
    "consensual","consequential","conjectural",
    "constructive","initial","cooperative",
    "essential","methodological","requisite",
    "historical","situational","political",
    "prepared","material","defined","well defined",
    "organizational","projected","overall",
    "accepted","rejected","corresponding",
    "committed","environmental","typical","working","timely",
    "growing","unprecedented","new","renewed","fresh",
    "rapid","changing","careful","comprehensive","broad",
    "massive","huge","enormous", "evaluated","discretionary",
    "durable","beneficial", "maximal","tremendous","minimal",
    "on-site","standardized","standard",
    "powerful","natural","necessary", "reasonable","successful",
    "doubtful","dubious","certain",
    "\1unified","different","similar","\1utilitarian",
    "realizable","organizable","motivated",
    "topical","valuable","feasible",
    "intelligent","deliverable","nontrivial",
    "worthwhile","complicated", "organized","organizing","progressing",
    "schedulable","resourceful","commanding",
    "important","allocatable","temporal",
    "ponderable","understandable","comprehensible",
    "past","present","future", "obvious","considerable","finished","completed",
    "\1unique","abovementioned", "major","minor","tendentious","activating",
    "actual","added","adequate","affordable",
    "analyzable","additional","intuitive", "artificial","good","better",
    "worse","bad","basic","fundamental","brief",
    "general","very unique","extreme","most unique",
    "central","proximate","approximate","collected",
    "conductable","contemplatable", "continuing","demonstrable","desirable",
    "correctable","foreseeable", "discontinued","early","beginning",
    "effectuated","elucidated","emotional",
    "enclosed","enthused","entire","exact", "experimental","final",
    "following","informative", "full","complete","indicated","authorized",
    "modularized","submodularized", "particular","preferred","satisfactory",
    "measurable","referenced","literal",
    "modified", "correct","prioritized","prolonged",
    "regrettable","apparent", "continued","subsequent","sufficient",
    "suggestive","true","ultimate","separate",
    "purposeful","regarded","resulting",
    "doubtful","evident","interesting","worthy",
    "\1uniform", "vital","viable", "worthwhile","alternative",
    "sophisticated","employed", "clear","lucid","simple","perspicuous",
    "incomplete","concerned"
#else
"abstract",
"abstract",
"abstract",
"abstract",
"acceptable",
"actual",
"algebraic",
"algebraic",
"algebraic",
"alternative",
"analogous",
"antisymmetric",
"applicable",
"applied",
"appropriate",
"arbitrary",
"arbitrary",
"arbitrary",
"arbitrary",
"arbitrary",
"arbitrary",
"arithmetic",
"associated",
"attractive",
"available",
"background",
"binary",
"boolean",
"canonical",
"canonical",
"canonical",
"canonical",
"canonical",
"canonical",
"canonical",
"canonical",
"cartesian",
"categorical",
"central",
"certain",
"clarifying",
"classical",
"clear",
"closed",
"collected",
"combinatory",
"combined",
"complete",
"complex",
"complicated",
"computable",
"computational",
"computed",
"computed",
"computed",
"computed",
"computed",
"computed",
"concatenated",
"conceptual",
"conditional",
"confusing",
"connected",
"considered",
"constructed",
"constructed",
"constructed",
"constructed",
"constructive",
"constructive",
"constructive",
"constructive",
"constructive",
"constructive",
"constructive",
"contained",
"convenient",
"conventional",
"correct",
"corresponding",
"counterintuitive",
"covered",
"curried",
"customary",
"decidable",
"decomposed",
"definable",
"defined",
"defined",
"defined",
"defined",
"defined",
"defining",
"definitional",
"definitional",
"definitional",
"definitional",
"denotational",
"denoted",
"dependent",
"dependent",
"depending",
"derived",
"described",
"desired",
"detailed",
"determined",
"developed",
"different",
"different",
"different",
"different",
"different",
"different",
"difficult",
"directed",
"discharged",
"discussed",
"disjoint",
"disjoint",
"disjoint",
"disjoint",
"divided",
"easy",
"elegant",
"elementary",
"eliminated",
"eliminable",
"empty",
"equal",
"equivalent",
"essential",
"evaluated",
"excluded",
"executed",
"exemplified",
"existential",
"expected",
"explained",
"explicit",
"expressed",
"expressive",
"extended",
"extensional",
"extensional",
"extensional",
"extensional",
"extensional",
"finite",
"formal",
"formalized",
"formulated",
"foundational",
"founded",
"functional",
"fundamental",
"general",
"general",
"general",
"general",
"general",
"generalized",
"heavy",
"hidden",
"hypothetical",
"identical",
"identical",
"identical",
"identical",
"identical",
"identical",
"identical",
"identified",
"immediate",
"important",
"impossible",
"included",
"incorporated",
"independent",
"indeterminate",
"inductive",
"infeasible",
"inferential",
"infinite",
"informal",
"inhabited",
"inherent",
"initial",
"integral",
"intended",
"intensional",
"intensional",
"intensional",
"intensional",
"intensional",
"interpreted",
"introduced",
"intuitionistic",
"intuitionistic",
"intuitionistic",
"intuitionistic",
"intuitive",
"intuitive",
"intuitive",
"intuitive",
"intuitive",
"intuitive",
"intuitive",
"intuitive",
"inverse",
"involved",
"irrelevant",
"justified",
"limited",
"logical",
"major",
"mathematical",
"mechanical",
"metamathematical",
"modified",
"modularizing",
"monomorphic",
"multilevel",
"necessary",
"noncanonical",
"noncanonical",
"noncanonical",
"noncanonical",
"nonconstructive",
"nonempty",
"nonstandard",
"nonstandard",
"nonstandard",
"nonstandard",
"notational",
"observed",
"obtained",
"obvious",
"omitted",
"operational",
"optimizing",
"ordered",
"ordinary",
"original",
"oriented",
"outermost",
"parameterized",
"particular",
"particular",
"particular",
"particular",
"philosophical",
"polymorphic",
"polymorphic",
"polymorphic",
"polymorphic",
"possible",
"practical",
"preceding",
"predefined",
"presented",
"previous",
"primitive",
"principal",
"proposed",
"propositional",
"propositional",
"propositional",
"propositional",
"propositional",
"propositional",
"propositional",
"propositional",
"propositional",
"provable",
"proved",
"provided",
"pure",
"reasonable",
"recursive",
"reduced",
"reflected",
"reflexive",
"reformulated",
"related",
"repeated",
"replaced",
"represented",
"required",
"restricted",
"satisfied",
"saturated",
"schematical",
"selected",
"semantical",
"sentential",
"separated",
"shortest",
"similar",
"simple",
"sketched",
"skipped",
"slight",
"sophisticated",
"special",
"specified",
"standard",
"stated",
"straightforward",
"strange",
"strong",
"structured",
"sufficient",
"suggested",
"suitable",
"suited",
"supposed",
"symmetric",
"syntactical",
"terminal",
"theoretical",
"theoretical",
"theoretical",
"theoretical",
"theoretical",
"theoretical",
"traditional",
"transitive",
"translated",
"trivial",
"typable",
"trivial",
"typable",
"trivial",
"typable",
"trivial",
"typable",
"trivial",
"typable",
"\1unary",
"understood",
"\1uniform",
"uninteresting",
"\1unique",
"\1universal",
"unnatural",
"unsaturated",
"untyped",
"unusual",
"\1usual",
"valid",
"valued",
"wellfounded",
"well defined",
"well defined",
"well defined",
"well defined",
"well defined",
"weak",
"wrong",
#endif
};

char *predicates[] = {
#if 1
    "real","ideal","functional","effective","characteristic",
    "qualitative","fully automatic","a candidate",
    "consensual","consequential","conjectural",
    "constructive","initial", "essential",
    "prepared","material","defined","well defined",
    "projected","accepted","rejected",
    "typical","working","timely",
    "growing","unprecedented","renewed",
    "rapid","changing","comprehensive",
    "massive","huge","enormous", "evaluated",
    "durable","beneficial", "maximal","tremendous","minimal",
    "standardized","standard",
    "powerful","natural","necessary", "reasonable","successful",
    "doubtful","dubious","certain",
    "realizable","organizable","motivated",
    "topical","valuable","feasible","nontrivial",
    "worthwhile","complicated", "organized","progressing",
    "schedulable","important","temporal",
    "ponderable","understandable","comprehensible",
    "obvious","considerable","finished","completed",
    "\1unique","major","minor","tendentious","activating",
    "added","adequate","affordable",
    "analyzable","counter-intuitive","artificial","good","better",
    "worse","bad","basic","fundamental",
    "general","very unique","extreme","most unique",
    "central","proximate","approximate","collected",
    "conductable","contemplatable","demonstrable","desirable",
    "correctable","foreseeable", "discontinued","beginning",
    "effectuated","exact","experimental","final",
    "informative","full","complete","indicated","authorized",
    "preferred","satisfactory","measurable",
    "modified", "correct","prioritized","prolonged",
    "regrettable","apparent","continued","sufficient",
    "suggestive","true","purposeful",
    "doubtful","evident","interesting",
    "vital","viable","worthwhile",
    "employed","clear","simple","perspicuous",
    "complete","incomplete"
#else
    "real","ideal","functional","effective","characteristic",
    "fully automatic","a candidate",
    "consensual","consequential","conjectural",
    "constructive","initial", "essential",
    "prepared","material","defined","well defined",
    "projected","accepted","rejected",
    "typical","working",
    "growing",
    "rapid","changing","comprehensive",
    "maximal","minimal",
    "standardized","standard",
    "powerful","natural","necessary", "reasonable","successful",
    "doubtful","dubious","certain",
    "realizable","motivated",
    "valuable","feasible","nontrivial",
    "worthwhile","complicated", "organized",
    "important",
    "ponderable","understandable","comprehensible",
    "obvious","considerable","finished","completed",
    "\1unique","major","minor",
    "adequate",
    "analyzable","counter-intuitive","artificial","good","better",
    "worse","bad","basic","fundamental",
    "general",
    "central","collected",
    "demonstrable","desirable",
    "exact","final",
    "informative","full","complete",
    "preferred","satisfactory",
    "modified", "correct",
    "apparent","continued","sufficient",
    "suggestive","true","purposeful",
    "doubtful","evident","interesting",
    "worthwhile",
    "clear","simple",
    "complete","incomplete",
"functional",
"functional",
"intuitive","intuitive","intuitive","intuitive","intuitive",
"true","true","true","true","true","true", 
#endif
};

char *nouns[] = {
#if 1
    "program","computer science","architecture","set theory",
    "type theory","proof","specification",
    "final completion","final ending","final outcome",
    "adaptation","appearance","argument","circumstance",
    "confession","confidence","delimitation","dilution",
    "dissertation","distribution","duplication",
    "entertainment","equipment","evolution",
    "existence","expression","generation","impression",
    "integration","interaction","investment","judgment",
    "population","provision","solution","statement",
    "tradition","transmission",
    "final result","added increment","assistance",
    "beneficial assistance","mutual cooperation",
    "projection","future projection",
    "capability","conjecture","consensus of opinion",
    "general consensus","absence","deficiency",
    "inadequacy","insufficience","insufficiency",
    "growing importance","renewed emphasis",
    "renewed interest","changing behavior",
    "critical thinking","careful thinking",
    "comprehensive survey","high standard",
    "basic foundation","system testing",
    "serious discussion","serious concern",
    "organizational framework","prototype model",
    "\1uniform nomenclature","greater cooperation",
    "\1uniform consistency","early expectation",
    "standardization","great similarity",
    "shortage","presence","sufficiency",
    "consequent result","construct","disutility",
    "early beginning","emotional feeling","endeavor",
    "authorization","order of magnitude","preference",
    "impact","joint cooperation","joint partnership",
    "main essential","methodology","modification",
    "necessary requisite","past history","situation",
    "effectuation","clarification","new doubt",
    "policy","encouragement","preparation",
    "criterion","material","interest","acceptance",
    "rejection","publication","circulation",
    "protection","insurance", "assignment","identification",
    "submission","request", "guidance","correspondence","inclusion",
    "attachment","assumption", "recommendation","prescription","approval",
    "discretion","responsibility","relevance",
    "issuance","termination","total effect",
    "deleterious effect","consolidation",
    "aggregation","definiteness","commencement",
    "actual experience","experience", "combination","accord","filing",
    "idea","abstraction","method","procedure",
    "complaint","maintenance","finance","travel",
    "purchase","repair","routine", "development","cancellation",
    "partitioning","development effort",
    "project","automation","multilevel architecture",
    "multilevel hierarchy","data stream", "objective",
    "individual assignment","mode of operation",
    "clear community","attendant interest",
    "task division","well defined interfacing",
    "team report","meeting time","effective use",
    "friction", "major objective","ownership",
    "overall project time constraint",
    "functional division","requirements analysis", "code development","charter",
    "requirements definition","vertical division",
    "broad range","strong feeling",
    "considerable latitude","overall project constraint",
    "sufficient resource","assigned task","expectation",
    "critical aspect","clear understanding",
    "computing load","clean interfacing","natural basis",
    "team activity","team responsibility",
    "main function","predominant portion",
    "work plan","major breakpoint","work module",
    "achievable accuracy","supplementary work",
    "field version","internal establishment",
    "internal communication","development progress",
    "internal meeting","experience level", "high level autonomy","adherence",
    "feasibility demonstration","persistent problem",
    "internal objective","idea sharing",
    "improved performance","unfamiliar methodology",
    "new methodology","development experience",
    "module specification","good progress", "optimal number","natural division",
    "good relationship","cross attendance",
    "attendance","necessary communication",
    "evolving organization","basic principle",
    "complete revision","general information",
    "primary objective","load-carrying capacity",
    "necessary revision","major change",
    "clarified interpretation","subsequent attempt",
    "basic objective","full utilization", "practical consideration",
    "proportionate quantity","substantial change",
    "database design","\1unified framework",
    "customer service","strong interest",
    "\1unified description","necessary background information",
    "provisioning","physical coverage","general observation",
    "new technology","validity determination",
    "relation","regulation","verification",
    "impediment","portal","practice","premise",
    "basis","movement","question", "issue","input","output","observation",
    "input","output","input","output", "mechanization","function","evaluation",
    "result","further consideration","category",
    "performance indicator","early warning",
    "analysis purpose","measurement","replacement",
    "\1utilitarian purpose", "quota","proposed enhancement","enhancement",
    "interfacing","team organization","module", "guideline","continuing study",
    "required assistance","major advance", "proposal","hierarchy",
    "current view","refinement","activity",
    "external description","tight schedule pressure",
    "internal conflict","internal issue", "reasonable compromise","next phase",
    "goal","time constraint","constraint", "outcome","important outcome",
    "considerable experience","intelligent choice",
    "deliverable documentation","discussion",
    "timely delivery","design issue","large quantity",
    "general environment","protocol", "transitioning","modeling",
    "considerable difficulty","abstract interfacing",
    "data structure","consideration","difficulty",
    "statistical accuracy", "agenda","technique","reordering",
    "reauthorization","current proposal",
    "significant change","criteria","validation",
    "validity", "terminology","current understanding",
    "incorporation","staffing impact", "schedule impact","cost tradeoff",
    "system architecture", "adequate capacity","centralization",
    "current task","system deployment", "attendant uncertainty","process",
    "potential usefulness","proposed method", "basic assumption","anomaly",
    "available data","potential improvement",
    "registration","exemption","exception", "follow-up","service",
    "installation","construction","necessity",
    "occasion","instrumentation","disposal", "attractiveness",
    "convenience","sponsoring", "signification","meaningfulness",
    "significantness","individuality",
    "specification","determination","affirmation",
    "recruitment","supervision","management",
    "oversight","overview","environment",
    "effectation","circumvention","location",
    "execution","effectiveness","consciousness",
    "notation","confirmation","restriction",
    "organization","realization","actification",
    "activation","reification","beginning","conclusion",
    "ending","finishing","teamwork","motivation",
    "attitude","good attitude", "progress","milestone","deadline","schedule",
    "allocation","resource","command","concern",
    "time","time frame","reality", "behaviour","ability","advent","increment",
    "opportunity","accomplishment","aggregate",
    "analysis","totality","matter", "date","duration","centrality",
    "proximity","collection","elimination", "investigation","opinion","debate",
    "decision","benefit","difference","discontinuity",
    "fabrication","plan","chart","forecast",
    "simplicity","simplification","maximization",
    "minimization","direction", "agreement",
    "amount","quantity","quality","essence",
    "description","violation","purpose",
    "primary purpose","automatic control","redefinition",
    "\1uniform emphasis","study activity","work activity",
    "concept stage","concept activity",
    "possible potential","summarization","system function",
    "rationale","significant enhancement","diverse need",
    "diverse organization","comprehensive plan","interim",
    "functional overview","system configuration",
    "configuration","failure","quantitative result",
    "major obstacle","conception", "effectiveness","final evaluation",
    "interrelationship","functional requirement",
    "system philosophy","verbal interchange",
    "perceived inadequacy","primary emphasis",
    "intermingling","cooperation","partnership",
    "adjustment","application","implementation", "contact","mention","power",
    "nature","invention","importance", "ground","reason","permission","size",
    "report","documentation","priority", "pursuance","recurrence","resumption",
    "presupposition","continuance", "substantiation","success","action","truth",
    "past experience","greater acceptability",
    "organizational structure","clear distinction", "clear definition",
    "significant use","unmet need","centralized organization",
    "vague concept","negative impact","detrimental effect",
    "modularization","submodularization", "effect","consistency",
    "inconsistency","completion","\1utilization", "reference","doubt","evidence",
    "viewpoint", "actual fact", "true fact","underlying purpose",
    "viable alternative"
#else
"abbreviation",
"abstraction",
"abstraction",
"abstraction",
"abstraction",
"absurdity",
"advantage",
"aim",
"algorithm",
"alphabet",
"altenative",
"analysis",
"application",
"application",
"application",
"application",
"application",
"application",
"approach",
"argument",
"arity",
"arity",
"arity",
"arity",
"arity",
"arity",
"arity",
"arity",
"arity",
"array",
"assumption",
"assumption",
"assumption",
"assumption",
"assumption",
"assumption",
"assumption",
"assumption",
"assumption",
"assumption",
"assumption",
"attempt",
"axiom",
"axiom",
"axiom",
"axiom",
"basis",
"binding",
"branch",
"calculus",
"capture",
"category",
"category",
"category",
"choice",
"coding",
"collection",
"colour",
"combination",
"comment",
"comparison",
"compiler",
"completion",
"complexity",
"component",
"comprehension",
"computation",
"computation",
"computation",
"computer",
"concept",
"concern",
"conclusion",
"conclusion",
"conclusion",
"conclusion",
"conclusion",
"conclusion",
"condition",
"conflict",
"confusion",
"conjunction",
"conjunction",
"connection",
"consequence",
"constant",
"construct",
"construct",
"construct",
"construct",
"construction",
"construction",
"construction",
"construction",
"constructor",
"constructor",
"constructor",
"constructor",
"context",
"context",
"context",
"context",
"context",
"context",
"convention",
"conversion",
"correctness",
"correspondence",
"counterpart",
"crisis",
"datatype",
"debate",
"decision",
"declaration",
"deduction",
"deduction",
"deduction",
"deduction rule",
"deduction rule",
"deduction rule",
"deduction rule",
"definiendum",
"definiens",
"definition",
"definition",
"definition",
"definition",
"definition",
"dependent type",
"dependent type",
"dependent type",
"dependent type",
"dependent type",
"dependent type",
"dependent type",
"dependent type",
"dependent type",
"derivation",
"derivation",
"derivation",
"derivation",
"derivation",
"derivation",
"derivation",
"description",
"detail",
"development",
"difference",
"direction",
"disadvantage",
"discipline",
"disjunction",
"disjunct",
"distinction",
"distribution",
"division",
"domain",
"effect",
"element",
"element",
"element",
"element",
"element",
"elimination",
"elimination rule",
"elimination rule",
"elimination rule",
"enumeration",
"equality",
"equality",
"equality",
"equality",
"equality",
"equality",
"equality",
"equality",
"equality",
"equality",
"equation",
"equivalence",
"error",
"evaluation",
"evaluation",
"evaluation",
"example",
"exception",
"existence",
"explanation",
"explanation",
"explanation",
"expression","expression","expression","expression","expression","expression","expression",
"extension",
"family",
"figure",
"formalism",
"formalization",
"formalization",
"formalization",
"formalization",
"format",
"formation",
"formation",
"formation rule",
"formation rule",
"formation rule",
"form",
"formula",
"formulation",
"foundation",
"foundation",
"foundation",
"foundation",
"framework",
"framework",
"framework",
"function",
"function",
"function",
"function",
"function",
"gap",
"generalization",
"goal",
"grammar",
"graph",
"group",
"hauptsatz",
"hypothesis",
"hypothesis",
"hypothesis",
"idea",
"identification",
"identifier",
"identifier",
"identifier",
"identifier",
"identity",
"identity",
"identity",
"identity",
"identity",
"implementation",
"implication",
"index",
"individual",
"induction",
"induction",
"induction",
"induction",
"induction",
"induction",
"induction",
"induction",
"inequality",
"inference",
"inference",
"inference",
"inference",
"inference",
"inspiration",
"instance",
"integer",
"intention",
"interpretation",
"interpretation",
"interpretation",
"interpretation",
"interpretation",
"introduction",
"introduction",
"introduction",
"introduction rule",
"introduction rule",
"introduction rule",
"introduction rule",
"introduction rule",
"introduction rule",
"introduction rule",
"intuition",
"intuition",
"intuition",
"intuition",
"intuition",
"intuition",
"investigation",
"judgement",
"judgement",
"judgement",
"judgement",
"judgement",
"judgement",
"judgement",
"judgement",
"justification",
"justification",
"justification",
"justification",
"knowledge",
"lambda",
"leaf",
"language",
"lemma",
"length",
"level",
"limit",
"list",
"logic",
"logic",
"logic",
"logic",
"machine",
"mapping",
"member",
"metamathematics",
"metavariable",
"method",
"methodology",
"module",
"motivation",
"motive",
"name",
"negation",
"node",
"normalization",
"normalization",
"normalization",
"notation",
"notion",
"number",
"object",
"object",
"object",
"object",
"numeral",
"occurence",
"operation",
"operator",
"order",
"order",
"order",
"ordering",
"origin",
"output",
"pair",
"parameter",
"parentheses",
"parentheses",
"parser",
"part",
"partition",
"pattern",
"permutation",
"phrase",
"picture",
"place",
"placeholder",
"placeholder",
"position",
"possibility",
"postulate",
"predicate",
"predicate",
"predicate",
"predicate",
"predicate",
"prefix",
"premise",
"premise",
"premise",
"premise",
"prescription",
"presentation",
"principle",
"priority",
"problem",
"procedure",
"product",
"program",
"programmer",
"projection",
"proof",
"proof",
"proof",
"proof",
"proof",
"property",
"proofchecker",
"proposal",
"proposition",
"proposition",
"proposition",
"proposition",
"proposition",
"purpose",
"quantifier",
"range",
"reader",
"reason",
"record",
"recursion",
"reduction",
"reduction",
"reduction",
"relation",
"relationship",
"remedy",
"report",
"representation",
"requirement",
"restriction",
"result",
"risk",
"rule",
"rule",
"rule",
"rule",
"rule",
"rule",
"rule",
"rule",
"schema",
"selection",
"selector",
"semantics",
"semantics",
"semantics",
"semantics",
"semantics",
"sentence",
"sequence",
"set",
"set",
"set",
"set",
"set",
"set",
"set",
"set",
"set",
"set",
"set",
"set",
"set",
"set",
"set",
"set",
"set",
"set",
"set",
"set",
"set",
"shorthand",
"side",
"simplification",
"situation",
"solution",
"source",
"specification",
"specification",
"specification",
"specification",
"specification",
"specification",
"specification",
"specification",
"specification",
"space",
"stack",
"start",
"state",
"step",
"strength",
"strategy",
"structure",
"style",
"subexpression",
"subgoal",
"subject",
"subproblem",
"subset",
"subset",
"subset",
"subset",
"subset",
"subset",
"subspecification",
"substitution",
"substitution",
"substitution",
"substitution",
"subtree",
"successor",
"support",
"symmetry",
"symmetry",
"symmetry",
"syntax",
"system",
"tactic",
"tautology",
"technique",
"term",
"text",
"theorem",
"theorem",
"theorem",
"theory",
"theory",
"theory",
"theory",
"theory",
"thought",
"transition",
"treatment",
"tree",
"trick",
"triple",
"truth",
"tuple",
"type",
"type",
"type",
"type",
"type",
"type",
"type theory",
"type theory",
"type theory",
"type theory",
"type theory",
"type theory",
"type theory",
"type theory",
"type theory",
"type theory",
"type theory",
"typing",
"understanding",
"union",
"universe",
"universe",
"universe",
"validity",
"value",
"value",
"value",
"value",
"value",
"variable",
"variant",
"verification",
"version",
"view",
"way",
"wellordering",
"work",
"zero",
#endif
};

char *adverbs[] = {
#if 1
    "very","extremely","generally","reasonably",
    "fundamentally","essentially","particularly","very",
    "very","very", "very","very", "very","very", "very","very",
    "very","very", "very","very", "very","very", "entirely ",
    "rather","fairly","relatively","comparatively",
    "moderately", "absolutely","functionally",
    "accordingly","broadly","actionably","actually", "additionally",
    "ambiguously","amply", "analogously", "aperiodically",
    "apparently","appreciably", "appropriately","approximately",
    "arbitrarily", "associatively", "automatically", "awfully",
    "axiomatically", "badly","barely","basically", "beneficially",
    "blatantly", "capably","carefully","carelessly",
    "casually","causally","cautiously", "centrally","certainly",
    "cheaply","cleanly", "closely","coarsely","cognizantly",
    "coincidentally","collectively","collaterally",
    "comparably", "competently","completely","comprehensibly",
    "concededly","conceivably", "concisely","conclusively","concretely",
    "concurrently","conjecturally", "currently",
    "conscientiously","consequently","consequentially",
    "consistently","constantly", "contemporaneously","constructively",
    "continually","continuously","contractually", "correctively",
    "contrarily","contributatively","conveniently", "conventionally",
    "correctly", "crudely", "curiously", "decidedly", "deeply",
    "deficiently","demandingly", "dependably","desirably",
    "determinately","diagnostically", "differentially","differently",
    "directly","discernibly", "distinctly","doubtfully","dramatically",
    "dynamically", "economically", "efficaciously","efficiently",
    "elegantly", "emphatically","encouragingly", "endlessly","endurably",
    "entirely","epistemologically", "functionally","immediately",
    "equably","equally","equitably","erroneously",
    "esoterically","eternally","evenly","eventfully",
    "eventually","evidently", "exceedingly","exactly","excellently",
    "exceptionally","excessively","exclusively", "experimentally",
    "explicitly","extremely", "factually","faithfully",
    "faultlessly","feasibly", "finitely","firmly","forcefully",
    "formally","formerly","frankly","freely",
    "frugally","fully","generally", "globally","gradually", "harmlessly",
    "helpfully", "highly","homogeneously", "hopefully",
    "ideally","identically","ideologically",
    "idiomatically","idiosyncratically","idly",
    "imaginably","immaterially","immensely",
    "impartially","imperceptibly","imperfectly","importantly",
    "improperly","imprudently","inaccurately","inappropriately",
    "accurately", "inclusively","incompletely","incorrectly",
    "increasingly","independently",
    "indirectly","ineffectively","ineffectually","inefficiently",
    "infallibly","instantaneously","instantly",
    "insufficiently","internally","likely","only",
    "invaluably","inversely","irrelevantly","irrespectively",
    "largely","lastly","legitimately","literally",
    "locally","loosely","manageably","markedly",
    "memorably","mildly","mindfully","moderately",
    "momentarily","naturally","needfully","needlessly",
    "nominally","normally","objectively","occasionally",
    "temporarily", "officially","oppositely","ordinarily","ostensibly",
    "partially","permissibly", "personally","pertinently",
    "physically","plainly","plainly", "pleasingly","politically",
    "potentially","predictively",
    "predominantly","prematurely","preparedly","presently",
    "previously","primarily", "primely","principally","problematically",
    "productively","promptly","proportionately",
    "provably","purely","quickly","radically","randomly","recently",
    "repeatedly","secondarily","separately",
    "\1usually","specifically", "redundantly","regardlessly","reliably",
    "remarkably","remotely","respectively", "probably",
    "robustly","seemingly", "sensibly","singularly","steadily",
    "strikingly","substantially","successfully",
    "supposedly","systematically","understandably", "necessarily",
    "unfortunately", "unnecessarily","unmistakably","\1usefully","weakly",
    "totally","very","quite"
#else
    "very","extremely","generally","reasonably",
    "fundamentally","essentially","particularly","very",
    "very","very", "very","very", "very","very", "entirely",
    "rather","fairly","relatively","comparatively",
    "moderately", "absolutely","functionally",
    "ambiguously", "analogously",
    "apparently","appreciably", "appropriately","approximately",
    "arbitrarily", "associatively", "automatically",
    "axiomatically", "badly","barely","basically",
    "capably","carefully",
    "casually","causally","cautiously", "centrally","certainly",
    "cleanly", "closely","coarsely",
    "coincidentally","collectively",
    "comparably", "competently","completely","comprehensibly",
    "concededly","conceivably", "concisely","conclusively","concretely",
    "concurrently","conjecturally", "currently",
    "conscientiously","consequently","consequentially",
    "consistently","constantly", "constructively",
    "continually","continuously", "correctively",
    "contrarily","contributatively","conveniently", "conventionally",
    "correctly", "crudely", "curiously", "decidedly", "deeply",
    "deficiently","demandingly", "dependably","desirably",
    "determinately", "differentially","differently",
    "directly","discernibly", "distinctly","doubtfully","dramatically",
    "dynamically", "efficiently",
    "elegantly", "endlessly","endurably",
    "entirely","epistemologically", "functionally","immediately",
    "equably","equally","erroneously",
    "eventually","evidently", "exceedingly","exactly","excellently",
    "exceptionally","excessively","exclusively", "experimentally",
    "explicitly","extremely", "factually","faithfully",
    "faultlessly","feasibly", "finitely","firmly","forcefully",
    "formally","formerly","frankly","freely",
    "ideally","identically","ideologically",
    "idiomatically","idiosyncratically","idly",
    "imaginably","immaterially","immensely",
    "impartially","imperfectly","importantly",
    "improperly","inaccurately","inappropriately",
    "accurately", "inclusively","incompletely","incorrectly",
    "increasingly","independently",
    "indirectly","ineffectively","ineffectually","inefficiently",
    "infallibly","instantaneously","instantly",
    "insufficiently","internally","likely","only",
    "invaluably","inversely","irrelevantly","irrespectively",
    "largely","lastly","legitimately","literally",
    "locally","loosely","manageably","markedly",
    "memorably","mildly","mindfully","moderately",
    "momentarily","naturally","needlessly",
    "nominally","normally","objectively","occasionally",
    "temporarily","oppositely","ordinarily",
    "partially","permissibly",
    "potentially","predictively",
    "predominantly","prematurely","preparedly","presently",
    "previously","primarily", "primely","principally","problematically",
    "productively","promptly","proportionately",
    "provably","purely","quickly","radically","randomly","recently",
    "repeatedly","secondarily","separately",
    "\1usually","specifically", "redundantly","regardlessly","reliably",
    "remarkably","remotely","respectively", "probably",
    "robustly","seemingly", "sensibly","singularly","steadily",
    "strikingly","substantially","successfully",
    "supposedly","systematically","understandably", "necessarily",
    "unfortunately", "unnecessarily","unmistakably","\1usefully","weakly",
    "totally","very","quite",
"arbitrarily",
"arbitrarily",
"arbitrarily",
"arbitrarily",
"automatically",
"briefly",
"certainly",
"classically",
"clearly",
"closely",
"completely",
"computationally",
"computationally",
"computationally",
"consequently",
"constructively","constructively","constructively","correspondingly",
"definitionally",
"definitionally",
"definitionally",
"differently",
"directly",
"easily",
"equally",
"equivalently",
"equivalently",
"equivalently",
"especially",
"essentially",
"exactly",
"explicitly",
"extensionally",
"extensionally",
"extensionally",
"extensionally",
"extensively",
"finally",
"finitely",
"formally",
"formally",
"formally",
"formally",
"formally",
"fully",
"hardly",
"hopefully",
"immediately",
"increasingly",
"independently",
"inductively",
"inductively",
"inductively",
"inductively",
"inductively",
"infinitely",
"informally",
"intensionally",
"intensionally",
"intensionally",
"intensionally",
"intuitionistically",
"intuitionistically",
"intuitionistically",
"intuitively",
"intuitively",
"intuitively",
"intuitively",
"irrespectively",
"mainly",
"mechanically",
"mutally",
"mutually",
"namely",
"neatly",
"normally",
"operationally",
"originally",
"perfectly",
"possibly",
"precisely",
"previously",
"probably",
"properly",
"provably",
"purely",
"schematically",
"semantically",
"similarly",
"simultaneously",
"slightly",
"specifically",
"succesively",
"syntactically",
"trivially",
"unfortunately",
"usually",
#endif
};

char *hedge[] = {
    "it is easy to see that", "it is a basic fact that", "trivially,",
    "it can be shown that", "it is obvious that","it is not unimportant that",
    "it is easy to overlook the fact that",
    "it is within the realm of possibility that", "it is apparent that",
    "this is indicative of the fact that",
    "this is in substantial agreement with the fact that",
    "this demonstrates the fact that",
    "this leaves out of consideration the fact that",
    "it is of the utmost importance that", "the truth is that",
    "the fact is that", "it turns out that","it will turn out to be true that",
    "it should be noted that", "it stands to reason that",
    "it would not be unreasonable to assume that",
    "it is interesting to note that",
    "it is intuitively clear that",
    "it is intuitively clear that",
    "the reason for this is that",
    "it seems natural that",
};

char *clause[] = {
    "although","even though","despite the fact that",
    "because","due to the fact that","since",
    "if","any time that","in the case that",
    "as a consequence of the fact that",
    "as regards the fact that", "as a desirable benefit of the fact that",
    "with reference to the fact that", "as long as",
    "as an important essential of the fact that",
    "in conjunction with the fact that", "in the light of the fact that",
    "if","if","if","if", "leaving out of consideration the fact that",
    "just as", "inasmuch as","until such time as",
    "as soon as","being as","in the same way as",
    "with the exception of the fact that", "notwithstanding the fact that",
    "on the grounds that", "on the basis of the fact that",
    "persuant to the fact that", "although it seems apparent that",
    "with regard to the fact that", "as can be seen from the fact that",
    "as", "although","even though","despite the fact that",
    "for the simple reason that", "because","due to the fact that","since",
    "whether or not", "inasmuch as", "as"
};

char *prep[] = {
    "across","by","in","of","near","under","over",
    "below","behind","of","of","of","of",
    "centered around",
    "in close proximity to","following after",
    "in conflict with","in conjunction with",
    "in the area of","in the neighborhood of","in the proximity of",
    "for the purpose of",
    "giving rise to","based upon","being caused by", "of","of","of","of",
    "being used with",
    "being collected together with","being combined together with",
    "connected up to","exhibiting a tendency towards",
    "being employed with",
    "impacting upon",
    "being joined together with","being merged together with",
    "in the vicinity of", "to","at","by","from","with","for",
"based upon","based upon","based upon",
};

char *pred_prep[] = {
    "in","near","above","below","beyond",
    "centered around","centered about",
    "in close proximity to","following after",
    "in conflict with","in conjunction with",
    "in the area of","in the neighborhood of","in the proximity of",
    "in the field of",
    "giving rise to","based upon","being caused by",
    "being effectuated by",
    "connected up to","exhibiting a tendency towards",
    "being facilitated by",
    "impacting","impacting upon",
    "being joined together with","being merged together with",
    "in the vicinity of","at"
};

int Lpos, Tense, Intitle, Inclause, Inpred;

main(argc, argv)
char **argv;
{
    char buf[BUFSIZ];
    register char *maxbuf = buf + BUFSIZ;
    register nsentences, n, para;

    if(argc < 2) 
	printf("Usage: %s number_of_sentences\n", argv[0]), exit(1);
    nsentences = atoi(argv[1]);
    srandom (getpid());

    if (nsentences > 2) {
	*buf = 0;
	title (buf);
	output (buf);
	if (Lpos > 0)
		putchar('\n');
	putchar('\n');
	Lpos = 0;
	*buf = 0;
	author(buf);
	output (buf);
	if (Lpos > 0)
		putchar('\n');
	putchar('\n');
    }
    for (Lpos = para = n = 0; n < nsentences; n++) {
	*buf = 0;
	Tense = NULL;
	sentence (buf);
	if (!(random() % 2)) {
		strcat (buf, !(random() % 2)? ", and ": ", but ");
		sentence (buf);
	}
	output (buf);
	if (++para > 2 && nsentences - n > 2 && !(random() % 2)) {
		if (Lpos > 0)
			putchar('\n');
		putchar('\n');
		Lpos = para = 0;
	}
    }
    if (Lpos > 0)
	putchar('\n');
}

title (buf)
register char *buf;
{
	Intitle = 1;
	strcat (buf, "The ");
	strcat (buf, PICK1(nouns));
	strcat (buf, ".");
	output (buf);
	*buf = 0;
	attribute (buf);
	strcat (buf, " ");
	strcat (buf, PICK1(nouns));
	strcat (buf, " ");
	strcat (buf, PICK1(prep));
	strcat (buf, " ");
	nounphr (buf);
	Intitle = 0;
}

author(buf)
register char *buf;
{
/* Removed UNIX code, added default 'OS2 User' name.*/
/*	struct passwd *pw, *getpwuid();
	register char *gp, *ep, *ap, *np;
	extern char *index();



	pw = getpwuid(getuid());
	if (*(gp = pw->pw_gecos)) {
		if (ep = index(gp, ','))
			*ep = 0;
		if (ap = index(gp, '&'))
			*ap++ = 0;
		strcat(buf, "By ");
		if (islower(*gp))
			*gp = toupper(*gp);
		strcat(buf, gp);
		if (ap) {
			if(*(np = pw->pw_name)) {
				if (islower(*np))
					*np = toupper(*np);
				strcat(buf, np);
			}
			strcat(buf, ap);
		}
	}
*/

        strcat(buf, "By ");
        strcat(buf, "OS2 User");

}

sentence (buf)
register char *buf;
{
    if (random() % 3)
	put_clause (buf);
    nounphr (buf);
    strcat (buf, " ");
    be (buf);
    predicate (buf);
}

nounphr (buf)
register char *buf;
{
    register char *noun;

    noun = PICK1(nouns);
    if (index(noun, ' ') || Intitle || !(random() % 4))
	strcat (buf, !(random() % 2)? "the ":
	(isvowel(*noun))? "an ": "a ");
    else {
	attribute (buf);
	strcat (buf, " ");
    }
    strcat (buf, noun);
    if (!Intitle && !Inpred && !(random() % 3)) {
	strcat (buf, " ");
	strcat (buf, PICK1(prep));
	strcat (buf, " ");
	nounphr (buf);
    }
}

attribute (buf)
register char *buf;
{
    register char *nextw, *attr, *adv = NULL;

    nextw = attr = PICK1(attributes);
    if (index(attr, ' ') == NULL && !(random() % 3))
	nextw = adv = PICK1(adverbs);
    strcat (buf, !Intitle && !(random() % 2)? "the ":
    (isvowel(*nextw))? "an ": "a ");
    if (adv) {
	strcat (buf, adv);
	strcat (buf, " ");
    }
    strcat (buf, attr);
}

be (buf)
register char *buf;
{
    register char *verb;

    verb =  Tense == PRESENT? "is ":
	    Tense == PAST? "was ":
	    random() % 3? "is " :
	    "was ";
    Tense = *verb == 'i'? PRESENT: PAST;
    strcat (buf, verb);
    if (!(random() % 3))
	strcat (buf, "not ");
}

predicate (buf)
register char *buf;
{
    register char *pred;

    Inpred = 1;
    if (random() % 3) {
	if (!(random() % 10))
	    strcat (buf, "known to be ");
	pred = PICK1(predicates);
	if (index(pred, ' ') == NULL && !(random() % 2)) {
	    strcat (buf, PICK1(adverbs));
	    strcat (buf, " ");
	}
	strcat (buf, pred);
    }
    else {
	strcat (buf, PICK1(pred_prep));
	strcat (buf, " ");
	nounphr (buf);
    }
    Inpred = 0;
}

put_clause (buf)	/* a clause to preceed the sentence */
register char *buf;
{
	if (!Inclause) {		/* Recursive clauses are too much! */
		Inclause = 1;
		if (random() % 3) {
			strcat (buf, PICK1(hedge));
			strcat (buf, " ");
			Tense = PRESENT;
		}
		else {
			strcat (buf, PICK1(clause));
			strcat (buf, " ");
			sentence (buf);
			strcat (buf, ", ");
		}
		Inclause = 0;
	}
}

output(buf)
register char *buf;
{
	register char *sp, *p;

	if (*buf == '\1')
		buf++;
	if (islower(*buf))
		*buf = toupper (*buf);
	if (!Intitle)
		strcat (buf, ".");
	for (sp = buf; *sp; sp++) {
		if (*sp == '\1')
			continue;
		if (sp == buf || *sp == ' ') {
			for (p = sp + 1; *p && *p != ' '; p++);
			if (Lpos + (p - sp) + (sp == buf? 2: 0) >= 72) {
				putchar('\n');
				Lpos = 0;
				if (*sp == ' ')
					continue;
			}
			else if (sp == buf && Lpos > 0) {
				putchar(' ');
				if (!Intitle)
					putchar(' ');
			}
		}
		putchar(*sp);
		Lpos++;
	}
}
