/* Installationsskript zum Programm 0130-Plus/2 */
SIGNAL ON ERROR NAME Fehler

SAY " "

/* REXXUTIL laden */
CALL rxfuncadd sysloadfuncs, rexxutil, sysloadfuncs
CALL sysloadfuncs

/* Abfrage, in welchem Pfad wir sind */
CALL SysFileTree '0130.*', datei, 'FO'
IF datei.0 < 3 THEN
DO
   SAY "Anscheinend haben sie das Archiv 0130*.* noch nicht entpackt."
   SAY "Bitte erledigen Sie dies und beginnen Sie dann nochmal."
   EXIT
END

/* Den Pfad und die Platte extrahieren */
pfad = FILESPEC("path",datei.1)
disk = FILESPEC("drive",datei.1)
path = OVERLAY(pfad,disk,3)

SAY "Installationsscript zum Programm 0130-Plus/2  (c) 1995 Uwe Schlenther Software"
SAY "=============================================================================="
SAY " "

/* Ansonsten Daten erfragen */
Abfrage:
SAY "In welchem Pfad soll 0130-Plus/2 installiert werden ?"
SAY "(z.B. C:\0130)  "
PARSE PULL pfad
IF pfad = "" THEN pfad="C:\0130"
SAY " "
SAY "0130-Plus/2 wird im Pfad " pfad " installiert."
SAY " "
SAY "Geben sie <return> fr weiter ein, <K> fr Korrektur oder <A> fr Abbruch!"
PULL antwort

/* Auswerten */
IF antwort = "A" THEN SIGNAL Abbruch
IF antwort = "K" THEN SIGNAL Abfrage

SAY "Danke...."

weiter:
/* Jetzt ggf. das Verzeichnis erzeugen */
rc = SysMkDir(pfad)

/* und die dort ntigen Dateien hinverschieben */
INTERPRET "'COPY 0130.EXE 'pfad'\*.*'"
INTERPRET "'COPY 0130.DB  'pfad'\*.*'"
INTERPRET "'COPY 0130.INF 'pfad'\*.*'"
INTERPRET "'COPY 0130.ICO 'pfad'\*.*'"

/* Anlegen des Ordners auf der WPS */
SAY " "
SAY "Soll ein Programmobjekt fr 0130-Plus/2 erstellt werden?"
SAY "Geben sie <J> oder <N> ein!"
PULL antwort

/* Auswerten */
IF antwort = "N" THEN SIGNAL Ende
SAY " "
SAY "WPS-Objekte werden erzeugt..."

/* Den Ordner anlegen */
klasse='WPFolder'
titel='0130-Plus'
ort='<WP_DESKTOP>'
param='OBJECTID=<0130_ORDNER>;'
mode='fail'
rc = SysCreateObject(klasse,titel,ort,param,mode)

/* Das Programmobjekt anlegen */
klasse='WPProgram'
titel='0130-Plus'
ort='<0130_ORDNER>'
param='PROGTYPE=PM;EXENAME='pfad'\0130.EXE;ICONFILE='pfad'\0130.ICO;STARTUPDIR='pfad';'
mode='fail'
rc = SysCreateObject(klasse,titel,ort,param,mode)

/* Das Hilfeobjekt anlegen */
klasse='WPProgram'
titel='Hilfe zu 0130-Plus'
ort='<0130_ORDNER>'
param='PROGTYPE=PM;NOPRINT=YES;HELPPANEL=4083;EXENAME=VIEW.EXE;NOPRINT=YES;STARTUPDIR='pfad';PARAMETERS='pfad'\0130.INF;'
mode='fail'
Location = "<WP_TEMPS>"
Title = "Hilfedatei"
rc = SysCreateObject(klasse,titel,ort,param,mode)

/* Ende-Meldung */
Ende:
SAY "0130-Plus/2 ist jetzt installiert!"
SAY " "
SAY "Bitte beachten Sie, da in dieser Demo-Version lediglich 50 Datenstze"
SAY "enthalten sind. Die Vollversion enthlt den vollstndigen Datenbestand"
SAY "mit ber 2000 Eintrgen."
EXIT

/* Standard-Fehlerhandler */
Fehler:
SAY "Es ist ein Fehler aufgetreten. Bitte versuchen Sie's nochmal!"
EXIT

/* Abbruch des scripts */
Abbruch:
SAY "Schade, da Sie das Installationsprogramm abgebrochen haben!"
EXIT

