/* ----------------------------------------------------------------- */
/* REXX-CMD to create (or update) the object for MIKE*.INF           */
/*                                                                   */
/* The default is on the desktop, but if you have already an object  */
/* for an older version of MIKE this program will update that        */
/* object.                                                           */
/*                                                                   */
/* ----------------------------------------------------------------- */

/* init some global variables */
  OS2BootDrive = ''
  fileMask =          'MIKE*.INF'
  fixedName =         'MIKE'
  defaultTitle =      'MIKE-136'
  curObjectID =       '<MIKE136A>'
  defaultLocation =   '<WP_DESKTOP>'

/* install some error handler */
  signal on halt name UserAbort
  signal on syntax name RexxUtilNotFound

/* load REXXUTIL */
IF RxFuncQuery("SysLoadFuncs") THEN
DO
   CALL RxFuncAdd "SysLoadFuncs", "RexxUtil", "SysLoadFuncs"
   CALL SysLoadFuncs
END
CALL SysCls
  
/* turn on the default error handler again */
  signal off Syntax

/* show the logo */

  say ''
  say '   Installation program for MIKE-136'
  say '   ================================='
  say ''

/* search the OS/2 boot drive */
  if OS2BootDrive = '' then
  do
    say ' Searching the boot drive. Please wait ...'
    OS2BootDrive = SearchbootDrive()

    say ' ... the OS/2 bootdrive is "' || OS2BootDrive || '".'
  end 


  say ' Searching the newest version of ' || defaultTitle || ' ...'
  say ' (only in the current directory!)'

/* search MIKE*.INF */
  call SysFileTree fileMask, 'infFileStem' , 'FO'

  curInfFileVersion = '00'
 
  do i = 1 to infFileStem.0
    parse upper var infFileStem.i (fixedName) infFileVersion '.' .
    if infFileVersion > curInfFileVersion then
    do
      curInfFile = infFileStem.i
      curInfFileVersion = infFileVersion
    end 
  end 

/* check, if we found a version of MIKE */  
  if curInfFileVersion <> '00' then
  do
    curtitle = strip( getTitle( '"' || curInfFile || '"' ) )
    if curTitle <> '' then 
    do

      say ' ... "' || curTitle || '" found.'
      say ''
      say ' Should I create an object for "' || curTitle || '" (Y/n)? '
      userResponse = substr( strip( translate( SysGetKey( 'NOECHO' ) ) ),1,1 )
      if UserResponse = 'N' then 
        signal UserAbort

      curTitle = translate( curTitle, '^', ',' )
  
      say ' Creating the object ...'

/* create the object */
      tempRC = SysCreateObject( 'WPProgram' ,,
                                curTitle ,,
                                defaultLocation ,,
                               'EXENAME=' || OS2BootDrive || '\OS2\VIEW.EXE;' || ,
                               'PARAMETERS="' || curInfFile || '";' || ,
                               'STARTUPDIR=' || OS2BootDrive || '\;' || ,
                               'TITLE=' || curTitle || ';' || ,
                               'OBJECTID=' || curObjectID || ';' ,,
                               'U' )

      if tempRC = 1 then
      do
        thisRC = 0
        say ' ... object created.'
      end 
      else
        say 'Error creating the object!'

    end 
    else
    do
      say '07'x
      say ' Error: Error reading the file'
      say
      say '  "' || curInfFile || '"!'
      say
      say ' Please close MIKE136 if it''s open and try it again.'
    end 
  end 
  else
  do
    say '07'x
    say ' Error: ' || defaultTitle || ' not found!'
    say 
    say ' Please make sure that the file MIKE*.INF is in the current directory'
    say ' and try it again.'
  end 
exit thisRC

/* ----------------------------------------------------------------- */
/* function:   search the boot drive                                 */
/* parameters: none                                                  */
/*                                                                   */
/* returns:    boot drive (e.g. "C:")                                */
/*                                                                   */
SearchBootDrive: PROCEDURE 

/* install a local error handler */
  signal on syntax name BootDriveNotFound

/* try the new function from the new REXXUTIL DLL */
  OS2BootDrive = SysBootDrive()

BootDriveNotFound:

  if symbol( 'OS2BootDrive' ) <> 'VAR' then
  do
/* new REXXUTIL DLL not found  */
/* use the old method          */
    OS2BootDrive = substr( value( 'RUNWORKPLACE' ,, 'OS2ENVIRONMENT' ), 1,2 )

    if OS2BootDrive = '' then
      OS2BootDrive = substr( value( 'COMSPEC' ,, 'OS2ENVIRONMENT' ), 1,2 )

    if OS2BootDrive = '' then
      OS2BootDrive = 'C:'

  end 
RETURN OS2BootDrive

/* ----------------------------------------------------------------- */
/* function:   get the title of an INF file                          */
/* parameters: fully qualified path of the INF file                  */
/*                                                                   */
/* returns:    the title of the INF file                             */
/*             or an empty string in case of an error                */
/*                                                                   */
GetTitle: PROCEDURE
  parse arg '"' infFile '"'

/* init the return code */
  thisTitle = ''
   
/* read the header of the INF file */
  thisRC = stream( infFile, 'c', 'OPEN READ' )
  if thisRC = 'READY:' then
  do
    infHeader = charIn( infFile, 1,500 )
    thisRC = stream( infFile, 'c', 'CLOSE' )

/* search the title */
    startPos = x2d( '6B' )

    do i = 1 to 100
      curChar = substr( infHeader, startPos+i, 1 )
      if curChar = '00'x then
        leave
      else
       thisTitle = thisTitle || curChar
    end 
  end 

RETURN thisTitle 

/* ----------------------------------------------------------------- */
/* Error handler (called if the DLL REXXUTIL is not found)           */
/*                                                                   */
RexxUtilNotFound:
  say ''
  say 'Error: REXXUTIL.DLL not found !!'
exit 255

/* ----------------------------------------------------------------- */
/* Error handler (called if the user presses CTRL-BREAK)             */
/*                                                                   */
UserAbort:
  say ''
  say ' Installation aborted by the user.'
exit 254
