#include <stdio.h>
#include <stdlib.h>
#include <malloc.h>
#include <string.h>
#include <string.h>

#define INCL_WIN
#include <os2.h>

#include <stdlib.h>

#include "forms.h"

extern unsigned int disp_field(struct field *f);

/**************** Functions for creating and managing field list **************/

/********* Add field p into form behind field where ********/

struct field * add_field(struct field *where, struct field *p)
{
    p->prev = where;
    p->next = where->next;
    where->next = p;
    if(p->next != NULL)
	p->next->prev = p;
    return p;
}

/********* Create field and initialize with name, row, col, length, attrib and content */

struct field * make_field(char *name, int prow, int pcol, int row, int col, int length,
    unsigned char type, long colsize, unsigned char attrib,
    char *content, char *prompt)
{
    struct field *new;

    if((new = malloc(sizeof(struct field))) == NULL) return NULL;
    if((new->name = malloc(32)) == NULL) return NULL;
    strcpy(new->name,name);
    new->colsize = colsize;
    if((new->value = (void *)malloc((size_t)colsize)) == NULL) return NULL;
    new->prow = prow;
    new->pcol = pcol;
    new->row = row;
    new->col = col;
    new->length = length;
    new->type = type;
    new->attrib = attrib;
    new->content = content;
    if((new->prompt = malloc(32)) == NULL) return NULL;
    strcpy(new->prompt,prompt);
    new->next = NULL;
    new->prev = NULL;
    return new;
}

/**** Fill field which content from near char string what *****/

void set_field_char(struct field *which, char *what)
{
    if(which->content == NULL)
	which->content = malloc(which->length);
    strcpy(which->content,what);
}

/**** Fill field which content to decimal from integer i *****/

void set_field_int(struct field *which, int i)
{
    if(which->content == NULL)
	which->content = malloc(which->length);
    _itoa(i,which->content, 10);
}

/**** Fill field which content to hex from integer i *****/

void set_field_hex(struct field *which, int i)
{
    if(which->content == NULL)
	which->content = malloc(which->length);
    _itoa(i,which->content, 16);
}

/**** Fill field which content with version number from unsigned int i *****/

void set_field_ver_no(struct field *which, unsigned int i)
{
    if(which->content == NULL)
	which->content = malloc(which->length);
    _itoa((i & 0x00f0) >> 4,which->content,10);
    which->content[1] = '.';
    _itoa((i & 0x000f), which->content+2, 10);
    which->content[3] = '\0';
}

/***** Display a form (list of fields) with head h on screen ******/

unsigned int disp_form(struct field *h)
{
    while(h != NULL) {
	disp_field(h);
	h = h->next;
    }
    return 0;
}

/* Set form position on screen following resizing */

void SetFormPos(struct field *f)
{
    while(f != NULL) {
        SetFieldPos(f);
        f = f->next;
    }
}

/***** Release field memory and unlink it from form list ****/

void release_field(struct field *where)
{
    if(where->content != NULL && where->length != 0)
	free(where->content);
    if(where->name != NULL)
	free(where->name);
    unlink_field(where);
    free(where);
}

void unlink_field(struct field *where)
{
    if(where->prev != NULL)
	where->prev->next = where->next;
    if(where->next != NULL)
	where->next->prev = where->prev;
}

/**** Release form memory *******/

void release_form(struct field *where)
{
    struct field *temp;

    while(where->next != NULL) {
	temp = where->next;
	release_field(where);
	where = temp;
    }
}

/****** Append a field onto end of form *****/

struct field * append_field(struct field *where, struct field *p)
{
    while(where->next != NULL)
	where = where->next; /* Get to bottom of list */
    return add_field(where,p);
}

void set_field_flstr(struct field *which, char *pbuf, long len)
{
    char *p, *q;

    if(which->content == NULL)
	which->content = malloc(which->length +1);

    q = which->content;
    p = pbuf + len - 1;
    while (*p == ' ' && p >= pbuf)
	p--;
    while(pbuf <= p)
	*q++ = *pbuf++;
    *q = '\0';
}

void v2c(struct field *f) /* field value to content conversion */
{
    switch(f->type) {
	case FLS:
	    set_field_flstr(f, f->value,f->colsize);
	    break;
	default:
	    break;
    }
}

void fv2c(struct field *f) /* Convert _all_ values to contents */
{
    while (f != NULL) {
	v2c(f);
	f = f->next;
    }
}

extern void refreshfield(struct field *f);

void refreshform(struct field *f)
{
    while(f != NULL) {
	refreshfield(f);
	f = f->next;
    }
}

extern void read_field(struct field *f);

void read_form(struct field * f)
{
    while(f != NULL) {
	read_field(f);
	f = f->next;
    }
}

void fc2v(struct field *f)  /* Convert all form contents to values */
{
    while (f != NULL) {
	c2v(f);
	f = f->next;
    }
}

void c2v(struct field *f)
{
    switch(f->type) {
	case FLS:
	    set_flstr_field(f, f->value,f->colsize);
	    break;
	default:
	    break;
    }
}


void set_flstr_field(struct field *f, char *dest, long length)
{
    char *s;

    s = f->content;

    while(*s && length) {
        *dest++ = *s++;
        length--;
    }

    while(length) {
        *dest++ = ' ';
        length--;
    }
}
