/************************************************************
Flight Planning Database Maintenance Program
by Les Bell 13/8/91
************************************************************/

#define INCL_WIN

#include <os2.h>
#include <process.h>
#define OS21

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <sys\types.h>
#include <sys\stat.h>

#define DBMSOS2

#include "..\forms\forms.h"
#include "..\forms\pmforms.h"
#include "lab10.h"
#include "search.h"
#include "fplan.h"

/* Forward Definitions */
MRESULT EXPENTRY fpmaintWndProc(HWND hwnd, ULONG ulMessage, MPARAM mp1, MPARAM mp2);
void Append(void);
void FpReadRecord(long recno);
void FpWriteRecord(long recno);
MRESULT EXPENTRY Search(HWND hwnd, ULONG ulMessage, MPARAM mp1, MPARAM mp2);
void fnyi(HWND owner);
void dbuginfo(HWND owner, PSZ info);
long FpLocateByName(char *id);
long FpLocateByAbbrev(char *abbrev);
void FpAskAndWrite(HWND);
MRESULT EXPENTRY UCEFWndProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2);

HAB hab;
HMQ hmq;

CHAR szClassName[] = "LBAFPM";

HWND hwndClient;
RECTL ClientSize;
HWND hwndFrame;
HWND hwndScroll;

HWND hwndSelect;
HWND hwndButton1, hwndButton2, hwndButton3;

HFILE infile;
long recno = 0;
long NumWaypoints;
struct _waypoint buffer;
BOOL RecordChanged = FALSE;
APIRET retcode;

CHAR    szExtension[]    = "\\*.DAT";
CHAR    szHelp[]    = "Help would go here.";

/* On-screen form */
struct field f[] =
   {{0,1, 6,1, 1,FLS,25,"name",    0,25,NULL,NULL,"Name", NULLHANDLE,NULLHANDLE, NULLHANDLE,NULL,f+1},
    {1,1,32,1,26,FLS, 4,"state", 0, 3,NULL,NULL,"State", NULLHANDLE,NULLHANDLE, NULLHANDLE,f,f+2},
    {2,1,42,1,35,FLS, 4,"abbrev",0, 4,NULL,NULL,"Abbrev",NULLHANDLE, NULLHANDLE,NULLHANDLE,f+1,f+3},
    {3,2, 6,2, 1,FLS,10,"lat",    0,10,NULL,NULL,"Lat.",    NULLHANDLE, NULLHANDLE,NULLHANDLE,f+2,f+4},
    {4,2,22,2,16,FLS,10,"lng",    0,10,NULL,NULL,"Long.", NULLHANDLE,NULLHANDLE, NULLHANDLE,f+3,f+5},
    {5,2,39,2,33,FLS, 4,"elev",    0, 4,NULL,NULL,"Elev.", NULLHANDLE,NULLHANDLE, NULLHANDLE,f+4,f+6},
    {6,3, 6,3, 1,FLS, 5,"atis",    0, 5,NULL,NULL,"ATIS",    NULLHANDLE,NULLHANDLE, NULLHANDLE,f+5,f+7},
    {7,3,20,3,14,FLS, 5,"afis", 0, 5,NULL,NULL,"AFIS", NULLHANDLE, NULLHANDLE, NULLHANDLE,f+6,f+8},
    {8,3,35,3,30,FLS, 5, "pal", 0, 5,NULL,NULL,"PAL",  NULLHANDLE, NULLHANDLE, NULLHANDLE,f+7,f+9},
    {9,4, 6,4, 2,FLS, 5, "vor", 0, 5,NULL,NULL,"VOR", NULLHANDLE, NULLHANDLE, NULLHANDLE,f+8,f+10},
    {10,4,20,4,14,FLS,5,"dmei", 0, 5,NULL,NULL,"DMEI",NULLHANDLE,NULLHANDLE, NULLHANDLE,f+9,f+11},
    {11,4,35,4,30,FLS,2,"dme",    0, 2,NULL,NULL,"DME",NULLHANDLE,NULLHANDLE, NULLHANDLE,f+10,f+12},
    {12,5,6,5, 2,FLS,3,"ndb",    0, 3,NULL,NULL,"NDB",NULLHANDLE,NULLHANDLE, NULLHANDLE,f+11,f+13},
    {13,5,20,5,14,FLS,4,"bcst",    0, 4,NULL,NULL,"Bcst",NULLHANDLE,NULLHANDLE, NULLHANDLE,f+12,f+14},
    {14,6, 6,6, 2,FLS,30,"rwinfo",0,30,NULL,NULL,"Rwy", NULLHANDLE,NULLHANDLE, NULLHANDLE,f+13,NULL}};

struct field *current_field = f;

/* Main function */

int main(int argc, char *argv[], char *envp[])
{
    ULONG ctldata = FCF_STANDARD | FCF_VERTSCROLL;

    QMSG qmsg;

    hab = WinInitialize(0);
    hmq = WinCreateMsgQueue(hab,0);

    if(!WinRegisterClass(hab,
        (PCH)szClassName,
        (PFNWP)fpmaintWndProc,
        CS_SIZEREDRAW | CS_SYNCPAINT,
        0))
    return(1);

    hwndFrame = WinCreateStdWindow(HWND_DESKTOP,
            WS_VISIBLE | FS_STANDARD,
            &ctldata,
            (PCH)szClassName,
            "Flight Plan Navaid Maintenance",
            0L,
            (HMODULE)0,
            ID_RESOURCE,
            &hwndClient);

    if(hwndFrame == NULLHANDLE)
    return(1);

    while(WinGetMsg(hab,&qmsg, NULLHANDLE, 0, 0))
    WinDispatchMsg(hab, &qmsg);

    DosClose(infile);
    WinDestroyWindow(hwndFrame);
    WinDestroyMsgQueue(hmq);
    WinTerminate(hab);
    return(0);
}

MRESULT EXPENTRY fpmaintWndProc(HWND hwnd, ULONG ulMessage, MPARAM mp1, MPARAM mp2)
{

    HPS hps;
    RECTL rcl;

    ENTRYFDATA efd;

    ULONG usResult;
    int field_id;
    char msgbuf[64];
    struct field *p;
    ULONG usAction;
    FILESTATUS3 *fs;

    switch(ulMessage) {

    case WM_CHAR:
        if(CHARMSG(&ulMessage)->fs & KC_KEYUP)
        break;;
        switch(CHARMSG(&ulMessage)->vkey) {
        case VK_UP:
        case VK_DOWN:
        case VK_PAGEUP:
        case VK_PAGEDOWN:
            return WinSendMsg(hwndScroll, ulMessage, mp1, mp2);
            break;
        case VK_TAB:
            if(current_field->next != NULL)
            current_field = current_field->next;
            WinSetFocus(HWND_DESKTOP,current_field->hwndField);
            break;
        case VK_BACKTAB:
            if(current_field->prev != NULL)
            current_field = current_field->prev;
            WinSetFocus(HWND_DESKTOP, current_field->hwndField);
            break;
        }
        return (MRESULT)TRUE;
        break;

    case WM_COMMAND:
        switch (SHORT1FROMMP(mp1)) {
        case IDM_OPEN: /* Open... dialog call */
            break;

        case IDM_SAVE: /* Save As... dialog call */
            break;

        case IDM_QUIT:
            WinPostMsg(hwnd, WM_QUIT, 0L, 0L);
            break;

        case IDM_APPEND:
            Append();
            break;

        case IDM_SEARCH:
            if(RecordChanged) {
            FpAskAndWrite(hwnd);
            /* Dealt with the problem, record now OK */
            RecordChanged = FALSE;
            }
            WinDlgBox(HWND_DESKTOP, hwndFrame, Search, (HMODULE)0,
                ID_SRCH_DLG, NULL);
            FpReadRecord(recno);
            WinSendMsg(hwndScroll, SBM_SETPOS,
            MPFROMSHORT((USHORT) recno),
            MPFROMSHORT(0));
            fv2c(f);
            refreshform(f);
            RecordChanged = FALSE;
            break;

        case ID_PBABANDON:
            WinDestroyWindow(hwndButton1);
            WinDestroyWindow(hwndButton2);
            WinDestroyWindow(hwndButton3);
            FpReadRecord(recno);
            fv2c(f);
            refreshform(f);
            RecordChanged = FALSE;
            return(0L);
            break;

        case ID_PBOK:
            read_form(f);
            fc2v(f);
            NumWaypoints++;

        default:
            WinDefWindowProc(hwnd,ulMessage, mp1, mp2);
        }
        break;

    case WM_CONTROL:
        switch (SHORT2FROMMP(mp1)) {
        case EN_SETFOCUS:    /* New field got focus */
            field_id = SHORT1FROMMP(mp1) / 2;
            if (field_id < current_field->id)
            while (field_id < current_field->id)
                current_field = current_field->prev;
            if (field_id > current_field->id)
            while (field_id > current_field->id)
                current_field = current_field->next;
            WinSetFocus(HWND_DESKTOP, current_field->hwndField);
            break;
        case EN_CHANGE:
            RecordChanged = TRUE;
            break;
        default:
            return WinDefWindowProc(hwnd, ulMessage, mp1, mp2);
        }
        break;

    case WM_CREATE:

        fs = malloc(sizeof(FILESTATUS3));

        retcode = DosOpen(    "FPLAN.DAT",
            &infile,
            &usAction,
            0,
            FILE_NORMAL,
            FILE_OPEN,
            OPEN_ACCESS_READWRITE | OPEN_SHARE_DENYWRITE,
            0);

        retcode = DosQueryFileInfo(infile,FIL_STANDARD,fs, sizeof(FILESTATUS3));
        NumWaypoints = fs->cbFile / sizeof(struct _waypoint);
        free(fs);

        /* Obtain the scroll bar handle */
        hwndScroll = WinWindowFromID(WinQueryWindow(hwnd, QW_PARENT), FID_VERTSCROLL);

        /* And set its range */
        WinSendMsg(hwndScroll, SBM_SETSCROLLBAR,
        MPFROM2SHORT(0,0),
        MPFROM2SHORT(0,NumWaypoints-1));

        WinQueryWindowRect(hwndClient,&ClientSize);

        f[0].value = buffer.name;
        f[1].value = buffer.state;
        f[2].value = buffer.abbrev;
        f[3].value = buffer.lat;
        f[4].value = buffer.lng;
        f[5].value = buffer.elev;
        f[6].value = buffer.atis;
        f[7].value = buffer.afis;
        f[8].value = buffer.pal;
        f[9].value = buffer.vor;
        f[10].value = buffer.dmei;
        f[11].value = buffer.dme;
        f[12].value = buffer.ndb;
        f[13].value = buffer.bcst;
        f[14].value = buffer.rwinfo;

        p = f;
        while (p) {
        p->hwndParent = hwnd;
        p = p->next;
        }

        FpReadRecord(0L);

        disp_form(f);
        fv2c(f);
        refreshform(f);
        RecordChanged = FALSE;
        return (MRESULT)FALSE;
        break;

    case WM_CLOSE:
        WinPostMsg(hwnd, WM_QUIT, mp1, mp2);
        break;

    case WM_SIZE:
        WinQueryWindowRect(hwnd, &ClientSize);
        SetFormPos(f);
        return (MRESULT) 0;
        break;

    case WM_PAINT:
        hps = WinBeginPaint(hwnd, 0L, &rcl);
        WinFillRect(hps, &rcl, CLR_WHITE);
        WinEndPaint(hps);
        return (MRESULT) 0;
        break;

    case WM_VSCROLL:
        /* Before scrolling, check for record having been edited */

        if(SHORT2FROMMP(mp2) == SB_ENDSCROLL) break;

        if(RecordChanged) {
        FpAskAndWrite(hwnd);
        /* Dealt with the problem, record now OK */
        RecordChanged = FALSE;
        }
        switch (SHORT2FROMMP(mp2)) {
        case 0: dbuginfo(hwnd,"SB usCmd ZERO!!!!!!");
            break;
        case SB_LINEDOWN:
            recno++;
            break;
        case SB_LINEUP:
            recno--;
            break;
        case SB_PAGEDOWN:
            recno += NumWaypoints / 20;
            break;
        case SB_PAGEUP:
            recno -= NumWaypoints / 20;
            break;
        case SB_SLIDERPOSITION:
            recno = SHORT1FROMMP(mp2);
            break;
        case SB_SLIDERTRACK:
            recno = SHORT1FROMMP(mp2);
            break;
        default:
            sprintf(msgbuf,"Unknown usCmd value: %04x",SHORT2FROMMP(mp2));
            dbuginfo(hwnd,msgbuf);
            break;
        }
        if (recno < 0)
        recno = 0;
        if (recno > NumWaypoints - 1)
        recno = NumWaypoints - 1;
        FpReadRecord(recno);
        WinSendMsg(hwndScroll, SBM_SETPOS,
        MPFROMSHORT((ULONG) recno),
        MPFROMSHORT(0));
        fv2c(f);
        refreshform(f);
        current_field = f;
        RecordChanged = FALSE;
        break;

    default:
        return(WinDefWindowProc(hwnd, ulMessage, mp1, mp2));
        break;
    }
    return 0L;
}

void Append()
{
    ULONG ulNewPtr;

    DosChgFilePtr(infile, 0, FILE_END, &ulNewPtr);
    memset(&buffer, ' ',sizeof(struct _waypoint));
    fv2c(f);
    refreshform(f);
    RecordChanged = FALSE;
    current_field = f;
    WinSetFocus(HWND_DESKTOP,current_field->hwndField);

    hwndButton1 = WinCreateWindow(hwndClient,
    WC_BUTTON,
    "OK",
    WS_VISIBLE | BS_PUSHBUTTON | BS_DEFAULT,
    100,10,
    75,38,
    hwndClient,
    HWND_TOP,
    ID_PBOK,
    NULL,
    NULL);

    hwndButton2 = WinCreateWindow(hwndClient,
    WC_BUTTON,
    "Cancel",
    WS_VISIBLE | BS_PUSHBUTTON,
    200,10,
    75,38,
    hwndClient,
    HWND_TOP,
    ID_PBCANCEL,
    NULL,
    NULL);

    hwndButton3 = WinCreateWindow(hwndClient,
    WC_BUTTON,
    "Abandon",
    WS_VISIBLE | BS_PUSHBUTTON,
    300,10,
    75,38,
    hwndClient,
    HWND_TOP,
    ID_PBABANDON,
    NULL,
    NULL);
}

void FpReadRecord(long recno)
{
    ULONG ulNewPtr;
    ULONG cbBytesRead;

    DosChgFilePtr(infile, (long)recno * sizeof(struct _waypoint),FILE_BEGIN,&ulNewPtr);
    retcode = DosRead(infile,&buffer, sizeof(struct _waypoint), &cbBytesRead);
    if(cbBytesRead != sizeof(struct _waypoint)) {
    WinMessageBox(HWND_DESKTOP,
            hwndClient,
            "Could not read record",
            "File Error",
            IDMB_FILEERROR,
            MB_OK | MB_ICONEXCLAMATION);
    DosExit(EXIT_PROCESS,1);
    }
}

void FpWriteRecord(long recno)
{
    ULONG ulNewPtr;
    ULONG cbBytesWritten;

    DosChgFilePtr(infile, (long)recno * sizeof(struct _waypoint), FILE_BEGIN, &ulNewPtr);
    retcode = DosWrite(infile, &buffer, sizeof(struct _waypoint), &cbBytesWritten);
    if(cbBytesWritten != sizeof(struct _waypoint)) {
    WinMessageBox(HWND_DESKTOP,
            hwndClient,
            "Could not write record",
            "File Error",
            IDMB_FILEERROR,
            MB_OK | MB_ICONEXCLAMATION);
    DosExit(EXIT_PROCESS,1);
    }
}

PFNWP OldWndProc;

MRESULT EXPENTRY Search(HWND hwnd, ULONG ulMessage, MPARAM mp1, MPARAM mp2)
{
    char target[26];
    long temp;

    switch (ulMessage) {
        case WM_INITDLG:
            /* Subclass the ID_SRCH_ABBREV entry field */
            OldWndProc = WinSubclassWindow(WinWindowFromID(hwnd, ID_SRCH_ABBREV), UCEFWndProc);
            return (MRESULT) FALSE;
            break;

        case WM_COMMAND:
            switch(SHORT1FROMMP(mp1)) {
                case ID_SRCH_OK:
                    WinQueryDlgItemText(hwnd,ID_SRCH_NAME, 25,target);
                    if(strlen(target) > 0) {
                        temp = FpLocateByName(target);
                        if (temp == -1)
                            dbuginfo(hwnd,"FpLocateByName failed");
                        else
                            recno = temp;
                    }
                    else {
                        WinQueryDlgItemText(hwnd, ID_SRCH_ABBREV, 5, target);
                        if(strlen(target) > 0) {
                            temp = FpLocateByAbbrev(target);
                            if(temp == -1)
                                dbuginfo(hwnd,"FpLocateByAbbrev failed");
                            else
                                recno = temp;
                        }
                    }
                    WinDismissDlg(hwnd,0);
                    break;

                case ID_SRCH_CANCEL:
                    WinDismissDlg(hwnd,0);
                    break;

                default:
                    dbuginfo(hwnd, "WM_COMMAND defaulted");
            }
            break;

        case WM_HELP:
            fnyi(hwnd);

        default:
            return WinDefDlgProc(hwnd, ulMessage, mp1, mp2);
    }
    return 0L;
}

void fnyi(HWND owner)
{
    WinMessageBox(HWND_DESKTOP,
    owner,
    "Feature Not Yet Implemented",
    "FP Maintenance",
    ID_FNYI,
    MB_CANCEL | MB_ICONEXCLAMATION);
}


void dbuginfo(HWND owner, PSZ info)
{
    WinMessageBox(HWND_DESKTOP,
    owner,
    info,
    "Debug Info",
    ID_DBGI,
    MB_OK | MB_ICONHAND);
}

long FpLocateByName(char *id)
{
    long guess, lower, upper, dir = 1;
    int i;

    lower = 0;                /* B1 */
    upper = NumWaypoints - 1;
    while (dir != 0 && upper >= lower) {
    guess = (upper + lower) / 2;    /* B2 */
    FpReadRecord(guess);
    for(i = sizeof(buffer.name) - 1; buffer.name[i] == ' '; i--);
    dir = strnicmp(id, buffer.name, max(strlen(id),i+1));
    if(dir == 0) return guess;
    if(dir < 0) upper = guess - 1;
    if(dir > 0) lower = guess + 1;
    }
    return -1L;
}

long FpLocateByAbbrev(char *abbrev)
{
    long recno = 0;
    int i,dir;

    if(strlen(abbrev) > 2) {
    while(recno < NumWaypoints && dir != 0) {
        FpReadRecord(recno);
        for(i = sizeof(buffer.abbrev) - 1; buffer.abbrev[i] == ' '; i--);
        dir = strnicmp(abbrev, buffer.abbrev, max(strlen(abbrev),i+1));
        if(dir == 0) return recno;
        recno++;
    }
    return -1L;
    }
    else {
    while(recno < NumWaypoints && dir != 0) {
        FpReadRecord(recno);
        for (i = sizeof(buffer.abbrev) - 1; buffer.abbrev[i] == ' '; i--);
        dir = strnicmp(abbrev, buffer.abbrev + 2, max(strlen(abbrev),i-1));
        if(dir == 0) return recno;
        recno++;
    }
    return -1L;
    }
}

void FpAskAndWrite(HWND hwnd)
{
    ULONG usResult;

    usResult = WinMessageBox(HWND_DESKTOP,
            hwnd,
            (PSZ)"Save this record?",
            (PSZ)"Record Has Been Changed",
            IDMB_SAVE,
            MB_YESNO | MB_ICONQUESTION);
    if(usResult == MBID_YES) {
    read_form(f);
    fc2v(f);
    /* Write back the record */
    FpWriteRecord(recno);
    }
}

/************************************************************************
* Subclass window procedure to force input to upper case                *
* Added by LB 10/10/96                                                  *
\***********************************************************************/
MRESULT EXPENTRY UCEFWndProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
    switch(msg) {
        case WM_CHAR:
            mp2 = MPFROM2SHORT(toupper(SHORT1FROMMP(mp2)),SHORT2FROMMP(mp2));
        default:
            return OldWndProc(hwnd, msg, mp1, mp2);
    }
    return (MRESULT) FALSE;
}
