#define INCL_WIN    /* This includes the window manager function prototypes, */
            /* constants, etc. */
#include <os2.h>    /* This is the main OS/2 definitions include file */

#include <string.h>
#include "lab2.h"

#define MAXSTR    128

/* Prototype for the applications window procedure */
MRESULT EXPENTRY HelloWndProc(HWND hwnd, ULONG ulMessage, MPARAM mp1, MPARAM mp2);

/* We need handles for both the frame window and the client window */
HWND hwndFrame;
HWND hwndClient;

/* Multiple windows can be maintained by one wndproc, so it's a class, rather
than an object. The class is registered by name with the system */
static char szClassName[] = "Hello";

HAB hab;        /* Handle to an 'anchor block' */

void main()
{
    HMQ hmq;        /* Handle to the input message queue */
    QMSG qmsg;        /* Queue message structure to hold the incoming message */
    ULONG ulFrameFlags;   /* Frame creation flags */

    /* First, register with PM to get services. This returns a handle to an anchor block */
    hab = WinInitialize(0);
    /* Next, create a message queue */
    hmq = WinCreateMsgQueue(hab, 0);
    /* Now register a window class for the application */
    if(!WinRegisterClass(hab,
        (PCH)szClassName,
        (PFNWP)HelloWndProc,    /* Pointer to winproc function */
        CS_SYNCPAINT | CS_SIZEREDRAW,   /* Flags to force redraw when resized, etc. */
        0))                 /* Number of bytes in 'window words' */
    DosExit(EXIT_PROCESS, 1);

    /* We want a regular window, but without an accelerator table and icon */
    /* *LAB* Add code to initialize the frame creation flags */
    ulFrameFlags = FCF_STANDARD & ~FCF_ACCELTABLE & ~FCF_ICON;

    /* *LAB* Add code here to create the application window */
    /* This function call returns the frame window handle and also sets the client window handle */
    hwndFrame = WinCreateStdWindow(HWND_DESKTOP,    /* Parent window */
            WS_VISIBLE,                 /* Window style visible */
            &ulFrameFlags,              /* pointer to frame flags */
            (PCH)szClassName,           /* Registered class name */
            "Quotes",                   /* Text for title bar */
            WS_VISIBLE,                 /* Client window style */
            (HMODULE)NULL,              /* Pointer to resource module */
            ID_LAB2,                    /* Resource ID within module */
            (HWND *)&hwndClient);   /* Pointer to client window handle */

    if(hwndFrame == 0) {
        WinAlarm(HWND_DESKTOP, WA_ERROR);
        DosExit(EXIT_PROCESS, 1);
    }

    /* Now loop around processing events. This is called the 'event loop' */
    /* WinGetMsg returns FALSE when it gets the WM_QUIT message */
    while(WinGetMsg(hab, &qmsg, NULLHANDLE, 0, 0))    /* Get a message */
         WinDispatchMsg(hab, &qmsg);        /* Dispatch it to the window */

    /* Lastly, clean up */
    WinDestroyWindow(hwndFrame);
    WinDestroyMsgQueue(hmq);
    WinTerminate(hab);
}

/* The client window procedure. Gets called with message components as parameters */
MRESULT EXPENTRY HelloWndProc(HWND hwnd, ULONG ulMessage, MPARAM mp1, MPARAM mp2)
{
    HPS hps;        /* Handle to a presentation space. This is where a PM program 'draws' */
    RECTL rc;        /* A rectangle structure, used to store the window coordinates */
    static CHAR szMessage[MAXSTR];    /* The message buffer    */

    switch(ulMessage) {

    case WM_CREATE:     /* process this message by returning FALSE. This lets the */
        strcpy(szMessage, "Quotable Quotes");
        return (MRESULT)FALSE;  /* system continue creating the window */
        break;

    case WM_ERASEBACKGROUND:    /* Let the frame window procedure redraw the background */
        return (MRESULT)TRUE;   /* in SYSCLR_WINDOW (usually white) */
        break;

    case WM_COMMAND:

        /* *LAB* Add code here to change the quote string in response to */
        /* the user's menu choice */
        switch(SHORT1FROMMP(mp1)) {
            case ID_TWAIN:
            case ID_IBSEN:
            case ID_GATES:
            case ID_POTEEN:
                WinLoadString(hab, 0, SHORT1FROMMP(mp1), MAXSTR, szMessage);
                WinInvalidateRect(hwnd, NULL, FALSE);
            break;

        /* *LAB* Add code here to quit the program in response to the user's command */
         case IDM_EXIT:
            WinPostMsg(hwnd, WM_CLOSE, 0L, 0L);

        default:
            break;
        }
        return (MRESULT) 0;

    case WM_PAINT:        /* The 'guts' of the application */
        hps = WinBeginPaint(hwnd, 0, &rc);   /* Get a presentation space */
        WinQueryWindowRect(hwnd, &rc);
        /* Draw the message, in rectangle rc, coloured CLR_NEUTRAL (black) on
        CLR_BACKGROUND (white), centered, over-writing the entire rectangle */
        WinDrawText(hps, -1, szMessage, &rc, CLR_NEUTRAL, CLR_BACKGROUND,
            DT_CENTER | DT_VCENTER | DT_ERASERECT);
        WinEndPaint(hps);        /* Release the presentation space */
        break;

    case WM_CLOSE:    /* User chose CLOSE on system menu or double-clicked */
        WinPostMsg(hwnd, WM_QUIT, 0, 0);    /* So send back WM_QUIT, causing */
        break;            /* WinGetMsg to return FALSE and exit the event loop */

    default:        /* Let the system handle messages we don't */
        return WinDefWindowProc(hwnd, ulMessage, mp1, mp2);
        break;
    }
    return 0L;
}
