/***************************************************************************
*   Lab 6                                                                  *
***************************************************************************/
#define  INCL_PM                               // Include PM info
#include <os2.h>                               // Include OS2H

#include <string.h>                            // Include C string functions
#include <malloc.h>                            // Include C memory functions
#include <process.h>

#include "lab6.h"                              // Include local header file

void main(int argc, char **argv)               // Thread 1 entry point
{
    HAB      hab;                              // Thread 1 PM ID
    QMSG     qmsg;                             // Queue message temp storage
    HMQ      hmq;                              // Handle to thread 1 Msg q
    HWND     hwndFrame, hwndClient;            // Main window handles
    RECTL    rctlDesk;                         // Storage for desktop size
    BOOL     rc;                               // Return code storage
    ULONG    flCreateFlags;

    hab = WinInitialize( 0 );
    hmq = WinCreateMsgQueue( hab, 0 );
    if(!WinRegisterClass( (HAB)hab,            // Register a private class
                          WC_SIMEDIT,          //   called WC_SIMEDIT for the
                          (PFNWP)wpSimEdit,    //   client window
                          0L,
                          4)) {                // Storage for a pointer
        WinMessageBox( HWND_DESKTOP,
                        0L,
                        "Unable to register a class",
                        "WinRegisterClass...",
                        1,
                        MB_OK );
        WinDestroyMsgQueue( hmq );
        WinTerminate( hab );
        DosExit( EXIT_PROCESS, 1 );
    }

    flCreateFlags = FCF_STANDARD & ~FCF_SHELLPOSITION;

    hwndFrame = WinCreateStdWindow(HWND_DESKTOP,
                                WS_VISIBLE,
                                &flCreateFlags,
                                "WC_SIMEDIT",
                                (PSZ)NULL,
                                0,                  // Client NOT visible
                                (HMODULE)0,
                                ID_MAIN,
                                &hwndClient);

    WinSetWindowText( hwndFrame, APP_TITLE );       // Init titlebar text

    /* *LAB* Size the window to be 3/4 of the desktop size */
    /* Use WinQueryWindowRect and WinSetWindowPos  */









    while( WinGetMsg( hab, &qmsg, 0L, 0, 0 ) )
        WinDispatchMsg( hab, (PQMSG)&qmsg );

    WinDestroyWindow( hwndFrame );
    WinDestroyMsgQueue( hmq );
    WinTerminate( hab );
}

MRESULT EXPENTRY wpSimEdit(HWND hwnd, ULONG ulMsg, MPARAM mp1, MPARAM mp2)
{
    switch(ulMsg) {
        case WM_CREATE: {                       // Window being created?
            HWND hMLE;                          // Create the editing child

            CHAR *datbuf = (PCHAR)malloc(32768 * sizeof( CHAR )); // Buffer

            hMLE = WinCreateWindow( hwnd,       // MLE is child of client
                                 WC_MLE,        // Class is MLE
                                 (PSZ)NULL,     // No window text
                                 WS_VISIBLE   | // Visible
                                 MLS_HSCROLL  | // Horizontal scrollbar
                                 MLS_VSCROLL,   // Vertical scrollbar
                                 0,0,0,0,       // No initial size/pos
                                 hwnd,          // Client is owner
                                 HWND_TOP,      // On top of siblings
                                 ID_MLE,        // Window ID
                                 NULL,          // No control data
                                 (PVOID)NULL ); // No pres parameters
            WinSetWindowPtr( hwnd, 0, (PVOID)datbuf );          // Store buffer pointer
            WinSendMsg( hMLE, MLM_SETIMPORTEXPORT,              // Set import/export buffer
                     MPFROMP( datbuf ), MPFROMSHORT(32768));    // and size
            WinSendMsg( hMLE, MLM_FORMAT,        // Set format to NO_TRANS
                     MPFROMSHORT(MLFIE_CFTEXT), (MPARAM)0L );
        }
        return (MRESULT) FALSE;
        break;

        case WM_SIZE: {                          // Client being sized?

            USHORT cxNew, cyNew;                 // Storage for new dimensions

            cxNew = SHORT1FROMMP(mp2);           // Extract width from ulMsg
            cyNew = SHORT2FROMMP(mp2);           // Extract height from ulMsg

            /* *LAB* Resize the MLE, using WinSetWindowPos */







            WinSetFocus( HWND_DESKTOP, WinWindowFromID( hwnd, ID_MLE ));
        }
        break;

        case WM_COMMAND: {

            switch(SHORT1FROMMP(mp1)) {
                case MNF_NEW: {
                    LONG lTxtCount;
                    HWND hMLE = WinWindowFromID( hwnd, ID_MLE );

                    lTxtCount = (LONG)WinSendMsg( hMLE,
                                             MLM_QUERYTEXTLENGTH,
                                             (MPARAM)0L,
                                             (MPARAM)0L );
                    if( lTxtCount > 0 )
                        WinSendMsg( hMLE, MLM_DELETE, MPFROMLONG( 0L ), MPFROMLONG( lTxtCount ) );
                    WinSetWindowText( WinQueryWindow( hwnd, QW_PARENT ), "New File" );
                    }
                break;

                case MNF_OPEN: {
                    PFILEDLG pfildlg;
                    TID      ThreadID;
                    PPARMARG parmarg;

                    pfildlg = (PFILEDLG)malloc(sizeof(FILEDLG) );
                    parmarg = (PPARMARG)malloc(sizeof(PARMARG) );

                    memset(pfildlg, 0, sizeof(FILEDLG));
                    pfildlg->cbSize          = sizeof( FILEDLG );
                    pfildlg->fl              = FDS_CENTER | FDS_OPEN_DIALOG;
                    pfildlg->pszTitle        = "Open...";    /* Dialog title string  */

                    WinFileDlg( HWND_DESKTOP, hwnd, pfildlg );
                    if(pfildlg->lReturn == DID_OK ) {
                        parmarg->datbuf   = (CHAR *)WinQueryWindowPtr( hwnd, 0 );
                        /* *LAB* fildlg->szFullFile is the name of the file */
                        /* Now, fill in the parmarg structure and launch the */
                        /* file-handling thread (FileThread) to read the file */





                        WinSetWindowText(WinQueryWindow(hwnd, QW_PARENT), parmarg->filename );
                    }
                    free(pfildlg);
                }
                break;
                case MNF_SAVE:
                case MNF_SAVEAS:
                {
                    CHAR *chTitString;
                    PFILEDLG pfildlg;
                    TID     ThreadID;
                    PPARMARG parmarg;
                    HWND    hMLE = WinWindowFromID( hwnd, ID_MLE );
                    ULONG   ulOff = 0;
                    ULONG   ulCopy;

                    pfildlg  = (PFILEDLG)malloc(sizeof(FILEDLG) );
                    parmarg = (PPARMARG)malloc(sizeof(PARMARG) );

                    chTitString = (PCHAR)malloc( CCHMAXPATH * sizeof( CHAR ) );
                    WinQueryWindowText( WinQueryWindow( hwnd, QW_PARENT ),
                                   CCHMAXPATH,
                                   chTitString );
                    if((!(strcmp( chTitString, APP_TITLE ))) || (SHORT1FROMMP(mp1) == MNF_SAVEAS )) {
                        memset(pfildlg, 0, sizeof(FILEDLG));
                        pfildlg->cbSize          = sizeof( FILEDLG );
                        pfildlg->fl              = FDS_CENTER | FDS_SAVEAS_DIALOG;
                        pfildlg->pszTitle        = "Save...";               /* Dialog title string  */

                        WinFileDlg( HWND_DESKTOP, hwnd, pfildlg );
                        if(pfildlg->lReturn == DID_OK) {
                            strcpy(parmarg->filename, pfildlg->szFullFile);
                            parmarg->datbuf   = (CHAR *)WinQueryWindowPtr( hwnd, 0 );
                            ulCopy = (ULONG)WinSendMsg( hMLE,
                                                            MLM_QUERYFORMATTEXTLENGTH,
                                                            (MPARAM)0L, (MPARAM)1L );
                            parmarg->ulSize = ulCopy;
                            WinSendMsg( hMLE, MLM_SETIMPORTEXPORT,
                                 MPFROMP( parmarg->datbuf ), MPFROMLONG(32768*sizeof(CHAR)) );
                            WinSendMsg( hMLE, MLM_EXPORT, MPFROMP( &ulOff ), MPFROMP( &ulCopy ));
                            /* *LAB* Fill in the PARMARG structure and launch the */
                            /* file handling thread to write. You'll need to query the text */
                            /* length from the MLE */



                            ulCopy = parmarg->ulSize;
                            WinSetWindowText( WinQueryWindow( hwnd, QW_PARENT ), parmarg->filename );
                        }
                    }
                    else {
                        strcpy( parmarg->filename, chTitString );
                        parmarg->hwndSend = hwnd;
                        parmarg->usOpt    = T2WRITE;
                        parmarg->ulSize   = (ULONG)WinSendMsg( hMLE,
                                                         MLM_QUERYFORMATTEXTLENGTH,
                                                         (MPARAM)0L, (MPARAM)0L );
                        parmarg->datbuf   = (CHAR *)WinQueryWindowPtr( hwnd, 0 );
                        ulCopy = parmarg->ulSize;
                        WinSendMsg( hMLE, MLM_SETIMPORTEXPORT,
                              MPFROMP( parmarg->datbuf ), MPFROMLONG(parmarg->ulSize) );
                        WinSendMsg( hMLE, MLM_EXPORT, MPFROMP( &ulOff ), MPFROMP( &ulCopy ));
                        ThreadID = (TID)_beginthread( FileThread, (PVOID)NULL, 8192, (void *)parmarg );
                    }
                    free(pfildlg);
                }
                break;
                /* *LAB* Add code to handle the following menu choices" */
                case MNF_EXIT:

                    break;
                case MNE_CUT:


                    break;
                case MNE_COPY:


                    break;
                case MNE_PASTE:


                    break;
                case MNE_CLEAR:


                    break;
                case MNE_DELETE:


                    break;
                case MNOF_BLACK:
                case MNOF_WHITE:
                case MNOF_BLUE:
                case MNOF_RED:
                case MNOF_GREEN:
                case MNOF_CYAN:
                case MNOF_PINK:
                case MNOF_BROWN:
                    WinSendMsg( WinWindowFromID( hwnd, ID_MLE ),
                                MLM_SETTEXTCOLOR,
                                MPFROMLONG( 100-SHORT1FROMMP(mp1) ),
                                (MPARAM)0L);
                    break;
                case MNOB_BLACK:
                case MNOB_WHITE:
                case MNOB_BLUE:
                case MNOB_RED:
                case MNOB_GREEN:
                case MNOB_CYAN:
                case MNOB_PINK:
                case MNOB_BROWN:
                    WinSendMsg( WinWindowFromID( hwnd, ID_MLE ),
                                MLM_SETBACKCOLOR,
                                MPFROMLONG( 200-SHORT1FROMMP(mp1) ),
                                (MPARAM)0L);
                    break;

                case MNO_WORDWRAP: {

                    BOOL Checked;
                    Checked = WinIsMenuItemChecked(WinWindowFromID( WinQueryWindow( hwnd, QW_PARENT ), FID_MENU ), MNO_WORDWRAP);
                    Checked = !Checked;
                    WinSendMsg( WinWindowFromID( hwnd, ID_MLE ),
                             MLM_SETWRAP,
                             (MPARAM)Checked, (MPARAM)0L );
                    WinCheckMenuItem(WinWindowFromID( WinQueryWindow( hwnd, QW_PARENT ), FID_MENU ), MNO_WORDWRAP,  Checked);
                    }
                    break;
                default:
                    break;
            }
        }
        break;

        case WM_ERASEBACKGROUND:
            return (MRESULT)TRUE;
            break;

        case UM_FILE_DEAD: {  // File-handling thread has finished
                            // mp1 = char count, mp2 = read/write option
            ULONG ulOff = 0;
            ULONG ulCount = LONGFROMMP( mp1 );

            if( SHORT1FROMMP( mp2 ) == T2READ ) {
                CHAR *datbuf;
                LONG lTxtCount;
                HWND hMLE = WinWindowFromID( hwnd, ID_MLE );

                /* *LAB* If the MLE contains text, delete it, then import the */
                /* new text */











            }
        }
        break;

        case WM_CLOSE:
            /* *LAB* Add code here to check whether the user really wants to exit. */
            /* Use the WinMessageBox function to ask for a yes/no response */






            break;

        default:
            return WinDefWindowProc( hwnd, ulMsg, mp1, mp2 );
            break;
    }
    return (MRESULT)FALSE;
}
