/* Strings */
#define OWS_TITLE           "Object Window Application"
#define OWS_CLASS_CLIENT    "OWSClient"
#define OWS_CLASS_OBJECT    "OWSObject"

/* Identifiers */
#define ID_OWS              3
#define IDM_SLEEP           03
#define IDM_ACTIONS         304

/* Lengths */
#define LENWORKSTRING       256
#define LEN_STACK           18000

/* Structure to hold global variables common to both threads */
struct _globals {
    BOOL    fBusy;
    HAB     hab;
    HWND    hwndClient;
    HWND    hwndFrame;
    HWND    hwndTitlebar;
    HWND    hwndMenubar;
    HWND    hwndObject;
    TID     tidObject;
} ;

typedef struct _globals GLOBALS, *PGLOBALS;

/* USer-defined messages for work items and acknowledgements */
#define WM_USER_ACK         (WM_USER+0)
#define WM_USER_SLEEP       (WM_USER+1)
#define WM_USER_ENABLE      (WM_USER+2)
#define WM_USER_DISABLE     (WM_USER+3)

/* Function prototypes -- _Optlink is an IBM CSet/2 modifier */
void _Optlink threadmain(void *);
PGLOBALS Create(HWND hwnd);
MRESULT EXPENTRY ObjectWinProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2);
MRESULT EXPENTRY ClientWinProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2);

