#define INCL_PM                                   // Include PM Info from OS2H
#define INCL_DOS                                  // Include DOS Functions
#include <os2.h>                                  // Include OS2H
#include <string.h>                               // C Language string funcs
#include <process.h>
#include <malloc.h>
#include "lab6.h"                                // Appl header file

void FileThread(VOID *temp)               // Secondary file IO thread
{
    PPARMARG parmarg = (PPARMARG)temp;
    HWND    hwndSend = parmarg->hwndSend;       // Handle of spawning thread
    USHORT  usOpt    = parmarg->usOpt;          // Spawning IO option
    CHAR    filename[CCHMAXPATH];               // IO Filename
    ULONG   ulSize   = parmarg->ulSize;         // Buffer size
    HFILE   fhdl;                               // File handle
    ULONG   exis,no_read,rc,no_written,fsize;   // Usual file IO variables
    CHAR    *datbuf = parmarg->datbuf;          // Data buffer
    FILESTATUS filestats;                       // For DosQFileInfo
    ULONG   fbufsize = sizeof( FILESTATUS );

    strcpy( filename, parmarg->filename );      // Copy in filename
    free( parmarg );                            // Free parameter structure
    no_read = 0; no_written = 0;                // Initialize values
    if( usOpt == T2READ )                       // If read mode IO
        ulSize = 0;                             //    init size to zero
//    else                                        // Else
//        if( datbuf[ulSize-1] != 0x1A )          //    set save size
//            datbuf[ulSize++] = 0x1A;
    rc = DosOpen((PSZ)filename,                 // Open target file for IO
                (PHFILE) &fhdl,                 // File handle returned
                &exis,                          // File exists
                (ULONG) ulSize,                 // File size
                (ULONG) 0,
                (ULONG)0x11,
                (ULONG)0x2092,
                (PEAOP2)0L);
    rc = DosQueryFileInfo(fhdl,                 // Get file size
                         (ULONG) 1,
                         (PVOID) &filestats,
                         (ULONG) fbufsize);
    fsize=filestats.cbFile;                     // Register file size
    if( fsize > 32766 )
        fsize = 32766;
    if( usOpt == T2READ )                       // If read mode IO
        DosRead(fhdl,                           // File handle
             (PVOID) datbuf,                    // Data buffer
             (ULONG) fsize,                     // Buffer length
             (PULONG) &no_read);                // Number read
    else
        DosWrite(fhdl,
              (PVOID) datbuf,
              (ULONG) ulSize,
              (PULONG) &no_written);
    rc=DosClose(fhdl);                          // Close the target
    if( usOpt == T2READ ) {
        if( datbuf[no_read-1] == 0x1A )
            no_read--;
        WinPostMsg( hwndSend, UM_FILE_DEAD, MPFROMLONG( no_read ), MPFROMSHORT( usOpt ));
    }
    else
        WinPostMsg( hwndSend, UM_FILE_DEAD, MPFROMLONG( no_written ), MPFROMSHORT( usOpt ));
    _endthread();
}

