/* money.cmd -- a country independent currency formatter */

numeric digits 26 /* as if I'd ever see this much cash! */

call RxFuncAdd "EdmLoadFuncs", "EdmRexx", "EdmLoadFuncs"
call EdmLoadFuncs

numb = arg( 1 )
do while ( datatype(numb, "Number") <> 1)
    say "Please enter a valid number to be formatted as currency:"
    pull numb
end /* do */

call EdmCountryInfo "X."

int     = trunc(numb)
lennumb = length(int)
len     = lennumb + lennumb % 3 - (lennumb // 3 = 0)
fract   = numb - int

tablein = "abcdefghijklmnopqrstuvwx"
string  = "abc def ghi jkl mno pqr stu vwx"

string  = translate(string, x.ThousandsSeparator, " ");
tablein = right(tablein, lennumb)
string  = right(string, len)
whole   = translate(string, int, tablein)

select
  when (x.CurrencyFormat = 0) then 
        /* currency indicator goes is at beginning */
      final = x.Currency || whole || x.Decimal ||,
              substr(fract, 3, x.DecimalPlace, '0');

  when (x.CurrencyFormat = 1) then
        /* currency indicator goes is at ending */
      final = whole || x.Decimal ||,
              substr(fract, 3, x.DecimalPlace, '0') || x.Currency;

  when (x.CurrencyFormat = 2) then 
        /* currency indicator replaces decimal */
      final = whole || x.Currency ||,
              substr(fract, 3, x.DecimalPlace, '0');
end

return final
