#define INCL_DOSFILEMGR
#include <os2.h>
#include <iostream.h>
#include <string.h>

const char* printEA(const char* pBase);
const char* printAsciiValue(const char* pBase);
const char* printMVMTValue(const char* pBase);

const char* printAsciiValue(const char* pBase)
{
   USHORT length = *(USHORT*)pBase;
   static char buffer[1024];
   strncpy(buffer, pBase+sizeof(USHORT), length);
   buffer[length] = 0;
   cout << "char[" << length << "]=\"" << buffer << "\"";
   return pBase+length+sizeof(USHORT);
}

const char* printMVMTValue(const char* pBase)
{
   USHORT codePage = *(USHORT*)pBase;
   USHORT length = *(USHORT*)pBase+1;
   cout << "{\n  CP=" << codePage << endl;
   cout << "  length=" << length << endl;
   const char* pp = pBase + 2*sizeof(USHORT);
   for (unsigned count=0; pp && count < length; ++count)
   {
     cout << "  [" << count << "] = ";
     pp = printEA(pp);
   }
   cout << endl << "}" << endl;
   return pp;
}

const char* printEA(const char* pBase)
{
  USHORT* pType = (USHORT*)(pBase);
  cout << "Type:\t";
  switch (*pType) {
  case EAT_ASCII:
     cout << "EAT_ASCII:\t";
     return printAsciiValue(pBase + sizeof(USHORT));
     break;
  case EAT_ICON:
     cout << "EAT_ICON";
     break;
  case EAT_BITMAP:
     cout << "EAT_BITMAP";
     break;
  case EAT_METAFILE:
     cout << "EAT_METAFILE";
     break;
  case EAT_MVMT:
     cout << "EAT_MVMT:\t";
     return printMVMTValue(pBase + sizeof(USHORT));
     break;
  case EAT_MVST:
     cout << "EAT_MVST";
     break;
  case EAT_BINARY:
     cout << "EAT_BINARY";
     break;
  case EAT_EA:
     cout << "EAT_EA";
     break;
  case EAT_ASN1:
     cout << "EAT_ASN1";
     break;
  default: 
     cout << "Unknown = " << hex << *pType << dec;
  }
  return 0;
}

void listEAs(const char* name)
{
   const unsigned size = 2000; // Incidently, if you make size > 65364
                               // bytes, and the file does not exist,
                               // a *LARGE* portion of your memory,
                               // starting at the buffer pointer,
                               // will be zeroed, destroying a lot
                               // of your data. Try it!!!
   void* pBuffer = (void*)(new char[size]);

   ULONG count = -1; // means, fill as many names as there is room for

   APIRET rc = DosEnumAttribute(ENUMEA_REFTYPE_PATH,
                                PVOID(name), // Yuk, I hate this API!
                                1, // ordinal index of first EA to read,
                                pBuffer,
                                size,
                                &count,
                                ENUMEA_LEVEL_NO_VALUE); // only legal value!!
  if (rc) {
     cerr << "DosEnumAttribute => " << rc << endl;
     return;
  } /* endif */
  PDENA2 pDena = (PDENA2)pBuffer;
  ULONG offset = 0;
  const ULONG eaop2size = 65000;
  PEAOP2 pEAOP2 = PEAOP2(new char[eaop2size]);
  pEAOP2->fpGEA2List = PGEA2LIST((CHAR*)pEAOP2 + sizeof(EAOP2));
                                                    // let's hope it's allocated
  PGEA2 pGea2 = (&(pEAOP2->fpGEA2List->list[0]));            // on a double word address!!
  if (count != 0) {
    do {
       pDena = PDENA2((CHAR*)(pDena) + offset);
       strcpy(pGea2->szName, pDena->szName);
       pGea2->cbName = pDena->cbName;
       offset = pDena->oNextEntryOffset;
       ULONG length = pGea2->cbName + sizeof(pGea2->cbName) + sizeof(pGea2->oNextEntryOffset);
       if (length % 4) {
          length+= 4-(length%4); // calc double word alignment
       } /* endif */
       pGea2->oNextEntryOffset = offset ? length : 0;
       pGea2 = PGEA2((CHAR*)pGea2 + length);
    } while ( pDena->oNextEntryOffset != 0 ); /* enddo */
    pEAOP2->fpGEA2List->cbList = ((char*)pGea2 - (char*)(pEAOP2->fpGEA2List));
    pEAOP2->fpFEA2List = PFEA2LIST((CHAR*)pEAOP2->fpGEA2List + pEAOP2->fpGEA2List->cbList);
    pEAOP2->fpFEA2List->cbList = eaop2size - ((CHAR*)pEAOP2->fpFEA2List - (CHAR*)pEAOP2);
    rc = DosQueryPathInfo(name,
                          FIL_QUERYEASFROMLIST,
                          PVOID(pEAOP2),
                          sizeof(EAOP2));
    if (rc) {
       cerr << "DosQueryPathInfo => " << rc << endl;
       return;
    } /* endif */
    if (pEAOP2->fpFEA2List->cbList) {
       ULONG offset = 0;
       PFEA2 pFEA2 = pEAOP2->fpFEA2List->list;
       do {
         pFEA2 = PFEA2((CHAR*)pFEA2 + offset);
         cout << "szName:\t" << pFEA2->szName << endl;
         cout << "fEA:\t" << int(pFEA2->fEA) << endl;
         cout << "cbName:\t" << int(pFEA2->cbName) << endl;
         char* pEABase = (CHAR*)pFEA2->szName + pFEA2->cbName+1;
         printEA(pEABase);
         cout << endl << endl;
         offset = pFEA2->oNextEntryOffset;
       } while ( offset ); /* enddo */

    } /* endif */
  } /* endif */
}

int main(int argc, char* argv[])
{
   if (argc != 2) {
      cerr << "Usage: namelist filename" << endl;
      return -1;
   } /* endif */
   listEAs(argv[1]);
   return 0;
}
