////////////////////////////////////////////////////////////////////
//                                                                //
// PROCSSTA.HPP - declares the class AProcessStatus               //
//                a progress indicating status line               //
//                                                                //
////////////////////////////////////////////////////////////////////

#ifndef _PROCSSTA_HPP_
#define _PROCSSTA_HPP_

#define INCL_PM
#define INCL_WINWINDOWMGR
#define INCL_WINMESSAGEMGR
#include <os2.h>

#include <istattxt.hpp>
#include <ipainhdr.hpp>
#include <ifont.hpp>
#include <ipoint.hpp>

#include "stamsgh.hpp"

typedef struct _PROCESS_START_PARAMS { // keeps the parameters needed when a process starts
   ULONG ulProcessSize,                // the total size of the process, e.g. a file's size in bytes
         ulTickSize;                   // the progress size per tick, e.g. the bytes read per reading
   LONG lResourceId;                   // the resource id of the text which names the process
} PROCESS_START_PARAMS;

class AProcessStatus : public IStaticText, 
                       public IPaintHandler,
                       public AStatusHandler
{
  public:
    AProcessStatus (IWindow * parentWindow);       // constructor
    ~AProcessStatus (void);                        // destructor

  protected:
    void resetAllVariables (void);                 // reset all variable members when created
    Boolean paintWindow (IPaintEvent& evt);        // handles WM_PAINT messages
    Boolean paintStd (IPaintEvent& evt);           // standard painting
    Boolean paintStartProcess (IPaintEvent& evt);  // painting to do when a process starts
    Boolean paintPercentNumber (IPaintEvent& evt); // painting to do when the percent number changes
    Boolean paintSlider (IPaintEvent& evt);        // painting to do when the slider size changes
    Boolean startProcess (IEvent& evt);            // handles MYM_STATUS_START_PROCESS messages
    Boolean proceed (IEvent& evt);                 // handles MYM_STATUS_PROCEED messages
    Boolean endProcess (IEvent& evt);              // handles MYM_STATUS_END_PROCESS messages

  private:
    enum ePaintWhat { ePaintStd = 0, ePaintStartProcess = 1, ePaintPercentNumber = 2, ePaintSlider = 3 };

    IFont * m_pFont;                  // keeps the fonts to calculate a text width
    ULONG m_ulY;                      // y-coordinate of the text and percent number
    LONG m_lStartSliderX,             // x-coordinate where the slider begins
         m_lStartPercentNumberX,      // x-coordinate where the actual displayed percent number begins
         m_lEndPercentNumberX,        // x-coordinate where the actual displayed percent number ends
         m_lWidth,                    // width in dots of displayed text
         m_lResourceId,               // resource id of the text which names the process
         m_lPercentNumberMaxXRight;   // largest right-end-x-coordinate of the percent number
    ULONG m_ulTotalTicks,             // total number of ticks the status line will receive
          m_ulActualTick,             // number of ticks actually received
          m_ulPercentReady,           // percent of the process done
          m_ulPercent,                // between-variable
          m_ulNewSliderSize,          // slider's new size in dots
          m_ulOldSliderSize;          // slider's old size in dots
    char m_szBuffer[81];              // string buffer
    ePaintWhat m_nPaintWhat;          // tells what to paint when the event was sent by the status line itself
    Boolean m_bProcessIsRunning,      // does the status line shows the progress of a process (== true if so)?
            m_bPaintSentByMe;         // did the status line sent a paint event itself (== true if so)?
    double m_dSizePerTick;            // slider size per tick
    RECTL m_Rectl;                    // between-variable
    POINTL m_Point;                   // between-variable
};

#endif // _PROCSSTA_HPP_
