#define INCL_PM
#include <os2.h>

#include <stdlib.h>
#include <fstream.h>

#include <ifiledlg.hpp>
#include <imsgbox.hpp>
#include <ientryfd.hpp>
#include <ipushbut.hpp>

#include "MainWin.hpp"
#include "GetNameWin.hpp"
#include "SaverRc.h"
#include "SaverHook.h"


SaverEntry::SaverEntry(){
   Module=NULL;
}

SaverEntry::SaverEntry(const IString &savername,const IString &dllname,SaverModule *mod):
                  SaverName(savername),DLLName(dllname){

   if(mod==NULL){
      somId classId = somIdFromString(SaverName);
      SOMClass *myClass = SOMClassMgrObject->somFindClsInFile(classId,
                            1, 1,DLLName);

      SOMFree(classId);

      if(myClass==NULL)
         throw BogusSaverName();

      Module=(SaverModule *) myClass->somNew();

      if(Module!=NULL)
         Module->IncCount();
      else
         throw BogusSaverName();
   }
   else
      Module=mod;
}

SaverEntry::SaverEntry(const SaverEntry &arg):SaverName(arg.SaverName),
                        DLLName(arg.DLLName),Module(arg.Module){
}

SaverEntry::~SaverEntry(){
   if(Module!=NULL)
      if(!Module->DecCount())
         delete Module;
}

SaverEntry& SaverEntry::operator=(const SaverEntry &arg){
   SaverName=arg.SaverName;
   DLLName=arg.DLLName;

   if(Module!=NULL)
      if(!Module->DecCount())
         delete Module;

   Module=arg.Module;

   if(Module!=NULL)
      Module->IncCount();

return *this;
}


SaverMainWin::CommandHandler::CommandHandler(SaverMainWin &mw):ICommandHandler(),main(mw){
   handleEventsFor(&main);
}

SaverMainWin::CommandHandler::~CommandHandler(){

}

Boolean SaverMainWin::CommandHandler::systemCommand(ICommandEvent &evt){
   if(evt.commandId()==SC_CLOSE){
      main.hide();
   }
return false;
}

Boolean SaverMainWin::CommandHandler::command(ICommandEvent &evt){
   switch(evt.commandId()){
      case ButTest:
         if(main.GetActiveSaver() !=NULL)
            main.StartCurSaverModule();
         break;
      case ButDrop:{
         SaverMainWin::tContainerType::Cursor  iterator(main.ModuleList);

         if(main.ModuleList.locateElementWithKey(main.List.itemText(main.List.selection()),iterator) ){
            main.ModuleList.removeAt(iterator);
            main.List.remove(main.List.selection());
            if(main.ModuleList.numberOfElements()<=1)
               IPushButton(ButDrop,&main.myclient).disable();
         }
         break;
      }
      case ButAdd:{
         IFileDialog::Settings settings;
         settings.setFileName("*.dll");
         IFileDialog  fd(desktopWindow(),&main,settings);

         if(fd.pressedOK()){
            GetNameWin GetName(11,&main);
            if(GetName.showModally()==1){   //1==DID_OK

               try{
                  IEntryField name(NameBox,&GetName);

                  main.ModuleList.add(SaverEntry(name.text(),fd.fileName()) );
                  main.List.addAsLast(name.text());
                  IPushButton(ButDrop,&main.myclient).enable();
               }
               catch(SaverEntry::BogusSaverName arg){
                  IMessageBox mb(&main);
                  mb.show("Saver Class Not found",IMessageBox::warningIcon|IMessageBox::applicationModal|
                           IMessageBox::okButton|IMessageBox::moveable);
               }
           }
         }
         break;
      }
      case ButHide:
         main.minimize();
         break;
      default:
         return false;
   }

return true;
}


SaverHandler::SaverHandler(SaverMainWin &mw):mainwin(mw){
   handleEventsFor(&mainwin);
}

SaverHandler::~SaverHandler(){
}


Boolean SaverHandler::dispatchHandlerEvent(IEvent &event){

  switch(event.eventId()){
     case WM_START_SAVER:
     case WM_STOP_SAVER:
        mainwin.GotInput();
        break;
     default:
        return false;
  }
return true;
}

SaverMainWin::SaverMainWin():IFrameWindow(IFrameWindow::border|
                                          IFrameWindow::systemMenu|
                                          IFrameWindow::titleBar|
                                          IFrameWindow::minimizeButton ,1),
                              myclient(10,this,this),List(ListBox,&myclient),handler(*this),
                              ModuleList(20),myTimerFunc(*this,TimerFunc),
                              aSaverHandler(*this){



   handler.handleEventsFor(&myclient);
   setClient(&myclient);

   moveSizeToClient(myclient.rect());

   LoadSetup();

   tContainerType::Cursor  iterator(ModuleList);

   forCursor(iterator){
      List.addAsLast(ModuleList.elementAt(iterator)->GetSaverName());
   }

   SaverModule::SetWindow(handle());

   if(ModuleList.numberOfElements()>1)
      IPushButton(ButDrop,&myclient).enable();
   else
      IPushButton(ButDrop,&myclient).disable();

   List.select(0);
   addToWindowList();

   CurTime=LastInTime=time(NULL);

   InitSaver(handle() ,((pSaverData*)&SaverData) );

   ((pSaverData)SaverData)->SaverActive=1;
   IsSaving=0;
   myTimer.start(IReference<ITimerFn>(&myTimerFunc), 1000);
}

SaverMainWin::~SaverMainWin(){
   myTimer.stop();
   SaveSetup();
   TermSaver();
}


void SaverMainWin::SaveSetup(){
  ofstream Out("Saver.cfg");

  tContainerType::Cursor  iterator(ModuleList);

  for(iterator.setToFirst();iterator.isValid() && Out ;iterator.setToNext()){
     Out<<(ModuleList.elementAt(iterator).GetSaverName())<<' '<< (ModuleList.elementAt(iterator).GetDLLName())<<endl;
  }

}
void SaverMainWin::LoadSetup(){
  ifstream In("Saver.cfg");
  if(In){
     char SaveName[512],SaveDLL[512];

     do{
        In>>SaveName>>SaveDLL;

        if(In)
           ModuleList.add(SaverEntry(SaveName,SaveDLL) );
    }while(In);
  }
  else{
     ModuleList.add(SaverEntry("TestSaver","TstSave") );
  }
}


void SaverMainWin::TimerFunc(){
  CurTime=time(NULL);

  if(!IsSaving && difftime(CurTime,LastInTime)>60){
     StartCurSaverModule();
  }
}

void SaverMainWin::GotInput(){
  if(IsSaving){
     StopSaverModule();
  }
  else{
     LastInTime=time(NULL);
  }
}

void SaverMainWin::StartCurSaverModule(){
  SaverModule* Cur=GetActiveSaver();
  if(Cur){
     Cur->ActivateSaver();
     ((pSaverData)SaverData)->SaverActive=0;
     IsSaving=1;
  }
  Running=Cur;
}

void SaverMainWin::StopSaverModule(){
  if(Running){
     Running->DeactivateSaver();
     IsSaving=0;
     ((pSaverData)SaverData)->SaverActive=1;
     LastInTime=time(NULL);
  }
  Running=NULL;
}

SaverModule* SaverMainWin::GetActiveSaver(){
   SaverModule*   Ret;

   try{
      Ret=ModuleList.elementWithKey(List.itemText(List.selection()));
   }
   catch(INotContainsKeyException arg) {
      try{
         Ret=ModuleList.firstElement();
      }
      catch(IEmptyException arg){
         Ret=NULL;
      }
   }

return Ret;
}
