#define INCL_GPIBITMAPS
#define INCL_GPIPRIMITIVES
#define INCL_WINBUTTONS
#define INCL_WINDIALOGS
#define INCL_WINWINDOWMGR
#include <os2.h>
#include "buttonrc.h"

typedef struct _BTNDLGINFO {
   ULONG ulSzStruct;
   HBITMAP hbmOkUp;
   HBITMAP hbmOkDown;
   HBITMAP hbmCancelUp;
   HBITMAP hbmCancelDn;
} BTNDLGINFO, *PBTNDLGINFO;

MRESULT EXPENTRY buttonDlgProc(HWND hwndWnd,
                               ULONG ulMsg,
                               MPARAM mpParm1,
                               MPARAM mpParm2)
{
   PBTNDLGINFO pbdiInfo;

   pbdiInfo=(PBTNDLGINFO)WinQueryWindowPtr(hwndWnd,0);

   switch (ulMsg) {
   case WM_INITDLG:
      {
         HPS hpsWnd;

         //----------------------------------------------------------------
         // Get the dialog's instance data and set it in the window words
         //----------------------------------------------------------------
         pbdiInfo=(PBTNDLGINFO)PVOIDFROMMP(mpParm2);
         WinSetWindowPtr(hwndWnd,0,pbdiInfo);

         //----------------------------------------------------------------
         // Load the bitmaps
         //----------------------------------------------------------------
         hpsWnd=WinGetPS(hwndWnd);

         pbdiInfo->hbmOkUp=GpiLoadBitmap(hpsWnd,
                                         NULLHANDLE,
                                         BMP_OKUP,
                                         0,
                                         0);
         pbdiInfo->hbmOkDown=GpiLoadBitmap(hpsWnd,
                                           NULLHANDLE,
                                           BMP_OKDOWN,
                                           0,
                                           0);
         pbdiInfo->hbmCancelUp=GpiLoadBitmap(hpsWnd,
                                             NULLHANDLE,
                                             BMP_CANCELUP,
                                             0,
                                             0);
         pbdiInfo->hbmCancelDn=GpiLoadBitmap(hpsWnd,
                                             NULLHANDLE,
                                             BMP_CANCELDN,
                                             0,
                                             0);

         WinReleasePS(hpsWnd);

         //----------------------------------------------------------------
         // Set the default state of the dialog
         //----------------------------------------------------------------
/* @1 */ WinSendDlgItemMsg(hwndWnd,
                           DBT_CB_ENABLEGROUP,
                           BM_SETCHECK,
                           MPFROMSHORT(TRUE),
                           0);
      }
      break;
   case WM_DESTROY:
      //-------------------------------------------------------------------
      // Cleanup
      //-------------------------------------------------------------------
      GpiDeleteBitmap(pbdiInfo->hbmOkUp);
      GpiDeleteBitmap(pbdiInfo->hbmOkDown);
      GpiDeleteBitmap(pbdiInfo->hbmCancelUp);
      GpiDeleteBitmap(pbdiInfo->hbmCancelDn);
      break;
   case WM_CONTROL:
      switch (SHORT1FROMMP(mpParm1)) {
      case DBT_CB_ENABLEGROUP:
         switch (SHORT2FROMMP(mpParm1)) {
         case BN_CLICKED:
         case BN_DBLCLICKED:
            {
               BOOL bChecked;

               //----------------------------------------------------------
               // Get the check state of the window and enable or disable
               // the radio button group appropriately.
               //----------------------------------------------------------
/* @2 */       bChecked=SHORT1FROMMP(WinSendDlgItemMsg(hwndWnd,
                                                       DBT_CB_ENABLEGROUP,
                                                       BM_QUERYCHECK,
                                                       0,
                                                       0));
               WinEnableWindow(WinWindowFromID(hwndWnd,DBT_RB_CHOICE1),
                               bChecked);
               WinEnableWindow(WinWindowFromID(hwndWnd,DBT_RB_CHOICE2),
                               bChecked);
            }
            break;
         default:
            return WinDefDlgProc(hwndWnd,ulMsg,mpParm1,mpParm2);
         } /* endswitch */
         break;
      case DBT_UB_OK:
      case DBT_UB_CANCEL:
         switch (SHORT2FROMMP(mpParm1)) {
         case BN_PAINT:
            {
               PUSERBUTTON pubButton;
               HBITMAP hbmDraw;
               RECTL rclWnd;
               BITMAPINFOHEADER2 bmihInfo;
               POINTL ptlPoint;

               //----------------------------------------------------------
               // Get the USERBUTTON structure so that we can paint
               // ourselves properly.
               //----------------------------------------------------------
/* @3 */       pubButton=(PUSERBUTTON)PVOIDFROMMP(mpParm2);

               if (pubButton->fsState==BDS_HILITED) {
                  if (SHORT1FROMMP(mpParm1)==DBT_UB_OK) {
                     hbmDraw=pbdiInfo->hbmOkDown;
                  } else {
                     hbmDraw=pbdiInfo->hbmCancelDn;
                  } /* endif */
               } else {
                  if (SHORT1FROMMP(mpParm1)==DBT_UB_OK) {
                     hbmDraw=pbdiInfo->hbmOkUp;
                  } else {
                     hbmDraw=pbdiInfo->hbmCancelUp;
                  } /* endif */
               } /* endif */

               //----------------------------------------------------------
               // Center the bitmap within the window
               //----------------------------------------------------------
/* @4 */       WinQueryWindowRect(pubButton->hwnd,&rclWnd);

               bmihInfo.cbFix=16;
               GpiQueryBitmapInfoHeader(hbmDraw,&bmihInfo);

               ptlPoint.x=rclWnd.xRight/2-bmihInfo.cx/2;
               ptlPoint.y=rclWnd.yTop/2-bmihInfo.cy/2;

               //----------------------------------------------------------
               // Draw the bitmap
               //----------------------------------------------------------
               WinDrawBitmap(pubButton->hps,
                             hbmDraw,
                             NULL,
                             &ptlPoint,
                             0,
                             0,
                             DBM_NORMAL);
            }
            break;
         default:
            return WinDefDlgProc(hwndWnd,ulMsg,mpParm1,mpParm2);
         } /* endswitch */
         break;
      } /* endswitch */
      break;
   case WM_COMMAND:
      switch (SHORT1FROMMP(mpParm1)) {
      case DBT_UB_OK:
      case DID_OK:
         {
            SHORT sChecked;

            //-------------------------------------------------------------
            // Query the tri-state checkbox to see if we should beep.
            // If in "halftoned" state, assume that means "don't care"
            // and beep anyway.
            //-------------------------------------------------------------
/* @5 */    sChecked=SHORT1FROMMP(WinSendDlgItemMsg(hwndWnd,
                                                    DBT_3B_WANTBEEP,
                                                    BM_QUERYCHECK,
                                                    0,
                                                    0));

            switch (sChecked) {
            case 0:
               break;
            case 1:
               WinAlarm(HWND_DESKTOP,WA_NOTE);
               break;
            case 2:
               WinAlarm(HWND_DESKTOP,WA_ERROR);
               break;
            default:
               break;
            } /* endswitch */

            WinDismissDlg(hwndWnd,TRUE);
         }
         break;
      case DBT_UB_CANCEL:
      case DID_CANCEL:
         WinDismissDlg(hwndWnd,FALSE);
         break;
      case DBT_PB_BEEPNOW:
         WinAlarm(HWND_DESKTOP,WA_NOTE);
         break;
      default:
         return WinDefDlgProc(hwndWnd,ulMsg,mpParm1,mpParm2);
      } /* endswitch */
      break;
   default:
      return WinDefDlgProc(hwndWnd,ulMsg,mpParm1,mpParm2);
   } /* endswitch */

   return MRFROMSHORT(FALSE);
}

INT main(VOID)
//-------------------------------------------------------------------------
// This is the standard main() for a dialog box application.
//-------------------------------------------------------------------------
{
   HAB habAnchor;
   HMQ hmqQueue;
   BTNDLGINFO bdiInfo;

   habAnchor=WinInitialize(0);
   hmqQueue=WinCreateMsgQueue(habAnchor,0);

   bdiInfo.ulSzStruct=sizeof(bdiInfo);

   WinDlgBox(HWND_DESKTOP,
             HWND_DESKTOP,
             buttonDlgProc,
             NULLHANDLE,
             DLG_BUTTONS,
             &bdiInfo);

   WinDestroyMsgQueue(hmqQueue);
   WinTerminate(habAnchor);
   return 0;
}
