SHORT EXPENTRY _findClass(PVWCLASSINFO pciInfo,PCHAR pchClass)
//-------------------------------------------------------------------------
// This function compares the name of the specified class to see if it
// matches the specified name.  It is called by CmnLstSearchRecord().
//
// Input:  pciInfo - points to a VWCLASSINFO structure
//         pchClass - points to the class name to compare with
// Returns:  0 if match, non-0 otherwise
//-------------------------------------------------------------------------
{
   return (strcmp(pciInfo->achName,pchClass)!=0);
}

BOOL EXPENTRY vwRegisterClass(PCHAR pchClass,PFNVWWP pfnWndProc)
//-------------------------------------------------------------------------
// This function registers the class with the name specified.
//
// Input:  pchClass - points to the name of the class
//         pfnWndProc - points to the window procedure for the class
// Returns:  TRUE if successful, FALSE otherwise
//-------------------------------------------------------------------------
{
   VWCLASSINFO ciInfo;

   if (hmqQueue==NULL) {
      return FALSE;
   } /* endif */

   if (CmnLstSearchRecord(CmnLstQueryRecord(habAnchor->hclClasses,0),
                          pchClass,
                          (PFNRECCOMP)_findClass)!=NULL) {
      return FALSE;
   } /* endif */

   strcpy(ciInfo.achName,pchClass);
   ciInfo.pfnWndProc=pfnWndProc;

   return CmnLstAddRecord(habAnchor->hclClasses,&ciInfo,LAR_TAIL,NULL);
}

BOOL EXPENTRY vwQueryClassName(HVWWND hwndWnd,ULONG ulSzBuf,PCHAR pchBuf)
//-------------------------------------------------------------------------
// This function returns the name of the class to which the window belongs.
//
// Input:  hwndWnd - handle to the window
//         ulSzBuf - specifies the size of the buffer
//         pchBuf - points to the buffer
// Output:  pchBuf - points to the buffer containing the class name
// Returns:  TRUE if successful, FALSE otherwise
//-------------------------------------------------------------------------
{
   if (!vwIsWindow(hwndWnd)) {
      return FALSE;
   } /* endif */

   *pchBuf=0;
   strncat(pchBuf,hwndWnd->pciClass->achName,ulSzBuf-1);
   return TRUE;
}

BOOL EXPENTRY vwQueryClassInfo(PCHAR pchClass,PVWCLASSINFO pciInfo)
//-------------------------------------------------------------------------
// This function returns information about the specified class
//
// Input:  pchClass - points to the class name
//         pciInfo - points to a VWCLASSINFO structure
// Output:  pciInfo - points to the initialized VWCLASSINFO structure
// Returns:  TRUE if successful, FALSE otherwise
//-------------------------------------------------------------------------
{
   PVWCLASSINFO pciClass;

   if (hmqQueue==NULL) {
      return FALSE;
   } /* endif */

   pciClass=(PVWCLASSINFO)CmnLstQueryRecord(habAnchor->hclClasses,0);
   pciClass=(PVWCLASSINFO)CmnLstSearchRecord(pciClass,
                                             pchClass,
                                             (PFNRECCOMP)_findClass);
   if (pciClass!=NULL) {
      (*pciInfo)=(*pciClass);
      return TRUE;
   } else {
      return FALSE;
   } /* endif */
}

HVWWND EXPENTRY vwCreateWindow(PCHAR pchClass,
                               USHORT usId,
                               ULONG ulStyle,
                               PCHAR pchText,
                               LONG lX,
                               LONG lY,
                               ULONG ulCx,
                               ULONG ulCy,
                               LONG lForeClr,
                               LONG lBackClr)
//-------------------------------------------------------------------------
// This function creates a window.
//
// Input:  pchClass - points to the name of the class of the window
//         usId - specifies the window id.  If -1 is specified, the check
//                for other windows with the same id is not performed.
//         ulStyle - specifies the style of the window
//         pchText - points to the text of the window
//         lX, lY - specifies the lower left corner of the window, relative
//                  to the desktop
//         ulCx, ulCy - specifies the width and height of the window
//         lForeClr - specifies the VWCLR_* constant for the foreground color
//         lBackClr - specifies the VWCLR_* constant for the background color
// Returns:  window handle if successful, NULLHANDLE otherwise
//-------------------------------------------------------------------------
{
   PVWCLASSINFO pciClass;
   VWWND vwWnd;
   HVWWND hwndNew;
   BOOL bDesktop;

   if (hmqQueue==NULL) {
      return NULL;
   } /* endif */

   //----------------------------------------------------------------------
   // Make sure the class was registered
   //----------------------------------------------------------------------
   pciClass=(PVWCLASSINFO)CmnLstQueryRecord(habAnchor->hclClasses,0);
   pciClass=(PVWCLASSINFO)CmnLstSearchRecord(pciClass,
                                             pchClass,
                                             (PFNRECCOMP)_findClass);
   if (pciClass==NULL) {
      return NULL;
   } /* endif */

   memset(&vwWnd,0,sizeof(VWWND));
   vwWnd.ulSzStruct=sizeof(VWWND);
   vwWnd.pciClass=pciClass;

   //----------------------------------------------------------------------
   // If the window id is not -1, check for another window with this id.
   //----------------------------------------------------------------------
   if ((usId!=-1) && (vwWindowFromID(usId)!=NULL)) {
      return NULL;
   } /* endif */

   //----------------------------------------------------------------------
   // If there are no other windows, then this window's id *must* be
   // VWWID_DESKTOP.
   //----------------------------------------------------------------------
   if ((CmnLstQueryRecordCount(habAnchor->hclWindows)==0) &&
       (usId!=VWWID_DESKTOP)) {
      return NULL;
   } /* endif */

   vwWnd.usId=usId;
   vwWnd.ulStyle=ulStyle;
   vwWnd.swpSwp.lX=lX;
   vwWnd.swpSwp.lY=lY;
   vwWnd.swpSwp.ulCx=ulCx;
   vwWnd.swpSwp.ulCy=ulCy;
   vwWnd.lForeClr=lForeClr;
   vwWnd.lBackClr=lBackClr;

   if (!CmnLstAddRecord(habAnchor->hclWindows,
                        &vwWnd,
                        LAR_TAIL,
                        (PPVOID)&hwndNew)) {
      return NULL;
   } /* endif */

   //----------------------------------------------------------------------
   // If this is the desktop, set a flag so that we post it a WM_PAINT
   // instead of sending it the message.
   //----------------------------------------------------------------------
   bDesktop=(usId==VWWID_DESKTOP);

   if (bDesktop) {
      habAnchor->ulStatus|=VW_HABST_CREATINGDESK;
   } /* endif */

   //----------------------------------------------------------------------
   // Check for valid initialization
   //----------------------------------------------------------------------
   if (LONGFROMMR(vwSendMsg(hwndNew,WM_CREATE,0,0))==TRUE) {
      CmnLstDeleteRecord(habAnchor->hclWindows,hwndNew);
      habAnchor->ulStatus&=~VW_HABST_CREATINGDESK;
      return NULL;
   } /* endif */

   if (bDesktop) {
      habAnchor->ulStatus&=~VW_HABST_CREATINGDESK;
   } /* endif */

   vwWnd.pchText=NULL;
   vwSetWindowText(hwndNew,pchText);

   //----------------------------------------------------------------------
   // Paint
   //----------------------------------------------------------------------
   if ((habAnchor->ulStatus & VW_HABST_CREATINGDESK)==0) {
      vwSendMsg(hwndNew,WM_PAINT,0,0);
   } else {
      vwPostMsg(hwndNew,WM_PAINT,0,0);
   } /* endif */

   return hwndNew;
}

BOOL EXPENTRY vwDestroyWindow(HVWWND hwndWnd)
//-------------------------------------------------------------------------
// This function destroys a window
//
// Input:  hwndWnd - handle to the window
// Returns:  TRUE if successful, FALSE otherwise
//-------------------------------------------------------------------------
{
   if (hwndWnd==VWHWND_DESKTOP) {
      hwndWnd=vwWindowFromID(VWWID_DESKTOP);
   } /* endif */

   if (!vwIsWindow(hwndWnd)) {
      return FALSE;
   } /* endif */

   //----------------------------------------------------------------------
   // If this is the desktop window, traverse the window list and destroy
   // all of the children first.
   //----------------------------------------------------------------------
   if (vwQueryWindowUShort(hwndWnd,QWS_ID)==VWWID_DESKTOP) {
      CmnLstTraverseList(habAnchor->hclWindows,(PFNRECFUNC)destroyWindow);
      destroyWindow(hwndWnd);
   } else {
      destroyWindow(hwndWnd);
   } /* endif */

   return TRUE;
}
