#define INCL_DOS
#include <os2.h>

#include <stdio.h>

class CPPfoo{
   int Count;          // Stores the Count Data

public:
   CPPfoo();
   ~CPPfoo();

   void IncrementCount();                //similar to SOM procedure
   void InlineIncrementCount(){Count++;} //no equivalence in SOM procedure
   virtual void OffIncrementCount();     //similar to SOM offset
   
   void SetCount(int C){Count=C;}
   int GetCount(){return Count;}

};


void main(){
   ULONG StartTime, EndTime;
   int i;

   CPPfoo *sfoo=new CPPfoo;


   DosQuerySysInfo(QSV_MS_COUNT,QSV_MS_COUNT,&StartTime,4);
   for(i=0;i<1000000;i++)
      sfoo->IncrementCount();
            
   DosQuerySysInfo(QSV_MS_COUNT,QSV_MS_COUNT,&EndTime,4);

   printf("Time for Procedure calls %i ms count= %i\r\n",EndTime-StartTime,sfoo->GetCount() );

   sfoo->SetCount(0);
   DosQuerySysInfo(QSV_MS_COUNT,QSV_MS_COUNT,&StartTime,4);
   for(i=0;i<1000000;i++)
      sfoo->OffIncrementCount();

   DosQuerySysInfo(QSV_MS_COUNT,QSV_MS_COUNT,&EndTime,4);

   printf("Time for Offset lookup calls %i ms count= %i\r\n",EndTime-StartTime,sfoo->GetCount() );

   sfoo->SetCount(0);
   DosQuerySysInfo(QSV_MS_COUNT,QSV_MS_COUNT,&StartTime,4);
   for(i=0;i<1000000;i++)
      sfoo->InlineIncrementCount();

   DosQuerySysInfo(QSV_MS_COUNT,QSV_MS_COUNT,&EndTime,4);

   printf("Time for inline calls %i ms count= %i\r\n",EndTime-StartTime,sfoo->GetCount() );

}


CPPfoo::CPPfoo(){
   Count=0;
}

CPPfoo::~CPPfoo(){
 
}

void CPPfoo::IncrementCount(){
   Count++;
}

void CPPfoo::OffIncrementCount(){
   Count++;
}

