/**************************************************************
*             protocoll.h                                     *
*                                                             *
* This file contains the declaration of the                   *
* OProtocoll, OProcedure and OMethod classes.                 *
*                                                             *
* Written by Timm Morten Steinbeck for EDM/2 1994             *
* Internet: Timm_Steinbeck@AC3.maus.de                        *
*                                                             *
**************************************************************/


#if !defined(_PROTOCOLL_H_)
#define _PROTOCOLL_H_

#if !defined(OS2_INCLUDED)
#define INCL_NOBASEAPI
#include <os2.h>
#endif  // OS2_INCLUDED

// defines for conditional compilation
//
// DBG_PROT_ALL: Enables all protocoll features in the source code
// DBG_PROT_TEXT: Enables usage of simple text protocolling via
OProtocoll::Text
// DBG_PROT_MSG: Enables protocolling of PM messages via OProtocoll::Msg
// DBG_PROT_LONG: Enables protocolling of longs via OProtocoll::Long
// DBG_PROT_PROC: Enables protocolling of procedures and methods via
//                OProcedure and OMethod


#if defined(DBG_PROT_ALL)
#define DBG_PROT_TEXT
#define DBG_PROT_MSG
#define DBG_PROT_LONG
#define DBG_PROT_PROC
#endif  // DBG_PROT_ALL


///////////////////////////////////////////////
//                                           //
//     Here start the class declarations     //
//                                           //
///////////////////////////////////////////////


#if defined (DBG_PROT_TEXT) || defined(DBG_PROT_MSG) || defined(DBG_PROT_LO=
NG)
|| defined(DBG_PROT_PROC)
// Compile only if needed

// Declaration of class OProtocoll
// This class is used for writing debugging outpout to a protocoll=
 file
//
// Constructor:
//     OProtocoll(char*)
//         argument: Name of file where protocoll is to be stored
//
// Destructor:
//     ~OProtocoll()
//
// Member functions:
//     void Text(char*)
//         Writes text specified as argument to protocoll file
//     void Msg(HWND, UINT, MPARAM, MPARAM)
//         Writes parameters passed to a window function to protocoll=
 file
//     void Long(char*, long)
//         Writes a comment and a long integer into the protocoll=
 file
//
// Data members:
//     char* PathName
//         Used to store the complete filename of the protocoll file.
//     int IO
//         Used to determine wether all of the previous writes have=
 worked

class OProtocoll {
protected:
  char* PathName;
  int IO;
public:
  OProtocoll(char* Name);
  ~OProtocoll();
  virtual void Text(char* Text);
  virtual void Msg(HWND hWnd, UINT Msg, MPARAM P1, MPARAM P2);
  virtual void Long(char *c, long l);
};

// if not prot.cpp, declare ProtP as an external pointer.

#if !defined(_PROTOCOLL_CPP_)
extern OProtocoll *ProtP;
#endif  // _PROTOCOLL_CPP_

#endif // DBG_PROT_LONG || DBG_PROT_TEXT || DBG_PROT_MSG || DBG_PROT_PROC


#if defined(DBG_PROT_PROC)

// Declaration of class OProcedure
// This class is used to write informations about entering and leaving
// procedures. A sort of protocoll stackframe.
//
// Constructor:
//     OProcedure(char*)
//         argument: Name of function that is protocollized
//
// Destructor
//     ~OProcedure()
//
// Member functions:
//     None
//
// Data members:
//     char* ProcName
//         Used to store the name of the function

class OProcedure {
protected:
  char *ProcName;
public:
  OProcedure(char * Name);
  ~OProcedure();
};


// Declaration of class OMethod
// This class is used to write information about member functions=
 entering
// and leaving as well as information about the instance to which=
 they belong.
//
// Constructor:
//     OMethod(void*, char*)
//         arguments: void*: Pointer to instance to which method belongs
//                    char*: name of method
//
// Destructor:
//     ~OMethod()
//
// Member functions:
//     None
//
// Data members:
//     char * ProcName
//         Used to store the name of the method
//     void *that
//         Used to store address of instance to which the method belongs

class OMethod {
protected:
  char *ProcName;
  void *that;
public:
  OMethod(void *That, char *Name);
  ~OMethod();
};

#endif // DBG_PROT_PROC


///////////////////////////////////////////////
//                                           //
//     This section contains the macros      //
//                                           //
///////////////////////////////////////////////


// PROT_TEXT: Macro for OProtocoll::Text
// arguments: char*: Text to be written

#if defined(DBG_PROT_TEXT)
#define PROT_TEXT(ATxt) if (ProtP) ProtP->Text(ATxt)
#else
#define PROT_TEXT(ATxt) ((void)0)
#endif  // DBG_PROT_TEXT


// PROT_MSG: Macro for OProtocoll::Msg
// arguments: HWND, UINT, MPARAM, MPARAM, like the parameters to a=
 window
function

#if defined(DBG_PROT_MSG)
#define PROT_MSG(AnHwnd, AMsg, AP1, AP2) if (ProtP) ProtP->Msg(AnHwnd,=
 AMsg,
AP1, AP2)
#else
#define PROT_MSG(AnHwnd, AMsg, AP1, AP2) ((void)0)
#endif // DBG_PROT_MSG


// PROT_LONG: Macro for OProtocoll::Long
// arguments: char*: comment to long; long: value to be written

#if defined(DBG_PROT_LONG)
#define PROT_LONG(AText, ALong) if (ProtP) ProtP->Long(AText, ALong)
#else
#define PROT_LONG(AText, ALong) ((void)0)
#endif  // DBG_PROT_LONG


// PROT_PROCEDURE: Creates an instance of OProcedure. Can only be=
 called once
per
//                       function
// arguments: char*: name of the function
//
// PROT_METHOD: Creates an instance of OMethod. Can also only be called=
 once
per
//                   function
// arguments: char*: name of member function

#if defined(DBG_PROT_PROC)
#define PROT_PROCEDURE(Func) OProcedure Prot_Procedure(Func)
#define PROT_METHOD(Func) OMethod Prot_Method(this, Func)
#else
#define PROT_PROCEDURE(Func) ((void)0)
#define PROT_METHOD(FUNC) ((void)0)
#endif  // DBG_PROT_PROC


// PROT_NEW: Creates an instance of OProtocoll or derived class and=
 assigns it
//               to the global pointer ProtP.
// arguments: Constructor of OProtocoll or derived class with filename,=
 where
// comments are to be stored.
// eg: PROT_NEW(OProtocoll("C:\\Prot\\FOO.Prt");
//
// PROT_END: Deletes the OProtocoll object pointed to by ProtP
// arguments: none

#if defined(DBG_PROT_MSG) || defined(DBG_PROT_TEXT) || defined(DBG_PROT_LON=
G)
|| defined(DBG_PROT_PROC)
#define PROT_NEW(ClasS, FilE) ClasS Protocoll(FilE);ProtP=3D&Protocoll
#else
#define PROT_NEW(Ptr, PP) ((void)0)
#endif  // fuer PROT_NEW


#endif // _PROTOCOLL_H_

