//-------------------------------------------------------------------------
// The following is part of the VIOWIN user-interface library source code.
// The code is copyright (c) 1994-1995 by Larry Salomon, Jr. and may not
// be used in a for-profit application without the expressed, written
// consent of Larry Salomon, Jr.  All rights reserved.
//-------------------------------------------------------------------------
#include "vwdefs.h"
#include <string.h>

BOOL EXPENTRY vwRegisterClass(PCHAR pchClass,PFNVWWP pfnWndProc)
//-------------------------------------------------------------------------
// This function registers the class with the name specified.
//
// Input:  pchClass - points to the name of the class
//         pfnWndProc - points to the window procedure for the class
// Returns:  TRUE if successful, FALSE otherwise
//-------------------------------------------------------------------------
{
   VWCLASSINFO ciInfo;

   if (hmqQueue==NULL) {
      return FALSE;
   } /* endif */

   if (CmnLstSearchRecord(CmnLstQueryRecord(habAnchor->hclClasses,0),
                          pchClass,
                          (PFNRECCOMP)_findClass)!=NULL) {
      return FALSE;
   } /* endif */

   strcpy(ciInfo.achName,pchClass);
   ciInfo.pfnWndProc=pfnWndProc;

   return CmnLstAddRecord(habAnchor->hclClasses,&ciInfo,LAR_TAIL,NULL);
}

BOOL EXPENTRY vwQueryClassName(HVWWND hwndWnd,ULONG ulSzBuf,PCHAR pchBuf)
//-------------------------------------------------------------------------
// This function returns the name of the class to which the window belongs.
//
// Input:  hwndWnd - handle to the window
//         ulSzBuf - specifies the size of the buffer
//         pchBuf - points to the buffer
// Output:  pchBuf - points to the buffer containing the class name
// Returns:  TRUE if successful, FALSE otherwise
//-------------------------------------------------------------------------
{
   if (!vwIsWindow(hwndWnd)) {
      return FALSE;
   } /* endif */

   *pchBuf=0;
   strncat(pchBuf,hwndWnd->pciClass->achName,ulSzBuf-1);
   return TRUE;
}

BOOL EXPENTRY vwQueryClassInfo(PCHAR pchClass,PVWCLASSINFO pciInfo)
//-------------------------------------------------------------------------
// This function returns information about the specified class
//
// Input:  pchClass - points to the class name
//         pciInfo - points to a VWCLASSINFO structure
// Output:  pciInfo - points to the initialized VWCLASSINFO structure
// Returns:  TRUE if successful, FALSE otherwise
//-------------------------------------------------------------------------
{
   PVWCLASSINFO pciClass;

   if (hmqQueue==NULL) {
      return FALSE;
   } /* endif */

   pciClass=(PVWCLASSINFO)CmnLstQueryRecord(habAnchor->hclClasses,0);
   pciClass=(PVWCLASSINFO)CmnLstSearchRecord(pciClass,
                                             pchClass,
                                             (PFNRECCOMP)_findClass);
   if (pciClass!=NULL) {
      (*pciInfo)=(*pciClass);
      return TRUE;
   } else {
      return FALSE;
   } /* endif */
}
