//-------------------------------------------------------------------------------
// FILE: Spinbut2.cpp
//-------------------------------------------------------------------------------
#define  INCL_WIN
#include <os2.h>
#include <stdio.h>
#include <math.h>
#include "spinbut2.h"

PSZ   achValues[] = {
                    "                ",
                    "                ",
                    "                ",
                    };

//-------------------------------------------------------------------------------
// Prototypes
//-------------------------------------------------------------------------------
MRESULT EXPENTRY SpinDlg (HWND, ULONG ,MPARAM, MPARAM);

//-------------------------------------------------------------------------------
// Main
//
// Sets up a simple dialogbox to demonstrate spinbuttons. By using a dialog
// none of the usual window control has to be included.
//-------------------------------------------------------------------------------
void main(void)
     {
     HAB  hab;
     HMQ  hmq;

     hab = WinInitialize(0);
     hmq = WinCreateMsgQueue(hab,0);

     WinDlgBox(HWND_DESKTOP,
               HWND_DESKTOP,
               SpinDlg,
               NULLHANDLE,
               SPINDLG,
               0);

     WinDestroyMsgQueue(hmq);
     WinTerminate(hab);
     }


//---------------------------------------------------------------------------------
// dialog procedure
//---------------------------------------------------------------------------------
MRESULT EXPENTRY SpinDlg(HWND hwndDlg, ULONG ulMsg, MPARAM mpParm1, MPARAM mpParm2)
     {
     switch (ulMsg)
          {
          case WM_INITDLG:
               {
               sprintf(achValues[0], "%.*f", 2, -0.01);
               sprintf(achValues[1], "%.*f", 2,  0.00);
               sprintf(achValues[2], "%.*f", 2,  0.01);
               WinSendDlgItemMsg(hwndDlg, SPINBUT1,     // Spinbut1 to predefined
                                 SPBM_SETARRAY,
                                 MPFROMP (achValues),
                                 MPFROMSHORT (3));

               WinSendDlgItemMsg(hwndDlg, SPINBUT1,     // Make middle one current
                                 SPBM_SETCURRENTVALUE,
                                 MPFROMLONG (1),
                                 MPFROMLONG (0));
               }
          break;

          case WM_CONTROL:
               {
               switch (SHORT2FROMMP(mpParm1))
                    {
                    case SPBN_DOWNARROW:
                    case SPBN_UPARROW:
                         {
                         char achRetValue[12];

                         WinSendDlgItemMsg(hwndDlg, SPINBUT1,
                                           SPBM_QUERYVALUE,
                                           MPFROMP (achRetValue),
                                           MPFROM2SHORT (sizeof(achRetValue), 0));

                         sprintf(achValues[0], "%.*f", 2, atof(achRetValue)-0.01);
                         sprintf(achValues[1], "%.*f", 2, atof(achRetValue));
                         sprintf(achValues[2], "%.*f", 2, atof(achRetValue)+0.01);

                         WinSendDlgItemMsg(hwndDlg, SPINBUT1,     // Spinbut1 to predefined
                                           SPBM_SETARRAY,
                                           MPFROMP (achValues),
                                           MPFROMSHORT (3));

                         WinSendDlgItemMsg(hwndDlg, SPINBUT1,     // Make middle one current
                                           SPBM_SETCURRENTVALUE,
                                           MPFROMLONG (1),
                                           MPFROMLONG (0));
                         }
                    return MRFROMSHORT (TRUE);
                    }
               }
          break;
          }
     return WinDefDlgProc(hwndDlg, ulMsg, mpParm1, mpParm2);
     }