#ifndef rmxpatch_h
#define rmxpatch_h
/*****************************************************************************
 * RMX Patch Functions
 ***************************************************************************** 
 *
 * Source:   $Source$
 *
 * Overview: This file contains the prototypes of the patch
 *           functions of RMX. 
 *
 * $Log$
 *
 *****************************************************************************/

#include <os2def.h>
typedef ULONG HFILE;

#ifdef __cplusplus
extern "C"
{
#endif

#define RMXENTRY APIENTRY

#define RMX_MAXDLLNAME 128 /* According to lxexe.doc the length of a
			   /* DLL's name cannot exceed 127 charatcters. 
			    */

typedef struct RMXMODULE_
{
  CHAR  achName[RMX_MAXDLLNAME];
  ULONG ulOffset;               
  BOOL  fixup8;
  BOOL  fixup16Selector; 
  BOOL  fixup1616Pointer;
  BOOL  fixup16Offset;
  BOOL  fixup1632Pointer;
  BOOL  fixup32Offset;
  BOOL  fixup32SROffset;
} RMXMODULE;

ULONG RMXENTRY RmxExeRead32Header (HFILE hFile, ULONG* pulExe32Offset, 
				   struct e32_exe* exeHeader);
ULONG RMXENTRY RmxExeRead32Modules(HFILE hFile, ULONG* pulModCount,
				   RMXMODULE** ppModules);


typedef struct RMXDLL_
{
  CHAR   achOriginal[RMX_MAXDLLNAME];
  ULONG  ulOffset;
  PCSZ   pcszReplacement;
  USHORT flState;
} RMXDLL;

typedef RMXDLL*       PRMXDLL;
typedef const RMXDLL* PCRMXDLL;

/* These are the possible values of RMXDLL.flState. */

#define RMXDLL_REPLACABLE    0x01 /* The dll can be replaced.               */
#define RMXDLL_TRANSPARENT   0x02 /* The dll need not be be replaced.       */
#define RMXDLL_SUSPICIOUS    0x04 /* The dll should probably be replaced,   */
				  /* but there is no support for that yet   */
				  /* The program may or may not work after  */
				  /* a patch.                               */
#define RMXDLL_USEDNONPURELY 0x08 /* Although 32-bit, the program uses      */
				  /* 16-bit functions from this dll. As     */
				  /* only 32-bit functions are supported   */
				  /* the program cannot possibly work       */
				  /* if it is patched.                      */
#define RMXDLL_NOTSUPPORTED  0x10 /* This dll must be replaced for remote   */
				  /* execution, but the dll is not supported*/
				  /* yet. The program cannot possible work  */
				  /* if it is patched.                      */


#define RMXDLL_OK            (RMXDLL_REPLACABLE    | \
			      RMXDLL_TRANSPARENT   | \
			      RMXDLL_SUSPICIOUS)
#define RMXDLL_FATAL         (RMXDLL_USEDNONPURELY | \
			      RMXDLL_NOTSUPPORTED)


/* These are the possible mode arguments of RmxPatchOpen. */

#define RMX_OPEN_PATCH  1
#define RMX_OPEN_QUERY  2

/* These are the possible mode arguments of RmxPatchReadDlls. */

#define RMX_PATCH     1
#define RMX_UNPATCH   2

ULONG RMXENTRY RmxPatch         (HFILE hFile, PCRMXDLL pcDll);
ULONG RMXENTRY RmxPatchIsPatched(PCSZ pszFile, BOOL* bPatched);
ULONG RMXENTRY RmxPatchOpen     (PCSZ pszFile, ULONG flMode, HFILE* hFile);
ULONG RMXENTRY RmxPatchReadDlls (HFILE hFile, ULONG flMode, 
				 ULONG* pcDlls, RMXDLL** ppDlls);

#ifdef __cplusplus
}
#endif
#endif
