/***************************************************************************
 *
 * MODULE:	RMX Communications API
 * SOURCE:	$Source$
 * OVERVIEW:	This module contains the source for RMXCOMMS.DLL, a DLL
 *              that eases the use of an actual RMX communications DLL.
 *
 * Copyright (c) 1995 Johan Wikman
 *
 * $Log$
 *
 ***************************************************************************** 
 *
 * Permission to use, copy, modify, distribute, and sell this software
 * and its documentation for any purpose is hereby granted without fee, 
 * provided that the above copyright notice appear in all copies and 
 * that both that copyright notice and this permission notice appear in 
 * supporting documentation.
 *
 * THERE IS NO WARRANTY FOR THIS SOFTWARE, TO THE EXTENT PERMITTED BY
 * APPLICABLE LAW. THE SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE. THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THE PROGRAM
 * IS WITH YOU.  SHOULD THE PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF
 * ALL NECESSARY SERVICING, REPAIR OR CORRECTION. 
 *
 *****************************************************************************/

#define INCL_NOCOMMON
#define INCL_DOSERRORS
#define INCL_DOSFILEMGR
#define INCL_DOSMISC
#define INCL_DOSMODULEMGR
#define INCL_DOSPROCESS
#define INCL_ORDINALS
#define INCL_WINDIALOGS
#define INCL_WINMESSAGEMGR
#define INCL_WINWINDOWMGR
#include <rmxcomms.h>
#include <string.h>
#include <os2.h>


/****************************************************************************
 * MODULE TYPES
 ****************************************************************************/

typedef PFN* PPFN;

struct Function
{
  ULONG ulOrdinal;
  PPFN  ppfnAddress;
};


/****************************************************************************
 * MODULE VARIABLES
 ****************************************************************************/

static HMODULE hmodRmxComms;

static ULONG RMXENTRY (*rmxClose)         (HCONNECTION);
static ULONG RMXENTRY (*rmxConnect)       (HCONNECTION);
static ULONG RMXENTRY (*rmxCreate)        (PCSZ, HCONNECTION*);
static ULONG RMXENTRY (*rmxCreateUnique)  (ULONG*, PSZ, HCONNECTION*);
static ULONG RMXENTRY (*rmxDisConnect)    (HCONNECTION);
static ULONG RMXENTRY (*rmxGetServiceName)(PCSZ, ULONG*, PSZ);
static ULONG RMXENTRY (*rmxOpen)          (PCSZ, PCSZ, HCONNECTION*);
static ULONG RMXENTRY (*rmxRead)          (HCONNECTION, 
					   PBYTE, ULONG, ULONG*);
static ULONG RMXENTRY (*rmxWrite)         (HCONNECTION, 
					   PCBYTE, ULONG);


static Function afFunctions[] =
{
  { ORD_RMXCLOSE,          (PPFN) &rmxClose },
  { ORD_RMXCONNECT,        (PPFN) &rmxConnect },
  { ORD_RMXCREATE,         (PPFN) &rmxCreate },
  { ORD_RMXCREATEUNIQUE,   (PPFN) &rmxCreateUnique },
  { ORD_RMXDISCONNECT,     (PPFN) &rmxDisConnect },
  { ORD_RMXGETSERVICENAME, (PPFN) &rmxGetServiceName },
  { ORD_RMXOPEN,           (PPFN) &rmxOpen },
  { ORD_RMXREAD,           (PPFN) &rmxRead },
  { ORD_RMXWRITE,          (PPFN) &rmxWrite }
};

const ULONG cFunctions     = sizeof(afFunctions)/sizeof(Function);

static CHAR acMsgCaption[] = "RMX - RMXCOMMS";
static CHAR acMsgName[]    = "rmxcomms: Environment variable RMXCOMMS "
	                     "is not specified.\n";
static CHAR acMsgDll[]     = "rmxcomms: Failed to load DLL as specified "
			     "by RMXCOMMS.\n";
static CHAR acMsgResolve[] = "rmxcomms: Failed to resolve functions from "
			     "DLL specified by envvar RMXCOMMS.\n";

const HFILE STDERR         = 2;


/****************************************************************************
 * MODULE FUNCTIONS
 ****************************************************************************/

typedef VOID (*PFNMSG)(PSZ);

static VOID   PrintMessageCL(PSZ pszMessage);
static VOID   PrintMessagePM(PSZ pszMessage);
static PFNMSG GetMsgFunction();


/****************************************************************************
 * DLL INITIALIZATION FUNCTION
 ****************************************************************************/

DLL_PREAMBLE;

ULONG DLLMAIN(ULONG terminating, HMODULE)
{
  // If 'terminating' is zero, DLL initialization is performed. If
  // 'termintaing' is one, DLL termination is performed.
  
  if (!terminating)
    {
      PCSZ
	pcszRmxComms;
      PFNMSG
	printMessage = GetMsgFunction();
      
      // First we must get the value of RMXCOMMS.

      if (DosScanEnv("RMXCOMMS", &pcszRmxComms) != NO_ERROR)
	{
	  printMessage(acMsgName);
	  return 0;
	}

      // Then we can load the actual communications DLL.
      
      if (DosLoadModule(0, 0, pcszRmxComms, &hmodRmxComms) != NO_ERROR)
	{
	  printMessage(acMsgDll);
	  hmodRmxComms = 0;
	  return 0;
	}
      
      // Finally we resolve the functions pointers.

      for (int i = 0; i < cFunctions; i++)
	{
	  ULONG
	    ulOrdinal   = afFunctions[i].ulOrdinal;
	  PPFN
	    ppfnAddress = afFunctions[i].ppfnAddress;
	  
	  ULONG
	    rc = DosQueryProcAddr(hmodRmxComms, ulOrdinal, 0, ppfnAddress);

	  if (rc != NO_ERROR)
	    {
	      DosFreeModule(hmodRmxComms);
	      hmodRmxComms = 0;
	      
	      printMessage(acMsgResolve);
	      return 0;
	    }
	}
    }
  else
    DosFreeModule(hmodRmxComms);

  return 1; // Success
}


/****************************************************************************
 * GLOBAL FUNCTIONS
 ****************************************************************************/

ULONG RMXENTRY RmxClose(HCONNECTION hConn)
{
  return rmxClose(hConn);
}


/****************************************************************************/

ULONG RMXENTRY RmxConnect(HCONNECTION hConn)
{
  return rmxConnect(hConn);
}


/****************************************************************************/

ULONG RMXENTRY RmxCreate(PCSZ pszName, HCONNECTION* hConn)
{
  return rmxCreate(pszName, hConn);
}


/****************************************************************************/

ULONG RMXENTRY RmxCreateUnique(ULONG* pulSize, PSZ pszName, HCONNECTION* hConn)
{
  return rmxCreateUnique(pulSize, pszName, hConn);
}


/****************************************************************************/

ULONG RMXENTRY RmxDisConnect(HCONNECTION hConn)
{
  return rmxDisConnect(hConn);
}


/****************************************************************************/

ULONG RMXENTRY RmxGetServiceName(PCSZ service, ULONG* size, PSZ pszName)
{
  return rmxGetServiceName(service, size, pszName);
}


/****************************************************************************/

ULONG RMXENTRY RmxOpen(PCSZ pcszHost, PCSZ pcszPort, HCONNECTION* hConn)
{
  return rmxOpen(pcszHost, pcszPort, hConn);
}


/****************************************************************************/

ULONG RMXENTRY RmxRead(HCONNECTION hConn, 
		       PBYTE       buffer,
		       ULONG       ulSize,
		       ULONG*      pulBytesRead)
{
  return rmxRead(hConn, buffer, ulSize, pulBytesRead);
}


/****************************************************************************/

ULONG RMXENTRY RmxWrite(HCONNECTION       hConn, 
			PCBYTE            buffer,	
			ULONG             ulBytesToWrite)
{
  return rmxWrite(hConn, buffer, ulBytesToWrite);
}


/****************************************************************************
 * MODULE FUNCTIONS
 ****************************************************************************
 * 
 * FUNCTION: PFNMSG GetMsgFunction();
 *
 * RETURN:
 *    A message function suitable for the current environment being used.
 *
 * OVERVIEW:
 *    The function establises whether PM or the command line is being
 *    used and returns an appropriate function.
 *
 ****************************************************************************/

static PFNMSG GetMsgFunction()
{
  PTIB
    ptib;
  PPIB
    ppib;

  DosGetInfoBlocks(&ptib, &ppib);
  
  if (ppib->pib_ultype == 3) // See documentation of PIB
    return PrintMessagePM;
  else
    return PrintMessageCL;
}


/****************************************************************************
 * 
 * FUNCTION: VOID PrintMessageXX(PSZ pszMessage);
 *
 * OVERVIEW:
 *    These functions display the message in a suitable form for the
 *    current environment (PM or command line).
 *
 ****************************************************************************/

static VOID PrintMessagePM(PSZ pszMessage)
{
  // The last character is a newline. We remove it.
  
  pszMessage[strlen(pszMessage) - 1] = 0;

  HMODULE
    hMod;
  
  if (DosLoadModule(0, 0, "PMWIN", &hMod))
    return;

  HAB   (*winInitialize)     (ULONG);
  HMQ   (*winCreateMsgQueue) (HAB, LONG);
  BOOL  (*winDestroyMsgQueue)(HMQ);
  ULONG (*winMessageBox)     (HWND, HWND, PSZ, PSZ, ULONG, ULONG);
  BOOL  (*winTerminate)      (HAB);
  
  BOOL
    bSuccess = TRUE;
  
  if (bSuccess && DosQueryProcAddr(hMod, ORD_WIN32INITIALIZE, 
				   0, (PFN*) &winInitialize))
    bSuccess = FALSE;

  if (bSuccess && DosQueryProcAddr(hMod, ORD_WIN32CREATEMSGQUEUE, 
				   0, (PFN*) &winCreateMsgQueue))
    bSuccess = FALSE;

  if (bSuccess && DosQueryProcAddr(hMod, ORD_WIN32DESTROYMSGQUEUE, 
				   0, (PFN*) &winDestroyMsgQueue))
    bSuccess = FALSE;

  if (bSuccess && DosQueryProcAddr(hMod, ORD_WIN32MESSAGEBOX, 
				   0, (PFN*) &winMessageBox))
    bSuccess = FALSE;

  if (bSuccess && DosQueryProcAddr(hMod, ORD_WIN32TERMINATE, 
				   0, (PFN*) &winTerminate))
    bSuccess = FALSE;

  if (bSuccess)
    {
      HAB
	hab = winInitialize(0);
      HMQ
	hmq = winCreateMsgQueue(hab, 0);
      
      winMessageBox(HWND_DESKTOP, HWND_DESKTOP, 
		    pszMessage, acMsgCaption, 
		    0, MB_OK | MB_MOVEABLE | MB_ERROR);
      
      winDestroyMsgQueue(hmq);
      winTerminate(hab);
    }
  
  DosFreeModule(hMod);
}


/****************************************************************************/

static VOID PrintMessageCL(PSZ pszMessage)
{
  ULONG
    ulNotUsed;
  
  DosWrite(STDERR, pszMessage, strlen(pszMessage), &ulNotUsed);
}
